#include "variable.h"

  BBSVARIABLE *variable_head[MAXINSTANCES];
  BBSFILE     *file_head[MAXINSTANCES];
  LABEL       *label_head[MAXINSTANCES];
  char        *script[MAXINSTANCES];


BBSVARIABLE * _fastcall find_variable (USHORT cp,char *name) {

  BBSVARIABLE *info;

  info = variable_head[cp];
  while(info) {
    if(!stricmp(info->name,name))
      return info;
    info = info->next;
  }
  return NULL;
}

char * _fastcall variable_to_string (USHORT cp,BBSVARIABLE *var,int radix) {

  switch(var->type) {
    case VAR_STR:
      return var->str;
    case VAR_INT:
      ltoa(var->val,var->str,(radix) ? radix : 10);
      return var->str;
  }
  return "";
}

long _fastcall variable_to_long (USHORT cp,BBSVARIABLE *var,int radix) {

  char *p;

  switch(var->type) {
    case VAR_INT:
      return var->val;
    case VAR_STR:
      p = var->str;
      return strtol(var->str,&p,(radix) ? radix : 10);
  }
  return 0L;
}

int _fastcall compare_variables (USHORT cp,BBSVARIABLE *var1,
                                 BBSVARIABLE *var2) {

  /* returns -1 (var1 < var2) 0 (var1 == var2) or 1 (var1 > var2) */

  switch(var1->type) {
    case VAR_INT:
      switch(var2->type) {
        case VAR_INT:
          return (var1->val < var2->val) ? -1 :
                 (var1->val == var2->val) ? 0 : 1;
        case VAR_STR:
          return (var1->val < atol(var2->str) :
                 (var1->val == atol(var2->str)) ? 0 : 1;
      }
      break;
    case VAR_STR:
      switch(var2->type) {
        case VAR_STR:
          return strcmp(var1->str,var2->str);
        case VAR_INT:
          {
            char rec[33];

            ltoa(var2->val,var2->str,10);
            return strcmp(var1->str,var2->str);
          }
      }
      break;
  }
  return 0;
}

void _fastcall string_to_variable (USHORT cp,BBSVARIABLE *var,char *str) {

  switch(var->type) {
    case VAR_STR:
      strncpy(var->str,str,255);
      var->str[255] = 0;
      break;
    case VAR_INT:
      var->val = atol(str);
      break;
  }
}

void _fastcall long_to_variable (USHORT cp,BBSVARIABLE *var,long val) {

  char *p;

  switch(var->type) {
    case VAR_INT:
      var->val = val;
      break;
    case VAR_STR:
      p = var->str;
      strtol(var->str,&p,10);
      break;
  }
}

void _fastcall variable_to_variable (USHORT cp,BBSVARIABLE *var1,
                                     BBSVARIABLE *var2) {

  /* assign var2 to var1 */

  switch(var1->type) {
    case VAR_INT:
      switch(var2->type) {
        case VAR_INT:
          var1->val = var2->val;
          break;
        case VAR_STR:
          var1->val = atol(var2->val);
          break;
      }
      break;

    case VAR_STR:
      switch(var2->type) {
        case VAR_INT:
          strcpy(var1->str,variable_to_string(cp,var2,10));
          break;
        case VAR_STR:
          strcpy(var1->str,var2->str);
      }
      break;
  }
}

BBSVARIABLE * _fastcall create_variable (USHORT cp,char *name,int type) {

  BBSVARIABLE *info,*last = NULL;

  info = variable_head[cp];
  while(info) {
    last = info;
    info = info->next;
  }
  info = malloc(sizeof(BBSVARIABLE));
  if(!info)
    return NULL;
  memset(info,0,sizeof(BBSVARIABLE));
  strncpy(info->name,name,25);
  info->name[25] = 0;
  if(last)
    last->next = info;
  else
    variable_head[cp] = info;
  info->next = NULL;
  return info;
}

void _fastcall destroy_variable (USHORT cp,BBSVARIABLE *var) {

  BBSVARIABLE *info,*last = NULL;

  if(var == variable_head[cp]) {
    variable_head[cp] = variable_head[cp]->next;
    free(var);
  }
  else {
    info = variable_head[cp];
    while(info) {
      if(info == var) {
        last->next = info->next;
        free(var);
        break;
      }
      last = info;
      info = info->next;
    }
  }
}

void _fastcall free_variables (USHORT cp,int scope) {

  BBSVARIABLE *info;

  info = variable_head[cp];
  while(info) {
    if(info->scope >= scope)
      destroy_variable(cp,info);
    info = info->next;
  }
}

char *_fastcall find_label (USHORT cp,char *label) {

  LABEL *info;

  info = label_head[cp];
  while(info) {
    if(!strcmp(info->label,label))
      return label->pos;
    info = info->next;
  }
  return NULL;
}

int _fastcall load_script (USHORT cp,char *filename) {

  int    handle;
  size_t len;

  handle = sopen(filename,O_RDONLY | O_BINARY,SH_DENYWR);
  if(handle != -1) {
    if(program[cp])
      bbs_free(cp,program[cp]);
    len = min((size_t)filelength(handle),32768);
    program[cp] = bbs_malloc(cp,len);
    if(program[cp]) {
      if(read(handle,program[cp],len) > 0) {
        close(handle);
        return 1;
      }
    }
    close(handle);
  }
  return 0;
}

