#define USE_TIME_MACROS

#include <ctype.h>
#include <process.h>
#include "mailer.h"
#include "modem.h"
#include "bbs.h"
#include "keys.h"
#include "xmisc.h"

    extern MDM      *modems[MAXINSTANCES];
    extern USER     *user[MAXINSTANCES];
    extern BBS      *bbs;
    extern int      helpkey;
    extern USHORT   focusline;


char * _fastcall input_string (int mode, USHORT cp,char *buffer, int maxlen,
                               int minlen,char *prompt, unsigned int type,
                               unsigned int flags, char *help,
                               char *helpfile) {

    int x,pos,y,kp,insert = 1,timeout = 0;

    if(!buffer)
      return "";

RePrompt:

    if(prompt)
      dputs(mode,cp,prompt);

    for(x = 0;x < maxlen && buffer[x];x++)
      dputc(mode,cp,buffer[x]);
    pos = x;

  for(;;) {

Continuing:

    if(!timeout && user[cp]->offline < time(NULL) + 120L && user[cp]->offline > time(NULL) + 60L) {
        quiet_bell(mode,cp,1);
        sayp(mode,cp,96,NULL,0);
        timeout = 1;
        goto RePrompt;
    }

    if(time(NULL) > user[cp]->offline || checkcarrier(cp)) {
        DosSemClear(&modems[cp]->bbsrunningSEM);
        _endthread();
    }

    kp = wait_inkey(mode,cp);
    if(kp == -1)
        goto RePrompt;
    if(!kp) {
        DosSleep(1L);
        continue;
    }
    if(kp & 16384) {
        dputs(mode,cp,"\r\n");
        goto RePrompt;
    }

    if(((user[cp]->attribs & U_ANSI) ||
         modems[cp]->curbaud) && (kp & 1024)) {
        if(kp == RIGHT || kp == CTRL_D) {       /* Right */
            if(pos == x)
              kp = ' ';
            else {
                pos++;
                dputs(mode,cp,"\x1b[1C");
                continue;
            }
        }
        else if(kp == LEFT || kp == CTRL_A) {  /* Left */
            if(pos == 0)
              continue;
            else {
                pos--;
                dputs(mode,cp,"\x1b[1D");
                continue;
            }
        }
        else if(kp == DEL || kp == CTRL_K) {  /* Del */
            if(pos == x || x == 0)
              continue;
            memmove(&buffer[pos],&buffer[pos+1],strlen(&buffer[pos]));
            if(flags & STRF_ENCRYPT) {
                dputs(mode,cp,"\x1b[1D\x1b[s");
                for(y = 0;y < (int)strlen(&buffer[pos]);y++) {
                    dputc(mode,cp,(char)((rand() % 14) + '!'));
                }
                dputs(mode,cp," \x1b[u");
            }
            else
              dprintf(mode,cp,"\x1b[s%s \x1b[u",&buffer[pos]);
            x--;
            continue;
        }
        else if(kp == INS || kp == CTRL_V) {  /* Ins */
            insert = 1 - insert;
            continue;
        }
        else if(kp == HOME || kp == CTRL_S) {  /* Home */
            dprintf(mode,cp,"\x1b[%dD",pos);
            pos = 0;
            continue;
        }
        else if(kp == END || kp == CTRL_E) {  /* End */
            if(pos < x)
              dprintf(mode,cp,"\x1b[%dC",x - pos);
            pos = x;
            continue;
        }
        else if(kp == CTRL_LEFT) { /* CTRL-Left */
            if(pos) {
                while(buffer[pos] == ' ' && pos) {
                    dputs(mode,cp,"\x1b[1D");
                    pos--;
                }
                if(pos) {
                    do {
                        dputs(mode,cp,"\x1b[1D");
                        pos--;
                    } while(buffer[pos] != ' ' && pos);
                }
            }
            continue;
        }
        else if(kp == CTRL_RIGHT) { /* CTRL-Right */
            if(x && pos != x) {
                while(buffer[pos] == ' ' && pos != x) {
                    dputs(mode,cp,"\x1b[1C");
                    pos++;
                }
                if(x && pos != x) {
                    do {
                        dputs(mode,cp,"\x1b[1C");
                        pos++;
                    } while(buffer[pos] != ' ' && pos != x);
                }
            }
            continue;
        }
    }

    kp &= 1279;

    if(kp == helpkey && !(flags & STRF_NOHELP)) {
        if(help && *help)
          send_help(mode,cp,help,helpfile);
        else
          sayp(mode,cp,97,NULL,0);
        goto RePrompt;
    }

    if(kp == TAB) {
        kp = ' ';           // add real tab handling later
        if(pos == x) {
            kp = 0;
            while(x < maxlen && kp < 4) {
                dputs(mode,cp," ");
                buffer[pos] = ' ';
                buffer[pos + 1] = 0;
                x++;
                pos++;
                kp++;
            }
            continue;
        }
        else {
            kp = 0;
            while(pos < maxlen && kp < 4) {
                if(!insert) {
                    dputs(mode,cp," ");
                    buffer[pos] = 0;
                    pos++;
                    kp++;
                    if(pos > x) x = pos;
                }
                else {
                    memmove(&buffer[pos + 1],&buffer[pos],maxlen - pos);
                    buffer[pos] = ' ';
                    buffer[maxlen - 1] = 0;
                    dprintf(mode,cp,"\x1b[s%s\x1b[u\x1b[1C",&buffer[pos]);
                    pos++;
                    kp++;
                    if(x < maxlen)
                      x++;
                }
            }
            continue;
        }
    }

    if((flags & STRF_UCASE) || type == STRT_YN || type == STRT_YNQ || type == STRT_YNQS)
      kp = toupper(kp);
    else if(flags & STRF_LCASE)
      kp = tolower(kp);

    if(kp == '\b' || kp == 127) {
        if(!x || !pos)
          continue;
        if(!(user[cp]->attribs & U_ANSI))
            dputs(mode,cp,"\b \b");
        else {
            if(pos == x)
                dputs(mode,cp,"\x1b[1D \x1b[1D");
            else {
                memmove(&buffer[pos - 1],&buffer[pos],strlen(&buffer[pos - 1]));
                if(flags & STRF_ENCRYPT) {
                    dputs(mode,cp,"\x1b[1D\x1b[s");
                    for(y = 0;y < (int)strlen(&buffer[pos - 1]);y++)
                        dputc(mode,cp,(char)((rand() % 14) + '!'));
                    dputs(mode,cp," \x1b[u");
                }
                else
                  dprintf(mode,cp,"\x1b[1D\x1b[s%s \x1b[u",&buffer[pos - 1]);
            }
        }
        x--;
        pos--;
        buffer[x] = 0;
        continue;
    }

    if(kp == CTRL_Y && x && type != STRT_ANY) {    /* CTRL-Y clears input */
        if(user[cp]->attribs & U_ANSI) {
            if(pos < x)
              dprintf(mode,cp,"\x1b[%dC",x - pos);
        }
        backup(mode,cp,x - 1);
        pos = x = 0;
        memset(buffer,0,maxlen);
        continue;
    }

    if(kp == '\r') {
        if(flags & STRF_REQUIRED) {

            char *p,*pp;

            pp = bbs_strdup(cp,buffer);
            if(pp) {
                p = pp;
                rstrip(p);
                lstrip(p);
                if(strlen(p) >= (unsigned int)minlen)
                    bbs_free(cp,pp);
                else {
                    bbs_free(cp,pp);
                    quiet_bell(mode,cp,1);
                    continue;
                }
            }
        }
        if(!(flags & STRF_EDIT))
          return rstrip(buffer);
        else
          return buffer;
    }

    if(x >= maxlen) {
        quiet_bell(mode,cp,1);
        continue;
    }

    if(flags & STRF_PRETTY) {
        if(!(bbs->attribs & B_NOPRETTY)) {
            if(!pos && kp == ' ')
              continue;
            if(pos && kp == ' ' && buffer[pos - 1] == ' ')
              continue;
            if(!pos || buffer[pos - 1] == ' ' || buffer[pos - 1] == '.' ||
               buffer[pos - 1] == '\'')
                kp = toupper(kp);
            else
              kp = tolower(kp);
        }
    }

    if(!pos) {
        if(flags & STRF_NEAT)
          kp = toupper(kp);
    }

    switch(type) {
        case STRT_YNQS:
            if(kp != modems[cp]->YES && kp != modems[cp]->NO &&
               kp != modems[cp]->QUIT && kp != modems[cp]->STOP)
              goto Continuing;
            break;

        case STRT_YNQ:
            if(kp != modems[cp]->YES && kp != modems[cp]->NO &&
               kp != modems[cp]->QUIT)
              goto Continuing;
            break;

        case STRT_YN:
            if(kp != modems[cp]->YES && kp != modems[cp]->NO)
              goto Continuing;
            break;

        case STRT_ANY:
            break;

        case STRT_ALPHA:
            if(!isalpha(kp))
              goto Continuing;
            break;

        case STRT_NUMERIC:
            if(!isdigit(kp))
              goto Continuing;
            break;

        case STRT_ALPHANUMERIC:
            if(!isalnum(kp))
              goto Continuing;
            break;

        case STRT_HEX:
            if(!isxdigit(kp))
              goto Continuing;
            break;

        case STRT_FILENAME:
            if(strchr("\"\\/[]:|<>+=;,& ",kp))
              goto Continuing;
            break;

        case STRT_FILESPEC:
            if(strchr("\"[]:|<>+=;,& ",kp))
              goto Continuing;
            break;

        case STRT_MULTFILES:
            if(strchr("\"\\/[]:|<>+=;,&",kp))
              goto Continuing;
            break;

        case STRT_MULTSPECS:
            if(strchr("\"[]:|<>+=;,&",kp))
              goto Continuing;
            break;

        case STRT_JUSTFILE:
            if(strchr("\"\\/[]:|<>+=;,&*? ",kp))
              goto Continuing;
            break;

        case STRT_MULTJUST:
            if(strchr("\"\\/[]:|<>+=;,&*?",kp))
              goto Continuing;
            break;

        case STRT_ALL:
        default:
            if(!isprint(kp))
              goto Continuing;
            break;
    }

    if(pos != x && insert) {
        memmove(&buffer[pos + 1],&buffer[pos],maxlen - pos);
        buffer[maxlen - 1] = 0;
    }

    buffer[pos] = (char)kp;
    if(pos == x || (x < maxlen && insert))
      buffer[x + 1] = 0;
    else
      buffer[x] = 0;

    if(!(flags & STRF_NOECHO)) {
        if(!(user[cp]->attribs & U_ANSI) || pos == x) {
            if(flags & STRF_ENCRYPT)
              dputc(mode,cp,(char)((rand() % 14) + '!'));
            else
              dputc(mode,cp,(char)kp);
        }
        else if(flags & STRF_ENCRYPT) {
            dputs(mode,cp,"\x1b[s");
            for(y = 0;y < (int)strlen(&buffer[pos]);y++)
                dputc(mode,cp,(char)((rand() % 14) + '!'));
            dputs(mode,cp,"\x1b[u\x1b[1C");
        }
        else
          dprintf(mode,cp,"\x1b[s%s\x1b[u\x1b[C",&buffer[pos]);
    }

    if(pos < maxlen)
      pos++;
    if(x < maxlen)
      x++;

    if(flags & STRF_MUSTHOT) {
        if(pos >= maxlen) {
            if(!(flags & STRF_EDIT))
                return rstrip(buffer);
            else
              return buffer;
        }
    }

    if((flags & STRF_HOT) && !(user[cp]->attribs & U_COLD)) {
        if(pos >= maxlen) {
            if(!(flags & STRF_EDIT))
                return rstrip(buffer);
            else
              return buffer;
        }
    }

    if((flags & STRF_MUSTHOT) && (flags & STRF_EDIT)) {
        if(x >= maxlen) {
            if(!(flags & STRF_EDIT))
                return rstrip(buffer);
            else
              return buffer;
        }
    }
  }
}



char * _fastcall pinput_string (int mode,USHORT cp,char *buf,int maxlen,
                               int minlen,int pnum,unsigned int type,
                               unsigned int flags,char *help,char *helpfile) {

    /* obtains prompt from current prompt file */

    char s[257];

    sayp(mode,cp,pnum,s,256);
    return input_string(mode,cp,buf,maxlen,minlen,s,
                        type,flags,help,helpfile);
}
