#define INCL_WIN

#include "mailer.h"
#include "xmisc.h"
#include "xbbs.h"

  extern USHORT focusline;
  extern HWND   hwndStatus[MAXINSTANCES];
  extern MDM   *modems[MAXINSTANCES];

  extern MRESULT EXPENTRY ChildFrameProc (HWND,USHORT,MPARAM,MPARAM);


MRESULT EXPENTRY StatusBoxProc (HWND hwnd,USHORT msg,MPARAM mp1,MPARAM mp2) {

  SHORT fline = WinQueryWindowUShort(hwnd,0);
  SHORT frameup;
  HWND  hwndSysmenu,hwndTitlebar,hwndMinmax;

  switch(msg) {
    case WM_CREATE:
      WinSetWindowUShort(hwnd,0,-1);
      WinSetPresParam(hwnd,PP_FONTNAMESIZE,
                      (ULONG)strlen("8.Helv.Bold") + 1L,
                      (PVOID)"8.Helv.Bold");
      WinCreateWindow(hwnd,WC_STATIC,"Status:",WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_STATUSHDR,
                      NULL,NULL);
      WinSetPresParam(WinWindowFromID(hwnd,IDM_STATUSHDR),PP_FONTNAMESIZE,
                      (ULONG)strlen("8.Helv") + 1L,
                      (PVOID)"8.Helv");
      WinCreateWindow(hwnd,WC_STATIC,"Baud:",WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_BAUDHDR,
                      NULL,NULL);
      WinSetPresParam(WinWindowFromID(hwnd,IDM_BAUDHDR),PP_FONTNAMESIZE,
                      (ULONG)strlen("8.Helv") + 1L,
                      (PVOID)"8.Helv");
      WinCreateWindow(hwnd,WC_STATIC,"User:",WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_LASTUSERHDR,
                      NULL,NULL);
      WinSetPresParam(WinWindowFromID(hwnd,IDM_LASTUSERHDR),PP_FONTNAMESIZE,
                      (ULONG)strlen("8.Helv") + 1L,
                      (PVOID)"8.Helv");
      WinCreateWindow(hwnd,WC_STATIC,"Mail:",WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_LASTHDR,
                      NULL,NULL);
      WinSetPresParam(WinWindowFromID(hwnd,IDM_LASTHDR),PP_FONTNAMESIZE,
                      (ULONG)strlen("8.Helv") + 1L,
                      (PVOID)"8.Helv");
      WinCreateWindow(hwnd,WC_STATIC,(PSZ)NULL,WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_STATUS,
                      NULL,NULL);
      WinCreateWindow(hwnd,WC_STATIC,(PSZ)NULL,WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_BAUD,
                      NULL,NULL);
      WinCreateWindow(hwnd,WC_STATIC,(PSZ)NULL,WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_LASTUSER,
                      NULL,NULL);
      WinCreateWindow(hwnd,WC_STATIC,(PSZ)NULL,WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_MISC,
                      NULL,NULL);
      WinCreateWindow(hwnd,WC_STATIC,(PSZ)NULL,WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_LAST,
                      NULL,NULL);
      WinCreateWindow(hwnd,WC_STATIC,(PSZ)NULL,WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_GENERAL,
                      NULL,NULL);
      hwndSysmenu = WinWindowFromID(WinQueryWindow(hwnd,QW_PARENT,0),
                                    FID_SYSMENU);
      hwndTitlebar = WinWindowFromID(WinQueryWindow(hwnd,QW_PARENT,0),
                                     FID_TITLEBAR);
      hwndMinmax = WinWindowFromID(WinQueryWindow(hwnd,QW_PARENT,0),
                                   FID_MINMAX);
      WinSetWindowULong(hwnd,8,(ULONG)hwndSysmenu);
      WinSetWindowULong(hwnd,12,(ULONG)hwndTitlebar);
      WinSetWindowULong(hwnd,16,(ULONG)hwndMinmax);
      WinSetWindowUShort(hwnd,2,1);
      WinDefWindowProc(hwnd,msg,mp1,mp2);
      if(!set_saved_position(hwnd,"StatSizePos"))
        WinSendMsg(hwnd,WM_TILE,MPFROMLONG(0L),MPFROMLONG(0L));
      return 0;

    case WM_BUTTON2DBLCLK:
      WinPostMsg(hwnd,WM_HIDEME,MPFROMLONG(0L),MPFROMLONG(0L));
      break;

    case WM_HIDEME:
      frameup = WinQueryWindowUShort(hwnd,2);
      frameup = (frameup) ? 0 : 1;
      WinSetWindowUShort(hwnd,2,frameup);
      hwndSysmenu = (HWND)WinQueryWindowULong(hwnd,8);
      hwndTitlebar = (HWND)WinQueryWindowULong(hwnd,12);
      hwndMinmax = (HWND)WinQueryWindowULong(hwnd,16);
      if(!frameup) {
        WinSetParent(hwndSysmenu,HWND_OBJECT,FALSE);
        WinSetParent(hwndTitlebar,HWND_OBJECT,FALSE);
        WinSetParent(hwndMinmax,HWND_OBJECT,FALSE);
      }
      else {
        WinSetParent(hwndSysmenu,WinQueryWindow(hwnd,QW_PARENT,0),TRUE);
        WinSetParent(hwndTitlebar,WinQueryWindow(hwnd,QW_PARENT,0),TRUE);
        WinSetParent(hwndMinmax,WinQueryWindow(hwnd,QW_PARENT,0),TRUE);
      }
      WinSendMsg(WinQueryWindow(hwnd,QW_PARENT,0),WM_UPDATEFRAME,
                 MPFROMSHORT(FCF_TITLEBAR | FCF_SYSMENU | FCF_MINBUTTON),0L) ;
      return 0;

    case WM_TILE:
      {
        SWP swp;

        WinQueryWindowPos(WinQueryWindow(WinQueryWindow(hwnd,QW_PARENT,0),
                          QW_PARENT,0),&swp);
        WinSetWindowPos(WinQueryWindow(hwnd,QW_PARENT,0),HWND_TOP,
                        0,(swp.cy / 2) + 12,swp.cx / 2,(swp.cy / 2) - 12,
                        SWP_RESTORE | SWP_MOVE | SWP_SIZE | SWP_ZORDER);
      }
      return 0;

    case WM_CASCADE:
      {
        SWP swp;

        WinQueryWindowPos(WinQueryWindow(WinQueryWindow(hwnd,QW_PARENT,0),
                          QW_PARENT,0),&swp);
        WinSetWindowPos(WinQueryWindow(hwnd,QW_PARENT,0),HWND_TOP,
                        0,96,swp.cx - 72,swp.cy - 96,
                        SWP_RESTORE | SWP_MOVE | SWP_SIZE | SWP_ZORDER);
      }
      return 0;

    case WM_LOGWIDE:
      WinSendMsg(hwnd,WM_TILE,MPFROMLONG(0L),MPFROMLONG(0L));
      return 0;

    case WM_STATWIDE:
      {
        SWP swp;

        WinQueryWindowPos(WinQueryWindow(WinQueryWindow(hwnd,QW_PARENT,0),
                          QW_PARENT,0),&swp);
        WinSetWindowPos(WinQueryWindow(hwnd,QW_PARENT,0),HWND_TOP,
                        0,(swp.cy / 2) + 12,swp.cx,(swp.cy / 2) - 12,
                        SWP_RESTORE | SWP_MOVE | SWP_SIZE | SWP_ZORDER);
      }
      return 0;

    case WM_SETCP:
      {
        char s[81];

        sprintf(s,"Status: %d",SHORT1FROMMP(mp1));
        WinSetWindowText(WinQueryWindow(hwnd,QW_PARENT,0),s);
        WinSetWindowUShort(hwnd,0,SHORT1FROMMP(mp1));
        WinSendMsg(hwnd,WM_HIDEME,MPFROMLONG(0L),MPFROMLONG(0L));
        {
          PFNWP oldproc;

          oldproc = WinSubclassWindow(ParentOf(hwnd),(PFNWP)ChildFrameProc);
          WinSendMsg(ParentOf(hwnd),WM_SETCP,MPFROMP(oldproc),MPVOID);
        }
      }
      return 0;

    case WM_SIZE:
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_STATUSHDR),HWND_TOP,
                      0,SHORT2FROMMP(mp2) - 16,46,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_STATUS),HWND_TOP,
                      46,SHORT2FROMMP(mp2) - 16,SHORT1FROMMP(mp2) - 46,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_GENERAL),HWND_TOP,
                      12,SHORT2FROMMP(mp2) - 32,SHORT1FROMMP(mp2) - 12,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_LASTUSERHDR),HWND_TOP,
                      0,SHORT2FROMMP(mp2) - 48,46,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_LASTUSER),HWND_TOP,
                      46,SHORT2FROMMP(mp2) - 48,SHORT1FROMMP(mp2) - 46,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_LASTHDR),HWND_TOP,
                      0,SHORT2FROMMP(mp2) - 64,46,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_LAST),HWND_TOP,
                      46,SHORT2FROMMP(mp2) - 64,SHORT1FROMMP(mp2) - 46,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_MISC),HWND_TOP,
                      12,SHORT2FROMMP(mp2) - 80,SHORT1FROMMP(mp2) - 12,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_BAUDHDR),HWND_TOP,
                      0,SHORT2FROMMP(mp2) - 96,46,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_BAUD),HWND_TOP,
                      46,SHORT2FROMMP(mp2) - 96,SHORT1FROMMP(mp2) - 46,16,
                      SWP_MOVE | SWP_SIZE);
      break;

    case WM_PAINT:
      {
        RECTL rclUpdate;
        HPS hps;

        hps = WinBeginPaint(hwnd,0L,(PRECTL)&rclUpdate);
        WinFillRect(hps,(PRECTL)&rclUpdate,SYSCLR_DIALOGBACKGROUND);
        WinEndPaint(hps);
      }
      break;

    case WM_CONTROL:
      return 0;

    case WM_STATUS:
      WinSetDlgItemText(hwnd,IDM_STATUS,(char *)mp2);
      return 0;

    case WM_GENERAL:
      WinSetDlgItemText(hwnd,IDM_GENERAL,(char *)mp2);
      return 0;

    case WM_BAUD:
      if(fline != -1) {

        char szBuffer[10];

        sprintf(szBuffer,"%u%s",modems[fline]->curbaud,
                &"L"[(modems[fline]->locked == 0)]);
        WinSetDlgItemText(hwnd, IDM_BAUD, szBuffer);
      }
      return 0;

    case WM_LASTUSERNAME:
      WinSetDlgItemText(hwnd,IDM_LASTUSER,(char *)mp2);
      return 0;

    case WM_LASTMAILER:
      WinSetDlgItemText(hwnd,IDM_MISC,(char *)mp2);
      return 0;

    case WM_MISC:
      WinSetDlgItemText(hwnd,IDM_MISC,(char *)mp2);
      return 0;

    case WM_LAST:
      WinSetWindowText(WinWindowFromID(hwnd, IDM_LAST),(char *)mp2);
      return 0;

    case WM_CLOSE:
      WinSendMsg(WinQueryWindow(hwnd,QW_PARENT,0),WM_SYSCOMMAND,
                 MPFROM2SHORT(SC_MINIMIZE,0),MPFROMLONG(0L));
      return 0;
  }

  return WinDefWindowProc(hwnd,msg,mp1,mp2);
}
