/*****************************************************/
/* This module performs Bark file requests...sending */
/*****************************************************/

#include <process.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys\types.h>
#include <sys\stat.h>
#include "mailer.h"
#include "bbs.h"
#include "modem.h"
#include "transfer.h"
#include "timers.h"
#include "xmisc.h"

    extern MDM  *modems[MAXINSTANCES];
    extern BBS  *bbs;


int _fastcall send_bark (USHORT cp,ADDR *addr) {

    /* NOTE: password cannot be NULL but may be "" */

    char        *s,*ss,*p,*pp,*password,sign;
    int         handle,temp,retries = 0,crc;
    clock_t     t1;
    long        pos=0L;
    time_t      date;


    if(!modems[cp]->sfreqsok) {
        com_putc(cp,ETB);
        return 2;
    }

    s = (char *)malloc(1050);
    ss = (char *)malloc(1027);
    if(!s || !ss) {
        if(s) free(s);
        if(ss) free(ss);
        return 1;
    }

    make_dirname("R",s,addr);

    handle = sopen(s,O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
    if(handle == -1) {
        com_putc(cp,ETB);
        free(s);
        free(ss);
        return 2;
    }

    while(!eof(handle)) {

SB0:

        pos = tell(handle);

        if(!fgetsx(s,1024,handle)) break;

        sign = 0;
        date = 0L;
        p = strchr(s,';');    /* get rid of comments, empty lines, junk */
        if(p) *p = 0;
        lstrip(s);
        stripcr(s);
        rstrip(s);
        if(!*s) continue;

        do {                /* change backslashes to slashes */
            p = strchr(s,'\\');
            if(p) *p = '/';
        } while(p);

        pp = strrchr(s,'/');          /* get rid of path */
        if(!pp) pp = strrchr(s,':');
        if(!pp) pp = s;
        else pp++;
        if(!*pp) continue;

        p = strchr(pp,' ');           /* dig out password, if any */
        if(p) {
            *p = 0;
            p++;
            if(*p == '!') {
                p++;
                password = p;
                p = strchr(p,' ');
                if(p) {
                    *p = 0;
                    p++;
                    sign = (char)(*p == '-');
                    p++;
                    date = atol(p);
                }
                else {
                    date = 0L;
                    sign = 0;
                }
            }
            else {
                password = "";
                sign = (char)(*p == '-');
                p++;
                date = atol(p);
            }
        }
        else {
            password = "";
            date = 0L;
            sign = 0;
        }

        /* build bark request packet in ss */

        sprintf(ss,"%c%s %01lu %s%c",(char)ACK,pp,date,password,(char)ETX);

        logfunc(0,cp,"Requesting %s(%s)",pp,password);

/* SB1 */

        /* send packet */

        crc = figurecrc(&ss[1],strlen(ss)-2,0);    /* calc crc for pkt */
        com_write(cp,ss,strlen(ss));
        com_write(cp,(char *)&crc,sizeof(int));

/* SB2 */

        t1 = timerset(10000L);
        while(retries < 5) {
          if(timeup(t1)) {
            retries++;
          }
          temp = get_modem_byte(cp,3000L);
          switch(temp) {
                case TIMEOUT: break;

                case LOSTCARRIER:   free(s);
                                    free(ss);
                                    rebuild_list(handle,pos,"R",addr);
                                    return LOSTCARRIER;

                case ACK:    do {
                               *s = 0;
                               temp = modem7_recv(cp,s);
                               switch(temp) {
                                 case LOSTCARRIER:
                                 case TIMEOUT:     return temp;

                                 case SUB:
                                 case EOT:         goto SB3;

                                 case SYN:         p = recv_file(cp,s,SYN,
                                                                 bbs->inbound[modems[cp]->whichin]);
                                                   break;

                                 case SOH:         p = recv_file(cp,s,SOH,
                                                                 bbs->inbound[modems[cp]->whichin]);
                                                   break;

                                 default:          p = recv_file(cp,s,0,
                                                                 bbs->inbound[modems[cp]->whichin]);
                                                   break;

                               }
                               if(p) {
                                 temp = 1;
                                 free(p);
                                 p = NULL;
                               }
                               else temp = 0;
                               if(checkcarrier(cp) == LOSTCARRIER)
                                 return LOSTCARRIER;
                               DosSleep(350L);
                               purge_in(cp);
                             } while(temp);
                             goto SB3;

                default:     purge_in(cp);
                             break;
          }
        }

        com_putc(cp,ETB);
        logfunc(0,cp,"Request failed");
        free(s);
        free(ss);
        rebuild_list(handle,pos,"R",addr);
        return 0;

SB3:

        t1 = timerset(45000L);
        while(!timeup(t1)) {
          temp = get_modem_byte(cp,5000L);
          switch(temp) {
                case TIMEOUT:   com_putc(cp,SUB);
                                break;

                case LOSTCARRIER:   free(s);
                                    free(ss);
                                    rebuild_list(handle,pos,"R",addr);
                                    return LOSTCARRIER;

                case ENQ:   goto SB0;

                default:    purge_in(cp);
                            break;
        }
        }

    logfunc(0,cp,"Request send timed out");
    com_putc(cp,ETB);
    free(s);
    free(ss);
    rebuild_list(handle,pos,"R",addr);
        return 3;
    }

    close(handle);
  make_dirname("R",s,addr);
  if(unlink(s)) {             /* Made all requests */
    logfunc(0,cp,"Unable to unlink %s",s);
  }
  else {
    logfunc(0,cp,"Unlinked request file %s",s);
  }
  com_putc(cp,ETB);
  free(s);
  free(ss);
    return 0;
}




int _fastcall rebuild_list (int handle,long pos,char *was,
                            ADDR *addr) {

  /* copies what's left in a list from pos to a new file */

  char *s,*s1,*p,type;
  int  han,wr1 = 0;

  s = (char *)malloc(1050);
  if(!s) {
    close(handle);
    return -1;
  }

  type = *was;
  *was = '!';

  make_dirname(was,s,addr);
  han = sopen(s,O_NOINHERIT | O_CREAT | O_RDWR | O_BINARY,SH_DENYWR,S_IWRITE);
  if(han == -1) {
    free(s);
    close(handle);
    return -1;
  }

  /* copy what's left of old file to new */

  lseek(handle,pos,SEEK_SET);

  while(!eof(handle)) {
    if(!fgetsx(s,1024,handle))
      break;
    wr1++;
    write(han,s,strlen(s));
  }

  close(handle);
  close(han);

  make_dirname(was,s,addr);
  s1 = strdup(s);
  if(!s1) {
    free(s);
    return -1;
  }

  p = strchr(s1,'!');
  *p = type;

  unlink(s1);            /* get rid of old file */
  if(!wr1)
    unlink(s);      /* empty file */
  else
    rename(s,s1);       /* name new file to old file */


  free(s1);
  free(s);
  return 0;
}
