/*
 * setup/execute REXX interface
 */

#define INCL_DOS

#include    <os2.h>
#include    <stdlib.h>
#include    <stdio.h>
#include    <string.h>
#include    "rexxsaa.h"

SHORT APIENTRY _loadds XBBSSUBCOM (PRXSTRING cmd,PUSHORT flags,
                                   PRXSTRING retval);

static SCBLOCK   XBBSSCBLOCK = {NULL, "XBBS", "", "", 0.,
                               (PFN) XBBSSUBCOM, 0, 0, 0, 0};



SHORT _fastcall Invoke_Rexx (USHORT cp,CHAR *ExecName) {

  SHORT    sRexxErrorCode,sErrorCode;
  RXSTRING rxsArg;
  RXSTRING rxResult;
  CHAR     argstr[RXAUTOBUFLEN];

  rxsArg.strptr = argstr;
  sprintf(argstr,"%u",cp);
  rxsArg.strlength = (long)strlen(argstr);
  sRexxErrorCode = REXXSAA (1, &rxsArg, ExecName, NULL, "XBBS",
                            RXCOMMAND, NULL, &sErrorCode,
                            &rxResult);
  logfunc(0,cp,"The return code from REXX was %d", sRexxErrorCode);
  return sRexxErrorCode;
}



void _fastcall DeregisterRexx (void) {

  /* drop our subcommand environment handler */
  RxSubcomDrop ("XBBS", "");
}



SHORT _fastcall Register_Rexx (void) {

  SHORT    sErrorCode = 0;
  SHORT    sRexxErrorCode;

  /* register our default environment with REXX */
  return RxSubcomRegister (&XBBSSCBLOCK);
}


/*******************************************************************/
/*                                                                 */
/* Function:            XBBSSUBCOM()                               */
/*                                                                 */
/* Description:         This is the XBBS subcom environment for    */
/*                      our environment.                           */
/*                                                                 */
/* Input Parms:         Command string                             */
/*                      Pointer to return flags                    */
/*                      Pointer to return string                   */
/*                                                                 */
/* Returns:             Error code                                 */
/*                                                                 */
/* References:                                                     */
/*                                                                 */
/* Notes:                                                          */
/*                                                                 */
/*     None.                                                       */
/*                                                                 */
/*******************************************************************/

SHORT APIENTRY _loadds XBBSSUBCOM (
         PRXSTRING cmd,                /* Command string           */
         PUSHORT   flags,              /* Return flags             */
         PRXSTRING retval) {           /* Return string            */

  SHORT       len;
  CHAR        FailName [CCHMAXPATH];
  PSZ         parm;
  RESULTCODES rescode;
  static CHAR cmdname[] = "CMD";
  static CHAR cmdparm[] = "/C ";

  /*******************************************************************/
  /* All we are going to do here is pass on the command passed to us */
  /* to another copy of CMD.EXE and have it execute the command.     */
  /*******************************************************************/

  parm = malloc ((USHORT) cmd -> strlength + 30);
  if (parm == NULL) {
    *flags = RXSUBCOM_ERROR;
    retval -> strlength = 0L;
    return (0);
  }
  strcpy (parm, cmdname);
  len = strlen (cmdname) + 1;
  strcpy (parm + len, cmdparm);
  len += strlen (cmdparm);
  memcpy (parm + len, cmd -> strptr, (USHORT) cmd -> strlength);
  len += (USHORT) cmd -> strlength;
  *(parm + len) = '\0';                  // 2 nulls
  *(parm + len + 1) = '\0';              // required

  DosExecPgm (FailName, sizeof (FailName), EXEC_SYNC, parm, NULL,
              &rescode, "CMD.EXE");

  if (rescode.codeTerminate != TC_EXIT)
    *flags = RXSUBCOM_ERROR;
  else
    *flags = RXSUBCOM_OK;

  free (parm);

  itoa (rescode.codeResult, retval -> strptr, 10);
  retval -> strlength = (ULONG) strlen (retval -> strptr);

  return (rescode.codeResult);
}
