#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <ctype.h>
#include "mailer.h"
#include "bbs.h"
#include "transfer.h"
#include "xmisc.h"

    extern MDM   *modems[MAXINSTANCES];
    extern USER  *user[MAXINSTANCES];

#define CTRL_K      11
#define CTRL_S      19


static char _fastcall skip_blanks (int fp);



int _fastcall readnew (int mode,USHORT cp,char *directory,int which) {

    /* which bit-mapped values: ( anything non-zero invokes readansi
                                  instead of readtext )
        2: disallow pausing/abort; continuous feed (when passed without 4 or 16)
        4: allow more? prompting
        8: allow translation through bbs_convert_string()
       16: allow aborting w/ 4
    */

    char                *p;
    char                *fullfile;
    HDIR                search_handle;
    USHORT              num_matches;
    unsigned long       reservd = 0L;
    unsigned long       num_bytes = 0L;
    unsigned int        num_files = 0L;
    struct stat         st;
    struct _file_buffer *fb;


    fb = (struct _file_buffer *)bbs_malloc(cp,sizeof(struct _file_buffer));
    if(!fb)
      return -1;
    fullfile = (char *)bbs_malloc(cp,257);
    if(!fullfile) {
        bbs_free(cp,fb);
        return -1;
    }

    search_handle = -1;
    num_matches = 1;
    if(bbs_findfirst(cp,directory,&search_handle,0,(FILEFINDBUF *)fb,
       sizeof(struct _file_buffer),&num_matches,reservd)) {
        bbs_free(cp,fb);
        bbs_free(cp,fullfile);
        return -1;
    }

    while((p = strchr(directory,'\\')) != NULL) *p = '/';
    p = strrchr(directory,'/');
    if(!p) p = strrchr(directory,':');
    if(p) {
        *p = 0;
        p++;
    }
    else p = directory; /* p points @ isolated dir or start of directory */

    do {
        if(user[cp]->offline < time(NULL)) break;
        if(p != directory) sprintf(fullfile,"%s/%s",directory,fb->filename);
        else strcpy(fullfile,fb->filename);
        if(!stat(fullfile,&st)) {
            if(st.st_mtime >= user[cp]->last_logon) {
                if(!which) readtext(mode,cp,fullfile);
                else {

                    char *p;

                    if(which & 2) p = NULL;
                    else p = "";
                    readansi(mode,cp,fullfile,p,
                      (((which & 8) != 0) * 2) |
                      ((which & 4) != 0) |
                      (((which & 16) != 0) * 4));
                }
            }
        }
        num_matches = 1;
    } while (!DosFindNext(search_handle,(FILEFINDBUF *)fb,sizeof(struct _file_buffer),
                          &num_matches));

    bbs_closefind(cp,search_handle);

    bbs_free(cp,fb);
    bbs_free(cp,fullfile);

    return 0;
}



int _pascal readtext (int mode,USHORT cp,char *s) {

    /* Read a text file with paging, searching, etc.
       Tries to break out of the stereotypical BBS file display mold */

    #define MAX_PAGE_PTRS 1024
    #define NUMSELECTS    8

    static char *selections[] = {"Next Page","Prev Page","Home","End",
                                 "Find String","Over","More","Abort"};
    long place;
    struct stat filestat;
    unsigned int page,lines = 1;
    long *pos;
    unsigned int scratch;
    int  fp;
    static int promptcolor = 4,cmdcolor = 12;
    char prev = 0,*p,*tempo,*here,lastpage = 0,searchstring[41],
         holdstring[41],teststring[81],prompt[54],findend = 0,color[15],
         printanyway = 0,a,eoff = 0,*dostring;


  if(!s || !*s)
    return 0;

  *searchstring = 0;
  *holdstring = 0;

  if (stat(s,&filestat) || !filestat.st_size || (filestat.st_mode & S_IFCHR))
    return -1;

  fp = bbs_sopen(cp,s,O_RDONLY | O_BINARY | O_NOINHERIT, SH_DENYNO);
  if(fp == -1)
    return -1;

  dostring = (char *)bbs_malloc(cp,256);
  pos = (long *)bbs_malloc(cp,(unsigned int)(sizeof(long) * MAX_PAGE_PTRS));
  if(!pos || !dostring) {
    if(pos)
      bbs_free(cp,pos);
    if(dostring)
      bbs_free(cp,dostring);
    bbs_close(cp,fp);
    return -1;
  }

  cls(mode,cp);
  page = 0;

  while((p = strchr(s,'\\')) != NULL) *p = '/'; /* Strip path off filename for display */
  p = strchr(s,':');
  here = strrchr(s,'/');
  if(!p && !here) here = s;
  else if (!here) here = &p[1];
  else if (p) here= (p < here) ? &here[1] : &p[1];
  else here++;

  dprintf(mode,cp,"File: %s  **  Page #%u\r\n",here,page+1);

  if(skip_blanks(fp)) goto Abort;
  pos[0] = tell(fp);
  lines = 1;
  while (!eof(fp)) {
    if ((*searchstring && !printanyway) || findend) goto Searcher;

Domore:

    if (!fgetsx(dostring,user[cp]->width + 2,fp)) {
        eoff++;
        goto EEOF;
    }
    stripcr(dostring);
    while ((p = (strchr(dostring,'\xc'))) != NULL)
      memmove(p,&p[1],strlen(&p[1])+1);
    while ((p = (strchr(dostring,'\x1b'))) != NULL)
      memmove(p,&p[1],strlen(&p[1])+1);
    if (!*dostring) {
        if (prev) {
            prev = 0;
            eoff = skip_blanks(fp);
            if (eoff) goto EEOF;
            else goto Domore;
        }
        else prev++;
    }
    else prev = 0;
    if (*searchstring) {
        strcpy(teststring,dostring);
        if (stristr(teststring,searchstring)) {
            dputs(mode,cp,dostring);
            lines++;
        }
        else {
            dputs(mode,cp,dostring);
            lines++;
        }
    }
    else {
        dputs(mode,cp,dostring);
        lines++;
    }
    scratch = strlen(dostring);
    p = dostring;
    while((tempo = (strchr(p,'\t'))) != NULL) {
        p = tempo + 1;
        scratch += 3;
    }
    if (scratch < 79) {
        dputs(mode,cp,"\r\n");
        scratch++;
    }
    if (scratch > user[cp]->width) {
        lines++;
    }

    a = (char)toupper(inkey(mode,cp));
    if(a)
      if(a == 'A') goto SkipThis;

Searcher:

    if (lastpage) goto EEOF;
    if ((a == 5) || (*searchstring) || (findend)) {
      if (findend) {
        if (++page > MAX_PAGE_PTRS) page = 1;
        pos[page] = tell(fp);
      }
      place = tell(fp);

Domore1:

      while (!eof(fp)) {

Domore2:

        if (!fgetsx(dostring,181,fp)) {
            eoff++;
            break;
        }
        while ((p = (strchr(dostring,'\xc'))) != NULL)
          memmove(p,&p[1],strlen(&p[1])+1);
        while ((p = (strchr(dostring,'\x1b'))) != NULL)
          memmove(p,&p[1],strlen(&p[1])+1);
        if (!strcmp(dostring,"\n")) {
            if (prev) {
                prev = 0;
                eoff = skip_blanks(fp);
                if (eoff) break;
                else goto Domore2;
            }
            else prev++;
        }
        else prev = 0;
        if (*searchstring) {
            if (stristr(dostring,searchstring)) {
                printanyway++;
                break;
            }
        }
        lines++;
        scratch = strlen(dostring);
        p = dostring;
        while((tempo = strchr(p,'\t')) != NULL) {
            p = tempo + 1;
            scratch += 3;
        }
        if (scratch < 79) {
            scratch++;
        }
        if (scratch > user[cp]->width) lines++;
        if (user[cp]->length) if ((lines >= user[cp]->length-2) || (eof(fp)) || (eoff)) break;
      }
      eoff = skip_blanks(fp);
      if (eof(fp) || eoff || printanyway) {
        if (*searchstring && !printanyway) {
            dputs(mode,cp,"\r\nNot found\r\n");
            goto EEOF;
        }
        lseek(fp,place,SEEK_SET);
        cls(mode,cp);
        dprintf(mode,cp,"File: %s  **  Page #%u\r\n",here,page+1);
        findend = prev = eoff = 0;
        lastpage = 1;
        lines = 1;
        goto Domore;
      }
      if ((*searchstring || findend) && !eoff) {
        if (++page>MAX_PAGE_PTRS) page = 1;
        pos[page] = place = tell(fp);
        lines = 1;
        goto Domore1;
      }
    }

EEOF:

    if (user[cp]->length) if ((lines >= user[cp]->length-2) || (eof(fp)) || (eoff)) {
        if(eof(fp) && findend) {
            findend = 0;
            lseek(fp,pos[page],SEEK_SET);
            goto Domore;
        }

/* Direct */

        prev = 0;
        eoff = skip_blanks(fp);
        if (eof(fp) || eoff) {
            dputs(mode,cp," (END)");
        }
        else {
            if(a == 'A') goto SkipThis;
        }
        pos[page+1] = tell(fp);

Getitagain:

        if(user[cp]->offline < time(NULL)) goto Abort;
        *prompt = 0;
        if(user[cp]->attribs & U_COLOR) {
            strcpy(prompt,MAKE_ANSI(promptcolor,color));
            dputs(mode,cp,color);
        }
        strcat(prompt,"After Page: ");
        if(user[cp]->attribs & U_COLOR) {
            strcat(prompt,MAKE_ANSI(cmdcolor,color));
        }

RePrompt:

        a = (char)select_one(mode,cp,selections,NUMSELECTS,prompt,NULL,"Read Text",((user[cp]->attribs & U_EXPERT) == 0) * 2 | ((user[cp]->attribs & U_NOROLL) == 0) * 4);
        if((signed char)a == -1) goto RePrompt;
        a++;

SkipThis:

        findend = 0;
        lastpage = 0;
        printanyway = 0;
        *searchstring = 0;

        switch (a) {
            case 0:
            case NUMSELECTS:     goto Abort;

            case 3:     if (!page) {
                            quiet_bell(mode,cp,1);
                            goto Getitagain;
                        }
                        page = 0;
                        lseek(fp,0,SEEK_SET);
                        break;

            case 4:     if (eof(fp) || eoff) {
                            quiet_bell(mode,cp,1);
                            goto Getitagain;
                        }
                        findend++;
                        break;

            case 5:     if (eof(fp) || eoff) {
                            quiet_bell(mode,cp,1);
                            goto Getitagain;
                        }
                        sprintf(dostring,"\r\n Search string: [%s]\r\n -> ",holdstring);
                        input_string(mode,cp,searchstring,40,1,dostring,
                                     STRT_ANY, STRF_UCASE, "Search string",NULL);
                        if (!*searchstring) {
                            if (*holdstring) {
                                strcpy(searchstring,holdstring);
                                if (++page > MAX_PAGE_PTRS) page = 1;
                                pos[page] = tell(fp);
                            }
                        }
                        else strcpy(holdstring,searchstring);
                        lseek(fp,pos[page],SEEK_SET);
                        eoff = skip_blanks(fp);
                        break;

            case 1:    if(eof(fp) || eoff) {
                            goto Abort;
                        }
                        a = 0;
                        if (++page > MAX_PAGE_PTRS) page = 1;
                        pos[page] = tell(fp);
                        break;

            case 6:     lseek(fp,pos[page],SEEK_SET);
                        eoff = skip_blanks(fp);
                        break;

            case 2:     if (page) {
                            lseek(fp,pos[--page],SEEK_SET);
                            eoff = skip_blanks(fp);
                            break;
                        }
                        quiet_bell(mode,cp,1);
                        goto Getitagain;

            case 7:     if (eof(fp) || eoff) {
                            quiet_bell(mode,cp,1);
                            goto Getitagain;
                        }
                        if(user[cp]->attribs & U_ANSI) {
                            dputs(mode,cp,"\r\x1b[K");
                        }
                        else {
                            dputs(mode,cp,"\r                                                \r");
                        }
                        if (user[cp]->length)
                          lines = user[cp]->length - 3;
                        goto Domore;

            default:    dputs(mode,cp,"\r\nNot yet implemented.\r\n");
                        DosSleep(2000L);
                        goto Getitagain;
        }

        eoff = 0;
        cls(mode,cp);
        dprintf(mode,cp,"File: %s  **  Page #%u\r\n",here,page+1);
        lines = 1;
      }
  }

Abort:

  if(pos) bbs_free(cp,pos);
  if(dostring) bbs_free(cp,dostring);
  bbs_close(cp,fp);
  return 0;
}




static char _fastcall skip_blanks (int fp) {  /* Skips blank lines, what else? */

  long pos;
  char temp[81];
  char eoff = 0;


  do {
    pos = tell(fp);
    if (!fgetsx(temp,81,fp))
      eoff++;
    stripcr(temp);
  } while ((!eoff) && (!eof(fp)) && (!*temp));
  if (!eoff && !eof(fp)) lseek(fp,pos,SEEK_SET);
  return eoff;
}




int _pascal readansi (int mode,USHORT cp,char *s, char *hotkeys,int flags) {

    /* flags bitmap:
        1:  pause as if normal text file (hotkeys must == NULL)
        2:  translate through bbs_convert_string()
        4:  allow aborting when flags & 1
    */

    struct stat  filestat;
    int          fp;
    char         *temp,*p;
    unsigned int kp,lines;


  if(!s || !*s)
    return 0;

  while((p = strchr(s,'\\')) != NULL)
    *p = '/';
  p = strrchr(s,'.');

  temp = malloc(1050);
  if(!temp)
    return -1;

  if(p && !stricmp(p,".XBS") && !strchr(s,'/')) {
    sprintf(temp,"%s/%s",d_menu,s);
    if(user[cp]->attribs & U_COLOR) {
        p = strrchr(temp,'.');
        p++;
        *p = 'G';                             /* Check for .GBS */
        if(stat(temp,&filestat)) *p = 'X';
    }
  }
  else if(p && !stricmp(p,".ASC")) {          /* Check for .ANS */
    sprintf(temp,"%s/%s",d_text,s);
    if(user[cp]->attribs & U_COLOR) {
        p = strrchr(temp,'.');
        p++;
        *p = 0;
        strcat(temp,"ANS");
        if(stat(temp,&filestat)) {
            *p = 0;
            strcat(temp,"ASC");
        }
    }
  }
  else
    strcpy(temp,s);

  if(stat(temp,&filestat) || !filestat.st_size || (filestat.st_mode & S_IFCHR)) {
      free(temp);
      return -1;
  }

  fp = bbs_sopen(cp,temp,O_NOINHERIT | O_RDONLY | O_BINARY, SH_DENYNO);
  if(fp == -1) {
    free(temp);
    return -1;
  }

  lines = 0;
  while(!eof(fp)) {
    if (!fgetsx(temp,134,fp))
      break;
    if(flags & 2) {
        p = bbs_convert_string(cp,temp);
        if(p) {
            dputs(mode,cp,p);
            bbs_free(cp,p);
        }
        else dputs(mode,cp,temp);
    }
    else dputs(mode,cp,temp);
    if(user[cp]->offline < time(NULL)) break;
    if(hotkeys) {       /* NOTE:  hotkeys == "" allows pause/abort */
        kp = (char)inkey(mode,cp);
        if(kp) {
            kp = toupper(kp);
            if(*hotkeys) {
                kp = check_hot(mode,cp,hotkeys,kp);
                if(kp) {
                    bbs_close(cp,fp);
                    if(user[cp]->attribs & U_COLOR)
                      dputs(mode,cp,"\x1b[0m");
                    free(temp);
                    return kp;
                }
            }
            else {
                if(kp == 'S' || kp == CTRL_K) {
                    if(user[cp]->attribs & U_COLOR)
                      dputs(mode,cp,"\x1b[0m");
                    goto BreakOut;
                }
                if(kp == 'P' || kp == CTRL_S) mpause(mode,cp);
            }
        }
    }
    else {
        if(!(user[cp]->attribs & U_NOMORE)) {
            lines++;
            if(lines > user[cp]->length - 2) {
                dputs(mode,cp,"\r\n");
                kp = do_more(mode,cp);
                if(flags & 4) {
                    if(kp)
                      break;
                }
                lines = 0;
            }
        }
    }
  }

BreakOut:

  bbs_close(cp,fp);
  free(temp);
  return 0;
}



int _pascal readany (int mode,USHORT cp,char *dir,int flags) {

    /* bitmapped flags:
        1:  read through ANSI reader w/ pausing
        2:  read through ANSI reader, no pausing
    */

    char        input[75],*build,*p;
    struct stat st;


    if(!dir)
      return -1;

    build = (char *)bbs_malloc(cp,1041);
    if(!build)
      return -1;

    strset(input,0);
    input_string(mode,cp,input,74,1,
                 "\r\nFile(s) to read:\r\n -> ",
                 STRT_MULTFILES,STRF_PRETTY,
                 "File Read",NULL);
    if(*input) {
        p = strtok(input," ");
        if(p) p = skip_white(p);
        while(p && *p) {
            sprintf(build,"%s/%s",dir,p);
            if(!stat(build,&st) && st.st_size && !(st.st_mode & S_IFCHR) && !(st.st_mode & S_IFDIR)) {
                logfunc(0,cp,"Text Read: \"%s\"",p);
                if(!flags) readtext(mode,cp,build);
                else if(flags & 1) readansi(mode,cp,build,NULL,5);
                else readansi(mode,cp,build,"",0);
            }
            p = strtok(0," ");
            if(p) p = skip_white(p);
        }
    }

    dputs(mode,cp,"\r\n");
    bbs_free(cp,build);
    return 0;
}
