/* retrieve/display sysop-definable prompts */

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "mailer.h"
#include "modem.h"
#include "bbs.h"
#include "xmisc.h"
#include "window.h"


    extern MDM  *modems[MAXINSTANCES];
    extern USER *user[MAXINSTANCES];


int _fastcall open_prompt_files (USHORT cp,int which,HFILE *id,HFILE *tt) {

    static char s[1050];
    time_t      date;
    long        size,pos;
    struct stat st;
    int         ctr = 0;
    USHORT      handstate;

    if(*id != -1)
      close(*id);
    if(*tt != -1)
      close(*tt);

    *id = *tt = -1;

    sprintf(s,"%s/PMPT%d.TXT",d_misc,which);
    if(stat(s,&st) || !st.st_size) {
      if(which != 1)
        which = 1;
    }

    sprintf(s,"%s/PMPT%d.TXT",d_misc,which);

    if(stat(s,&st) || !st.st_size) {
        logfmain("Can't find \"%s\"",s);
        return 1;
    }

    sprintf(s,"%s/PMPT%d.IDX",d_misc,which);
    *id = sopen(s,O_NOINHERIT | O_RDONLY | O_BINARY | O_CREAT,SH_DENYWR,S_IWRITE | S_IREAD);
    if(*id == -1) {
        logfmain("Can't open \"%s\"",s);
        return 2;
    }

    DosQFHandState(*id,&handstate);
    if(!(handstate & (1 << 12)))
      DosSetFHandState(*id,handstate |= (1 << 12));

    sprintf(s,"%s/PMPT%d.TXT",d_misc,which);
    *tt = sopen(s,O_RDONLY | O_BINARY | O_NOINHERIT,SH_DENYWR);
    if(*tt == -1) {
        close(*id);
        *id = -1;
        logfmain("Can't open \"%s\"",s);
        return 3;
    }

    if(filelength(*id) > (long)sizeof(long) * 2L) {
        read(*id,&date,sizeof(time_t));
        read(*id,&size,sizeof(long));
    }
    else {
        date = 0L;
        size = 0L;
    }

    if(date != st.st_mtime || size != st.st_size) {    /* needs indexing */
        close(*id);
        sprintf(s,"%s/PMPT%d.IDX",d_misc,which);
        *id = sopen(s,O_RDWR | O_BINARY | O_CREAT | O_NOINHERIT,SH_DENYWR,S_IWRITE | S_IREAD);
        if(*id == -1) {
            logfmain("Can't reopen \"%s\" to index",s);
            close(*tt);
            *tt = -1;
            return 4;
        }
        lseek(*id,(long)sizeof(long) * 2L,SEEK_SET);
        while(!eof(*tt)) {
            if(!fgetsx(s,512,*tt)) break;
            if(*s == '\01') {
                pos = tell(*tt);
                write(*id,&pos,sizeof(long));
            }
        }
        lseek(*id,0L,SEEK_SET);
        write(*id,&st.st_mtime,sizeof(time_t));
        write(*id,&st.st_size,sizeof(long));
        close(*id);
        sprintf(s,"%s/PMPT%d.IDX",d_misc,which);
        *id = sopen(s,O_RDONLY | O_BINARY | O_CREAT | O_NOINHERIT,SH_DENYWR,S_IWRITE | S_IREAD);
        if(*id == -1) {
            logfmain("Can't reopen \"%s\"",s);
            close(*tt);
            *tt = -1;
            return 5;
        }
        DosQFHandState(*id,&handstate);
        if(!(handstate & (1 << 12)))
          DosSetFHandState(*id,handstate |= (1 << 12));
    }

    DosQFHandState(*tt,&handstate);
    if(!(handstate & (1 << 12)))
      DosSetFHandState(*tt,handstate |= (1 << 12));

    return 0;
}



char * _fastcall sayp (int mode,USHORT cp,USHORT pnum,char *buf,int len) {

    long pos,kpos;
    char *s,*tp;


    if(buf && len) *buf = 0;

    if(lseek(modems[cp]->id,((long)(pnum - 1) * (long)sizeof(long)) +
      ((long)sizeof(long) * 2L),SEEK_SET) == -1L) {

        return buf;
    }
    if(read(modems[cp]->id,&pos,sizeof(long)) != sizeof(long)) {

        return buf;
    }
    if(lseek(modems[cp]->tt,pos,SEEK_SET) == -1L) {

        return buf;
    }

    s = (char *)bbs_malloc(cp,257);
    if(!s) {

        return buf;
    }

    kpos = tell(modems[cp]->tt);
    for(;;) {
        lseek(modems[cp]->tt,kpos,SEEK_SET);
        if(!fgetsx(s,256,modems[cp]->tt)) {

            break;
        }
        kpos = tell(modems[cp]->tt);
        s[256] = 0;
        stripcr(s);
        if(s[strlen(s) - 1] == ';') s[strlen(s) - 1] = 0;

ReSwitch:

        switch((int)*s) {
            case '\01':
                goto BreakOut;

            case '\02':     /* return to caller */
                if(!buf || !len) goto BreakOut;
                strncpy(buf,&s[1],min((size_t)len,strlen(s)));
                buf[len - 1] = 0;
                goto BreakOut;

            case '\03':     /* log */
                logfunc(0,cp,&s[1]);
                break;

            case '\04':     /* local only */
                dputs(D_LOCAL,cp,s);
                break;

            case '\05':     /* ANSI only */
                if(cp == -1 || !user[cp] || !(user[cp]->attribs & U_ANSI)) break;
                memmove(s,&s[1],strlen(s));
                goto ReSwitch;

            case '\06':     /* ASCII only */
                if(cp != -1 && user[cp] && !(user[cp]->attribs & U_ANSI)) {
                    memmove(s,&s[1],strlen(s));
                    goto ReSwitch;
                }
                break;

            case 11:        /* run a program */
                break;

            case 14:        /* read a file */
                break;

            case 15:        /* send to CMD.EXE */
                break;

            case 16:        /* COLOR only */
                if(cp == -1 || !user[cp] || !(user[cp]->attribs & U_COLOR)) break;
                memmove(s,&s[1],strlen(s));
                goto ReSwitch;

            case 17:        /* Pause until [Enter] key pressed */
                if(cp != -1 && user[cp]) hitreturn(mode,cp);
                break;

            case 18:        /* High ASCII */
                if(cp == -1 || !user[cp] || !(user[cp]->attribs & U_HIGHASCII)) break;
                memmove(s,&s[1],strlen(s));
                goto ReSwitch;

            case 19:        /* clear screen */
                if(cp != -1 && user[cp]) cls(mode,cp);
                break;

            case 20:        /* expert */
                if(cp == -1 || !user[cp] || !(user[cp]->attribs & U_EXPERT)) break;
                memmove(s,&s[1],strlen(s));
                goto ReSwitch;

            case 21:        /* twit */
                if(cp == -1 || !user[cp] || !(user[cp]->attribs & U_TWIT)) break;
                memmove(s,&s[1],strlen(s));
                goto ReSwitch;

            case 22:        /* novice */
                if(cp == -1 || !user[cp] || !(user[cp]->attribs & U_NOVICE)) break;
                memmove(s,&s[1],strlen(s));
                goto ReSwitch;

            case 23:        /* send help */

                break;

            case 24:        /* invoke .MNU menu */

                break;

            case 25:        /* convert literals & metas in string */
                if(cp != -1 && user[cp]) {
                    tp = bbs_convert_string(cp,&s[1]);
                    if(tp) {
                        strncpy(s,tp,256);
                        s[256] = 0;
                        bbs_free(cp,tp);
                        goto ReSwitch;
                    }
                }
                break;

            case 28:        /* convert literals in string */
                memmove(s,&s[1],strlen(s));
                literal(s);
                goto ReSwitch;

            case 29:        /* write to current commport */
                if(cp && cp != -1 && modems[cp]->mh != -1) {
                    com_write(cp,&s[1],strlen(&s[1]));
                }
                break;

            case 30:        /* write to screenlog */
                logfunc(2,cp,&s[1]);
                break;

            case 31:        /* note to status window */
                if(cp && cp != -1)
                  Say_General(&s[1]);
                break;

            default:
                if(cp != -1 && user[cp])
                  dputs(mode,cp,s);
                break;
        }

    }

BreakOut:

    bbs_free(cp,s);
    return buf;
}



char * _fastcall sayn (int mode,USHORT cp,USHORT pnum,char *buf,int len) {

    long pos;
    char *s;


    if(buf && len) *buf = 0;

    if(lseek(modems[cp]->id,((long)(pnum - 1) * (long)sizeof(long)) +
      ((long)sizeof(long) * 2L),SEEK_SET) == -1L) {

        return buf;
    }
    if(read(modems[cp]->id,&pos,sizeof(long)) != sizeof(long)) {

        return buf;
    }
    if(lseek(modems[cp]->tt,pos,SEEK_SET) == -1L) {

        return buf;
    }

    s = (char *)malloc(257);
    if(!s) {

        return buf;
    }

    for(;;) {
        if(!fgetsx(s,256,modems[cp]->tt)) {

            break;
        }
        s[256] = 0;
        stripcr(s);
        if(s[strlen(s) - 1] == ';') s[strlen(s) - 1] = 0;

ReSwitch:

        switch((int)*s) {
            case '\01':
                goto BreakOut;

            case '\02':     /* return to caller */
                if(!buf || !len) goto BreakOut;
                strncpy(buf,&s[1],min((size_t)len,strlen(s)));
                buf[len - 1] = 0;
                goto BreakOut;

            case '\03':     /* log */
                logfunc(0,cp,&s[1]);
                break;

            case '\04':     /* local only */
                dputs(D_LOCAL,cp,s);
                break;

            case 11:        /* run a program */
                break;

            case 15:        /* send to CMD.EXE */
                break;

            case 28:        /* convert literals in string */
                memmove(s,&s[1],strlen(s));
                literal(s);
                goto ReSwitch;

            case 29:        /* write to current commport */
                if(cp && cp != -1 && modems[cp]->mh != -1) {
                    com_write(cp,&s[1],strlen(&s[1]));
                }
                break;

            case 30:        /* write to screenlog */
                logfunc(2,cp,&s[1]);
                break;

            case 31:        /* note to status screen */
                if(cp && cp != -1)
                  Say_General(&s[1]);
                break;

            default:
                break;
        }

    }

BreakOut:

    free(s);
    return buf;
}


char ** _pascal pgetarray (USHORT cp,USHORT pnum,USHORT howmany) {

    long pos;
    char s[82],**selections = NULL;
    USHORT ctr;


    if(!pnum || !howmany) return NULL;

    if(lseek(modems[cp]->id,((long)(pnum - 1) * (long)sizeof(long)) +
      ((long)sizeof(long) * 2L),SEEK_SET) == -1L) {

        return NULL;
    }
    if(read(modems[cp]->id,&pos,sizeof(long)) != sizeof(long)) {

        return NULL;
    }
    if(lseek(modems[cp]->tt,pos,SEEK_SET) == -1L) {

        return NULL;
    }

    selections = (char **)bbs_malloc(cp,((sizeof(char *) * howmany) + 1));
    if(!selections) {

        return NULL;
    }

    for(ctr = 0;ctr < howmany;ctr++) {
        if(!fgetsx(s,80,modems[cp]->tt)) {

            break;
        }
        if(*s == '\01') break;
        s[80] = 0;
        stripcr(s);
        if(s[strlen(s) - 1] == ';') s[strlen(s) - 1] = 0;

        selections[ctr] = bbs_strdup(cp,s);
    }

    if(ctr < howmany) {
        logfmain("Array mismatch in prompt file line #%u; expect crash...",pnum);
        DosSleep(2000L);
    }

    return selections;
}



void _fastcall free_selections (USHORT cp,char **selector,int num) {

    /* free selection array loaded by pgetarray */

    int c;


    for(c = 0;c < num;c++) {
        bbs_free(cp,selector[c]);
    }
    bbs_free(cp,selector);
}
