#define INCL_DOSERRORS

#include <stdarg.h>
#include <process.h>
#include <io.h>
#include "mailer.h"
#include "bbs.h"
#include "modem.h"
#include "xmisc.h"

    extern MDM           *modems[MAXINSTANCES];
    extern USER          *user[MAXINSTANCES];

  #define MAX_BUFFER_LENGTH 2020

/* Modem and screen output module (BBS) */


int dprintf (int mode,USHORT cp,char *szFormat, ...) {

    /* cprintf to commport and screen */

    char    *chBuffer;
    USHORT  sLength;
    va_list pArguments;

    if((mode & D_ANSIONLY) && !(user[cp]->attribs & U_ANSI))
      return 0;
    chBuffer = (char *)bbs_malloc(cp,MAX_BUFFER_LENGTH);
    if(!chBuffer) {
      DosSemClear(&modems[cp]->bbsrunningSEM);
      return 0;
    }

    va_start(pArguments,szFormat);
    sLength = vsprintf(chBuffer,szFormat,pArguments);
    va_end(pArguments);

    if(sLength)
      sLength = dputs(mode,cp,chBuffer);

    bbs_free(cp,chBuffer);

    return (int)sLength;
}


int _fastcall dputs (int mode, USHORT cp,char *szText) {

    int mlen;

    /* cputs to commport and screen */

    if(!szText || !*szText)
      return 0;
    if(!user[cp] || ((mode & D_ANSIONLY) && !(user[cp]->attribs & U_ANSI)))
      return 0;
    if(cp && modems[cp]->curbaud && (mode & D_REMOTE) &&
       !com_online(cp) && checkcarrier(cp))
      return 0;
    mlen = (int)strlen(szText);
    if(mlen) {
      if(user[cp] && !(user[cp]->attribs & U_HIGHASCII)) {

        register char *p = szText;

        while(*p++)
          if(*p & 128)
            *p &= 127;
      }

      if(mode & D_LOCAL)    /* display locally */
        ANSIPuts(cp,szText);

      if(cp && modems[cp]->curbaud && (mode & D_REMOTE)) {   /* Write to modem */
        if(!com_online(cp) && checkcarrier(cp)) return 0;
        if(user[cp]->attribs & U_EBCDIC)
          com_write(cp,ASCIIstr2EBCDICstr(szText),mlen);
        else
          com_write(cp,szText,mlen);
        if(modems[cp]->curbaud < 2401 && mlen > 10) {
          if(!com_online(cp) && checkcarrier(cp))
            return 0;
          flushout(cp);
        }
      }
    }

    return mlen;
}


int _fastcall dputc (int mode, USHORT cp, char onebyte) {

    /* cputc to commport and screen for convenience only */

  char s[2];

  *s = onebyte;
  s[1] = 0;
  return(dputs(mode,cp,s));
}
