/*
This module contains functions to read and search a type 6 nodelist
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <malloc.h>
#include "mailer.h"
#include "bbs.h"
#include "nodelist.h"
#include "xmisc.h"

#pragma optimize("",off)

  long                   nidxsize = 0L;      // How many nodes in index
  NODEIDX _huge         *nidx = NULL;        // Pointer to nodelist index in memory

  static long            lastnodelistsize,lastnodelistdate;
  static unsigned long   nodelistSEM = 0L;

  extern BBS            *bbs;




long _fastcall read_nodelist (void) {

    /* Loads type 6 nodelist index into huge allocated array    */
    /* pointed to by nidx.  Returns 0L on error, otherwise      */
    /* returns the number of nodes in the nodelist.             */

    NODEIDX _huge          *nidxx = NULL;
    int                    handle;
    struct stat            f;
    char                   *bigstring;


    if(nidx)
      hfree(nidx);

    nidxsize = 0L;    // Zero out for safety
    nidx = NULL;

    if(bbs->attribs2 & B2_USEVER7)
      return 0L;

    bigstring = (char *)malloc(1050);
    if(!bigstring)
      return 0L;

    sprintf(bigstring,"%s/NODELIST.IDX",d_nodelist);
    if(!stat(bigstring,&f)) {
        nidxsize = f.st_size / (long)sizeof(NODEIDX);
        nidx = (NODEIDX _huge *) halloc(nidxsize,sizeof(NODEIDX));
        if (nidx == NULL) {
            nidxsize = 0L;
            free(bigstring);
            return 0L;
        }

        handle = sopen(bigstring,O_NOINHERIT | O_RDONLY | O_BINARY, SH_DENYNO);
        if(handle == -1) { // Open
            if (nidx != NULL) hfree(nidx);
            nidx = NULL;
            nidxsize = 0L;
            free(bigstring);
            return 0L;
        }

        lastnodelistsize = f.st_size;
        lastnodelistdate = f.st_mtime;

        nidxx = nidx;

        while (f.st_size) {

            int x;


            x = 32767 / sizeof(NODEIDX);
            x *= sizeof(NODEIDX);
            if(f.st_size > (long)x) {
                f.st_size -= (long)x;
            }
            else {
                x = (int)f.st_size;
                f.st_size = 0L;
            }

            if (read(handle,nidxx,x) < x || eof(handle) == -1) {
                hfree (nidx);
                nidx = NULL;
                nidxsize = 0L;
                break;
            }
            nidxx += ((long)x / (long)sizeof(NODEIDX));
            DosSleep(1L);
        }
        close(handle);
    }

    free(bigstring);
    return nidxsize;
}





NODEINFO * _fastcall get_node_from_list (NODEINFO *nif,unsigned int zone,
                                         unsigned int point,
                                         char *domain) {

    /* Given a nodeinfo_ structure with the address (net/node)         */
    /* filled in, completes the structure with info from the nodelist.  */
    /* Returns NULL if address not found or error occurred, otherwise   */
    /* returns pointer to nodeinfo_ structure passed.                  */

    int                    handle,recsize;
    long                   x;
    char                   temp[290];
    NODEIDX _huge          *nidxx;
    REAL_NODEINFO          rnif;
    unsigned int           curzone = 0;
    struct stat            st;
    char                   *bigstring;


    if(bbs->attribs2 & B2_USEVER7)
      return ver7find(nif,zone,point,domain);

    DosSemRequest(&nodelistSEM,0L);

    if(!nidxsize || !nidx) {   // No data to look through
      DosSemClear(&nodelistSEM);
      if(try_for_points(nif,zone,point,domain,temp))
       return nif;
      else
       return NULL;
    }

    if(point) {
      DosSemClear(&nodelistSEM);
      if(try_for_points(nif,zone,point,domain,temp))
        return nif;
      else
        return NULL;
    }

    bigstring = (char *)malloc(1050);
    if(!bigstring)
      return NULL;
    sprintf(bigstring,"%s/NODELIST.DAT",d_nodelist);
    if (!stat(bigstring,&st)) {
      if(st.st_size != lastnodelistsize || st.st_mtime != lastnodelistdate) {
        read_nodelist();
      }
    }

    nidxx = nidx;     // Search through RAM index...

    for (x = 0;x < nidxsize;x++) {
       if ((int)nidxx->node == -2)
         curzone = nidxx->net;
       else if (curzone == zone && nidxx->net == nif->net &&
           nidxx->node == nif->node)
         break;
       nidxx++;
       if(!(x % 1000))
         DosSleep(1L);
    }

    if (x >= nidxsize) {    /* Not listed; try alternate route */
        if(try_for_points(nif,zone,point,domain,temp)) {
          free(bigstring);
          return nif;
        }
        else {
          free(bigstring);
          return NULL;
        }
    }

    if(!stat(bigstring,&st)) {   /* say WHAT? */
      recsize = (int)(st.st_size / nidxsize);   /* actual record size */
    }
    else {
        DosSemClear(&nodelistSEM);
        free(bigstring);
        return NULL;
    }

    sprintf(bigstring,"%s/NODELIST.DAT",d_nodelist);
    handle = sopen(bigstring,O_NOINHERIT | O_RDONLY | O_BINARY, SH_DENYNO);
    if(handle == -1) {
      DosSemClear(&nodelistSEM);
      free(bigstring);
      return NULL;
    }

    if(lseek(handle,x * (long)recsize,SEEK_SET) == -1) {
        DosSemClear(&nodelistSEM);
        free(bigstring);
        return NULL;
    }

    if (read(handle,&rnif,sizeof(REAL_NODEINFO)) < sizeof(REAL_NODEINFO)) {
       close(handle);
       DosSemClear(&nodelistSEM);
       free(bigstring);
       return NULL;
    }

    close(handle);

    memcpy(nif,&rnif,sizeof(REAL_NODEINFO));
    nif->password[8] = 0;
    nif->realcost = rnif.realcost;
    nif->hubnode = rnif.hubnode;
    nif->rate = rnif.rate;
    nif->modem = rnif.modem;
    nif->flags = rnif.flags;
    nif->reserved = rnif.reserved;
    nif->name[33] = 0;
    nif->city[29] = 0;
    nif->phone[39] = 0;

    DosSemClear(&nodelistSEM);
    free(bigstring);
    return nif;
}




NODEINFO * _fastcall try_for_points (NODEINFO *nif,unsigned int zone,
                                     unsigned int point,
                                     char *domain,char *s) {

    int handle;
    char *p,*pp,compare[81],*bigstring;

    strset(nif->name,0);
    strset(nif->city,0);
    strset(nif->password,0);
    strset(nif->phone,0);
    nif->cost=0;
    nif->flags=0;
    nif->rate=0;
    nif->modem=0;
    nif->realcost=0;
    nif->hubnode=0;
    nif->reserved=0;

    sprintf(compare,"%u:%u/%u.%u@%0.8s",zone,nif->net,nif->node,
                    point,domain);

    bigstring = (char *)malloc(1050);
    if(!bigstring)
      return NULL;
    sprintf(bigstring,"%s/POINTS.LST",d_nodelist);
    if ((handle = sopen(bigstring,O_NOINHERIT | O_RDONLY | O_BINARY, SH_DENYNO)) == -1) {
      free(bigstring);
      return NULL;
    }
    free(bigstring);

    while(!eof(handle)) {
        if(!fgetsx(s,255,handle))
          break;
        if(*s == ';')
          continue;
        stripcr(s);
        if(!*s)
          continue;
        lstrip(s);
        rstrip(s);
        if(!*s)
          continue;
        p = skip_nonwhite(s);
        if(*p) {
            *p = 0;
            p++;
            if(!stricmp(s,compare)) {   /* if address matches, load info */
                p = skip_white(p);
                if(*p) {
                    pp = skip_nonwhite(p);
                    if(*pp) {
                        *pp = 0;
                        pp++;
                    }
                    rstrip(p);
                    strncpy(nif->phone,p,41);
                    nif->phone[40] = 0;
                    p = skip_white(pp);
                    if(*p) {
                        pp=skip_nonwhite(p);
                        if(*pp) {
                            *pp=0;
                            pp++;
                        }
                        rstrip(p);
                        strncpy(nif->name,p,21);
                        nif->name[20]=0;
                        p=skip_white(pp);
                        if(*p) {
                            pp=skip_nonwhite(p);
                            if(*pp) {
                                *pp=0;
                                pp++;
                            }
                            rstrip(p);
                            strncpy(nif->city,p,41);
                            p=skip_white(pp);
                            if(*p) {
                                nif->city[40]=0;
                                pp=skip_nonwhite(p);
                                if(*pp) {
                                    *pp=0;
                                    pp++;
                                }
                                rstrip(p);
                                nif->cost=atoi(p);
                                p=skip_white(pp);
                                if(*p) {
                                    pp=skip_nonwhite(p);
                                    if(*pp) {
                                        *pp=0;
                                        pp++;
                                    }
                                    rstrip(p);
                                    nif->rate=(char)(atoi(p)/300);
                                    p=skip_white(pp);
                                    if(*p) {
                                        pp=skip_nonwhite(p);
                                        if(*pp) {
                                            *pp=0;
                                            pp++;
                                        }
                                        rstrip(p);
                                        nif->modem=(char)atoi(p);
                                        p=skip_white(pp);
                                        if(*p) {
                                            pp=skip_nonwhite(p);
                                            if(*pp) {
                                                *pp=0;
                                                pp++;
                                            }
                                            rstrip(p);
                                            nif->flags=atoi(p);
                                            p=skip_white(pp);
                                            if(*p) {
                                                pp=skip_nonwhite(p);
                                                if(*pp) {
                                                    *pp=0;
                                                    pp++;
                                                }
                                                rstrip(p);
                                                strncpy(nif->password,p,9);
                                                nif->password[8]=0;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                else {
                    close(handle);
                    return NULL;
                }
                close(handle);
                return nif;
            }
            DosSleep(0L);
        }
    }
    close(handle);
    return NULL;
}

#pragma optimize("",on)
