
/*
 * A quick-and-dirty configuration utility for XBBS-OS/2 written by XBBS'
 * author and resident asshole, Mark Kimes
 */

#include "mailer.h"
#include <io.h>
#include <ctype.h>
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"

#define ISSTRING            1
#define ISLONG              2
#define ISINT               3
#define ISINTARRAY          4
#define ISBITMAP            5
#define ISBIT               6
#define ISSTIME             7

#define BBS_NUMCALLS        1
#define BBS_LASTUSERID      2
#define BBS_LASTPOINTID     3
#define BBS_MINAGE          4
#define BBS_MAXAGE          5
#define BBS_CREDIT          6
#define BBS_EXPIREDAYS      7
#define BBS_EXPIREMINS      8
#define BBS_TIMEPERDAY      9
#define BBS_SECURITY1       10
#define BBS_SECURITY2       11
#define BBS_FLAGS1          12
#define BBS_FLAGS2          13
#define BBS_UKPERDAY        14
#define BBS_DKPERDAY        15
#define BBS_ATTRIBS         16
#define BBS_ATTRIBS2        17
#define BBS_MAXUSERS        18
#define BBS_ORIGIN          19
#define BBS_MAXATTEMPTS     20
#define BBS_MSGFLAGS        21
#define BBS_FILEFLAGS       22
#define BBS_BBSMSG          23
#define BBS_BBSFILE         24
#define BBS_DEFAULTCOST     25
#define BBS_QUOTEPOS        26
#define BBS_TIMEPERCALL     27
#define BBS_ULMULTI         28
#define BBS_QUOTEODDS       29
#define BBS_LOCALBBSPRI     30
#define BBS_MAINTHREADPRI   31
#define BBS_INBOUND1        32
#define BBS_INBOUND2        33
#define BBS_INBOUND3        34
#define BBS_OKFILE1         35
#define BBS_OKFILE2         36
#define BBS_OKFILE3         37
#define BBS_MAXPAGE         38
#define BBS_SYSOP           39
#define BBS_BBSNAME         40
#define BBS_UATTRIBS        41
#define BBS_UATTRIBS2       42
#define BBS_SYSOPIN         43
#define BBS_BEGINPAGE       44
#define BBS_ENDPAGE         45
#define BBS_USEVER7         46
#define BBS_MAXUSERPKT      47

#define MAIL_INIT           50
#define MAIL_DPRE           51
#define MAIL_DSUF           52
#define MAIL_DPRE1          53
#define MAIL_DSUF1          54
#define MAIL_DPRE2          55
#define MAIL_DSUF2          56
#define MAIL_DPRE3          57
#define MAIL_DSUF3          58
#define MAIL_DPRE4          59
#define MAIL_DSUF4          60
#define MAIL_DPRE5          61
#define MAIL_DSUF5          62
#define MAIL_DPRE6          63
#define MAIL_DSUF6          64
#define MAIL_DPRE7          65
#define MAIL_DSUF7          66
#define MAIL_DPRE8          67
#define MAIL_DSUF8          68
#define MAIL_ANSWER         69
#define MAIL_EXTMAIL        70
#define MAIL_BANNER         71
#define MAIL_MAILONLY       72
#define MAIL_TOOSLOW        73
#define MAIL_MAXBAUD        74
#define MAIL_MINBAUD        75
#define MAIL_MINMAILBAUD    76
#define MAIL_MINCALLBAUD    77
#define MAIL_MAXCALLBAUD    78
#define MAIL_MINCOST        79
#define MAIL_MAXCOST        80
#define MAIL_MAXMAILK       81
#define MAIL_MAXMAILTIME    82
#define MAIL_MAXMAILMISC    83
#define MAIL_NEXTEVENT      84
#define MAIL_MAXBAD         85
#define MAIL_MAXTRIES       86
#define MAIL_LOCKED         87
#define MAIL_HUMANSOK       88
#define MAIL_RFREQSOK       89
#define MAIL_SFREQSOK       90
#define MAIL_DIALOUTOK      91
#define MAIL_ANSWEROK       92
#define MAIL_FTS0001        93
#define MAIL_RECVUNK        94
#define MAIL_SENDUNK        95
#define MAIL_MAILERPRI      96
#define MAIL_COMMPRI        97
#define MAIL_BBSPRI         98
#define MAIL_EXPORTPRI      99
#define MAIL_OUTSIDEPRI     100
#define MAIL_TRANSFERPRI    101
#define MAIL_BEGINZMH       102
#define MAIL_ENDZMH         103
#define MAIL_NOSEALINK      104
#define MAIL_NOSLO          105
#define MAIL_SEA1K          106
#define MAIL_MAXTRANSERRS   107
#define MAIL_MAXRESYNCS     108
#define MAIL_NO1K           109
#define MAIL_DEBUGTRANS     110

typedef struct __table__ {
  char  *keyword;  /* keyword as would be first in file */
  int   token;
  int   type;
  int   len;
  SHORT offset;
} TABLE;

BBS *bbs;

TABLE bbs_table[] = {
  "numcalls",BBS_NUMCALLS,ISLONG,0,FIELDOFFSET(BBS,numcalls),
  "lastuserid",BBS_LASTUSERID,ISLONG,0,FIELDOFFSET(BBS,last_userid),
  "lastpointid",BBS_LASTPOINTID,ISINT,0,FIELDOFFSET(BBS,last_pointid),
  "minage",BBS_MINAGE,ISINT,0,FIELDOFFSET(BBS,minage),
  "maxage",BBS_MAXAGE,ISINT,0,FIELDOFFSET(BBS,maxage),
  "credit",BBS_CREDIT,ISLONG,0,FIELDOFFSET(BBS,credit),
  "expiredays",BBS_EXPIREDAYS,ISINT,0,FIELDOFFSET(BBS,expiredays),
  "expiremins",BBS_EXPIREMINS,ISLONG,0,FIELDOFFSET(BBS,expiremins),
  "timeperday",BBS_TIMEPERDAY,ISINT,0,FIELDOFFSET(BBS,time_per_day),
  "security1",BBS_SECURITY1,ISLONG,0,FIELDOFFSET(BBS,security1),
  "security2",BBS_SECURITY2,ISLONG,0,FIELDOFFSET(BBS,security2),
  "flags1",BBS_FLAGS1,ISLONG,0,FIELDOFFSET(BBS,flags1),
  "flags2",BBS_FLAGS2,ISLONG,0,FIELDOFFSET(BBS,flags2),
  "ukperday",BBS_UKPERDAY,ISLONG,0,FIELDOFFSET(BBS,ukperday),
  "dkperday",BBS_DKPERDAY,ISLONG,0,FIELDOFFSET(BBS,dkperday),
  "attribs",BBS_ATTRIBS,ISLONG,0,FIELDOFFSET(BBS,attribs),
  "attribs2",BBS_ATTRIBS2,ISLONG,0,FIELDOFFSET(BBS,attribs2),
  "maxusers",BBS_MAXUSERS,ISINT,0,FIELDOFFSET(BBS,maxusers),
  "origin",BBS_ORIGIN,ISSTRING,65,FIELDOFFSET(BBS,origin),
  "maxattempts",BBS_MAXATTEMPTS,ISINT,0,FIELDOFFSET(BBS,maxattempts),
  "msgflags",BBS_MSGFLAGS,ISBITMAP,512,FIELDOFFSET(BBS,msgflags),
  "fileflags",BBS_FILEFLAGS,ISBITMAP,512,FIELDOFFSET(BBS,fileflags),
  "bbsmsg",BBS_BBSMSG,ISBITMAP,512,FIELDOFFSET(BBS,bbsmsg),
  "bbsfile",BBS_BBSFILE,ISBITMAP,512,FIELDOFFSET(BBS,bbsfile),
  "defaultcost",BBS_DEFAULTCOST,ISINT,0,FIELDOFFSET(BBS,defaultcost),
  "quotepos",BBS_QUOTEPOS,ISLONG,0,FIELDOFFSET(BBS,quotepos),
  "timepercall",BBS_TIMEPERCALL,ISINT,0,FIELDOFFSET(BBS,time_per_call),
  "ulmulti",BBS_ULMULTI,ISINT,0,FIELDOFFSET(BBS,ulmulti),
  "quoteodds",BBS_QUOTEODDS,ISINT,0,FIELDOFFSET(BBS,quoteodds),
  "localbbspri",BBS_LOCALBBSPRI,ISINTARRAY,2,FIELDOFFSET(BBS,localbbs),
  "mainthreadpri",BBS_MAINTHREADPRI,ISINTARRAY,2,FIELDOFFSET(BBS,mainthread),
  "inbound1",BBS_INBOUND1,ISSTRING,132,FIELDOFFSET(BBS,inbound[0]),
  "inbound2",BBS_INBOUND2,ISSTRING,132,FIELDOFFSET(BBS,inbound[1]),
  "inbound3",BBS_INBOUND3,ISSTRING,132,FIELDOFFSET(BBS,inbound[2]),
  "okfile1",BBS_OKFILE1,ISSTRING,132,FIELDOFFSET(BBS,okfiles[0]),
  "okfile2",BBS_OKFILE2,ISSTRING,132,FIELDOFFSET(BBS,okfiles[1]),
  "okfile3",BBS_OKFILE3,ISSTRING,132,FIELDOFFSET(BBS,okfiles[2]),
  "maxpage",BBS_MAXPAGE,ISINT,0,FIELDOFFSET(BBS,maxpage),
  "sysop",BBS_SYSOP,ISSTRING,20,FIELDOFFSET(BBS,sysop),
  "bbsname",BBS_BBSNAME,ISSTRING,50,FIELDOFFSET(BBS,bbs_name),
  "uattribs",BBS_UATTRIBS,ISLONG,0,FIELDOFFSET(BBS,uattribs),
  "uattribs2",BBS_UATTRIBS2,ISLONG,0,FIELDOFFSET(BBS,uattribs2),
  "sysopin",BBS_SYSOPIN,ISBIT,0,0,
  "beginpage",BBS_BEGINPAGE,ISSTIME,0,FIELDOFFSET(BBS,beginpage),
  "endpage",BBS_ENDPAGE,ISSTIME,0,FIELDOFFSET(BBS,endpage),
  "usever7",BBS_USEVER7,ISBIT,0,0,
  "maxuserpkt",BBS_MAXUSERPKT,ISLONG,0,FIELDOFFSET(BBS,maxuserpkt),
  "",0,0,0,0
};

MDM *modem;

TABLE modem_table[] = {
  "init",MAIL_INIT,ISSTRING,128,FIELDOFFSET(MDM,init),
  "dpre",MAIL_DPRE,ISSTRING,128,FIELDOFFSET(MDM,dpre),
  "dsuf",MAIL_DSUF,ISSTRING,32,FIELDOFFSET(MDM,dsuf),
  "dpre1",MAIL_DPRE1,ISSTRING,128,FIELDOFFSET(MDM,dprevar[0]),
  "dsuf1",MAIL_DSUF1,ISSTRING,32,FIELDOFFSET(MDM,dsufvar[0]),
  "dpre2",MAIL_DPRE2,ISSTRING,128,FIELDOFFSET(MDM,dprevar[1]),
  "dsuf2",MAIL_DSUF2,ISSTRING,32,FIELDOFFSET(MDM,dsufvar[1]),
  "dpre3",MAIL_DPRE3,ISSTRING,128,FIELDOFFSET(MDM,dprevar[2]),
  "dsuf3",MAIL_DSUF3,ISSTRING,32,FIELDOFFSET(MDM,dsufvar[2]),
  "dpre4",MAIL_DPRE4,ISSTRING,128,FIELDOFFSET(MDM,dprevar[3]),
  "dsuf4",MAIL_DSUF4,ISSTRING,32,FIELDOFFSET(MDM,dsufvar[3]),
  "dpre5",MAIL_DPRE5,ISSTRING,128,FIELDOFFSET(MDM,dprevar[4]),
  "dsuf5",MAIL_DSUF5,ISSTRING,32,FIELDOFFSET(MDM,dsufvar[4]),
  "dpre6",MAIL_DPRE6,ISSTRING,128,FIELDOFFSET(MDM,dprevar[5]),
  "dsuf6",MAIL_DSUF6,ISSTRING,32,FIELDOFFSET(MDM,dsufvar[5]),
  "dpre7",MAIL_DPRE7,ISSTRING,128,FIELDOFFSET(MDM,dprevar[6]),
  "dsuf7",MAIL_DSUF7,ISSTRING,32,FIELDOFFSET(MDM,dsufvar[6]),
  "dpre8",MAIL_DPRE8,ISSTRING,128,FIELDOFFSET(MDM,dprevar[7]),
  "dsuf8",MAIL_DSUF8,ISSTRING,32,FIELDOFFSET(MDM,dsufvar[7]),
  "answer",MAIL_ANSWER,ISSTRING,64,FIELDOFFSET(MDM,answer),
  "extmail",MAIL_EXTMAIL,ISSTRING,128,FIELDOFFSET(MDM,extmail),
  "banner",MAIL_BANNER,ISSTRING,161,FIELDOFFSET(MDM,banner),
  "mailonly",MAIL_MAILONLY,ISSTRING,161,FIELDOFFSET(MDM,mailonly),
  "tooslow",MAIL_TOOSLOW,ISSTRING,161,FIELDOFFSET(MDM,tooslow),
  "maxbaud",MAIL_MAXBAUD,ISINT,0,FIELDOFFSET(MDM,maxbaud),
  "minbaud",MAIL_MINBAUD,ISINT,0,FIELDOFFSET(MDM,minbaud),
  "minmailbaud",MAIL_MINMAILBAUD,ISINT,0,FIELDOFFSET(MDM,minmailbaud),
  "mincallbaud",MAIL_MINCALLBAUD,ISINT,0,FIELDOFFSET(MDM,mincallbaud),
  "maxcallbaud",MAIL_MAXCALLBAUD,ISINT,0,FIELDOFFSET(MDM,maxcallbaud),
  "mincost",MAIL_MINCOST,ISINT,0,FIELDOFFSET(MDM,mincost),
  "maxcost",MAIL_MAXCOST,ISINT,0,FIELDOFFSET(MDM,maxcost),
  "maxmailk",MAIL_MAXMAILK,ISLONG,0,FIELDOFFSET(MDM,maxmailk),
  "maxmailtime",MAIL_MAXMAILTIME,ISLONG,0,FIELDOFFSET(MDM,maxmailtime),
  "maxmailmisc",MAIL_MAXMAILMISC,ISLONG,0,FIELDOFFSET(MDM,maxmailmisc),
  "nextevent",MAIL_NEXTEVENT,ISLONG,0,FIELDOFFSET(MDM,nextevent),
  "maxbad",MAIL_MAXBAD,ISINT,0,FIELDOFFSET(MDM,maxbad),
  "maxtries",MAIL_MAXTRIES,ISINT,0,FIELDOFFSET(MDM,maxtries),
  "locked",MAIL_LOCKED,ISBIT,0,0,
  "humansok",MAIL_HUMANSOK,ISBIT,0,0,
  "rfreqsok",MAIL_RFREQSOK,ISBIT,0,0,
  "sfreqsok",MAIL_SFREQSOK,ISBIT,0,0,
  "dialoutok",MAIL_DIALOUTOK,ISBIT,0,0,
  "answerok",MAIL_ANSWEROK,ISBIT,0,0,
  "fts0001",MAIL_FTS0001,ISBIT,0,0,
  "recvunk",MAIL_RECVUNK,ISBIT,0,0,
  "sendunk",MAIL_SENDUNK,ISBIT,0,0,
  "mailerpri",MAIL_MAILERPRI,ISINTARRAY,2,FIELDOFFSET(MDM,mailer),
  "sendpri",MAIL_COMMPRI,ISINTARRAY,2,FIELDOFFSET(MDM,comm),
  "bbspri",MAIL_BBSPRI,ISINTARRAY,2,FIELDOFFSET(MDM,bbs),
  "exportpri",MAIL_EXPORTPRI,ISINTARRAY,2,FIELDOFFSET(MDM,export),
  "outsidepri",MAIL_OUTSIDEPRI,ISINTARRAY,2,FIELDOFFSET(MDM,outside),
  "receivepri",MAIL_TRANSFERPRI,ISINTARRAY,2,FIELDOFFSET(MDM,transfer),
  "beginzmh",MAIL_BEGINZMH,ISSTIME,0,FIELDOFFSET(MDM,beginZMH),
  "endzmh",MAIL_ENDZMH,ISSTIME,0,FIELDOFFSET(MDM,endZMH),
  "nosealink",MAIL_NOSEALINK,ISBIT,0,0,
  "noslo",MAIL_NOSLO,ISBIT,0,0,
  "sea1k",MAIL_SEA1K,ISBIT,0,0,
  "maxresyncs",MAIL_MAXRESYNCS,ISINT,0,FIELDOFFSET(MDM,maxresyncs),
  "maxtranserrs",MAIL_MAXTRANSERRS,ISINT,0,FIELDOFFSET(MDM,maxtranserrs),
  "no1k",MAIL_NO1K,ISBIT,0,0,
  "debugtransfers",MAIL_DEBUGTRANS,ISBIT,0,0,
  "",0,0,0,0
};

int _fastcall     look_up (char *str,char *params,TABLE *table,char *var);
int _fastcall     parse_bit(TABLE *table,int x,char *params,char *var);
int _fastcall     parse_string (SHORT varoffset,int len,char *str,char *var);
int _fastcall     parse_long (SHORT varoffset,char *str,char *var);
int _fastcall     parse_int (SHORT varoffset,char *str,char *var);
int _fastcall     parse_bitmap (SHORT varoffset,int len,char *str,char *var);
int _fastcall     parse_intarray (SHORT varoffset,int size,char *str,char *var);
int _fastcall     parse_stime (SHORT varoffset,char *str,char *var);
void              setup_bbs_defaults(void);
void              setup_modem_defaults(void);
void              show_bbs(void);
void              show_mailer(int linenum);
char * _fastcall  fixup (char *orig,char *dest,int maxlen);

extern int    _fastcall mevaluate(char *, long *);
extern char * _fastcall literal (char *fsource);




int main (int argc,char *argv[]) {

  register unsigned int x;
  FILE         *infile,*outfile;
  char         *p;
  static char  ext[81] = "CFG";
  static char  s[1025];
  int          lineno = 0,show = 0,debug = 0;
  SEL          tsel;
  BBS          *bbsshr = NULL;
  MDM          *mdmshr = NULL;

  fprintf(stderr,"\x1b[2J\r     \nMakecfg copyright (c) 1993 by M. Kimes -- "
                 "all rights reserved\nCompiled:  "__DATE__ " "__TIME__"\n\n");
  if(argc > 1 && (!stricmp(argv[1],"/H") || !stricmp(argv[1],"-H") ||
     !stricmp(argv[1],"H") || !stricmp(argv[1],"/?") ||
     !stricmp(argv[1],"-?") || !stricmp(argv[1],"?"))) {
    printf(" Usage:\n  MAKECFG /H  (this help)\n  MAKECFG /L  (list configs)\n"
           "  MAKECFG /D  (debug info while setting configs)\n"
           "  MAKECFG <anything else or nothing>  (set configs)\n"
           "    (if anything else, use as extension for files, default CFG)\n");
    printf("\n Files used:\n  XBBSBBS.<extension>  (BBS config file)\n"
           "  XBBS###.<extension>  (Line config file)\n"
           "\n Modifies in-memory parameters if XBBS is running, X?CONFIG.###\n"
           " files if not, unless /L is used, in which case it outputs to stdout\n"
           " the current configurations.\n"
           "\n Note that strings are run through a vaguely C-like preprocessor so\n"
           " that \\r is a carriage return, \\x1b is escape, \\\\ is \\, etc.\n"
           " Numbers are similarly treated, so 1 | 2 == 3 and 0x10 == 16 decimal.\n");
    return 254;
  }

  if(argc > 1 && (!stricmp(argv[1],"/D") || !stricmp(argv[1],"-D") ||
     !stricmp(argv[1],"D"))) {
    argc = 1;
    debug = 1;
  }

  if(argc > 1 && (!stricmp(argv[1],"/L") || !stricmp(argv[1],"-L") ||
     !stricmp(argv[1],"L"))) {
    argc = 1;
    show = 1;
  }

  if(!show)
    fprintf(stderr,"  MAKECFG /H for help\n");

  if(argc > 1) {
    strncpy(ext,argv[1],80);
    ext[80] = 0;
    printf("\n*Using config files with extension \"%s\"\n",ext);
  }

  /*
   * why we set the priority so high:
   *
   * we don't want to change something while the BBS is also changing it.
   * therefore, we set our priority too high to be interrupted, and
   * put some sleeps in the loops to prevent eating up all the time while
   * this runs.
   */
  DosSetPrty(PRTYS_PROCESS,PRTYC_TIMECRITICAL,31,0);

  sprintf(s,"XBBSBBS.%s",ext);
  if(!show) {
    infile = fopen(s,"rt");
    if(!infile) {
        printf("\n**Can't open %s for input.\n",s);
        goto Mailers;
    }
    printf("\n*Processing BBS config...");
  }

  if(!DosGetShrSeg("\\SHAREMEM\\XBBS\\BBS.0",&tsel))
      bbsshr = (BBS *)MAKEP(tsel,0);

  if(!bbsshr) {
    bbs = malloc(sizeof(BBS));
    memset(bbs,0,sizeof(BBS));
    outfile = fopen("XBCONFIG.000","rb");
    if(!outfile)
      setup_bbs_defaults();
    else {          /* read old values */
      if(filelength(fileno(outfile)) == (long)sizeof(BBS))
        fread(bbs,sizeof(BBS),1,outfile);
      fclose(outfile);
    }
  }
  else
    bbs = bbsshr;

  if(show)
    show_bbs();
  else {
    while(!feof(infile)) {
      DosSleep(64L);
      if(!fgets(s,1024,infile))
        break;
      lineno++;
      stripcr(s);
      lstrip(s);
      rstrip(s);
      if(!*s || *s == ';' || *s == '\x1a')
        continue;
      p = skip_nonwhite(s);
      if(!*p) {
          printf("\n**Error line #%d: no argument for \"%s\"",lineno,s);
          continue;
      }
      *p = 0;
      p++;
      lstrip(p);
      if(!*p) {
          printf("\n**Error line #%d: no argument for \"%s\"",lineno,s);
          continue;
      }
      if(debug)
        printf("\n#%d: \"%s\" \"%s\"",lineno,s,p);
      if(look_up(s,p,bbs_table,(char *)bbs)) {
          printf("\n**Error line #%d: bad verb or argument: \"%s\" \"%s\"",lineno,s,p);
          continue;
      }
    }
    fclose(infile);
    outfile = fopen("XBCONFIG.000","wb");
    if(!outfile) {
        printf("\n**Can't open XBCONFIG.000 for output.\n");
        goto Mailers;
    }
    fwrite(bbs,sizeof(BBS),1,outfile);
    fclose(outfile);
  }
  if(bbsshr) {
    if(!show)
      printf("\n*Modified in-memory parameters");
    else
      DosFreeSeg(tsel);
  }
  else
    free(bbs);
  DosSleep(64L);

Mailers:

  for(x = 0;x < MAXINSTANCES;x++) {
      if(!show) {
        lineno = 0;
        sprintf(s,"XBBS%03x.%s",x,ext);
        infile = fopen(s,"rt");
        if(!infile)
          continue;
        printf("\n*Processing line #%u...",x);
      }
      sprintf(s,"\\SHAREMEM\\XBBS\\MDM.%u",x);
      if(!DosGetShrSeg(s,&tsel))
        mdmshr = (MDM *)MAKEP(tsel,0);
      else
        mdmshr = NULL;

      if(!mdmshr) {
        modem = malloc(sizeof(MDM));
        memset(modem,0,sizeof(MDM));
        sprintf(s,"XMCONFIG.%03x",x);
        outfile = fopen(s,"rb");
        if(!outfile) {
          if(show)
            continue;
          else
            setup_modem_defaults();
        }
        else {          /* read old values */
          if(filelength(fileno(outfile)) == sizeof(MDM))
            fread(modem,sizeof(MDM),1,outfile);
          fclose(outfile);
        }
      }
      else
        modem = mdmshr;

      if(show)
        show_mailer(x);
      else {
        while(!feof(infile)) {
          DosSleep(64L);
          if(!fgets(s,1024,infile))
            break;
          lineno++;
          stripcr(s);
          lstrip(s);
          rstrip(s);
          if(!*s || *s == ';' || *s == '\x1a')
            continue;
          p = skip_nonwhite(s);
          if(!*p) {
              printf("\n**Error line #%d: no argument for \"%s\"",lineno,s);
              continue;
          }
          *p = 0;
          p++;
          lstrip(p);
          if(!*p) {
              printf("\n**Error line #%d: no argument for \"%s\"",lineno,s);
              continue;
          }
          if(debug)
            printf("\n#%d: \"%s\" \"%s\"",lineno,s,p);
          if(look_up(s,p,modem_table,(char *)modem)) {
              printf("\n**Error line #%d; bad verb or argument: \"%s\" \"%s\"",lineno,s,p);
              continue;
          }
        }
        fclose(infile);

        sprintf(s,"XMCONFIG.%03x",x);
        outfile = fopen(s,"wb");
        if(!outfile) {
            printf("\n**Can't open %s for output.\n",s);
            return 2;
        }
        fwrite(modem,sizeof(MDM),1,outfile);
        fclose(outfile);
      }

      if(mdmshr) {
        if(!show) {
          DosFreeSeg(tsel);
          printf("\n*Modified in-memory parameters");
        }
        else
          DosFreeSeg(tsel);
        mdmshr = NULL;
      }
      else
        free(modem);
      modem = NULL;
      DosSleep(64L);
  }

  return 0;
}


int _fastcall look_up (char *str,char *params,TABLE *table,char *var) {

  register int x = 0;

  while(*table[x].keyword) {
      if(!stricmp(table[x].keyword,str)) {
          switch(table[x].type) {
              case ISSTRING:
                  return parse_string(table[x].offset,table[x].len,params,var);

              case ISLONG:
                  return parse_long(table[x].offset,params,var);

              case ISINT:
                  return parse_int(table[x].offset,params,var);

              case ISINTARRAY:
                  return parse_intarray(table[x].offset,table[x].len,params,var);

              case ISBITMAP:
                  return parse_bitmap(table[x].offset,table[x].len,params,var);

              case ISBIT:
                  return parse_bit(table,x,params,var);

              case ISSTIME:
                  return parse_stime(table[x].offset,params,var);

              default:
                  return table[x].type;
          }
          return 0;
      }
      x++;
  }
  return -1;
}


int _fastcall parse_bit (TABLE *table,int x,char *params,char *var) {

  if(table == modem_table) {
      switch(table[x].token) {
          case MAIL_LOCKED:
              modem->locked = atoi(params);
              break;
          case MAIL_HUMANSOK:
              modem->humansok = atoi(params);
              break;
          case MAIL_RFREQSOK:
              modem->rfreqsok = atoi(params);
              break;
          case MAIL_SFREQSOK:
              modem->sfreqsok = atoi(params);
              break;
          case MAIL_DIALOUTOK:
              modem->dialoutok = atoi(params);
              break;
          case MAIL_ANSWEROK:
              modem->answerok = atoi(params);
              break;
          case MAIL_FTS0001:
              modem->fts0001 = atoi(params);
              break;
          case MAIL_RECVUNK:
              modem->recvunk = atoi(params);
              break;
          case MAIL_SENDUNK:
              modem->sendunk = atoi(params);
              break;
          case MAIL_SEA1K:
              modem->sea1k = atoi(params);
              break;
          case MAIL_NOSEALINK:
              modem->nosealink = atoi(params);
              break;
          case MAIL_NOSLO:
              modem->noslo = atoi(params);
              break;
          case MAIL_NO1K:
              modem->no1k = atoi(params);
              break;
          case MAIL_DEBUGTRANS:
              modem->debugtrans = atoi(params);
              break;
          case BBS_SYSOPIN:
              bbs->sysopin = atoi(params);
              break;
          case BBS_USEVER7:
              if(atoi(params))
                bbs->attribs2 |= B2_USEVER7;
              else
                bbs->attribs2 &= (~B2_USEVER7);
              break;
          default:
              return -1;
      }
  }
  return 0;
}


int _fastcall parse_string (SHORT varoffset,int len,char *str,char *var) {

  literal(str);
  if(str[strlen(str) - 1] == ';')
    str[strlen(str) - 1] = 0;
  strncpy(var + varoffset,str,len);
  if(len > 1)
    var[varoffset + (len - 1)] = 0;
  return 0;
}


int _fastcall parse_long (SHORT varoffset,char *str,char *var) {

  int  ret;
  long temp = 0L;

  *(long *)(var + varoffset) = 0L;
  ret = mevaluate(str,&temp);
  if(!ret)
    *(long *)(var + varoffset) = temp;
  return ret;
}


int _fastcall parse_int (SHORT varoffset,char *str,char *var) {

  long temp = 0L;
  int  ret;

  *(int *)(var + varoffset) = 0;
  ret = mevaluate(str,&temp);
  if(!ret)
    *(int *)(var + varoffset) = (int)temp;
  return ret;
}


int _fastcall parse_intarray (SHORT varoffset,int len,char *str,char *var) {

  char         *p = str,*pp;
  register int x;
  int          ret;
  long         temp;

  for(x = 0;x < len;x++) {
      if(p && *p) {
          pp = strchr(p,',');
          if(!pp) pp = strchr(p,' ');
          if(pp && *pp) {
              *pp = 0;
              pp++;
          }
          temp = 0L;
          ret = mevaluate(p,&temp);
          if(!ret)
            ((int *)(var + varoffset))[x] = (int)temp;
          else
            ((int *)(var + varoffset))[x] = 0;
          p = pp;
      }
      else
        ((int *)(var + varoffset))[x] = 0;
  }
  return 0;
}


int _fastcall parse_stime (SHORT varoffset,char *str,char *var) {

  char  *p = str;
  STIME  temp;

  memset(&temp,0,sizeof(STIME));
  if(p && *p) {
      temp.hour = (char)atoi(p);
      p = strchr(p,':');
      if(p && *p) {
          p++;
          temp.min = (char)atoi(p);
          p = strchr(p,':');
          if(p && *p) {
              p++;
              temp.sec = (char)atoi(p);
              if(temp.hour > 24 ||
                 temp.min > 59 ||
                 temp.sec > 59) {
                  printf("\nInvalid timestring \"%s\"\n",str);
                  return -1;
              }
              *(STIME *)(var + varoffset) = temp;
          }
      }
  }
  else {
      printf("\nMissing timestring\n");
      return -1;
  }
  return 0;
}


int _fastcall parse_bitmap (SHORT varoffset,int len,char *str,char *var) {

  char *p = str;
  register int x;

  for(x = 0; x < len;x++) {
    if(*p) {
      if(*p == '-')
        BitOff((var + varoffset),x);
      else
        BitOn((var + varoffset),x);
      p++;
    }
    else
      BitOn((var + varoffset),x);
  }
  return 0;
}


void setup_bbs_defaults (void) {

  bbs->quotepos = 0L;
  bbs->numcalls = 0L;
  bbs->last_userid = 0L;
  bbs->last_pointid = 0;
  bbs->minage = 12;
  bbs->maxage = 130;
  bbs->credit = 0;
  bbs->expiredays = 0;
  bbs->expiremins = 0;
  bbs->time_per_day = 45;
  bbs->security1 = 5L;
  bbs->security2 = 0L;
  bbs->flags1 = 0L;
  bbs->flags2 = 0L;
  bbs->ukperday = 500L;
  bbs->dkperday = 500L;
  bbs->attribs = B_LOGONQUOTE | B_LOGOFFQUOTE | B_FIRSTLOGMSG |
                B_LOGOFFMSG | B_FOLLOWBBS;
  bbs->attribs2 = 0L;
  strcpy(bbs->origin,"An OS/2 XBBS");
  memset(bbs->msgflags,255,64);
  memset(bbs->fileflags,255,64);
  memset(bbs->bbsmsg,255,64);
  memset(bbs->bbsfile,255,64);
  bbs->defaultcost = 50;
  bbs->maxattempts = 3;
  bbs->time_per_call = 30;
  bbs->ulmulti = 0;
  bbs->quoteodds = 50;
  bbs->localbbs[0] = 2;
  bbs->localbbs[1] = 0;
  bbs->mainthread[0] = 2;
  bbs->mainthread[1] = 15;
  strcpy(bbs->inbound[0],"./INBOUND");
  strcpy(bbs->inbound[1],"./INBOUND");
  strcpy(bbs->inbound[2],"./INBOUND");
  strcpy(bbs->okfiles[0],"./OKFILE.LST");
  strcpy(bbs->okfiles[1],"./OKFILE.LST");
  strcpy(bbs->okfiles[2],"./OKFILE.LST");
  bbs->maxpage = 3;
  strcpy(bbs->sysop,"Duhhh");
  strcpy(bbs->bbs_name,"XBBS in your eye");
  bbs->uattribs = U_NOVICE | U_SEENEWS | U_AVAILABLE;
  bbs->maxuserpkt = 65535L;
}

void setup_modem_defaults (void) {

  strcpy(modem->dpre,"v~^~ATDT ");
  strcpy(modem->dsuf,"|");
  strcpy(modem->dprevar[0],"v~^~ATDT ");
  strcpy(modem->dsufvar[0],"|");
  strcpy(modem->dprevar[1],"v~^~ATDT ");
  strcpy(modem->dsufvar[1],"|");
  strcpy(modem->dprevar[2],"v~^~ATDT ");
  strcpy(modem->dsufvar[2],"|");
  strcpy(modem->dprevar[3],"v~^~ATDT ");
  strcpy(modem->dsufvar[3],"|");
  strcpy(modem->dprevar[4],"v~^~ATDT ");
  strcpy(modem->dsufvar[4],"|");
  strcpy(modem->dprevar[5],"v~^~ATDT ");
  strcpy(modem->dsufvar[5],"|");
  strcpy(modem->dprevar[6],"v~^~ATDT ");
  strcpy(modem->dsufvar[6],"|");
  strcpy(modem->dprevar[7],"v~^~ATDT ");
  strcpy(modem->dsufvar[7],"|");
  strcpy(modem->answer,"ATA|");
  strcpy(modem->banner,"\r\nIdentify, humanoid:\r\n -> ");
  strcpy(modem->mailonly,"\rGO AWAY, HUMAN\r");
  strcpy(modem->init,"v~^~AT Z0|~AT S2=255 S9=28 H0 %C0|~");

  /*
   * note the above init string is for an Intel 9600ex (most
   * parameters already set in NVRAM)
   *
   */

  strcpy(modem->extmail,"cmd.exe /c mail.cmd %s");
  strcpy(modem->tooslow,"\r\nYou're too slow\r\n");
  modem->locked = 1;
  modem->humansok = 1;
  modem->fts0001 = 0;
  modem->maxbaud = 19200;
  modem->minbaud = 1200;
  modem->minmailbaud = 1200;
  modem->mincallbaud = 2400;
  modem->maxcallbaud = 38400;
  modem->mincost = 0;
  modem->maxcost = 1;
  modem->sfreqsok = 1;
  modem->rfreqsok = 1;
  modem->dialoutok = 1;
  modem->answerok = 1;
  modem->nextevent = 0L;
  modem->maxmailk = 1024L;
  modem->maxmailtime = 60L * 60L;
  modem->maxmailmisc = 0L;
  modem->maxbad = 3;
  modem->maxtries = 100;
  modem->whichin = 0;
  modem->mailer[0] = 2;
  modem->mailer[1] = 15;
  modem->comm[0] = 4;
  modem->comm[1] = 0;
  modem->bbs[0] = 2;
  modem->bbs[1] = 1;
  modem->export[0] = 2;
  modem->export[1] = 0;
  modem->outside[0] = 2;
  modem->outside[1] = 1;
  modem->transfer[0] = 4;
  modem->transfer[1] = 2;
  modem->nosealink = 0;
  modem->noslo = 0;
  modem->sea1k = 0;
  modem->maxresyncs = 20;
  modem->maxtranserrs = 200;
  modem->no1k = 1;
  modem->debugtrans = 0;
}

void show_bbs (void) {

  register int x = 0;
  static char  str[4096];

  printf("\n;BBS table:\n;%-31s  %s\n","Keyword:","Value:");
  while(*bbs_table[x].keyword) {
    DosSleep(64L);
    printf("\n%-32s  ",bbs_table[x].keyword);
    switch(bbs_table[x].type) {
      case 0:
          return;
      case ISSTRING:
          printf("%s",fixup(((char *)bbs + bbs_table[x].offset),str,4095));
          break;
      case ISLONG:
          printf("%ld",*(long *)((char *)bbs + bbs_table[x].offset));
          break;
      case ISINT:
          printf("%d",*(int *)((char *)bbs + bbs_table[x].offset));
          break;
      case ISINTARRAY:
          {
            INT cnt;

            for(cnt = 0;cnt < bbs_table[x].len;cnt++) {
              printf("%d",((int *)((char *)bbs + bbs_table[x].offset))[cnt]);
              if(cnt < bbs_table[x].len - 1)
                printf(",");
            }
          }
          break;
      case ISBITMAP:
          {
            INT cnt;

            for(cnt = 0; cnt < bbs_table[x].len;cnt++) {
              if(!IsBit(((char *)bbs + bbs_table[x].offset),cnt))
                printf("-");
              else
                printf("X");
            }
          }
          break;
      case ISBIT:
          switch(bbs_table[x].token) {
            case BBS_SYSOPIN:
                printf("%d",bbs->sysopin);
                break;
            case BBS_USEVER7:
                printf("%d",(bbs->attribs & B2_USEVER7) ? "1" : "0");
                break;
          }
          break;
      case ISSTIME:
          printf("%02d:%02d:%02d",
                 ((STIME *)((char *)bbs + bbs_table[x].offset))->hour,
                 ((STIME *)((char *)bbs + bbs_table[x].offset))->min,
                 ((STIME *)((char *)bbs + bbs_table[x].offset))->sec);
          break;
    }
    x++;
  }
}

void show_mailer (int linenum) {

  register int x = 0;
  static char  str[4096];

  printf("\n\n;MAILER table #%d:\n;%-31s  %s\n",linenum,"Keyword:","Value:");
  while(*modem_table[x].keyword) {
    DosSleep(64L);
    printf("\n%-32s  ",modem_table[x].keyword);
    switch(modem_table[x].type) {
      case 0:
          return;
      case ISSTRING:
          printf("%s",fixup(((char *)modem + modem_table[x].offset),str,4095));
          break;
      case ISLONG:
          printf("%ld",*(long *)((char *)modem + modem_table[x].offset));
          break;
      case ISINT:
          printf("%d",*(int *)((char *)modem + modem_table[x].offset));
          break;
      case ISINTARRAY:
          {
            INT cnt;

            for(cnt = 0;cnt < modem_table[x].len;cnt++) {
              printf("%d",((int *)((char *)modem + modem_table[x].offset))[cnt]);
              if(cnt < modem_table[x].len - 1)
                printf(",");
            }
          }
          break;
      case ISBITMAP:
          {
            INT cnt;

            for(cnt = 0; cnt < modem_table[x].len;cnt++) {
              if(!IsBit(((char *)modem + modem_table[x].offset),cnt))
                printf("-");
              else
                printf("X");
            }
          }
          break;
      case ISBIT:
          switch(modem_table[x].token) {
            case MAIL_LOCKED:
                printf("%d",modem->locked);
                break;
            case MAIL_HUMANSOK:
                printf("%d",modem->humansok);
                break;
            case MAIL_RFREQSOK:
                printf("%d",modem->rfreqsok);
                break;
            case MAIL_SFREQSOK:
                printf("%d",modem->sfreqsok);
                break;
            case MAIL_DIALOUTOK:
                printf("%d",modem->dialoutok);
                break;
            case MAIL_ANSWEROK:
                printf("%d",modem->answerok);
                break;
            case MAIL_FTS0001:
                printf("%d",modem->fts0001);
                break;
            case MAIL_RECVUNK:
                printf("%d",modem->recvunk);
                break;
            case MAIL_SENDUNK:
                printf("%d",modem->sendunk);
                break;
            case MAIL_SEA1K:
                printf("%d",modem->sea1k);
                break;
            case MAIL_NOSEALINK:
                printf("%d",modem->nosealink);
                break;
            case MAIL_NOSLO:
                printf("%d",modem->noslo);
                break;
            case MAIL_NO1K:
                printf("%d",modem->no1k);
                break;
            case MAIL_DEBUGTRANS:
                printf("%d",modem->debugtrans);
                break;
          }
          break;
      case ISSTIME:
          printf("%02d:%02d:%02d",
                 ((STIME *)((char *)modem + modem_table[x].offset))->hour,
                 ((STIME *)((char *)modem + modem_table[x].offset))->min,
                 ((STIME *)((char *)modem + modem_table[x].offset))->sec);
          break;
    }
    x++;
  }
}

char * _fastcall fixup (char *orig,char *dest,int maxlen) {

  register char *o = orig,*d = dest,*tp;
  char     temp[33] = "\\x";

  while(*o && (d - dest) < maxlen) {
    if(!isprint(*o)) {
      if(*o == '\r') {
        *d = '\\';
        d++;
        *d = 'r';
        d++;
      }
      else if(*o == '\n') {
        *d = '\\';
        d++;
        *d = 'n';
        d++;
      }
      else if(*o == '\b') {
        *d = '\\';
        d++;
        *d = 'b';
        d++;
      }
      else {
        sprintf(&temp[2],"%02x",(int)*o);
        tp = temp;
        while(*tp)
          *d++ = *tp++;
      }
      o++;
    }
    else {
      if(*o == '\\') {
        *d = '\\';
        d++;
        *d = '\\';
        d++;
        o++;
      }
      else
        *d++ = *o++;
    }
    *d = 0;
  }
  return dest;
}

