#define INCL_WIN

#include <io.h>
#include <fcntl.h>
#include <stdarg.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"
#include "xbbs.h"

    extern HWND   xdhwnd;
    extern MDM    *modems[MAXINSTANCES];
    static int    LOG_DEBUG = 1;
    extern USHORT focusline;


void logfunc (int which,USHORT cp,char *szFormat, ...) {

    char         *chBuffer;
    unsigned int sLength;
    va_list      pArguments;

    /* (which & 3) definitions:
     *    which == 0: output to log and listbox
     *    which == 1: output to log only
     *    which == 2: output to listbox only
     *   (which & 4): don't free string in mp2; otherwise do
     */

    if(cp == -1)
      return;
    if((which & 32767) && !LOG_DEBUG)
      return;

    /* build string */

    chBuffer = malloc(1536);
    if(!chBuffer) {
      DosBeep(50,100);
      return;
    }
    va_start(pArguments,szFormat);
    sLength = vsprintf(chBuffer,szFormat,pArguments);
    va_end(pArguments);
    if(xdhwnd)
      WinPostMsg(xdhwnd,WM_LOG,MPFROM2SHORT(cp,which),
                 (MPARAM)chBuffer);
    else
      free(chBuffer);
}



void logfmain (char *szFormat, ...) {

    static char  chBuffer[1536],tempdate[12],temptime[12];
    unsigned int sLength;
    va_list      pArguments;
    int          handle;

    /* build string */

    va_start(pArguments,szFormat);
    sLength = vsprintf(chBuffer,szFormat,pArguments);
    va_end(pArguments);

    handle = sopen("XBBSERR.LOG",O_RDWR | O_BINARY | O_CREAT,SH_DENYWR,
                   S_IWRITE);
    if(handle != -1) {
      lseek(handle,0L,SEEK_END);
      _strdate(tempdate);
      _strtime(temptime);
      ffprintf(handle,"%s %s  %s\r\n",tempdate,temptime,chBuffer);
      close(handle);
    }
    if(xdhwnd)
      WinPostMsg(xdhwnd,WM_LOG,MPFROM2SHORT(focusline,2 | 4),
                 (MPARAM)chBuffer);
}
