#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include "mailer.h"
#include "transfer.h"
#include "bbs.h"
#include "xmisc.h"
#include "keys.h"



    extern MDM      *modems[MAXINSTANCES];
    extern USER     *user[MAXINSTANCES];
    extern FILEAREA *fileareas;


long _pascal list_fbbs (int mode,USHORT cp,char *fstr,long *numfiles,
                        char *fbbs,char *path,time_t date,
                        unsigned int flags,int *error) {

    /* error = 1:   out of memory
             = 2:   bad path
             = 3:   can't open file
             = -1:  aborted by user

       flags:
        passed through to list_files if no FILES.BBS
        if (flags & 1), don't display non-matching crap here
        if (flags & 2), don't drop through to list_files
        if (flags & 4), do dir instead of files.bbs list
        if (flags & 8), don't do common files.bbs
        if (flags & 16), only do common files.bbs
    */

    long        numbytes = 0L,pos;
    int         handle,lines = 0,len,wasmatch = 0,cntr = 0;
    char        *s,*f,*p,*area,*ul,fordate[33];
    struct stat st;
    FILEAREA    *info;


    *numfiles = 0L;
    *error = 0;
    if(!path || !*path) {
        *error = 2;
        return 0L;
    }
    s = bbs_malloc(cp,257);
    if(!s) {
        *error = 1;
        return 0L;
    }
    f = bbs_malloc(cp,257);
    if(!f) {
        *error = 1;
        bbs_free(cp,s);
        return 0L;
    }

    if(flags & 4)
      goto NoFilesBBS;

    if(!fbbs || !*fbbs) {
      if(!(flags & 16)) {
        sprintf(s,"%s/FILES.BBS",path);
        if(stat(s,&st) && !(flags & 8))
          strcpy(s,"FILES.BBS");
      }
      else
        strcpy(s,"FILES.BBS");
    }
    else
      strcpy(s,fbbs);

    /* got the filename to display, now open it */

    handle = bbs_sopen(cp,s,O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
    if(handle == -1) {

NoFilesBBS:

        *error = 3;
        bbs_free(cp,s);

        if(!fstr || !*fstr)
          sprintf(f,"%s/*.*",path);
        else {
          if(!strchr(fstr,'.'))
            sprintf(f,"%s/%s*.*",path,fstr);
          else
            sprintf(f,"%s/%s*",path,fstr);
        }

        /* file not available; do raw directory */

        if(!(flags & 2))
          numbytes = list_files(mode,cp,f,numfiles,date,flags,error);
        bbs_free(cp,f);
        return numbytes;
    }

    /* file's open, display it */

    while(!eof(handle)) {

Continuing:

        if(!fgetsx(s,133,handle))
          break;
        if((p = strchr(s,';')) != NULL) *p = 0; /* strip 'private' stuff */
        stripcr(s);
        rstrip(s);
        if(!*s) continue; /* blank line */
        if(*s == ' ' || *s == '\t') {   /* comment */
            if(user[cp]->attribs & U_LIMITFLIST) continue;
            if(fstr && *fstr) {
              if(!stristr(s,fstr)) continue;  /* no match */
            }
            if(date) continue;                  /* not a file, can't be new */
//            if(!(flags & 1)) {  /* why did I do that compare? */
                lines++;
                if(dprintf(mode,cp,"%s\r\n",s) >= (int)user[cp]->width) lines++;
                if(lines > (int)user[cp]->length - 2) {
                    lines = 1;
                    if(do_more(mode,cp)) {
                        *error = -1;
                        break;
                    }
                }
//            }
            continue;
        }

        /* better be a file... */

        if(fstr && *fstr) {
            if(stristr(s,fstr)) wasmatch = 1;
            else wasmatch = 0;
        }

        area = to_delim(s," ");
        if(*area) {
            *area = 0;
            area++;
            area = skip_white(area);
        }

        ul = "";
        p = path;
        if(*area) {                     /* check for good area */
            ul = to_delim(area," ");
            if(*ul) {
                *ul = 0;
                ul++;
                ul = skip_white(ul);
            }
            if(user[cp]->attribs & U_LIMITFLIST) {  /* must be current area */
                if(stricmp(area,user[cp]->currfilearea->name)) {
                    skip_comments(handle);
                    continue;
                }
            }
            info = next_file_area(fileareas,cp,0,0);
            while(info && info->password && *info->password) {
                info = next_file_area(info,cp,1,0);
            }
            while(info) {
                if(!stricmp(area,info->name)) break;
                info = next_file_area(info,cp,1,0);
                while(info && info->password && *info->password) {
                    info = next_file_area(info,cp,1,0);
                }
            }
            if(info) p = info->dpath;
            else {            /* not an accessible area */
                skip_comments(handle);
                continue;
            }
        }

        sprintf(f,"%s/%s",p,s);

        if(stat(f,&st)) {               /* missing file */
            skip_comments(handle);
            continue;
        }

        if(st.st_mtime < date) {        /* file older than date */
            skip_comments(handle);
            continue;
        }

        if(fstr && *fstr && !wasmatch) {

            long pos2;

            pos2 = tell(handle);
            if(!stristr(s,fstr) && !stristr(area,fstr) && !stristr(ul,fstr)) {
                if(eof(handle)) goto Continuing;
                while(!eof(handle)) {
                    pos = tell(handle);
                    if(!fgetsx(f,133,handle)) {
                        lseek(handle,pos,SEEK_SET);
                        goto Continuing;
                    }
                    if((p = strchr(f,';')) != NULL) *p = 0; /* strip 'private' stuff */
                    stripcr(f);
                    rstrip(f);
                    if(*f != ' ' && *f != '\t') {
                        lseek(handle,pos,SEEK_SET);
                        goto Continuing;
                    }
                    if(stristr(f,fstr)) {
                        lseek(handle,pos2,SEEK_SET);
                        break;
                    }
                    if(eof(handle)) goto Continuing;
                }
            }
        }

        /* update how many files & bytes */

        (*numfiles)++;
        numbytes += st.st_size;

        /* display file info */

        if(user[cp]->attribs & U_COLOR) {
            if(dprintf(mode,cp,"\x1b[0;1;33m%-13s  \x1b[34m%s  \x1b[0;2;36m%9lu\x1b[0;1;36m\r\n",s,
                       say_date(fordate,st.st_mtime),st.st_size)
                          >= (int)user[cp]->width + 34) lines++;
        }
        else {
            if(dprintf(mode,cp,"%-13s  %s  %9lu\r\n",s,
                       say_date(fordate,st.st_mtime),st.st_size)
                          >= (int)user[cp]->width + 2) lines++;
        }
        lines++;
        if(lines > (int)user[cp]->length - 2) {
            lines = 1;
            if(do_more(mode,cp)) {
                *error = -1;
                break;
            }
        }

        len = 0;    /* display area and uploader if available */
        if(*area) {
            len += dprintf(mode,cp," AREA: %s",area);
            if(*ul) len += dprintf(mode,cp,"  Uploaded by: %s",ul);
            if(len >= user[cp]->width) lines++;
            dputs(mode,cp,"\r\n");
            lines++;
            if(lines > (int)user[cp]->length - 2) {
                lines = 1;
                if(do_more(mode,cp)) {
                    *error = -1;
                    break;
                }
            }
        }

        while(!eof(handle)) {   /* display comments */
            pos = tell(handle);
            if(!fgetsx(s,133,handle)) break;
            if((p = strchr(s,';')) != NULL) *p = 0; /* strip 'private' stuff */
            stripcr(s);
            rstrip(s);
            if(*s != ' ' && *s != '\t') {
                lseek(handle,pos,SEEK_SET);
                break;
            }
            if(dprintf(mode,cp,"%s\r\n",s) >= (int)user[cp]->width + 2) lines++;
            lines++;
            if(lines > (int)user[cp]->length - 2) {
                lines = 1;
                if(do_more(mode,cp)) {
                    *error = -1;
                    goto BreakOut;
                }
            }
        }

        DosSleep(0L);   /* breather for other stuff */
    }

BreakOut:

    bbs_close(cp,handle);
    bbs_free(cp,s);
    bbs_free(cp,f);
    return numbytes;
}



void _fastcall skip_comments (int handle) { /* skip extended FILES.BBS comments */

    char s[134];
    long pos;


    while(!eof(handle)) {
        pos = tell(handle);
        if(!fgetsx(s,133,handle)) break;
        stripcr(s);
        if(*s != ' ' && *s != '\t') {
            lseek(handle,pos,SEEK_SET);
            break;
        }
    }
}



long _pascal list_all_fbbs (int mode,USHORT cp,char *fstr,long *numfiles,
                            time_t date,unsigned int flags,int *error) {

    FILEAREA *info;
    long     numbytes = 0L,thesefiles;

    /* list all files.bbs files in all accessible directories sequentially */

    *numfiles = 0L;
    info = next_file_area(fileareas,cp,0,0);
    while(info && info->password && *info->password) {
      info = next_file_area(info,cp,1,0);
    }
    while(info) {
        dprintf(mode,cp,"\r\n#%-5u \"%s\"\r\n",info->number,info->name);
        thesefiles = 0;
        numbytes += list_fbbs(mode,cp,fstr,&thesefiles,NULL,
                              info->dpath,date,
                              flags |
                              (((info->areaflags & F_NODIR) != 0) * 2) |
                              (((info->areaflags & F_NOFBBS) != 0) * 4) |
                              (((info->areaflags & F_NOCOMMON) != 0) * 8),
                              error);
        *numfiles += thesefiles;

        if(*error == -1) break;

        info = next_file_area(info,cp,1,0);
        while(info && info->password && *info->password) {
          info = next_file_area(info,cp,1,0);
        }
        if(info && thesefiles > 4L)
          hitreturn(mode,cp);
    }

    return numbytes;
}
