#define INCL_WIN

#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"
#include "xbbs.h"

extern BBS *bbs;


MRESULT EXPENTRY PriDlgBoxProc (HWND hwndDlg,USHORT msg,
                                MPARAM mp1,MPARAM mp2) {

  static MDM     *mdm;
  static int      spos[16],lastsbar = -1;
  int             x;
  char            s[13];

  switch(msg) {
    case WM_INITDLG:
      mdm = (MDM *)mp2;
      for(x = 0;x < 8;x++) {
        WinSendMsg(WinWindowFromID(hwndDlg,PRI_SSBAR1 + x),SBM_SETSCROLLBAR,
                   MPFROM2SHORT(0,0),MPFROM2SHORT(0,31));
        WinSendMsg(WinWindowFromID(hwndDlg,PRI_PSBAR1 + x),SBM_SETSCROLLBAR,
                   MPFROM2SHORT(0,0),MPFROM2SHORT(1,4));
      }
      spos[0] = bbs->mainthread[0];
      spos[1] = bbs->localbbs[0];
      spos[2] = mdm->mailer[0];
      spos[3] = mdm->comm[0];
      spos[4] = mdm->bbs[0];
      spos[5] = mdm->export[0];
      spos[6] = mdm->outside[0];
      spos[7] = mdm->transfer[0];
      spos[8] = bbs->mainthread[1];
      spos[9] = bbs->localbbs[1];
      spos[10] = mdm->mailer[1];
      spos[11] = mdm->comm[1];
      spos[12] = mdm->bbs[1];
      spos[13] = mdm->export[1];
      spos[14] = mdm->outside[1];
      spos[15] = mdm->transfer[1];
      for(x = 0;x < 8;x++) {
        sprintf(s,"%d",spos[x]);
        WinSetWindowText(WinWindowFromID(hwndDlg,PRI_PTEXT1 + x),s);
        WinSendMsg(WinWindowFromID(hwndDlg,PRI_PSBAR1 + x),SBM_SETPOS,
                   MPFROMSHORT(spos[x]),MPFROMLONG(0L));
        sprintf(s,"%d",spos[x + 8]);
        WinSetWindowText(WinWindowFromID(hwndDlg,PRI_STEXT1 + x),s);
        WinSendMsg(WinWindowFromID(hwndDlg,PRI_SSBAR1 + x),SBM_SETPOS,
                   MPFROMSHORT(spos[x + 8]),MPFROMLONG(0L));
      }
      break;

    case WM_HSCROLL:
      lastsbar = SHORT1FROMMP(mp1);
      x = (lastsbar > PRI_PSBAR8);
      switch(SHORT2FROMMP(mp2)) {
        case SB_LINELEFT:
          if(spos[lastsbar - PRI_PSBAR1] > 0 + (x == 0))
            spos[lastsbar - PRI_PSBAR1]--;
          break;

        case SB_LINERIGHT:
          if(spos[lastsbar - PRI_PSBAR1] < 4 + ((lastsbar > PRI_PSBAR8) * 27))
            spos[lastsbar - PRI_PSBAR1]++;
          break;

        case SB_PAGELEFT:
          spos[lastsbar - PRI_PSBAR1] -= (2 + (2 * x));
          if(spos[lastsbar - PRI_PSBAR1] < 0 + (x == 0))
            spos[lastsbar - PRI_PSBAR1] = 0 + (x == 0);
          break;

        case SB_PAGERIGHT:
          spos[lastsbar - PRI_PSBAR1] += (2 + (2 * x));
          if(spos[lastsbar - PRI_PSBAR1] > 4 + (x * 27))
            spos[lastsbar - PRI_PSBAR1] = 4 + (x * 27);
          break;

        case SB_SLIDERTRACK:
          spos[lastsbar - PRI_PSBAR1] = SHORT1FROMMP(mp2);
          break;

        default:
          return MRFROMSHORT(0);
      }
      sprintf(s,"%d",spos[lastsbar - PRI_PSBAR1]);
      WinSetWindowText(WinWindowFromID(hwndDlg,PRI_PTEXT1 + (lastsbar - PRI_PSBAR1)),s);
      WinSendMsg(WinWindowFromID(hwndDlg,lastsbar),SBM_SETPOS,
                 MPFROMSHORT(spos[lastsbar - PRI_PSBAR1]),MPFROMLONG(0L));
      break;

    case WM_COMMAND:
      switch(SHORT1FROMMP(mp1)) {
        case PRI_CANCEL:
          WinDismissDlg(hwndDlg,0);
          break;

        case PRI_OKAY:
          bbs->mainthread[0] = spos[0];
          bbs->localbbs[0] = spos[1];
          mdm->mailer[0] = spos[2];
          mdm->comm[0] = spos[3];
          mdm->bbs[0] = spos[4];
          mdm->export[0] = spos[5];
          mdm->outside[0] = spos[6];
          mdm->transfer[0] = spos[7];
          bbs->mainthread[1] = spos[8];
          bbs->localbbs[1] = spos[9];
          mdm->mailer[1] = spos[10];
          mdm->comm[1] = spos[11];
          mdm->bbs[1] = spos[12];
          mdm->export[1] = spos[13];
          mdm->outside[1] = spos[14];
          mdm->transfer[1] = spos[15];
          WinDismissDlg(hwndDlg,0);
          break;

        case PRI_HELP:
          WinMessageBox(HWND_DESKTOP, hwndDlg,
                        "OS/2 uses two numbers for a priority setting:\r"
                        "a priority class (1 - 4) and a level (0 - 31)\r"
                        "  Classes (first slider):\r"
                        "1 = idle  2 = normal  3 = high  4 = fixed high\r"
                        "(Note 4 is a \"lower\" priority class than 3)\r"
                        "  Levels (second slider):\r"
                        "The higher the level the higher the priority.\r"
                        "\rNote not all new priorities will be effective until after restarting XBBS.",
                        "Priorities",0,MB_OK | MB_APPLMODAL);
          break;

        default:
          break;
      }
      return MRFROMSHORT(0);

    case WM_CLOSE:
      WinDismissDlg(hwndDlg,0);
      break;
  }
  return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
