/*******************************************/
/* Miscellaneous structures used by bbs    */
/*******************************************/

typedef unsigned int word;

#define BACKSPACE "\b \b"

#ifndef SIMPLETIME
    typedef struct {
        char hour;
        char min;
        char sec;
    } STIME;
    #define SIMPLETIME
#endif

/* Used by line editor */

#define E_NOTO            0x0001
#define E_NOFROM          0x0002
#define E_NOSUBJ          0x0004
#define E_NOQUOTES        0x0008

/* Used by dprintf/dputs/dputc */

#define D_REMOTE          0x0001
#define D_LOCAL           0x0002
#define D_BOTH            0x0003
#define D_ANSIONLY        0x0004
#define D_COLORONLY       0x0008
#define D_HIGHONLY        0x0010
#define D_ASCIIONLY       0x0020

/* bbs.attribs */

#define B_LOGALLHELP      0x00000001
#define B_PREREGISTERED   0x00000002
#define B_NOPRETTY        0x00000004
#define B_INTL            0x00000008
#define B_NOHAPPY         0x00000010
#define B_ANSINEWS        0x00000020
#define B_NODUPENUMS      0x00000040
#define B_COLOR           0x00000080
#define B_HIGHASCII       0x00000100
#define B_PAUSE           0x00000200
#define B_CLEAR           0x00000400
#define B_COLD            0x00000800
#define B_WIDTH           0x00001000
#define B_LENGTH          0x00002000
#define B_SHOW            0x00004000
#define B_PHONE           0x00008000
#define B_ADDRESS         0x00010000
#define B_HANDLE          0x00020000
#define B_PASSWORD        0x00040000
#define B_INTERESTS       0x00080000
#define B_COMPUTERS       0x00100000
#define B_NO_NEW_EDIT     0x00200000
#define B_LOGONQUOTE      0x00400000
#define B_NOCOMPRESS      0x00800000
#define B_LOGOFFQUOTE     0x01000000
#define B_LOGOFFMSG       0x02000000
#define B_FIRSTLOGMSG     0x04000000
#define B_FIRSTLOGCALLBK  0x08000000
#define B_ALWAYSCALLBACK  0x10000000
#define B_AUTOPASSWORDS   0x20000000
#define B_FOLLOWBBS       0x40000000
#define B_SYSOPIN         0x80000000

/* bbs.attribs2 */

#define B2_ANSI           0x00000001
#define B2_USEVER7        0x00000002
#define B2_AUTOVERIFY     0x00000004
#define B2_FTNTOALL       0x00000008
#define B2_MINIMIZEBBS    0x00000010
#define B2_SMALLFONT      0x00000020

/* user[cp]->attribs */

#define U_ANSI            0x00000001
#define U_COLOR           0x00000002
#define U_HIGHASCII       0x00000004
#define U_NOMORE          0x00000008
#define U_NOCLEAR         0x00000010
#define U_COLD            0x00000020
#define U_NOSHOWADDRESS   0x00000040
#define U_NOSHOWPHONE     0x00000080
#define U_NOSHOWREAL      0x00000100
#define U_NOKILL          0x00000200
#define U_DELETED         0x00000400
#define U_EXPERT          0x00000800
#define U_TWIT            0x00001000
#define U_NEWFILES        0x00002000
#define U_NEWMSGS         0x00004000
#define U_DLNEWMSGS       0x00008000
#define U_DLNEWFILELIST   0x00010000
#define U_SEENEWS         0x00020000
#define U_ASKDL           0x00040000
#define U_NOVICE          0x00080000
#define U_NOROLL          0x00100000
#define U_POINTONLY       0x00200000
#define U_LOCKEDOUT       0x00400000
#define U_AVAILABLE       0x00800000
#define U_LISTPROTECTED   0x01000000
#define U_MISCNEWSOK      0x02000000
#define U_LIMITFLIST      0x04000000
#define U_EBCDIC          0x08000000

/* Used by string_input */

    /* flags */

#define STRF_UCASE        0x0001
#define STRF_LCASE        0x0002
#define STRF_REQUIRED     0x0004
#define STRF_NOECHO       0x0008
#define STRF_ENCRYPT      0x0010
#define STRF_HOT          0x0020
#define STRF_EDIT         0x0040
#define STRF_PRETTY       0x0080
#define STRF_MUSTHOT      0x0100
#define STRF_NEAT         0x0200
#define STRF_NOHELP       0x0400

    /* types */

#define STRT_ALPHA        1
#define STRT_NUMERIC      2
#define STRT_ALPHANUMERIC 3
#define STRT_HEX          4
#define STRT_FILENAME     5
#define STRT_FILESPEC     6
#define STRT_ALL          7
#define STRT_ANY          8
#define STRT_YN           9
#define STRT_MULTFILES    10
#define STRT_MULTSPECS    11
#define STRT_YNQ          12
#define STRT_YNQS         13
#define STRT_JUSTFILE     14
#define STRT_MULTJUST     15

    struct __variables__ {  /* REX-like variables */
        char *name;
        char *value;
    };

    typedef struct __variables__ VARIABLES;

    struct _msgarea {
      char      *name;
      char      *descr;
      char            *forceto;
      int       age;
      unsigned long r_security1;
      unsigned long r_security2;
      unsigned long r_flags1;
      unsigned long r_flags2;
      unsigned long w_security1;
      unsigned long w_security2;
      unsigned long w_flags1;
      unsigned long w_flags2;
      unsigned long s_security1;
      unsigned long s_security2;
      unsigned long s_flags1;
      unsigned long s_flags2;
      unsigned long   areaflags;
      struct _addresses *addr;
      unsigned int  number;
      char            *password;
      struct _msgarea *next;
      struct _msgarea *prior;
    };

    typedef struct _msgarea MSGAREA;

/*----------------------------------------------------------*/
/* Message area flags (areaflags)                           */
/*----------------------------------------------------------*/
#define M_NOORIG     0x00000001  /* No Origin or tear       */
#define M_ANSI       0x00000002  /*                         */
#define M_PRIVATE    0x00000004  /*                         */
#define M_PUBLIC     0x00000008  /*                         */
#define M_ECHO       0x00000010  /*                         */
#define M_NET        0x00000020  /*                         */
#define M_MCI        0x00000040  /*                         */
#define M_ANON       0x00000080  /*                         */
#define M_REAL       0x00000100  /*                         */
#define M_ASSOC      0x00000200  /* Msg area allows assoc   */
#define M_FORCE      0x00000400  /* Always force            */
#define M_COMPRESS   0x00000800  /* Allow LZSS comp here    */
#define M_GROUP      0x00001000  /* groupmail               */
#define M_USENET     0x00002000  /* usenet conference       */
#define M_QWK        0x00004000  /* barf! qwk conference    */

    struct _filearea {
        char             *name;
        char             *descr;
        int              age;
        unsigned long    r_security1;
        unsigned long    r_security2;
        unsigned long    r_flags1;
        unsigned long    r_flags2;
        unsigned long    w_security1;
        unsigned long    w_security2;
        unsigned long    w_flags1;
        unsigned long    w_flags2;
        unsigned long    s_security1;
        unsigned long    s_security2;
        unsigned long    s_flags1;
        unsigned long    s_flags2;
        unsigned long    areaflags;
        int              cost_per_k;
        unsigned int     number;
        char             *upath;
        char             *dpath;
        char             *password;
        struct _filearea *next;
        struct _filearea *prior;
    };

    typedef struct _filearea FILEAREA;

/*-----------------------------------------------------------*/
/* File area flags (areaflags)                               */
/*------------------------------------------------------------*/
#define F_FREE       0x00000001 /*                            */
#define F_NOUP       0x00000002 /*                            */
#define F_NODOWN     0x00000004 /*                            */
#define F_LEECH      0x00000008 /*                            */
#define F_DOWNBACK   0x00000010 /*                            */
#define F_UPBACK     0x00000020 /*                            */
#define F_CHARGE     0x00000040 /*                            */
#define F_NOCOMMON   0x00000080 /* no common FILES.BBS list   */
#define F_NODIR      0x00000100 /* no directory list          */
#define F_NOFBBS     0x00000200 /* no FILES.BBS at all        */
#define F_COMMONONLY 0x00000400 /* use only common FILES.BBS  */
#define F_HIDDEN     0x00000800 /* no area shown, must use    */
                                /* exact filename to download */

    typedef struct _libarea {
      char            *name;
      char            *descr;
      int             age;
      unsigned long   r_security1;
      unsigned long   r_security2;
      unsigned long   r_flags1;
      unsigned long   r_flags2;
      unsigned long   w_security1;
      unsigned long   w_security2;
      unsigned long   w_flags1;
      unsigned long   w_flags2;
      unsigned long   s_security1;
      unsigned long   s_security2;
      unsigned long   s_flags1;
      unsigned long   s_flags2;
      unsigned long   areaflags;
      unsigned int    number;
      char            *path;
      char            *password;
      struct _libarea *next;
      struct _libarea *prior;
    } LIBAREA;

/*----------------------------------------------------------*/
/* Library area flags (areaflags)                           */
/*----------------------------------------------------------*/
#define L_ANSIONLY   0x00000001  /*                         */


    typedef struct _user_info {     /* BBS user control info */
        char          name[36];
        char          handle[36];
        char          address[80];
        char          phone_number[21];
        char          password[13];
        char          interests[80];
        unsigned int  computer_type;
        unsigned long userid;
        unsigned int  pointid;
        time_t        initial_logon;
        time_t        expires;
        time_t        last_logon;
        time_t        logon_today;
        unsigned int  birthyear;
        unsigned char birthmonth;
        unsigned char birthday;
        long          credit;
        long          minlimit;
        unsigned int  time_today;
        unsigned int  time_per_day;
        unsigned long numcalls;
        unsigned long ulnum;
        unsigned long dlnum;
        unsigned long ulk;
        unsigned long dlk;
        unsigned long uktoday;
        unsigned long dktoday;
        unsigned long ukperday;
        unsigned long dkperday;
        unsigned long numposts;
        unsigned long security1;
        unsigned long security2;
        unsigned long flags1;
        unsigned long flags2;
        unsigned long attribs;
        unsigned long attribs2;
        unsigned int  length;
        unsigned int  width;
        unsigned int  lastmsgarea;
        unsigned int  lastfilearea;
        char          lastprotocol;
        char          lastarchiver;
        unsigned int  time_per_call;
        long          forsysop;
        unsigned char interface;
        unsigned char exp;
        unsigned int  leech_percent;
        long          nvar[9];
        char          svar[9][80];
        char          bbsmsg[64];     /* 512 access bit flags -- system */
        char          bbsfile[64];    /* 512 access bit flags -- system */
        char          usermsg[64];    /* 512 access bit flags -- user   */
        char          userfile[64];   /* 512 access bit flags -- user   */

        /* NOTE: vars from here down *not* saved in userfile */

        unsigned int  *lastread;      /* pointer to lastread array loaded from extern file */
        VARIABLES     *vars;          /* linked list of named variables */
        time_t        online;
        time_t        offline;
        unsigned int  number;
        int           age;
        MSGAREA       *currmsgarea;
        FILEAREA      *currfilearea;
        LIBAREA       *currlibarea;
        int           badattempts;
        char          macrobuff[81];
        char          matchhow;
        char          idunno[3];
        char          *from[10];          /* for msg threading/locating */
        char          *to[10];
        char          *subj[10];
        char          *msgid[10];
        char          *reply[10];
        char          *body[10];
    } USER;

    #define USERSUB 359
    #define LASTREADSIZE 512

typedef struct _xmsg {
      char from[36];
      char to[36];
      char subj[60];
      word upmsg;
      word dnmsg;
      word o_point;
      word length;         /* Length of message */
      long start;          /* Starting postition in text file              */
      char date[20];       /*   */
      word unused;         /*   */
      word d_node;         /* Destination node                             */
      word o_node;         /* Origination node number                      */
      word cost;           /* Unit cost charged to send the message        */
      word o_net;          /* Origination network number                   */
      word d_net;          /* Destination network number                   */
      char indate[4];      /* import date  (YMD(null))                     */
      word xflags;         /* Extra attributes                             */
      word d_zone;         /* Destination zone                             */
      word o_zone;         /* Origination zone                             */
      word fflags;         /* Attribute (behavior) of the message          */
      word d_point;
} XMSG;

/*----------------------------------------------------*/
/* FIDO Message attributes (fflags)                   */
/*----------------------------------------------------*/
#define MSGPRIVATE 0x0001  /* private message,        */
#define MSGCRASH   0x0002  /* accept for forwarding   */
#define MSGREAD    0x0004  /* read by addressee       */
#define MSGSENT    0x0008  /* sent OK (remote)        */
#define MSGFILE    0x0010  /* file attached to msg    */
#define MSGFWD     0x0020  /* being forwarded         */
#define MSGORPHAN  0x0040  /* unknown dest node       */
#define MSGKILL    0x0080  /* kill after mailing      */
#define MSGLOCAL   0x0100  /* FidoNet vs. local       */
#define MSGXX1     0x0200  /*                         */
#define MSGXX2     0x0400  /* STRIPPED by FidoNet<tm> */
#define MSGFRQ     0x0800  /* file request            */
#define MSGRRQ     0x1000  /* receipt requested       */
#define MSGCPT     0x2000  /* is a return receipt     */
#define MSGARQ     0x4000  /* audit trail requested   */
#define MSGURQ     0x8000  /* update request          */
/*----------------------------------------------------*/

/*----------------------------------------------------*/
/* XBBS Message attributes (xflags)                   */
/*----------------------------------------------------*/
#define MSGDELETED 0x0001  /* deleted message,          0000 0000 0000 0001*/
#define MSGANON    0x0002  /* anonymous message         0000 0000 0000 0010*/
#define MSGECHO    0x0004  /* unmoved echo message      0000 0000 0000 0100*/
#define MSGNET     0x0008  /* unmoved net message       0000 0000 0000 1000*/
#define MSGHOLD    0x0010  /* file attached to msg      0000 0000 0001 0000*/
#define MSGHOST    0x0020  /* being forwarded           0000 0000 0010 0000*/
#define MSGSCANNED 0x0040  /* fidonet scanned           0000 0000 0100 0000*/
#define MSGKEEP    0x0080  /* don't delete              0000 0000 1000 0000*/
#define MSGTREATED 0x0100  /* soft cr's & lf's removed  0000 0001 0000 0000*/
#define MSGPACKED  0x0200  /* message LZSS compressed   0000 0010 0000 0000*/
#define MSGGSCAN   0x0400  /* groupmail scanned         0000 0100 0000 0000*/
#define MSGRSCAN   0x0800  /* rfc0822 scanned           0000 1000 0000 0000*/
/*#define    0x1000  0001 0000 0000 0000*/
/*#define    0x2000  0010 0000 0000 0000*/
#define MSGARCHIVED 0x4000 /*                           0100 0000 0000 0000*/
#define MSGTAGGED  0x8000  /* used by offline readers   1000 0000 0000 0000*/
/*----------------------------------------------------*/


    typedef struct _bbs_info {      /* BBS control info */
        long              numcalls;
        unsigned long     last_userid;
        unsigned int      last_pointid;
        int               minage;
        int               maxage;
        long              credit;
        unsigned int      expiredays;
        long              expiremins;
        unsigned int      time_per_day;
        unsigned long     security1;
        unsigned long     security2;
        unsigned long     flags1;
        unsigned long     flags2;
        unsigned long     ukperday;
        unsigned long     dkperday;
        unsigned long     attribs;
        unsigned long     attribs2;
        unsigned int      maxusers;
        char              origin[66];
        int               maxattempts;
        char              msgflags[64];
        char              fileflags[64];
        char              bbsmsg[64];
        char              bbsfile[64];
        word              defaultcost;
        long              quotepos;
        unsigned int      time_per_call;
        int               ulmulti;
        int               quoteodds;
        int               localbbs[2],mainthread[2];
        char              inbound[3][133];  /* inbound directories */
        char              okfiles[3][133];  /* okfiles for freq */
        int               maxpage;
        char              bbs_name[50];
        unsigned long     uattribs;
        unsigned long     uattribs2;
        char              sysop[20];
        unsigned int      sysopin:      1;
        unsigned int      reservedb:    7;
        STIME             beginpage;
        STIME             endpage;
        unsigned long     maxuserpkt;
        char              reserved[508];
        VARIABLES         *sharevars;       /* shared variables */
    } BBS;

    typedef struct __computer_types__ {
        char *name;
        struct __computer_types__ *next;
    } COMPTYPES;

    typedef struct __arc_type__ {
        char    *id;
        char    *ext;
        long    file_offset;
        char    *list;
        char    *extract;
        char    *exwdirs;
        char    *test;
        char    *create;
        char    *createrecurse;
        char    *createwdirs;
        char    *move;
        char    *movewdirs;
        char    *delete;
        char    *signature;
        char    *startlist;
        char    *endlist;
        int     osizepos;
        int     nsizepos;
        int     fdpos;
        int     fdflds;
        int     fnpos;
        struct __arc_type__ *next;
    } ARC_TYPE;

#ifndef INDEXESDEFINED
    typedef struct {
      int to;
      int from;
      int subj;
      long msgidcrc;
      long msgidserialno;
      long replycrc;
      long replyserialno;
    } INDEXES;
  #define INDEXESDEFINED
#endif

