#include "mailer.h"
#include <stdarg.h>

  extern MDM *modems[MAXINSTANCES];

#define MAXARGLEN       128

static int  savx[MAXINSTANCES],savy[MAXINSTANCES],issaved[MAXINSTANCES];
static int  Maxx[MAXINSTANCES],Maxy[MAXINSTANCES],RealMaxx[MAXINSTANCES],
            RealMaxy[MAXINSTANCES],Curx[MAXINSTANCES],Cury[MAXINSTANCES],
            arglen[MAXINSTANCES],ansistate[MAXINSTANCES];
static char argbuf[MAXINSTANCES][MAXARGLEN + 1],CurAttr[MAXINSTANCES];
static char AnsiTerminators[] = "HFABCDnsuJKmp";
static int  TabSpaces = 8;

#define NOTHING         0
#define WASESCAPE       1
#define WASBRKT         2

/* initialize ANSI interpreter for a line */
void _fastcall SetScreensize (USHORT cp,int reservedlines);

/* put character c at x,y using attr as attribute */
/* position hardware cursor at x,y */
void _fastcall PosHardcursor (USHORT cp,int x,int y);

/* turn hardware cursor off */
void _fastcall HardCursorOff (USHORT cp);

/* turn hardware cursor on at x,y */
void _fastcall HardCursorOn (USHORT cp,int x,int y);

/* scroll window tx,ty - bx,by up one line; fill with blank+attr */
void _fastcall ScrollUp (USHORT cp,int tx,int ty,int bx,int by,char attr);

/* clear the window from tx,ty - bx,by; fill with blank+attr */
void _fastcall ClearWindow (USHORT cp,int tx,int ty,int bx,int by,char attr);

/* clear line y from col x to eol (ex); fill with blank+attr */
void _fastcall CleartoEOL (USHORT cp,int x,int y,int ex,char attr);

/* the ansi string interpreter */
int _fastcall ANSIPuts (USHORT cp,char *buf);


/* "generic" support functions closely related to ANSIPuts */

static void _fastcall set_pos (USHORT cp,char *argbuf,int arglen,char cmd) {

  int   y,x;
  char *p;
    
  if(!*argbuf || !arglen)
    Curx[cp] = Cury[cp] = 0;
  y = atoi(argbuf) - 1;
  p = strchr(argbuf,';');
  if(y >= 0 && p) {
    x = atoi(p + 1) - 1;
    if(x >= 0) {
      Curx[cp] = x;
      Cury[cp] = y;
    }
  }
}


static void _fastcall go_up (USHORT cp,char *argbuf,int arglen,char cmd) {

  register int x;

  x = atoi(argbuf);
  if(!x)
    x = 1;
  for(;x;x--) {
    if(!Cury[cp])
      break;
    (Cury[cp])--;
  }
}


static void _fastcall go_down (USHORT cp,char *argbuf,int arglen,char cmd) {

    register int x;

    x = atoi(argbuf);
    if(!x)
      x = 1;
    for(;x;x--) {
      if(Cury[cp] == Maxy[cp] - 1)
        break;
      (Cury[cp])++;
    }
}


static void _fastcall go_left (USHORT cp,char *argbuf,int arglen,char cmd) {

    register int x;

    x = atoi(argbuf);
    if(!x)
      x = 1;
    for(;x;x--) {
      if(!Curx[cp])
        break;
      (Curx[cp])--;
    }
}


static void _fastcall go_right (USHORT cp,char *argbuf,int arglen,char cmd) {

    register int x;

    x = atoi(argbuf);
    if(!x)
      x = 1;
    for(;x;x--) {
      if(Curx[cp] == Maxx[cp] - 1)
        break;
      (Curx[cp])++;
    }
}


static void _fastcall report (USHORT cp,char *argbuf,int arglen,char cmd) {

    /* you figure out how to implement it ... */
}


static void _fastcall save_pos (USHORT cp,char *argbuf,int arglen,char cmd) {

    savx[cp] = Curx[cp];
    savy[cp] = Cury[cp];
    issaved[cp] = 1;
}


static void _fastcall restore_pos (USHORT cp,char *argbuf,int arglen,char cmd) {

    if(issaved[cp]) {
      Curx[cp] = savx[cp];
      Cury[cp] = savy[cp];
      issaved[cp] = 0;
    }
}


static void _fastcall clear_screen (USHORT cp,char *argbuf,int arglen,char cmd) {

    /* needs error checking */

    ClearWindow(cp,0,0,Maxx[cp] - 1,Maxy[cp] - 1,
                CurAttr[cp]);
    Curx[cp] = Cury[cp] = 0;
}


static void _fastcall kill_line (USHORT cp,char *argbuf,int arglen,char cmd) {

    CleartoEOL(cp,Curx[cp],Cury[cp],Maxx[cp] - 1,
               CurAttr[cp]);
}


static void _fastcall set_colors (USHORT cp,char *argbuf,int arglen,char cmd) {

    register char *p;
    char          *pp;

    if(*argbuf && arglen) {
        pp = argbuf;
        do {
            p = strchr(pp,';');
            if(p && *p) {
              *p = 0;
              p++;
            }
            switch(atoi(pp)) {
                case 0: /* all attributes off */
                    CurAttr[cp] = 7;
                    break;

                case 1: /* bright on */
                    CurAttr[cp] |= 8;
                    break;

                case 2: /* faint on */
                    CurAttr[cp] &= (~8);
                    break;

                case 3: /* italic on */
                    break;

                case 5: /* blink on */
                    CurAttr[cp] |= 128;
                    break;

                case 6: /* rapid blink on */
                    break;

                case 7: /* reverse video on */
                    CurAttr[cp] = 112;
                    break;

                case 8: /* concealed on */
                    CurAttr[cp] = 0;
                    break;

                case 30: /* black fg */
                    CurAttr[cp] &= (~7);
                    break;

                case 31: /* red fg */
                    CurAttr[cp] &= (~7);
                    CurAttr[cp] |= 4;
                    break;

                case 32: /* green fg */
                    CurAttr[cp] &= (~7);
                    CurAttr[cp] |= 2;
                    break;

                case 33: /* yellow fg */
                    CurAttr[cp] &= (~7);
                    CurAttr[cp] |= 6;
                    break;

                case 34: /* blue fg */
                    CurAttr[cp] &= (~7);
                    CurAttr[cp] |= 1;
                    break;

                case 35: /* magenta fg */
                    CurAttr[cp] &= (~7);
                    CurAttr[cp] |= 5;
                    break;

                case 36: /* cyan fg */
                    CurAttr[cp] &= (~7);
                    CurAttr[cp] |= 3;
                    break;

                case 37: /* white fg */
                    CurAttr[cp] |= 7;
                    break;

                case 40: /* black bg */
                    CurAttr[cp] &= (~112);
                    break;

                case 41: /* red bg */
                    CurAttr[cp] &= (~112);
                    CurAttr[cp] |= (4 << 4);
                    break;

                case 42: /* green bg */
                    CurAttr[cp] &= (~112);
                    CurAttr[cp] |= (2 << 4);
                    break;

                case 43: /* yellow bg */
                    CurAttr[cp] &= (~112);
                    CurAttr[cp] |= (6 << 4);
                    break;

                case 44: /* blue bg */
                    CurAttr[cp] &= (~112);
                    CurAttr[cp] |= (1 << 4);
                    break;

                case 45: /* magenta bg */
                    CurAttr[cp] &= (~112);
                    CurAttr[cp] |= (5 << 4);
                    break;

                case 46: /* cyan bg */
                    CurAttr[cp] &= (~112);
                    CurAttr[cp] |= (3 << 4);
                    break;

                case 47: /* white bg */
                    CurAttr[cp] |= 112;
                    break;

                case 48: /* subscript bg */
                    break;

                case 49: /* superscript bg */
                    break;

                default: /* unsupported */
                    break;
            }
            pp = p;
        } while(p);
    }
}


int ANSIPrintf (USHORT cp,char *szFormat, ...) {

    /* cprintf to commport and screen */

    char    chBuffer[1027];
    USHORT  sLength;
    va_list pArguments;

    va_start(pArguments,szFormat);
    sLength = vsprintf(chBuffer,szFormat,pArguments);
    va_end(pArguments);
    if(sLength)
      sLength = ANSIPuts(cp,chBuffer);
    return (int)sLength;
}


int _fastcall ANSIPuts (USHORT cp,char *buf) {

  register char *b = buf;
  register int   x,maxxl = Maxx[cp],maxyl = Maxy[cp];

  if(!modems[cp] || modems[cp]->VidHandle == -1 || !buf || !*buf)
    return 0;

  /* cursor is off while string is being displayed so we don't have
     to keep updating it. */

  HardCursorOff(cp);

  while(*b) {
    switch(ansistate[cp]) {
      case NOTHING:
        switch(*b) {
          case '\x1b':
              ansistate[cp] = WASESCAPE;
              break;

          case '\r':
              Curx[cp] = 0;
              break;

          case '\n':
              (Cury[cp])++;
              if(Cury[cp] > maxyl - 1) {
                (Cury[cp])--;
                ScrollUp(cp,0,0,maxxl - 1,
                         maxyl - 1,CurAttr[cp]);
              }
              break;

          case '\t':     /* so _you_ figure out what to do... */
              for(x = 0;x < TabSpaces;x++) {
                VioWrtCharStrAtt(" ",1,Cury[cp],Curx[cp],&CurAttr[cp],
                                 modems[cp]->VidHandle);
                (Curx[cp])++;
                if(Curx[cp] > maxxl - 1) {
                  Curx[cp] = 0;
                  (Cury[cp])++;
                  if(Cury[cp] > maxyl - 1) {
                    (Cury[cp])--;
                    ScrollUp(cp,0,0,maxxl - 1,
                             maxyl - 1,
                             CurAttr[cp]);
                  }
                }
              }
              break;

          case '\b':
              if(Curx[cp])
                (Curx[cp])--;
              break;

          case '\07':     /* usually a console bell */
              DosBeep(1000,25);
              break;

          default:
              {
                register int len = 0;

                while(b[len] && !strchr("\x1b\r\n\b\07\t",(int)b[len]) &&
                      Curx[cp] + len < maxxl)
                  len++;
                if(len) {
                  VioWrtCharStrAtt(b,len,Cury[cp],Curx[cp],&CurAttr[cp],
                                   modems[cp]->VidHandle);
                  b += len;
                  (Curx[cp]) += len;
                  if(Curx[cp] > maxxl - 1) {
                    Curx[cp] = 0;
                    (Cury[cp])++;
                    if(Cury[cp] > maxyl - 1) {
                      (Cury[cp])--;
                      ScrollUp(cp,0,0,maxxl - 1,
                               maxyl - 1,
                               CurAttr[cp]);
                    }
                  }
                  b--;
                }
              }
              break;
          }
          break;

      case WASESCAPE:
          if(*b == '[') {
            ansistate[cp] = WASBRKT;
            arglen[cp] = 0;
            *argbuf[cp] = 0;
            break;
          }
          VioWrtCharStrAtt(b,1,Cury[cp],Curx[cp],&CurAttr[cp],
                           modems[cp]->VidHandle);
          (Curx[cp])++;
          if(Curx[cp] > maxxl - 1) {
            Curx[cp] = 0;
            (Cury[cp])++;
            if(Cury[cp] > maxyl - 1) {
              (Cury[cp])--;
              ScrollUp(cp,0,0,maxxl - 1,
                       maxyl - 1,
                       CurAttr[cp]);
            }
          }
          ansistate[cp] = NOTHING;
          break;

      case WASBRKT:
          if(strchr(AnsiTerminators,(int)*b)) {
            switch((int)*b) {
              case 'H':   /* set cursor position */
              case 'F':
                  set_pos(cp,argbuf[cp],arglen[cp],*b);
                  break;

              case 'A':   /* up */
                  go_up(cp,argbuf[cp],arglen[cp],*b);
                  break;

              case 'B':   /* down */
                  go_down(cp,argbuf[cp],arglen[cp],*b);
                  break;

              case 'C':   /* right */
                  go_right(cp,argbuf[cp],arglen[cp],*b);
                  break;

              case 'D':   /* left */
                  go_left(cp,argbuf[cp],arglen[cp],*b);
                  break;

              case 'n':   /* report pos */
                  report(cp,argbuf[cp],arglen[cp],*b);
                  break;

              case 's':   /* save pos */
                  save_pos(cp,argbuf[cp],arglen[cp],*b);
                  break;

              case 'u':   /* restore pos */
                  restore_pos(cp,argbuf[cp],arglen[cp],*b);
                  break;

              case 'J':   /* clear screen */
                  clear_screen(cp,argbuf[cp],arglen[cp],*b);
                  break;

              case 'K':   /* delete to eol */
                  kill_line(cp,argbuf[cp],arglen[cp],*b);
                  break;

              case 'm':   /* set video attribs */
                  set_colors(cp,argbuf[cp],arglen[cp],*b);
                  break;

              case 'p':   /* keyboard redef -- disallowed */
                  break;

              default:    /* unsupported */
                  break;
            }
            ansistate[cp] = NOTHING;
            arglen[cp] = 0;
            *argbuf[cp] = 0;
        }
        else if(arglen[cp] < MAXARGLEN) {
          argbuf[cp][arglen[cp]] = *b;
          argbuf[cp][arglen[cp] + 1] = 0;
          (arglen[cp])++;
        }
        break;

      default:
        break;
    }
    b++;
  }

  PosHardcursor(cp,Curx[cp],Cury[cp]);
  HardCursorOn(cp,Curx[cp],Cury[cp]);

  return ((int)b - (int)buf);
}

void _fastcall SetScreensize (USHORT cp,int reservedlines) {

    if(modems[cp]->VidHandle == -1)
      return;
    Maxx[cp] = 80;
    Maxy[cp] = 25 - reservedlines;
    RealMaxx[cp] = Maxx[cp];
    RealMaxy[cp] = 25;
    *argbuf[cp] = 0;
    ansistate[cp] = NOTHING;
    arglen[cp] = 0;
    Curx[cp] = Cury[cp] = 0;
    CurAttr[cp] = 7;
    savx[cp] = savy[cp] = issaved[cp] = 0;
}


void _fastcall PosHardcursor (USHORT cp,int x,int y) {

    VioSetCurPos(y,x,modems[cp]->VidHandle);
}


void _fastcall HardCursorOff (USHORT cp) {

    VIOCURSORINFO vc;

    VioGetCurType(&vc,modems[cp]->VidHandle);
    vc.attr = -1;
    VioSetCurType(&vc,modems[cp]->VidHandle);
}


void _fastcall HardCursorOn (USHORT cp,int x,int y) {

    VIOCURSORINFO vc;

    VioGetCurType(&vc,modems[cp]->VidHandle);
    vc.attr = 0;
    VioSetCurType(&vc,modems[cp]->VidHandle);
    VioSetCurPos(y,x,modems[cp]->VidHandle);
}


void _fastcall ScrollUp (USHORT cp,int tx,int ty,int bx,int by,char attr) {

    int attrib = ' ' | (attr << 8);

    VioScrollUp(ty,tx,by,bx,1,(char *)&attrib,modems[cp]->VidHandle);
}


void _fastcall ClearWindow (USHORT cp,int tx,int ty,int bx,int by,char attr) {

    int attrib = ' ' | (attr << 8);

    VioScrollUp(ty,tx,by,bx,-1,(char *)&attrib,modems[cp]->VidHandle);
}


void _fastcall CleartoEOL (USHORT cp,int x,int y,int ex,char attr) {

    int attrib = ' ' | (attr << 8);

    VioScrollUp(y,x,y,ex,-1,(char *)&attrib,modems[cp]->VidHandle);
}


char _fastcall GetAttr (USHORT cp) {

  return CurAttr[cp];
}


void _fastcall GetXY (USHORT cp,int *x,int *y) {

  *x = Curx[cp];
  *y = Cury[cp];
}

int _fastcall WhereX (USHORT cp) {

  return Curx[cp];
}

int _fastcall WhereY (USHORT cp) {

  return Cury[cp];
}

void _fastcall SetXY (USHORT cp,int x,int y) {

  Curx[cp] = x;
  Cury[cp] = y;
  PosHardcursor(cp,x,y);
}

void _fastcall SetAttr (USHORT cp,char attr) {

  CurAttr[cp] = attr;
}
