#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "modem.h"
#include "bbs.h"
#include "xmisc.h"

    extern MDM  *modems[MAXINSTANCES];
    extern USER *user[MAXINSTANCES];


int _fastcall trashcan (int mode,USHORT cp,char *name) {

    int  handle,ret = 0;
    char s[42],*p,*pp;


    handle = bbs_sopen(cp,"TRASHCAN.BB2",O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
    if(handle == -1) return 0;

    while(!eof(handle)) {
        if(!fgetsx(s,41,handle)) break;
        s[41] = 0;
        stripcr(s);
        lstrip(s);
        rstrip(s);
        if(!*s || *s == ';') continue;
        if(*s == '!') {
            if(stristr(name,&s[1])) {
                ret = -1;
                break;
            }
        }
        else if(*s == ':') {
            pp = name;
            do {
                p = skip_nonwhite(pp);
                if(*p) {
                    *p = 0;
                    p++;
                }
                if(!stricmp(s,pp)) {
                    if(*p) {
                        p--;
                        *p = ' ';
                    }
                    ret = -1;
                    break;
                }
                if(*p) {
                    p--;
                    *p = ' ';
                    p++;
                }
                if(*pp == ' ' || *pp == '\t') {
                    ret = -1;
                    break;
                }
                pp = skip_white(p);
            } while(*pp);
        }
        else {
            if(!stricmp(name,s)) {
                ret = -1;
                break;
            }
        }
    }

    bbs_close(cp,handle);

    if(ret) {
        readansi(mode,cp,"TRASHCAN.ASC",NULL,3);
        sayp(mode,cp,192,NULL,0);
        flushout(cp);
    }
    return ret;
}



int _fastcall phonecan (int mode,USHORT cp,char *phone) {

    int          handle,ret = 0;
    unsigned int counter;
    char         s[42],*p,*pp;


    handle = bbs_sopen(cp,"PHONECAN.BB2",O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
    if(handle == -1) goto TryDupe;

    while(!eof(handle)) {
        if(!fgetsx(s,41,handle)) break;
        s[41] = 0;
        stripcr(s);
        lstrip(s);
        rstrip(s);
        if(!*s || *s == ';') continue;
        if(*s == '!') {
            if(stristr(phone,&s[1])) {
                ret = -1;
                break;
            }
        }
        else if(*s == ':') {
            pp = phone;
            do {
                p = skip_nonwhite(pp);
                if(*p) {
                    *p = 0;
                    p++;
                }
                if(!stricmp(s,pp)) {
                    if(*p) {
                        p--;
                        *p = ' ';
                    }
                    ret = -1;
                    break;
                }
                if(*p) {
                    p--;
                    *p = ' ';
                    p++;
                }
                if(*pp == ' ' || *pp == '\t') {
                    ret = -1;
                    break;
                }
                pp = skip_white(p);
            } while(*pp);
        }
        else {
            if(!stricmp(phone,s)) {
                ret = -1;
                break;
            }
        }
        DosSleep(1L);
    }

    bbs_close(cp,handle);

    if(ret) {
        readansi(mode,cp,"PHONECAN.ASC",NULL,3);
        sayp(mode,cp,193,NULL,0);
        flushout(cp);
        return ret;
    }

TryDupe:

    handle = bbs_sopen(cp,"USERS.BB2",O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
    if(handle == -1) return 0;
    else {

        USER *dummy;

        dummy = bbs_malloc(cp,sizeof(USER) - USERSUB);
        if(!dummy) {
            bbs_close(cp,handle);
            return 0;
        }

        counter = 0;
        lseek(handle,0L,SEEK_SET);
        while(!eof(handle)) {
            if(read(handle,dummy,(sizeof(USER) - USERSUB)) < (long)(sizeof(USER) - USERSUB)) break;
            if(!stricmp(dummy->phone_number,phone) && counter != user[cp]->number - 1) {
                ret = -2;
                if(dummy->attribs & U_DELETED) {
                    ret = 0;
                    continue;
                }
                if(ret) break;
            }
            counter++;
            DosSleep(1L);
        }
        bbs_close(cp,handle);
        bbs_free(cp,dummy);
    }

    return ret;
}
