/* background msg-to-textfile export thread */

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"
#include "xmsg.h"

    extern MDM     *modems[MAXINSTANCES];
    extern USER    *user[MAXINSTANCES];
    extern BBS     *bbs;
    extern MSGAREA *msgareas;
    extern int     *_threadid;
    extern ADDR    *addresses;




void TXT_export (void *ccp) {

    /* exports msgs into a pseudo-RFC-0822 format in background */

    USHORT  cp = *((USHORT *)ccp),messno,c;
    USER    u;
    MSGAREA *info;
    XMSG    msg;
    char    *hold,*p,line[133];
    int     temp,handle,handle2;
    int     mode = (((modems[cp]->curbaud != 0) * D_REMOTE) + D_LOCAL);
    struct stat st;

    DosEnterCritSec();
      if(!user[cp]) {
        DosExitCritSec();
        _endthread();
      }
      if(DosSemRequest(&modems[cp]->amexportingSEM,0L)) {
          dputs(mode,cp,"\r\nAn export is already in progress; try again after it finishes.\r\n");
          DosExitCritSec();
          _endthread();
      }
      sprintf(line,"%s/%08lx.ZIP",d_xport,user[cp]->userid);
      if(!stat(line,&st)) {
        if(st.st_size) {
            dputs(mode,cp,"\r\nYou already have a packet waiting; download it first\r\n");
            DosSemSet(&modems[cp]->amdonexportingSEM); /* let BBS thread know it's done */
            DosSemClear(&modems[cp]->amexportingSEM);
            DosExitCritSec();
            _endthread();
        }
        else unlink(line);
      }
      memcpy(&u,user[cp],sizeof(USER));
      u.lastread = (unsigned int *)malloc(LASTREADSIZE * sizeof(unsigned int));
      if(!u.lastread) {
        dputs(mode,cp,"\r\nExport aborted; I'm out of memory\r\n");
        DosSemClear(&modems[cp]->amexportingSEM);
        DosExitCritSec();
        _endthread();
      }
      memcpy(u.lastread,user[cp]->lastread,LASTREADSIZE * sizeof(unsigned int));
    DosExitCritSec();

    /* find first available area */

    info = next_xport_area(msgareas,&u,0);
    if(!info) {
        free(u.lastread);
        DosSemClear(&modems[cp]->amexportingSEM);
        _endthread();
    }

    /* open export file */

    sprintf(line,"%s/%08lx.TXT",d_xport,u.userid);
    unlink(line);
    handle = sopen(line,O_NOINHERIT | O_RDWR | O_BINARY | O_CREAT,SH_DENYWR,S_IWRITE);
    if(handle == -1) {
        free(u.lastread);
        DosSemClear(&modems[cp]->amexportingSEM);
        _endthread();
    }

    /* open BBS ID file */

    sprintf(line,"%s/%08lx.BID",d_xport,u.userid);
    unlink(line);
    handle2 = sopen(line,O_NOINHERIT | O_RDWR | O_BINARY | O_CREAT,SH_DENYWR,S_IWRITE);
    if(handle2 == -1) {
        free(u.lastread);
        close(handle);
        sprintf(line,"%s/%08lx.TXT",d_xport,u.userid);
        unlink(line);
        DosSemClear(&modems[cp]->amexportingSEM);
        _endthread();
    }
    else {

        ADDR *addr;

        ffprintf(handle2,"BBS: %s\r\n",bbs->bbs_name);
        ffprintf(handle2,"Sysop: %s\r\n",bbs->sysop);
        addr = addresses;
        if(!addr) ffprintf(handle2,"Addr: <None>\r\n");
        while(addr) {
            if(addr->point == 0) {
                ffprintf(handle2,"Addr: %s#%u:%u/%u.%u\r\n",addr->domain,
                         addr->zone,addr->net,addr->node,addr->point);
            }
            addr = addr->next;
        }
        ffprintf(handle2,"\r\n");
    }

    /* set priority before beginning actual work */

    logfunc(0,cp,"Text export thread working");
    DosSetPrty(2,modems[cp]->export[0],modems[cp]->export[1],*_threadid);

    /* do the export */

    while(info) {

        ffprintf(handle2,"Area: #%u \"%s\"",info->number,info->name);
        if(info->areaflags & M_NET) ffprintf(handle2," (Net)");
        else if(info->areaflags & M_ECHO) ffprintf(handle2," (Echo)");
        else if(info->areaflags & M_GROUP) ffprintf(handle2," (Group)");
        ffprintf(handle2,"\r\n");

        messno = how_many_msgs(info);
        if(u.lastread[info->number - 1] > messno) {
           if(messno)
             u.lastread[info->number - 1] = messno;
        }

        for(c = u.lastread[info->number - 1] + 1;c < messno + 1;c++) {

            /* get header */

            memset(&msg,0,sizeof(XMSG));
            temp = get_mess((USHORT)-1,&msg,info->number,c);
            if(temp != MSG_NOERR) continue;
            if(msg.fflags & MSGPRIVATE) {
                if(mymsg(&u,&msg) && msg_sysop_ok(&u,info)) continue;
            }
            if(msg.xflags & MSGDELETED && msg_sysop_ok(&u,info)) continue;

            /* get text */

            temp = get_text((USHORT)-1,&hold,&msg,info->number,c);
            if(temp != MSG_NOERR && temp != MSG_REDUCED) {
                if(hold) free(hold);
                continue;
            }

            /* write header */

            ffprintf(handle,"Area \"%s\"\r\n",info->name);
            ffprintf(handle,"From: ");
            if((msg.xflags & MSGANON) && !msg_sysop_ok(&u,info)) {
                ffprintf(handle,"%%Anonymous%%\r\n");
            }
            else ffprintf(handle,"%s\r\n",msg.from);
            ffprintf(handle,"To:   %s\r\n",msg.to);
            if(!(msg.xflags & MSGANON) || !msg_sysop_ok(&u,info)) {
                ffprintf(handle,"Date: %-0.19s\r\nAttr: ",msg.date);
            }
            else ffprintf(handle,"Date: %-0.9s\r\nAttr: ",msg.date);
            temp = 0;
            if(msg.fflags & MSGPRIVATE) temp += write(handle,"P",1);
            if(msg.fflags & MSGREAD) temp += write(handle,"R",1);
            else if(mymsg(&u,&msg)) temp += write(handle,"!",1);
            if(msg.xflags & MSGDELETED) temp += write(handle,"D",1);
            if(msg.xflags & MSGNET) temp += write(handle,"N",1);
            if(msg.xflags & MSGECHO) temp += write(handle,"E",1);
            if(msg.xflags & MSGKEEP) temp += write(handle,"+",1);
            if(info->areaflags & M_NET) {
                if(msg.fflags & MSGFILE) temp += write(handle,"A",1);
                if(msg.fflags & MSGRRQ) temp += write(handle,"Q",1);
                if(msg.fflags & MSGURQ) temp += write(handle,"U",1);
                if(msg.fflags & MSGKILL) temp += write(handle,"K",1);
                if(msg.fflags & MSGCRASH) temp += write(handle,"C",1);
                if(msg.fflags & MSGSENT) temp += write(handle,"S",1);
                if(msg.xflags & MSGHOST) temp += write(handle,"H",1);
                if(msg.xflags & MSGHOLD) temp += write(handle,"h",1);
                if(msg.xflags & MSGANON) temp += write(handle,"a",1);
                if(!temp) write(handle,"<none>",6);
                ffprintf(handle,"\r\nNet:  %u:%u/%u.%u.%u -> %u/%u.%u.%u",msg.o_zone,
                         msg.o_net,msg.o_node,msg.o_point,msg.d_zone,msg.d_net,
                         msg.d_node,msg.d_point);
                if((msg.fflags & MSGFILE) || (msg.fflags & MSGRRQ) || (msg.fflags & MSGURQ)) {
                    ffprintf(handle,"\r\nFile: %s\r\n",msg.subj);
                }
                else ffprintf(handle,"\r\nSubj: %s\r\n",msg.subj);
            }
            else {
                if(!temp) write(handle,"<none>",6);
                ffprintf(handle,"\r\nSubj: %s\r\n",msg.subj);
            }

            /* write kludge lines into header */

            p = hold;
            strip_seenbys(hold);

            for(;;) {
                if(!*write_line(line,&p,(unsigned int)(u.width - 1),1)) break;
                if(*line == '\01') {
                    if(line[1]) {
                        ffprintf(handle,"%s\r\n",&line[1]);
                    }
                }
                continue;
            }

            write(handle,"\r\n",2);   /* end-of-header marker */
            DosSleep(0L);   /* brief snooze */

            /* write text */

            p = hold;

            for(;;) {
                if(!*write_line(line,&p,(unsigned int)(u.width - 1),0)) break;
                if(*line == '\01')
                    continue;
                if(!*line)
                  write(handle," \r\n",3);     /* "fold" */
                else
                  ffprintf(handle,"%s\r\n",line);
            }
            write(handle,"\r\n",2); /* end-of-text marker */

            if(hold)
              free(hold);

            if(c == messno)
              messno = how_many_msgs(info);
            DosSleep(1L);
            if(bbs->maxuserpkt && tell(handle) > bbs->maxuserpkt)
              break;
        }
        if(messno)
          u.lastread[info->number - 1] = messno;
        DosBufReset(handle);
        DosSleep(1L);
        if(bbs->maxuserpkt && tell(handle) > bbs->maxuserpkt)
          break;
        info = next_xport_area(info,&u,1);
    }

    if(filelength(handle) == 0L) {
        close(handle);
        close(handle2);
        sprintf(line,"%s/%08lx.TXT",d_xport,u.userid);
        unlink(line);
        sprintf(line,"%s/%08lx.BID",d_xport,u.userid);
        unlink(line);
        goto BailOut;
    }

    close(handle);
    close(handle2);

    /* update lastread */

    DosEnterCritSec();
     if(user[cp] && user[cp]->number == u.number) {
       memcpy(user[cp]->lastread,u.lastread,LASTREADSIZE * sizeof(unsigned int));
     }
     save_lastread((USHORT)-1,u.lastread,u.number);
    DosExitCritSec();

    /* archive files */

    forkf(D_LOCAL,(USHORT)-1,0,"%s /C PKZIP.EXE -m %s/%08lx.ZIP %s/%08lx.TXT %s/%08lx.BID 1>NUL 2>NUL",
          getenv("COMSPEC"),d_xport,u.userid,d_xport,u.userid,d_xport,u.userid);

BailOut:

    free(u.lastread);
    DosEnterCritSec();
     if(user[cp] && user[cp]->number == u.number)
       DosSemSet(&modems[cp]->amdonexportingSEM); /* let BBS thread know it's done */
    DosExitCritSec();
    DosSemClear(&modems[cp]->amexportingSEM);
}



MSGAREA * _fastcall next_xport_area (MSGAREA *ma, USER *u, int dir) {

    /* Also finds first accessible area if called with ma == msgareas */
    /* and dir == 0 */

    MSGAREA *info;
    char temp = 0;


    if(!msgareas || !ma) return NULL;

    info = ma;
    while(info) {
        if(dir || temp) {
            if(dir < 0) info = info->prior;
            else info = info->next;
        }
        else temp++;
        if(!info) break;
        if(info->r_security1 > u->security1) continue;
        if(info->r_security2 > u->security2) continue;
        if(info->r_flags1 & (~u->flags1)) continue;
        if(info->r_flags2 & (~u->flags2)) continue;
        if(info->age) {
            if(info->age < 0) {
                if(u->age > abs(info->age)) continue;
            }
            else {
                if(u->age < info->age) continue;
            }
        }
        if((info->areaflags & M_ANSI) && !(u->attribs & U_COLOR)) continue;
        if(!IsBit(u->bbsmsg,info->number - 1)) continue;
        if(info->password && *info->password) continue;
        break;
    }
    return info;
}
