#include <ctype.h>
#include "mailer.h"
#include "bbs.h"
#include "modem.h"
#include "xmisc.h"
#include "keys.h"

    extern MDM  *modems[MAXINSTANCES];
    extern USER *user[MAXINSTANCES];
    extern int  helpkey;


/* 'Rolling' input */


int _fastcall select_one (int mode,USHORT cp,char **selections,int numselecs,
                          char *prompt,char *helpfile,char *helpstr,
                          unsigned int flags) {

    int          x = 0,y,oldx,oldlen,longest = 0,perline = 1,timeout = 0,tx;
    unsigned int temp;

    /* flags:
        1:  Show initial list of options
        2:  Show initial list of first letters
        4:  No roll, just regular hot input
        32768: (Used by pselect_one())
    */

    if(flags & 1)
      goto Options;

RePrompt:

    if(flags & 2) {

        int x;

        dputs(mode,cp,"\r\n");
        if(user[cp]->attribs & U_ANSI)
          dputs(mode,cp,"\x1b[K");
        dputs(mode,cp,"[");
        for(x = 0;x < numselecs;x++) {
          if(*selections[x] != '*')
            dputc(mode,cp,*selections[x]);
        }
        dputs(mode,cp,"?] ");
    }
    if(user[cp]->attribs & U_NOROLL)
      flags |= 4;

    if(prompt && *prompt)
      dputs(mode,cp,prompt);

    for(;;) {
        if(!timeout && user[cp]->offline < time(NULL) + 60L) {
            sayp(mode,cp,145,NULL,0);
            timeout = 1;
            goto RePrompt;
        }

        if(!(flags & 4)) {
            oldx = x;
            oldlen = dputs(mode,cp,selections[x]);
        }

Another:

        temp = wait_inkey(mode,cp);
        if(temp == -1) {
          dputs(mode,cp,"\r\n");
          goto RePrompt;
        }
        if((int)temp == helpkey) {
            dputs(mode,cp,"\r\n");
            send_help(mode,cp,helpstr,helpfile);
            goto RePrompt;
        }

        if(temp == '\r') {
            if(flags & 4) {
                return 0;   /* default to initial option */
            }
            else {
                return x;   /* return current option */
            }
        }

        if(!(flags & 4)) {
            switch(temp) {
                case RIGHT:
                case PGUP:
                case '9':
                case '8':
                  tx = x / 2;
                  if(tx == x) x--;
                  else x = tx;
                  if(x < 0) x = numselecs - 1;
                  goto BotLoop;

                case UP:
                case '6':
                case ' ':
                  x++;
                  if(x >= numselecs) x = 0;
                  goto BotLoop;

                case DN:
                case PGDN:
                case '3':
                case '2':
                  tx = x + ((numselecs - x) / 2);
                  if(tx == x) x++;
                  else x = tx;
                  if(x >= numselecs) x = 0;
                  goto BotLoop;

                case LEFT:
                case '4':
                  x--;
                  if(x < 0) x = numselecs - 1;
                  goto BotLoop;

                case END:
                case '1':
                  x = numselecs - 1;
                  goto BotLoop;

                case HOME:
                case '7':
                  x = 0;
                  goto BotLoop;

                default:    break;
            }
        }

        switch(temp) {
          case '?':

Options:

            sayp(mode,cp,144,NULL,0);
            {

                int x;

                if(!longest) {
                    for(x = 0;x < numselecs;x++) {
                        y = strlen(selections[x]);
                        longest = max(longest,y);
                    }
                    perline = user[cp]->width / (longest + 2);
                }

                for(x = 0;x < numselecs;x++) {
                    if(longest <= ((int)user[cp]->width / perline) - 1) {
                        if((x + 1) % perline) {
                            dputs(mode,cp," ");
                            dputs(mode,cp,selections[x]);
                            if(x < numselecs - 1) {
                                for(y = 0;y < (((int)user[cp]->width / perline) - 1) - strlen(selections[x]);y++) {
                                    dputs(mode,cp," ");
                                }
                            }
                            else {
                              dputs(mode,cp,"\r\n");
                              if(user[cp]->attribs & U_ANSI)
                                dputs(mode,cp,"\x1b[K");
                            }
                        }
                        else {
                          dprintf(mode,cp," %s\r\n",selections[x]);
                          if(user[cp]->attribs & U_ANSI)
                            dputs(mode,cp,"\x1b[K");
                        }
                    }
                    else {
                      dprintf(mode,cp," %s\r\n",selections[x]);
                      if(user[cp]->attribs & U_ANSI)
                        dputs(mode,cp,"\x1b[K");
                    }
                }
            }
            goto RePrompt;

          case '\x1b':
          case '\xb':
            return -1;

          default:
            temp = toupper(temp);
            for(y = 0;y < numselecs;y++) {
                if(toupper(*selections[y]) == (int)temp) {
                    if(!(flags & 4)) {
                        if(y != oldx) {
                            backup(mode,cp,oldlen - 1);
                            dputs(mode,cp,selections[y]);
                        }
                    }
                    else dputc(mode,cp,*selections[y]);
                    if(!(flags & 4) && (user[cp]->attribs & U_COLD)) {
                        x = oldx = y;
                        oldx = strlen(selections[y]);
                        goto Another;
                    }
                    else return y;
                }
            }

            if(!(flags & 4)) {
                if(user[cp]->attribs & U_ANSI) {
                    sayp(mode,cp,142,NULL,0);
                    purge_in(cp);
                    DosSleep(2250L);
                    dputs(mode,cp,"\r\x1b[K");
                }
                else {
                    sayp(mode,cp,143,NULL,0);
                    DosSleep(100L);
                    purge_in(cp);
                }
            }
            else {
                quiet_bell(mode,cp,1);
                dputs(mode,cp,"\r");
                if(user[cp]->attribs & U_ANSI)
                  dputs(mode,cp,"\x1b[K");
                purge_in(cp);
            }
            goto RePrompt;
        }

BotLoop:

        if(!(flags & 4)) {
            backup(mode,cp,oldlen - 1);
        }
        else if(isprint(temp)) {
            backup(mode,cp,1);
        }

        if(user[cp]->offline < time(NULL) || checkcarrier(cp))
          break;
    }

    return -1;
}



int _fastcall is_one (int key,char **selections,int numselecs) {

    /* checks a key to see if it's one of the selections */

    register int x;


    if(key && key != -1) {
        for(x = 0;x < numselecs;x++) {
            if(key == (int)*selections[x]) return x;
        }
    }
    return -1;
}



int _fastcall pselect_one (int mode,USHORT cp,int pnum,int numselecs,
                           int pnum2,char *helpfile,char *helpstr,
                           unsigned int flags) {

    char **selector;
    char prompt[80];
    int  select;


    selector = pgetarray(cp,pnum,numselecs);
    if(selector) {
        if((user[cp]->attribs & U_COLOR) && !(flags & 32768)) {
            select = top_menu(mode,cp,selector,numselecs,helpfile,helpstr);
        }
        else {
            sayp(mode,cp,pnum2,prompt,79);
            select = select_one(mode,cp,selector,numselecs,prompt,helpfile,
                                helpstr,flags);
        }
        free_selections(cp,selector,numselecs);
        return select;
    }
    return -1;
}




int _fastcall top_menu (int mode,USHORT cp,char **selections,int numselects,
                        char *helpfile,char *helpstr) {

    int x,ts = 0,first = 0,last,cur = 0,len,redisplay = 1,temp,lastcur = 32767;
    char *moref = "-=>",*moreb = "<=-";


ReStart:

    dputs(mode,cp,"\x1b[s\x1b[0m");

    for(;;) {
        if(redisplay) {
            dputs(mode,cp,"\x1b[1;1H\x1b[7m\x1b[K ");
            len = 1;
            first = ts;
            for(x = first; ;x++) {
                len += dputs(mode,cp,selections[x]);
                len += dputs(mode,cp,"  ");
                if(x == numselects - 1 ||
                   len > user[cp]->width - (strlen(moref) +
                   strlen(selections[x + 1]) + 2)) {
                    last = x;
                    break;
                }
            }
            last = x;
            if(cur <= first) cur = first;
            else cur = last;
            if(last < numselects - 1) len += dputs(mode,cp,moref);
            else if(first > 0) len += dputs(mode,cp,moreb);
            while(len++ < user[cp]->width) dputs(mode,cp," ");
        }

        if(cur != lastcur || redisplay) {
            len = 1;
            for(x = first;x <= last;x++) {
                if(x == cur) {
                    dprintf(mode,cp,"\x1b[1;%dH\x1b[0m%s\x1b[7m",len + 1,selections[x]);
                    if(redisplay || lastcur == 32767) break;
                }
                if(x == lastcur) {
                    dprintf(mode,cp,"\x1b[1;%dH%s",len + 1,selections[x]);
                }
                len += strlen(selections[x]) + 2;
            }
            redisplay = 0;
            lastcur = cur;
        }

ReInput:

        temp = wait_inkey(mode,cp);
        switch(temp) {
            case ESC:
            case CTRL_K:
                dputs(mode,cp,"\x1b[0m\x1b[u");
                return -1;

            case '\r':
                dputs(mode,cp,"\x1b[0m\x1b[u");
                return cur;

            case '4':
            case LEFT:
                if(!cur) {
                    cur = numselects - 1;
                    len = 1;
                    for(x = numselects - 1; ;x--) {
                        len += strlen(selections[x]) + 2;
                        if(!x ||
                           len > user[cp]->width - (strlen(moref) +
                           strlen(selections[x - 1]) + 2)) {
                            ts = x;
                            break;
                        }
                    }
                    if(ts) redisplay = 1;
                    break;
                }
                else cur--;
                if(cur >= first && cur <= last) break; /* else fallthrough to UP handler */

            case '8':
            case '9':
            case UP:
            case PGUP:
                if(first > 0 || last < numselects - 1) {
                    if(ts) {
                        len = 1;
                        for(x = ts - 1; ;x--) {
                            len += strlen(selections[x]) + 2;
                            if(!x ||
                               len > user[cp]->width - (strlen(moref) +
                               strlen(selections[x - 1]) + 2)) {
                                cur = ts - 1;
                                ts = x;
                                break;
                            }
                        }
                        redisplay = 1;
                        break;
                    } /* else fallthrough to END handler */
                }
                else {
                    quiet_bell(mode,cp,1);
                    break;
                }

            case '1':
            case END:
                if(first > 0 || last < numselects - 1) {
                    cur = numselects - 1;
                    len = 1;
                    for(x = numselects - 1; ;x--) {
                        len += strlen(selections[x]) + 2;
                        if(!x ||
                           len > user[cp]->width - (strlen(moref) +
                           strlen(selections[x - 1]) + 2)) {
                            ts = x;
                            break;
                        }
                    }
                    redisplay = 1;
                }
                else quiet_bell(mode,cp,1);
                break;

            case ' ':
            case '6':
            case RIGHT:
                cur++;
                if(cur > numselects - 1) {
                    cur = 0;
                    ts = 0;
                    if(first > 0) redisplay = 1;
                    break;
                }
                if(cur <= last) break; /* else fallthrough to DOWN handler */

            case '2':
            case '3':
            case DN:
            case PGDN:
                if(first > 0 || last < numselects - 1) {
                    ts = last + 1;
                    if(ts > numselects - 1) ts = 0;
                    redisplay = 1;
                }
                else quiet_bell(mode,cp,1);
                break;

            case '7':
            case HOME:
                cur = 0;
                ts = 0;
                redisplay = 1;
                break;

            default:
                if(temp == helpkey) {
                    dputs(mode,cp,"\x1b[0m\x1b[u");
                    send_help(mode,cp,helpstr,helpfile);
                    redisplay = 1;
                    goto ReStart;
                }
                temp = toupper(temp);
                for(x = first;x < last + 1;x++) {   /* first try what's showing */
                    if(toupper(*selections[x]) == temp) {
                        dputs(mode,cp,"\x1b[0m\x1b[u");
                        return x;
                    }
                }
                for(x = 0;x < numselects;x++) {     /* then try everything */
                    if(toupper(*selections[x]) == temp) {
                        dputs(mode,cp,"\x1b[0m\x1b[u");
                        return x;
                    }
                }
                quiet_bell(mode,cp,1);
                goto ReInput;
        }
        if(user[cp]->offline < time(NULL) || checkcarrier(cp)) break;
    }

    dputs(mode,cp,"\x1b[0m\x1b[u");
    return -1;
}
