#include <limits.h>
#include <io.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <share.h>
#include <errno.h>
#include "mailer.h"
#include "xmisc.h"
#include "msgid.h"

    extern MDM *modems[MAXINSTANCES];


int _fastcall put_mess (int mode,USHORT cp,unsigned int messno,
                        unsigned int areano,struct _xmsg *msg) {

 int                   handle;
 struct stat           st;
 register unsigned int x=0;
 struct _lockit {
    long start;
    long len;
 }                     lock;
 char                  filename[256];
 unsigned int          lastmess;


 sprintf(filename,"%s/MSGS/XODATA.%03x",modems[cp]->bbs.homedir,areano);

 lastmess=messno;

 while ((handle=bbs_sopen(cp,filename,O_NOINHERIT | O_RDWR | O_CREAT | O_BINARY, SH_DENYNO, S_IWRITE | S_IREAD))==-1) {
     if (errno==EACCES) {
        x++;
        if(x>2) {
            dputs(mode,cp,"\r\nGot tired of waiting...\r\n");
            return -1;
        }
        dputs(mode,cp,"\r\nAwaiting access...\r\n");
        DosSleep(1000L);
     }
     else {
        dputs(mode,cp,"\r\nCannot open message file...\r\n");
        return -2;
     }
 }

     for(x=0;x<12;x++) {
         if(!lastmess) {  // Append msg to end of file
            if(fstat(handle,&st)) messno=1;
            else {
                messno=(unsigned int)(st.st_size/(long)sizeof(struct _xmsg));
                if(messno<65535) messno++;
                else {
                    dputs(mode,cp,"\r\nMessage area is full.\r\n");
                    bbs_close(cp,handle);
                    return -4;
                }
            }
         }

         lock.start=(long)((long)(messno-1)*(long)sizeof(struct _xmsg));
         lock.len=(long)sizeof(struct _xmsg);
         if(!DosFileLocks(handle,NULL,&lock)) break;
         DosSleep(500L);
     }

     if ((lseek(handle,(long)((long)(messno-1)*(long)sizeof(struct _xmsg)),SEEK_SET)==(-1)) || (write(handle,msg,sizeof(struct _xmsg))<sizeof(struct _xmsg))) {
        dputs(mode,cp,"\r\nSeek or write error\r\n");
        DosFileLocks(handle,&lock,NULL);
        bbs_close(cp,handle);
        return -3;
     }

     DosFileLocks(handle,&lock,NULL);
     bbs_close(cp,handle);

 return 0;
}






long _fastcall put_text (int mode,USHORT cp,unsigned int messno,
                         unsigned int areano,char *hold,char *extra,
                         char *origintext,struct _xmsg *msg,int addmsgid) {

   char once=0;
   int handle,x;
   long tries,holdlen;
   struct _lockit {
      long start;
      long len;
   } lock;
   char filename[256];


 if (hold==NULL || !*hold) return 0;
 sprintf(filename,"%s/MSGS/XOTEXT.%03x",modems[cp]->bbs.homedir,areano);
 holdlen=(long)strlen(hold);

ReTry:

 handle=bbs_sopen(cp,filename,O_NOINHERIT | O_RDWR | O_CREAT | O_BINARY,SH_DENYWR,S_IWRITE | S_IREAD);
 if(handle==-1) {
     if (errno==EACCES) {
        dputs(mode,cp,"\r\nAwaiting access\r\n");
        once++;
        if(once<3) goto ReTry;
        dputs(mode,cp,"\r\nTired of waiting...\r\n");
        return 0;
     }
     else dputs(mode,cp,"\r\nCan't open text database\r\n");
     return 0;
 }

     once=0;
     if(messno) {
         if((long)(messno-1) * (long)sizeof(struct _xmsg) > filelength(handle)) {
             messno=0;
         }
     }

     if(messno) lock.start=(long)(messno-1) * (long)sizeof(struct _xmsg);
     else lock.start=filelength(handle);
     lock.len=holdlen+512L;
     for(x=0;x<12;x++) {
         if(!DosFileLocks(handle,NULL,&lock)) break;
         DosSleep(500L);
     }

TryThatAgain:

     if(!messno) tries=lseek(handle,0L,SEEK_END);
     else tries=lseek(handle,(long)(messno-1) * (long)sizeof(struct _xmsg),SEEK_SET);
     if (tries == -1L) {
         if (eof(handle)==-1) {
             if (once<3) {
                 once++;
                 goto TryThatAgain;
             }
             else {
                 dputs(mode,cp,"\r\nSeek error\r\n");
                 DosFileLocks(handle,&lock,NULL);
                 bbs_close(cp,handle);
                 return 0;
             }
          }
     }

     msg->start=tell(handle);
     msg->length=0L;

     if(addmsgid) {     /* add msgid */

        char addrstr[48];

        sprintf(addrstr,"%s#%u:%u/%u.%u",msg->o_domain,msg->o_zone,msg->o_net,
                msg->o_node,msg->o_point);

        msg->msgidaddr = crc32str(addrstr);
        msg->msgidunique = NextMsgidSerial();

        msg->length += (long)ffprintf(handle,"\01MSGID: %s %08x\r",addrstr,
                                      msg->msgidunique);
     }

     if(msg->replyidaddr && *modems[cp]->lastreplyid) {  /* add replyid */
        msg->length += (long)ffprintf(handle,"\01REPLY: %s\r",
                                      modems[cp]->lastreplyid);
     }

     if(*msg->assoc) {  /* add assoc */
        msg->length += (long)ffprintf(handle,"\01ASSOC: %s\r",msg->assoc);
     }

     if (extra && *extra) msg->length += (long)write(handle,extra,strlen(extra));
     msg->length += (long)write(handle,hold,(size_t)holdlen);
     if(origintext && *origintext) msg->length += (long)write(handle,origintext,
                                                              strlen(origintext));
     msg->length += (long)write(handle,"\0",1);

// Compress if > 1024b && !(modems[cp]->bbs.attribs & B_NOCOMPRESS)

     DosFileLocks(handle,&lock,NULL);

 bbs_close(cp,handle);
 return msg->length;
}
