#include "mailer.h"
#include "xmisc.h"






int _fastcall parse_addr (char **p, ADDR *r,ADDR *rr) {

    // Tries to parse a string for a valid FTN addresss.
    // I say "tries" because it attempts to allow incomplete addresses
    // without getting itself confused.
    // p=pointer-to-pointer to string to parse
    // r=pointer to address structure to place parsed address in

    char *domain,*zone,*net,*node,*point,*temp;
    char lastdelim=0;


    domain = zone = net = node = point = NULL;
    *r->domain = 0;
    if(!*p || !**p) return -1;
    *p = skip_white(*p);

    do {
        temp = *p;
        *p = to_delim(*p,"#:/.@\t ");
        switch((int) **p) {
            case '\0':
            case ' ':
            case 't':   if(lastdelim == '.') point = temp;
                        else if(lastdelim == '@') domain = temp;
                        else node = temp;
                        goto BreakOut;
            case '#':   domain = temp;
                        break;
            case ':':   zone = temp;
                        break;
            case '/':   net = temp;
                        break;
            case '@':   if(lastdelim == '.') point = temp;
                        else node = temp;
                        break;
            case '.':   node = temp;
                        break;
        }
        lastdelim = **p;
        (*p)++;     // Skip delimiter
    } while(*p && **p);

BreakOut:

    if(!zone && !net && !point && !domain) {
        if(!node || (atoi(node)==0 && *node!='0')) return -1;
    }

    if(domain) {
        strncpy(r->domain,domain,8);
        r->domain[8]=0;
        domain=strchr(r->domain,'#');
        if(domain) *domain=0;
        domain = strchr(r->domain,'.');
        if(domain) *domain=0;
        rstrip(r->domain);
    }
    else *r->domain=0;
    if(zone)r->zone=(unsigned int)atol(zone);
    else r->zone=0;
    if(net)r->net=(unsigned int)atol(net);
    else r->net=0;
    if(node)r->node=(unsigned int)atol(node);
    else r->node=0;
    if(point)r->point=(unsigned int)atol(point);
    else r->point=0;

Again:

    if(!r->zone || !r->net || !node || !*r->domain) {
        if(rr) {
            guess_rest(r,rr);
            rr=NULL;
            goto Again;
        }
        else return -1;
    }

    return 0;
}




int _fastcall guess_rest (ADDR *r, ADDR *m) {

    // Makes primitive attempt to fill in missing fields of address
    // r=pointer to address structure to complete
    // m=pointer to first address in list to find missing info in

    ADDR *temp;


    if(!r->net) r->net = m->net;  // always assume primary address' net

    if(!r->zone) {
        temp=m;
        r->zone=m->zone;        // start assuming primary address' zone
        while(temp) {
            if(temp->net==r->net) { // unless we get a net match
                r->zone=temp->zone;
                break;
            }
            temp=temp->next;
        }
    }

    if(!*r->domain) {
        strncpy(r->domain,m->domain,8); // start assuming primary domain
        r->domain[8]=0;
        temp=m;
        while(temp) {
            if(temp->zone==r->zone) {   // unless we get zone match
                strncpy(r->domain,temp->domain,8);
                r->domain[8]=0;
            }
            if(temp->net==r->net) break;    // if we get a net match, break
            temp=temp->next;
        }
    }

    return 0;
}




ADDR * _fastcall best_guess (ADDR *r,ADDR *m) {

    /* take our best guess as to who we should be when talking to node r */
    /* m is list of addresses from which to choose */

    ADDR *temp,*ret=NULL;


    temp=m;
    while(temp) {
        if(!stricmp(temp->domain,r->domain)) {
            if(!ret) ret=temp;         /* at least domains will match */
            if(temp->zone == r->zone) {
                if(ret->zone != r->zone) ret=temp;  /* zones too */
                if(temp->net == r->net) {           /* nets match! */
                    ret=temp;
                    break;             /* close as we're likely to get */
                }
            }
        }
        temp = temp->next;
    }

    if(ret) return ret;
    else return m;
}
