/*  Copyright (c) 1987 Shrier and Deihl. Licensed to Mix Software, Inc.

    mkkey.c ISAM INTERNAL make keys for records
*/

#include "isam.cfg"
#include "isam.i"
#include <string.h>

/*
    Defined Functions

    I_mkkey     construct a key from a record
*/

/*
    I_mkkey - construct a key for index from fields into buf

    fields may be ended prematurely by a NULL.
    The format of a key is:
        byte - the index number
        strings - a series of nul-terminated strings that are the
            partial keys for each field in the total key

    Returns length of key (and fills in buf), or -1 for error.
*/

int I_mkkey (index, fields, buf, bufsize)
Index_Obj *index;   /* make key for this index */
char    *fields[];  /* record to make key from */
char    *buf;       /* OUTPUT the made key */
int bufsize;    /* length of buf */
{
    int i;
    int key_length;
    int field_length;
    char    *this_field;
    int *field_nbrs;

    key_length = 0;
    *buf++ = (char) index->index_nbr;
    key_length++;

    field_nbrs = index->field_nbrs;
    for (i = 0; i < index->field_count; i++) {

        this_field = fields[*field_nbrs++];
        if (this_field == NULL)
            break;

        field_length = strlen (this_field) + 1;
        if (key_length + field_length > bufsize) {
            key_length = -1;
            isam_errno = I_KEYTOOLONG;
            break;
        }

        strcpy (buf, this_field);
        buf += field_length;
        key_length += field_length;
    }

    return (key_length);
} /* I_mkkey */

/* end mkkey.c */
