#include <stdlib.h>
#include <stdarg.h>
#include <string.h>


int make_key (int index, char *buf, int bufsize, int numfields,...) {

  /*
   * index is a number denoting which index is to be used
   * buf is a buffer in which the key is built
   * bufsize is the maximum length of buf
   * numfields indicates how many null-terminated strings follow
   * length of the resultant key is returned
   */

  register int  i,key_length = 0,field_length;
  register char *this_field;
  va_list       sargs;

  *buf++ = (char)index; /* prepend index # to key */
    key_length++;

  va_start(sargs,numfields);

  for (i = 0; i < numfields; i++) {
    this_field = va_arg(sargs,char *);
    if (this_field == NULL) break;

        field_length = strlen (this_field) + 1;

    if (key_length + field_length > bufsize) {
            key_length = -1;
      break;  /* truncates if fields too long */
        }

        strcpy (buf, this_field);
        buf += field_length;
        key_length += field_length;
    }

  va_end(sargs);

  return key_length;
}
