#include "mailer.h"
#include "timers.h"
#include "modem.h"
#include "transfer.h"
#include "xmisc.h"
#include "bbs.h"

    extern unsigned long callnowSEM[MAXINSTANCES];
    extern unsigned long killlogSEM[MAXINSTANCES];
    extern unsigned long initSEM[MAXINSTANCES];
    extern unsigned long mailSEM[MAXINSTANCES];
    extern unsigned long InactiveSEM[MAXINSTANCES];
    extern int           *_threadid;
    extern unsigned long EndMeSEM[MAXINSTANCES];
    extern HWND          xdhwnd;
    extern ADDR          *addresses;
    extern MDM           *modems[MAXINSTANCES];
    extern BBS           *bbs;
    extern ADDR          poll;
    extern unsigned long scannowSEM[MAXINSTANCES];
    extern unsigned long pollnowSEM[MAXINSTANCES];



int _fastcall waiting_for_something (USHORT cp,clock_t time_for_next_call,
                                     clock_t time_til_reinit) {

    char s[81],*p;

    /* returns:
     *          0:  RING detected
     *          1:  Semaphore set
     *          2:  Time to make a call
     *          3:  Time to reinitialize
     *
     * (the idea is to get the polling loop into a small segment)
     *
     */

    for(;;) {
        if(modems[cp]->answerok) {
          if(peek_at_byte(cp,1000L) != TIMEOUT) {  /* anybody there? */
            if(get_modem_str(cp,s,80,'\r',1,1000L) != TIMEOUT) {
              stripcr(s);
              p = s;
              while(*p == '\r' || *p == '\n')
                p++;
              if(!stricmp(p,"RING"))
                return 0;
            }
          }
        }
        else
          DosSleep(1000L);

        if(modems[cp]->dialoutok && timeup(time_for_next_call))
          return 2;

        if(timeup(time_til_reinit))
          return 3;

        if(DosSemWait(&callnowSEM[cp],0L) ||
           DosSemWait(&killlogSEM[cp],0L) ||
           DosSemWait(&initSEM[cp],0L) ||
           DosSemWait(&mailSEM[cp],0L) ||
           DosSemWait(&InactiveSEM[cp],0L) ||
           DosSemWait(&EndMeSEM[cp],0L) ||
           DosSemWait(&scannowSEM[cp],0L) ||
           DosSemWait(&pollnowSEM[cp],0L)) {
            return 1;
        }
    }
}
