/* primitives for manipulating XBBS message areas
   this code hacked out in one sitting by Mark Kimes 06/25/91
   compiles; no guarantee that it works. */

/* I'm not quite sure how locking works under DOS-OS/2.  Does the seek
   to a locked record fail, or the read/write?  This code assumes that
   either could fail.  It locks for all writes, no reads. */

#include <sys/locking.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <errno.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"
#include "xmsg.h"


/* external variables referenced */

/* external functions referenced */

/* global variables created here */







int _fastcall get_text (USHORT cp,char **hold,XMSG *msg,unsigned int areano,
                        unsigned int messno) {

 /* loads text for XMSG *msg message #messno from areano #areano into
    **hold (allocates here, caller must free).  Can modify *msg if
    message hasn't been previously TREATED.  UNLZSSs if message was
    compressed. */

    int          once,reduced = 0,handle;
    char         *tempo;
    char         filename[64];
    unsigned int temp,len;
    long         pos;


    if(!msg->length) return MSG_NOTEXT;
    if(msg->length > 65500U) msg->length = 65500U;
    *hold = NULL;

    /* open text file */

    sprintf(filename,"MSG/XTEXT.%03x",areano);
    once = 0;
    while ((handle = bbs_sopen(cp,filename,O_NOINHERIT | O_RDONLY | O_BINARY, SH_DENYNO,S_IREAD | S_IWRITE)) == -1) {
        if (errno == EACCES) {
            once++;
            if (once > 10) {
                return MSG_NOACCESS;
            }
            DosSleep(1000L);
        }
        else {
            return MSG_NOOPEN;
        }
    }

    temp = msg->length;

    /* seek to position */

    once = 0;
    while (lseek(handle,msg->start,SEEK_SET) == -1L) {
        if (once < 10) {
            once++;
            DosSleep(1000L);
        }
        else {
            bbs_close(cp,handle);
            return MSG_NOSEEK;
        }
    }

    /* load text */

    if(msg->length > 65500U) msg->length = 65500U;

ReTry:
    *hold = (char *)bbs_malloc(cp,msg->length + 1);
    if (*hold == NULL) {
        if (msg->length > 1024 && !(msg->xflags & MSGPACKED)) {
            msg->length -= 256;
            reduced = 1;
            goto ReTry;
        }
        else {
            bbs_close(cp,handle);
            return MSG_NOMEM;
        }
    }

    memset(*hold,0,msg->length);

    once = 0;
    for(;;) {
        pos = tell(handle);
        len = (unsigned int)read(handle,*hold,msg->length);
        if(!len || len == 65535U) {
            once++;
            if(once < 10) {
                lseek(handle,pos,SEEK_SET);
                DosSleep(500L);
            }
            else {
                bbs_close(cp,handle);
                bbs_free(cp,*hold);
                *hold = NULL;
                return MSG_NOREAD;
            }
        }
        else if(len < (msg->length - 1)) {
            reduced = 1;
            break;
        }
        else break;
    }

    bbs_close(cp,handle);
    tempo = *hold;
    tempo[msg->length - 1] = 0;
    tempo[msg->length] = 0;

    /* treat text if necessary */

    tempo = *hold;
    if(!(msg->xflags & MSGTREATED) &&
       /* !(currarea->fflags & ANSI) && */ !(msg->xflags & MSGPACKED)) {
        while (*tempo) {
            if(*tempo == '\x8d' || *tempo == '\n') {
                memmove(tempo,&tempo[1],msg->length - ((unsigned int)tempo -
                        (unsigned int)*hold));
                msg->length--;
                if(!msg->length) break;
            }
            else tempo++;
        }
        if(*(tempo - 1) != '\r' && tempo > *hold) {
            *tempo = '\r';
            tempo[1] = 0;
        }

        /* rewrite treated text */

        if(!reduced && temp > ((unsigned int)strlen(*hold) + 1) && **hold) {
            msg->length = (unsigned int)strlen(*hold) + 1;
            sprintf(filename,"MSG/XTEXT.%03x",areano);
        if ((handle = bbs_sopen(cp,filename,O_NOINHERIT | O_RDWR | O_BINARY, SH_DENYNO,S_IWRITE | S_IREAD)) == -1)
              goto OkayThenDont;
            once = 0;
            while (lseek(handle,msg->start,SEEK_SET) == -1L) {
                if (once < 10) {
                    once++;
                    DosSleep(100L);
                }
                else {
                    bbs_close(cp,handle);
                    goto OkayThenDont;
                }
            }
            if(!locking(handle,LK_LOCK,(long)(msg->length + 1))) {
                write(handle,*hold,strlen(*hold));
                write(handle,"\0",1);
                lseek(handle,msg->start,SEEK_SET);
                locking(handle,LK_UNLCK,(long)(msg->length + 1));
                bbs_close(cp,handle);

                /* rewrite header for treated text */

                msg->xflags |= MSGTREATED;
                put_mess(cp,msg,areano,messno);
                temp = msg->length;
            }
        }
    }

    /* UnLZSS compressed text */

    if((msg->xflags & MSGPACKED) && !reduced) {
       if(unpack_msg(cp,msg,hold) == NULL) {   /* extern routine */
           if(*hold)
             bbs_free(cp,*hold);
           *hold = NULL;
           return MSG_NOUNLZSS;
       }
    }

    /* wrapup */

OkayThenDont:

    msg->length = temp;
    if(reduced) return MSG_REDUCED;
    return MSG_NOERR;
}




int _fastcall append_text (USHORT cp,XMSG *msg,char *hold,unsigned int areano,
                           unsigned int messno) {

 /* appends text for XMSG *msg, message #messno in area #areano with
    text in *hold.  updates msg->length and msg->start */

    unsigned int messlen = 0;
    int          handle,once;
    long         pos;
    char         filename[64];


    if (hold == NULL || !*hold) return MSG_NOTEXT;

    /* open text file */

    sprintf(filename,"MSG/XTEXT.%03x",areano);
    once = 0;
    while ((handle = bbs_sopen(cp,filename,O_NOINHERIT | O_RDWR | O_BINARY | O_CREAT, SH_DENYNO,S_IWRITE | S_IREAD)) == -1) {
        if (errno == EACCES) {
            if(once < 10) {
                DosSleep(1000L);
                once++;
            }
            else {
                return MSG_NOACCESS;
            }
        }
        else return MSG_NOOPEN;
    }

    /* seek to position */

SeekAgain:

    once = 0;
    while ((pos = lseek(handle,0L,SEEK_END)) == -1L) {
        if (once < 10) {
            once++;
            DosSleep(100L);
        }
        else {
            bbs_close(cp,handle);
            return MSG_NOSEEK;
        }
    }

    /* lock, write, unlock */

    if(!locking(handle,LK_LOCK,65535L)) {
        if(lseek(handle,0L,SEEK_END) != pos) {
            lseek(handle,pos,SEEK_SET);
            locking(handle,LK_UNLCK,65535L);
            goto SeekAgain;
        }
        messlen += write(handle,hold,strlen(hold));
        if((int)messlen == -1) {
            bbs_close(cp,handle);
            return MSG_BADWRITE;
        }
        write(handle,"\0",1);
        lseek(handle,pos,SEEK_SET);
        locking(handle,LK_UNLCK,65535L);
        messlen += 2;
        msg->length = messlen;
        msg->start = pos;
        if(msg->length > 65500U) msg->length = 65500U;
        bbs_close(cp,handle);
        return MSG_NOERR;
    }

    bbs_close(cp,handle);
    return MSG_NOLOCK;
}




int _fastcall replace_text (USHORT cp,XMSG *msg,char *hold,
                            unsigned int areano,unsigned int messno) {

 /* call this to replace text for XMSG *msg, message #messno, areano
    #areano with text in *hold.  Will append instead of replace if
    there's not enough room in existing allocation.  Updates msg->length
    (and msg->start) */

    unsigned int messlen = 0;
    int          handle,once;
    char         filename[64];
    INDEXES      idx;


    if (hold == NULL || !*hold) return MSG_NOTEXT;

    /* decide whether to append or replace */

    if(strlen(hold) > msg->length - 2)
      return append_text(cp,msg,hold,areano,messno);

    /* open text file */

    sprintf(filename,"MSG/XTEXT.%03x",areano);
    once = 0;
    while ((handle = bbs_sopen(cp,filename,O_NOINHERIT | O_RDWR | O_BINARY | O_CREAT, SH_DENYNO,S_IWRITE | S_IREAD)) == -1) {
        if (errno == EACCES) {
            if(once < 10) {
                DosSleep(1000L);
                once++;
            }
            else {
                return MSG_NOACCESS;
            }
        }
        else return MSG_NOOPEN;
    }

    /* seek to position */

    once = 0;
    while (lseek(handle,msg->start,SEEK_SET) == -1L) {
        if (once < 10) {
            once++;
            DosSleep(100L);
        }
        else {
            bbs_close(cp,handle);
            return MSG_NOSEEK;
        }
    }

    /* lock, write, unlock */

    if(!locking(handle,LK_LOCK,65535L)) {
        messlen += write(handle,hold,sizeof(char) * strlen(hold));
        write(handle,"\0",1);
        lseek(handle,msg->start,SEEK_SET);
        locking(handle,LK_UNLCK,65535L);
        messlen += 2;
        msg->length = messlen;
        bbs_close(cp,handle);
        if(msg->length > 65500U) msg->length = 65500U;
        calc_idx(msg,&idx,hold);
        put_idx(cp,&idx,areano,messno);
        return MSG_NOERR;
    }

    bbs_close(cp,handle);
    return MSG_NOLOCK;
}




int _fastcall get_mess (USHORT cp,XMSG *msg,unsigned int areano,
                        unsigned int messno) {

 /* fill XMSG *msg with data for message #messno in area #areano */

    int          handle,once;
    char         filename[64];
    unsigned int len;
    long         pos;


    /* open data file */

    sprintf(filename,"MSG/XDATA.%03x",areano);
    if (messno < 1) messno = 1;
    once = 0;
    while ((handle = bbs_sopen(cp,filename,O_NOINHERIT | O_RDONLY | O_BINARY, SH_DENYNO,S_IWRITE | S_IREAD)) == -1) {
        if (errno == EACCES) {
            if(once < 10) {
                once++;
                DosSleep(1000L);
            }
            else {
                return MSG_NOACCESS;
            }
         }
         else {
             return MSG_NOOPEN;
         }
    }

    /* seek to position */

    once = 0;
    while (lseek(handle,(long)((long)(messno - 1) * (long)sizeof(XMSG)),SEEK_SET) == -1L) {
        if(once < 10) {
            once++;
            DosSleep(100L);
        }
        else {
            bbs_close(cp,handle);
            return MSG_NOSEEK;
        }
    }

    /* read and wrapup */

    once = 0;
    memset(msg,0,sizeof(XMSG));
    pos = tell(handle);
    for(;;) {
        len = (unsigned int)read(handle,msg,sizeof(XMSG));
        if(!len || len == 65535U) {
            if(messno > (unsigned int)(filelength(handle) / (long)sizeof(XMSG))) {
                bbs_close(cp,handle);
                return MSG_BADNUM;
            }
            once++;
            if(once < 10) {
                lseek(handle,pos,SEEK_SET);
                DosSleep(500L);
            }
            else {
                bbs_close(cp,handle);
                return MSG_NOREAD;
            }
        }
        else if(len < sizeof(XMSG)) {
            if(messno > (unsigned int)(filelength(handle) / (long)sizeof(XMSG))) {
                bbs_close(cp,handle);
                return MSG_BADNUM;
            }
            bbs_close(cp,handle);
            return MSG_PARTREAD;
        }
        else break;
    }

    bbs_close(cp,handle);
    return MSG_NOERR;
}




int _fastcall put_mess (USHORT cp,XMSG *msg,unsigned int areano,
                        unsigned int messno) {

 /* write XMSG *msg to message #messno in area #areano */

    int          handle;
    unsigned int x = 0;
    char         filename[64];
    long         pos;
    INDEXES      idx;


    /* open data file */

    sprintf(filename,"MSG/XDATA.%03x",areano);
    while ((handle = bbs_sopen(cp,filename,O_NOINHERIT | O_RDWR | O_BINARY | O_CREAT, SH_DENYNO,S_IWRITE | S_IREAD)) == -1) {
        if (errno == EACCES) {
            x++;
            if(x > 9) {
                return MSG_NOACCESS;
            }
            DosSleep(1000L);
         }
         else {
            return MSG_NOOPEN;
         }
    }

    if(messno) {

        /* seek to position */

        x = 0;
        while (lseek(handle,(long)((long)(messno - 1) * (long)sizeof(XMSG)),SEEK_SET) == -1L) {
            x++;
            if(x > 9) {
                bbs_close(cp,handle);
                return MSG_NOSEEK;
            }
        }

        /* lock, write, unlock */

        if(!locking(handle,LK_LOCK,(long)sizeof(XMSG))) {
            write(handle,msg,sizeof(XMSG));
            lseek(handle,(long)((long)(messno - 1) * (long)sizeof(XMSG)),SEEK_SET);
            locking(handle,LK_UNLCK,(long)sizeof(XMSG));
            bbs_close(cp,handle);
            if(get_idx(cp,&idx,areano,messno) == MSG_NOERR) {
              calc_part_idx(msg,&idx);
              put_idx(cp,&idx,areano,messno);
            }
            return MSG_NOERR;
        }
        bbs_close(cp,handle);
        return MSG_NOLOCK;
    }
    else {  /* append new header */
        for(;;) {
            x = 0;
            while((pos = lseek(handle,0L,SEEK_END)) == -1L) {
                x++;
                if(x > 9) {
                    bbs_close(cp,handle);
                    return MSG_NOSEEK;
                }
            }
            if(!locking(handle,LK_LOCK,(long)sizeof(XMSG))) {
                if(lseek(handle,0L,SEEK_END) != pos) {
                    lseek(handle,pos,SEEK_SET);
                    locking(handle,LK_UNLCK,(long)sizeof(XMSG));
                    continue;
                }
                write(handle,msg,sizeof(XMSG));
                lseek(handle,pos,SEEK_SET);
                locking(handle,LK_UNLCK,(long)sizeof(XMSG));
                bbs_close(cp,handle);
                return MSG_NOERR;
            }
            bbs_close(cp,handle);
            return MSG_NOLOCK;
        }
    }
}



int _fastcall post_message (USHORT cp,XMSG *msg,char **hold,
                            unsigned int areano,int isfile) {

    /* post a new message given header, text and area #.  if isfile is
       non-zero, **hold is name of file containing text to import (note
       that hold must be malloced and freeable).  text imported from a
       file will be treated here; text sent in *hold will not.  Note that
       some preceding text (usually kludge lines like MSGID) can be sent
       behind the filename by separating it from the filename with a space.
       Therefore, don't send filenames containing spaces... :-) */

    struct stat  st;
    char         filename[64],*tempo,*p;
    unsigned int nomess,tlen = 0;
    int          ret;
    INDEXES      idx;


    if(!hold || !*hold || !**hold) return MSG_NOTEXT;

    sprintf(filename,"MSG/XDATA.%03x",areano);
    if(stat(filename,&st)) st.st_size = 0L;
    nomess = (unsigned int)(st.st_size / (long)sizeof(XMSG));

    if(isfile) {    /* load a file for msg text */
        tempo = *hold;
        tempo = skip_nonwhite(tempo);
        if(*tempo) {
            *tempo = 0;
            tempo++;
        }
        strcpy(filename,*hold);
        ret = bbs_sopen(cp,filename,O_NOINHERIT | O_RDONLY | O_BINARY, SH_DENYNO,S_IWRITE | S_IREAD);
        if(ret == -1) {
            bbs_free(cp,*hold);
            *hold = NULL;
            return MSG_NOTEXT;
        }
        lseek(ret,0L,SEEK_END);
        st.st_size = tell(ret);
        if(!st.st_size) {
            bbs_close(cp,ret);
            bbs_free(cp,*hold);
            *hold = NULL;
            return MSG_NOTEXT;
        }
        if(st.st_size > 65000L) st.st_size = 65000L;
        if(*tempo) memmove(*hold,tempo,strlen(tempo) + 1);
        else **hold = 0;
        tempo = *hold;
        *hold = (char *)bbs_realloc(cp,*hold,(size_t)st.st_size + 1 + strlen(*hold) + 1);
        if(!*hold) {
            bbs_free(cp,tempo);
            bbs_close(cp,ret);
            *hold = NULL;
            return MSG_NOMEM;
        }
        p = (char *)(*hold + strlen(*hold));
        tlen = strlen(*hold);
        lseek(ret,0L,SEEK_SET);
        if((unsigned int)read(ret,p,(unsigned int)st.st_size) !=
           (unsigned int)st.st_size) {
            bbs_close(cp,ret);
            bbs_free(cp,*hold);
            *hold = NULL;
            return MSG_NOREAD;
        }
        bbs_close(cp,ret);
        tempo = *hold;      /* "treat" text */
        tempo[(unsigned int)st.st_size + tlen] = 0;
        msg->length = strlen(tempo);
        while (*tempo) {
            if(*tempo == '\x8d' || *tempo == '\n') {
                memmove(tempo,&tempo[1],msg->length - ((unsigned int)tempo -
                        (unsigned int)*hold));
                msg->length--;
                if(!msg->length) {
                    return MSG_NOTEXT;
                }
            }
            else tempo++;
        }
        if(*(tempo - 1) != '\r' && tempo > *hold) {
            *tempo = '\r';
            tempo[1] = 0;
        }
    }

    ret = append_text(cp,msg,*hold,areano,nomess + 1);
    calc_idx(msg,&idx,*hold);
    bbs_free(cp,*hold);
    *hold = NULL;
    if(ret == MSG_NOERR) {
        put_idx(cp,&idx,areano,nomess + 1);
        return put_mess(cp,msg,areano,nomess + 1);
    }
    return ret;
}




int _fastcall get_messu (USHORT cp,XMSG *msg,unsigned int areano,
                        unsigned int messno,USER *user) {

    /* get msg header if user has access & msg exists */

    struct stat st;
    word        nomess;
    MSGAREA     *curr;
    int         temp;


    curr = find_msg_area(NULL,cp,areano);
    if(!curr)
      return MSG_BADAREA;

    {
        char filename[64];

        sprintf(filename,"MSG/XDATA.%03x",areano);
        if(stat(filename,&st))
          st.st_size = 0L;
    }
    nomess = (word)(st.st_size / (long)sizeof(XMSG));
    if(nomess < messno)
      return MSG_BADNUM;

    temp = get_mess(cp,msg,areano,messno);
    if(temp != MSG_NOERR)
      return temp;

    if(msg->fflags & MSGPRIVATE) {
      if(mymsg(user,msg) && msg_sysop_ok(user,curr)) {
        memset(msg,0,sizeof(XMSG));
        return MSG_ISPRIVATE;
      }
    }

    if((msg->xflags & MSGDELETED) && msg_sysop_ok(user,curr))
      return MSG_ISDELETED;

    return MSG_NOERR;
}




int _fastcall mymsg (USER *user,XMSG *msg) {

    /* determine if msg is from or to user */

    rstrip(msg->to);
    rstrip(msg->from);

    if(user->number == 1) {
        if(!stricmp(msg->to,"SYSOP") || !stricmp(msg->from,"SYSOP")) return 0;
    }
    if(!stricmp(msg->to,user->name) ||
       !stricmp(msg->to,user->handle) ||
       !stricmp(msg->from,user->name) ||
       !stricmp(msg->to,user->handle)) return 0;
    return 1;
}



int _fastcall get_idx (USHORT cp,INDEXES *idx,unsigned int areano,
                       unsigned int messno) {

    int          once,handle;
    unsigned int len;
    long         pos;
    char         filename[81];

    /* open hash file */

    sprintf(filename,"MSG/XIDX.%03x",areano);
    if (messno < 1) messno = 1;
    once = 0;
    while ((handle = bbs_sopen(cp,filename,O_NOINHERIT | O_RDONLY | O_BINARY, SH_DENYNO,S_IWRITE | S_IREAD)) == -1) {
        if (errno == EACCES) {
            if(once < 10) {
                once++;
                DosSleep(1000L);
            }
            else {
                return MSG_NOACCESS;
            }
         }
         else {
             return MSG_NOOPEN;
         }
    }

    if(filelength(handle) / (long)sizeof(INDEXES) < (long)messno - 1L) {
      bbs_close(cp,handle);
      return MSG_BADNUM;
    }

    /* seek to position */

    once = 0;
    while (lseek(handle,(long)((long)(messno - 1) * (long)sizeof(INDEXES)),SEEK_SET) == -1L) {
        if(once < 10) {
            once++;
            DosSleep(100L);
        }
        else {
            bbs_close(cp,handle);
            return MSG_NOSEEK;
        }
    }

    /* read and wrapup */

    once = 0;
    memset(idx,0,sizeof(INDEXES));
    pos = tell(handle);
    for(;;) {
        len = (unsigned int)read(handle,idx,sizeof(INDEXES));
        if(!len || len == 65535U) {
            if(messno > (unsigned int)(filelength(handle) / (long)sizeof(INDEXES))) {
                bbs_close(cp,handle);
                return MSG_BADNUM;
            }
            once++;
            if(once < 10) {
                lseek(handle,pos,SEEK_SET);
                DosSleep(500L);
            }
            else {
                bbs_close(cp,handle);
                return MSG_NOREAD;
            }
        }
        else if(len < sizeof(INDEXES)) {
            if(messno > (unsigned int)(filelength(handle) / (long)sizeof(INDEXES))) {
                bbs_close(cp,handle);
                return MSG_BADNUM;
            }
            bbs_close(cp,handle);
            return MSG_PARTREAD;
        }
        else break;
    }

    bbs_close(cp,handle);
    return MSG_NOERR;
}


int _fastcall put_idx (USHORT cp,INDEXES *idx,unsigned int areano,
                        unsigned int messno) {

 /* write INDEXES *idx to message #messno in area #areano */

    int          handle;
    unsigned int x = 0;
    char         filename[64];
    long         pos;


    /* open data file */

    sprintf(filename,"MSG/XIDX.%03x",areano);
    while ((handle = bbs_sopen(cp,filename,O_NOINHERIT | O_RDWR | O_BINARY | O_CREAT, SH_DENYNO,S_IWRITE | S_IREAD)) == -1) {
        if (errno == EACCES) {
            x++;
            if(x > 9) {
                return MSG_NOACCESS;
            }
            DosSleep(1000L);
         }
         else {
            return MSG_NOOPEN;
         }
    }

    if(messno) {

        /* seek to position */

        x = 0;
        while (lseek(handle,(long)((long)(messno - 1) * (long)sizeof(INDEXES)),SEEK_SET) == -1L) {
            x++;
            if(x > 9) {
                bbs_close(cp,handle);
                return MSG_NOSEEK;
            }
        }

        /* lock, write, unlock */

        if(!locking(handle,LK_LOCK,(long)sizeof(INDEXES))) {
            write(handle,idx,sizeof(INDEXES));
            lseek(handle,(long)((long)(messno - 1) * (long)sizeof(INDEXES)),SEEK_SET);
            locking(handle,LK_UNLCK,(long)sizeof(INDEXES));
            bbs_close(cp,handle);
            return MSG_NOERR;
        }
        bbs_close(cp,handle);
        return MSG_NOLOCK;
    }
    else {  /* append new hash */
        for(;;) {
            x = 0;
            while((pos = lseek(handle,0L,SEEK_END)) == -1L) {
                x++;
                if(x > 9) {
                    bbs_close(cp,handle);
                    return MSG_NOSEEK;
                }
            }
            if(!locking(handle,LK_LOCK,(long)sizeof(INDEXES))) {
                if(lseek(handle,0L,SEEK_END) != pos) {
                    lseek(handle,pos,SEEK_SET);
                    locking(handle,LK_UNLCK,(long)sizeof(INDEXES));
                    continue;
                }
                write(handle,idx,sizeof(INDEXES));
                lseek(handle,pos,SEEK_SET);
                locking(handle,LK_UNLCK,(long)sizeof(INDEXES));
                bbs_close(cp,handle);
                return MSG_NOERR;
            }
            bbs_close(cp,handle);
            return MSG_NOLOCK;
        }
    }
}
