/*********************************************************************/
/* This module fills in a packet header, builds specialized packets, */
/* and kills the specialized packets.                                */
/*********************************************************************/

#include "mailer.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include "bbs.h"
#include "xmisc.h"


    extern int *_threadid;
    extern ADDR *addresses;



PKTHDR * _fastcall fill_in_pkt_hdr (PKTHDR *pkt,ADDR *myaddr,
                                    ADDR *addr,char *password) {

    memset(pkt,0,sizeof(PKTHDR));

    pkt->onode=myaddr->node;
    pkt->onet=myaddr->net;
    pkt->ozone=myaddr->zone;
    pkt->opoint=myaddr->point;
    pkt->dnode=addr->node;
    pkt->dnet=addr->net;
    pkt->dpoint=addr->point;
    pkt->dzone=addr->zone;
    strncpy(pkt->odomain,myaddr->domain,8);
    strncpy(pkt->ddomain,addr->domain,8);

    strncpy(pkt->password,password,8);

    pkt->version=2;
    pkt->subver=2;
    pkt->product = XBBSPRODCODE;
    pkt->rev_lev = XBBSVERMAJOR;

    return pkt;
}




int _fastcall make_pkt (PKTHDR *pkt,char *to,char *from,char *subj,
                        char *msgtxt) {

    int handle,attrib = MSGPRIVATE;
    char s[32];
    struct tm t;
    time_t tt;


    sprintf(s,"%08x.PKT",*_threadid);
    handle=sopen(s,O_NOINHERIT | O_RDWR | O_BINARY,SH_DENYWR);
    if(handle == -1) {
        handle=sopen(s,O_CREAT | O_NOINHERIT | O_RDWR | O_BINARY,SH_DENYWR,S_IWRITE | S_IREAD);
        if(handle == -1) return -1;
        write(handle,pkt,sizeof(PKTHDR));
    }
    if(msgtxt && to && from && subj) {  /* add a msg to the packet */
        lseek(handle,filelength(handle)-2L,SEEK_SET);
        write(handle,"\02\0",2);
        write(handle,&pkt->onode,2);
        write(handle,&pkt->dnode,2);
        write(handle,&pkt->onet,2);
        write(handle,&pkt->dnet,2);
        write(handle,&attrib,2);   /* attrib */
        write(handle,"\0",2);   /* cost */
        tt=time(NULL);
        memcpy(&t,localtime(&tt),sizeof(struct tm));
        strftime(s,31,"%d %b %y  %H:%M:%S",&t);
        write(handle,s,20);
        write(handle,to,strlen(to)+1);
        write(handle,from,strlen(from)+1);
        write(handle,subj,strlen(subj)+1);
        write(handle,msgtxt,strlen(msgtxt)+1);
        write(handle,"\0\0",3);
    }
    close(handle);
    return 0;
}



int _fastcall kill_pkt (void) {

    char s[13];

    sprintf(s,"%08x.PKT",*_threadid);
    return (unlink(s));
}


int _fastcall make_pkt_from_file (PKTHDR *pkt,char *to,char *from,char *subj,
                                  char *filename) {

    int handle,handlet;
    char s[81];
    struct tm t;
    time_t tt;


    sprintf(s,"%08x.PKT",*_threadid);
    handle=sopen(s,O_NOINHERIT | O_RDWR | O_BINARY,SH_DENYWR);
    if(handle == -1) {
        handle=sopen(s,O_CREAT | O_NOINHERIT | O_RDWR | O_BINARY,SH_DENYWR,S_IWRITE | S_IREAD);
        if(handle == -1) return -1;
        write(handle,pkt,sizeof(PKTHDR));
    }
    if(filename && to && from && subj) {  /* add a msg to the packet */
        lseek(handle,filelength(handle)-2L,SEEK_SET);
        write(handle,"\02\0",2);
        write(handle,&pkt->onode,2);
        write(handle,&pkt->dnode,2);
        write(handle,&pkt->onet,2);
        write(handle,&pkt->dnet,2);
        write(handle,"\0",2);   /* attrib */
        write(handle,"\0",2);   /* cost */
        tt=time(NULL);
        memcpy(&t,localtime(&tt),sizeof(struct tm));
        strftime(s,31,"%d %b %y  %H:%M:%S",&t);
        write(handle,s,20);
        write(handle,to,strlen(to)+1);
        write(handle,from,strlen(from)+1);
        write(handle,subj,strlen(subj)+1);

        handlet = sopen(filename,O_RDONLY | O_BINARY, SH_DENYWR);
        if(handlet != -1) {
            while(!eof(handlet)) {
                if(!fgetsx(s,81,handlet)) break;
                stripcr(s);
                write(handle,s,strlen(s));
                write(handle,"\r",1);
            }
            close(handlet);
        }

        write(handle,"\0\0",3);
    }
    close(handle);
    return 0;
}


int _fastcall make_fts1plus_pkt_from_file (PKTHDR *pkt,ADDR *hisaddr,
                                           ADDR *myaddr) {

    int handle;
    char s[81],*subj = "FTS1+ 0.0";
    register ADDR *info;
    struct tm t;
    time_t tt;

    sprintf(s,"%08x.PKT",*_threadid);
    handle=sopen(s,O_NOINHERIT | O_RDWR | O_BINARY,SH_DENYWR);
    if(handle == -1) {
        handle=sopen(s,O_CREAT | O_NOINHERIT | O_RDWR | O_BINARY,SH_DENYWR,S_IWRITE | S_IREAD);
        if(handle == -1)
          return -1;
        write(handle,pkt,sizeof(PKTHDR));
    }
    lseek(handle,filelength(handle)-2L,SEEK_SET);
    write(handle,"\02\0",2);
    write(handle,&pkt->onode,2);
    write(handle,&pkt->dnode,2);
    write(handle,&pkt->onet,2);
    write(handle,&pkt->dnet,2);
    write(handle,"\0",2);   /* attrib */
    write(handle,"\0",2);   /* cost */
    tt=time(NULL);
    memcpy(&t,localtime(&tt),sizeof(struct tm));
    strftime(s,31,"%d %b %y  %H:%M:%S",&t);
    write(handle,s,20);
    ffprintf(handle,"%s#%u:%u/%u.%u",hisaddr->domain,hisaddr->zone,
             hisaddr->net,hisaddr->node,hisaddr->point);
    write(handle,"",1);
    ffprintf(handle,"%s#%u:%u/%u.%u",myaddr->domain,myaddr->zone,
             myaddr->net,myaddr->node,myaddr->point);
    write(handle,"",1);
    write(handle,subj,strlen(subj)+1);
    info = addresses;
    while(info) {
      ffprintf(handle,"\01ADDR: %s#%u:%u/%u.%u\r",info->domain,info->zone,
               info->net,info->node,info->point);
      info = info->next;
    }
    ffprintf(handle,"\01PROTO: SEAlink/Overdrive\r\01PROTO: Telink\r"
             "\01PROTO: Modem7\r\01PROTO: XModem\r");
    ffprintf(handle,"\01MAILTYPE: FTN 2\r");
    write(handle,"",1);
    write(handle,"\0\0",3);
    close(handle);
    return 0;
}

