#include <stdlib.h>
#include <string.h>




#pragma optimize("eg",off)

int _pascal calcrc (char *ptrr, int count, int likexmodem) {

    /* This function calculates the CRC used by the XMODEM/CRC Protocol
       The first argument is a pointer to the message block.
       The second argument is the number of bytes in the message block.
       The function returns an integer which contains the CRC.
       The low order 16 bits are the coefficients of the CRC. */

   unsigned int crc;
   char         temp;
   register char        *ptr = ptrr;
   register int          cnt = count;


    crc = 0;
    while(cnt--) {
        temp = *ptr;
        _asm {
                    MOV     DX,[crc]
                    XOR     DH,BYTE PTR[temp] ;init X^16 term
                    XOR     DL,DL
                    MOV     CX,8
            CRCUP1: SHL     DX,1
                    JNC     CRCUP2
                    XOR     DX,1021h          ;X^12 + X^5 + 1
            CRCUP2: LOOP    CRCUP1
                    XOR     DH,BYTE PTR[crc]  ;finish X^16 term
                    MOV     [crc],DX          ;update CRC accumulator
        }
        ptr++;
    }

    if(likexmodem) {
        _asm {                                ;swap bytes
            MOV     DX,[crc]
            XCHG    DH,DL
            MOV     [crc],DX
        }
    }

    return crc;
}

#pragma optimize("",on)

extern char * _fastcall rstrip(char *s);
extern char * _fastcall lstrip(char *s);


int _fastcall csum16str (char *s) {

  register unsigned int i;

  i = 0;
  while(*s) {
    i ^= toupper(*s++);
    if(i & 1)
      i = i >> 1 ^ 0xA000;
    else
      i >>= 1;
  }
  return (int)i;
}
