#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"

extern MDM  *modems[MAXINSTANCES];
extern BBS  *bbs;
extern USER *user[MAXINSTANCES];


long _fastcall bbs_convert_number (USHORT cp,int c) {

    long ret = 0L;


  if(user[cp]) {

    switch(c) {
        case 1:
            ret = (long)bbs->numcalls;
            break;

        case 2:
            ret = (long)bbs->minage;
            break;

        case 3:
            ret = (long)bbs->maxage;
            break;

        case 4:
            ret = (long)bbs->maxusers;
            break;

        case 5:
            ret = (long)bbs->maxattempts);
            break;

        case 6:
            ret = (long)bbs->maxpage);
            break;

        case 7:
            ret = atol(bbs->bbs_name);
            break;

        case 8:
            ret = atol(bbs->sysop);
            break;

        case 9:
            ret = atol(user[cp]->name);
            break;

        case 10:
            ret = atol(user[cp]->name);
            break;

        case 11:
            ret = atol(user[cp]->address);
            break;

        case 12:
            ret = atol(user[cp]->phone_number);
            break;

        case 13:
            ret = atol(user[cp]->interests);
            break;

        case 14:
            ret = (long)user[cp]->computer_type;
            break;

        case 15:
            ret = atol(find_computer(user[cp]->computer_type));
            break;

        case 16:
            ret = (long)user[cp]->userid;
            break;

        case 17:
            ret = (long)user[cp]->pointid;
            break;

        case 18:
            ret = (long)user[cp]->birthyear;
            break;

        case 19:
            ret = (long)user[cp]->credit;
            break;

        case 20:
            ret = (long)user[cp]->minlimit;
            break;

        case 21:
            ret = (long)user[cp]->time_today;
            break;

        case 22:
            ret = (long)user[cp]->time_per_day;
            break;

        case 23:
            ret = (long)user[cp]->numcalls;
            break;

        case 24:
            ret = (long)user[cp]->ulnum;
            break;

        case 25:
            ret = (long)user[cp]->dlnum;
            break;

        case 26:
            ret = (long)user[cp]->ulk;
            break;

        case 27:
            ret = (long)user[cp]->dlk;
            break;

        case 28:
            ret = (long)user[cp]->uktoday;
            break;

        case 29:
            ret = (long)user[cp]->dktoday;
            break;

        case 30:
            ret = (long)user[cp]->ukperday;
            break;

        case 31:
            ret = (long)user[cp]->dkperday;
            break;

        case 32:
            ret = (long)user[cp]->security1;
            break;

        case 33:
            ret = (long)user[cp]->security2;
            break;

        case 34:
            ret = (long)user[cp]->flags1;
            break;

        case 35:
            ret = (long)user[cp]->flags2;
            break;

        case 36:
            ret = (long)user[cp]->attribs;
            break;

        case 37:
            ret = (long)user[cp]->attribs2;
            break;

        case 38:
            ret = (long)user[cp]->length;
            break;

        case 39:
            ret = (long)user[cp]->width;
            break;

        case 40:
            ret = (long)user[cp]->lastmsgarea;
            break;

        case 41:
            ret = (long)user[cp]->lastfilearea;
            break;

        case 42:
            ret = (long)user[cp]->lastprotocol;
            break;

        case 43:
            ret = (long)user[cp]->lastarchiver;
            break;

        case 44:
            ret = (long)user[cp]->time_per_call;
            break;

        case 45:
            ret = (long)user[cp]->forsysop;
            break;

        case 46:
            ret = (long)user[cp]->interface;
            break;

        case 47:
            ret = (long)user[cp]->exp;
            break;

        case 48:
            ret = (long)user[cp]->age;
            break;

        case 49:
            if(user[cp]->currmsgarea) {
                ret = atol(user[cp]->currmsgarea->name);
            }
            else ret = 0L;
            break;

        case 50:
            if(user[cp]->currfilearea) {
                ret = atol(user[cp]->currfilearea->name);
            }
            else ret = 0L;
            break;

        case 51:
            if(user[cp]->currlibarea) {
                ret = atol(user[cp]->currlibarea->name);
            }
            else ret = 0L;
            break;

        case 52:
            ret = (long)modems[cp]->curbaud;
            break;

        case 53:    /* mins left */
            ret = (long)(user[cp]->offline - time(NULL)) / 60L);
            break;

        case 54:    /* secs remainder */
            ret = (long)(user[cp]->offline - time(NULL)) - (user[cp]->offline - time(NULL)) / 60L);
            break;

        case 55:    /* secs left */
            ret = (long)user[cp]->offline - time(NULL);
            break;

        case 56:    /* graphics capability */
            if(user[cp]->attribs & U_COLOR) ret = 1L;
            else ret = 0L;
            break;

        case 57:    /* numeric variables */
        case 58:
        case 59:
        case 60:
        case 61:
        case 62:
        case 63:
        case 64:
        case 65:
            ret = (long)user[cp]->nvar[c]);
            break;

        case 66:    /* string variables */
        case 67:
        case 68:
        case 69:
        case 70:
        case 71:
        case 72:
        case 73:
        case 74:
            ret = atol(user[cp]->svar[c]);
            break;

        case 75:
            if(user[cp]->currlibarea) {
                ret = (long)user[cp]->currlibarea->number;
            }
            else ret = 0L;
            break;

        case 76:    /* number of messages in current msg area */
            if(user[cp]->currmsgarea) {
                ret = (long)how_many_msgs(user[cp]->currmsgarea);
            }
            else ret = 0L;
            break;

        case 77:    /* lastread for current msg area */
            if(user[cp]->currmsgarea && user[cp]->lastread) {
                ret = (long)user[cp]->lastread[user[cp]->currmsgarea->number - 1];
            }
            else ret = 0L;
            break;

        case 78:    /* current msg area # */
            if(user[cp]->currmsgarea) {
                ret = (long)user[cp]->currmsgarea->number;
            }
            else ret = 0L;
            break;

        case 79:    /* current file area # */
            if(user[cp]->currfilearea) {
                ret = (long)user[cp]->currfilearea->number;
            }
            else ret = 0L;
            break;

        case 80:    /* lastread for current area + 1 */
            if(user[cp]->currmsgarea && user[cp]->lastread) {
                ret = (long)(user[cp]->lastread[user[cp]->currmsgarea->number - 1] + 1);
            }
            else ret = 0L;
            break;

        case 81:    /* line # */
            ret = (long)cp;
            break;

        case 82:    /* various date/time stuff */
        case 83:
        case 84:
        case 85:
        case 86:
        case 87:
        case 88:
        case 89:
            {
                time_t t;
                struct tm *tm;

                t = time(NULL);
                tm = localtime(&t);
                switch(c) {
                    case 82:    /* user birthmonth */
                        ret = (long)user[cp]->birthmonth;
                        break;
                        break;

                    case 83:    /* user birthday */
                        ret = (long)user[cp]->birthday;
                        break;

                    case 84:    /* year */
                        ret = (long)tm->tm_year;
                        break;

                    case 85:    /* month (numeric) */
                        ret = (long)tm->tm_mon;
                        break;

                    case 86:    /* day (numeric) */
                        ret = (long)tm->tm_mday;
                        break;

                    case 87:    /* seconds */
                        ret = (long)tm->tm_sec;
                        break;

                    case 88:    /* minutes */
                        ret = (long)tm->tm_min;
                        break;

                    case 89:    /* time */
                        ret = (long)tm->tm_hour;
                        break;
                }
            }
            break;

            case 90:    /* clear screen */
                break;

        case 32767: /* comhandle */
            ret = (long)modems[cp]->mh;
            break;

        default:
            if(c >= 32000 && c <= 32022) {
            }
            else {
                dprintf(D_LOCAL,cp,"\r\n\04Unrecognized variable %d\r\n",c);
            }
            break;
    }
  }

  return ret;
}
