/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards.                            */
/*  (Modified very slightly to work online w/ XBBS by M. Kimes)      */
/*  The following block of notes are Paul's.                         */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  Calendar - produce a calendar for any given year.                */
/*                                                                   */
/*  This program takes as a command line parameter a single number   */
/*  which should be a 4 digit year.  It then prints out a calendar   */
/*  corresponding to that year.  This program was inspired by a      */
/*  shareware program which performed a similar function but didn't  */
/*  come with source!                                                */
/*                                                                   */
/*  Many many thanks to Paul Schlyter, Stockholm, Sweden for his     */
/*  absolutely fantastically brilliant dow macro.  However, due to   */
/*  limitations of this macro (which are affected by anomolies of    */
/*  the '/' and '%' operators on negative numbers) this program will */
/*  generate invalid calendars for years such as 4 AD.  But I reckon */
/*  anyone who wants to print out the gregorian calendar for 4 AD is */
/*  a total wanker, especially when you consider the fact that the   */
/*  gregorian calendar only came into existence in 1582.  There is   */
/*  no upper limit to the year the calendar can print.  The program  */
/*  also knows all the rules, ie the 4, 100, 400 year rules for a    */
/*  leapyear, so that even if you don't know that 1900 wasn't a      */
/*  leapyear, yet 2000 will be, this program knows!  Oh yeah, I'm    */
/*  not sure exactly where the lower bound on calendars is, but it   */
/*  will certainly work for anything above 1582.  Have fun!  Paul.   */
/*                                                                   */
/*  This program is dedicated to the public domain.                  */
/*                                                                   */
/*  Written 1990/8/28.                                               */
/*                                                                   */
/*********************************************************************/

#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"


static int  _fastcall dayno(int yyyy, int mm, int x, int y);
static void _fastcall prt3mon(int mode,USHORT cp,int yr, int a, int prtmon);




int _fastcall print_calendar (int mode,USHORT cp) {

  int yr, wrkyr, dig1, dig2, dig3, dig4;
  char yrstr[32];

  *yrstr = 0;
  if(!*pinput_string(mode,cp,yrstr,4,4,228,
                    STRT_NUMERIC,0,"Calendar",NULL)) {
      dputs(mode,cp,"\r\n");
      return 0;
  }

  yr = atoi(yrstr);
  if(!atoi(yrstr)) return 0;

  wrkyr = yr;
  dig1 = wrkyr / 1000;
  wrkyr %= 1000;
  dig2 = wrkyr / 100;
  wrkyr %= 100;
  dig3 = wrkyr / 10;
  wrkyr %= 10;
  dig4 = wrkyr;
  dprintf(mode,cp,"\r\n                                %d %d %d %d\r\n\r\n",
          dig1,dig2,dig3,dig4);
  prt3mon(mode,cp,yr, 0, 229);
  prt3mon(mode,cp,yr, 1, 230);
  prt3mon(mode,cp,yr, 2, 231);
  prt3mon(mode,cp,yr, 3, 232);
  return 0;
}




static void _fastcall prt3mon (int mode,USHORT cp,int yr, int a, int prtmon) {

  int b, i, j, x;


  sayp(mode,cp,prtmon,NULL,0);
  sayp(mode,cp,233,NULL,0);
  for (i = 0;i < 6;i++) {
    for (b = 1;b <= 3;b++) {
      for (j = 0;j < 7;j++) {
        x = dayno(yr,a * 3 + b,i,j);
        if (x) dprintf(mode,cp,"%2d ",x);
        else dputs(mode,cp,"   ");
      }
      dputs(mode,cp,"    ");
    }
    dputs(mode,cp,"\r\n");
  }
  dputs(mode,cp,"\r\n");
  return;
}




int _fastcall print_amonth (int mode, USHORT cp, int yr, int month) {

  int wrkyr, dig1, dig2, dig3, dig4;
  char **mons = NULL;
  int i, j, x;


  mons = pgetarray(cp,234,12);
  wrkyr = yr;
  dig1 = wrkyr / 1000;
  wrkyr %= 1000;
  dig2 = wrkyr / 100;
  wrkyr %= 100;
  dig3 = wrkyr / 10;
  wrkyr %= 10;
  dig4 = wrkyr;
  dprintf(mode,cp,"\r\n     %d %d %d %d\r\n\r\n",
          dig1,dig2,dig3,dig4);

  dprintf(mode,cp,"       %s\r\n",mons[month - 1]);
  sayp(mode,cp,235,NULL,0);
  for (i = 0;i < 6;i++) {
      for (j = 0;j < 7;j++) {
        x = dayno(yr,month,i,j);
        if(x) dprintf(mode,cp,"%2d ",x);
        else dputs(mode,cp,"   ");
      }
      dputs(mode,cp,"\r\n");
  }
  dputs(mode,cp,"\r\n");
  free_selections(cp,mons,12);
  return 0;
}





#define isleap(year) ((((year%4)==0) && ((year%100)!=0)) || \
        ((year%400)==0))



#define dow(y,m,d)  \
( ( ( 3*(y) - (7*((y)+((m)+9)/12))/4 + (23*(m))/9 + (d) + 2 \
    + (((y)-((m)<3))/100+1) * 3 / 4 - 15 ) % 7 ) )




static int _fastcall dayno (int yyyy, int mm, int x, int y) {

  static int daytab[] = { 31, 28, 31, 30, 31, 30,
                          31, 31, 30, 31, 30, 31};
  int a, b, c;

  a = dow(yyyy,mm,1);
  b = x * 7 + y;
  c = daytab[mm - 1];
  if ((mm == 2) && isleap(yyyy)) c++;
  if (b < a) return (0);
  if ((b - a) >= c) return (0);
  return ((b - a + 1));
}
