#include <ctype.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"
#include "xmsg.h"

int _fastcall csum16str (char *s) {

  register unsigned int i;

  i = 0;
  while(*s) {
    i ^= toupper(*s++);
    if(i & 1)
      i = i >> 1 ^ 0xA000;
    else
      i >>= 1;
  }
  return (int)i;
}


void _fastcall calc_idx (struct _xmsg *msg,INDEXES *idx,char *text) {

  char *p,*pp;

  if(!msg || !idx || !text)
    return;

  idx->to = csum16str(msg->to);
  idx->from = csum16str(msg->from);
  idx->subj = csum16str(msg->subj);
  if(!(msg->xflags & MSGPACKED)) {
    if(!strncmp(text,"\01MSGID: ",8)) p = text; /* might be first line */
    else {
      p = strnstr(text,"\r\01MSGID: ",1024);
      if(p) p++;
    }
    if(p) {
      p += 8;
      pp = p;
      while(*pp == ' ')
        pp++;
      while(*pp && *pp != ' ')
        pp++;
      if(*pp) {
        *pp = 0;
        pp++;
      }
      idx->msgidcrc = crc32str(p);
      p = pp;
      idx->msgidserialno = strtol(pp,&p,16);
    }
    else {
      idx->msgidcrc = 0L;
      idx->msgidserialno = 0L;
    }
    p = strnstr(text,"\r\01REPLY: ",1024);
    if(p) {
      p += 9;
      pp = p;
      while(*pp == ' ')
        pp++;
      while(*pp && *pp != ' ')
        pp++;
      if(*pp) {
        *pp = 0;
        pp++;
      }
      idx->replycrc = crc32str(p);
      p = pp;
      idx->replyserialno = strtol(pp,&p,16);
    }
    else {
      idx->replycrc = 0L;
      idx->replyserialno = 0L;
    }
  }
  else {
    idx->msgidcrc = 0L;
    idx->msgidserialno = 0L;
    idx->replycrc = 0L;
    idx->replyserialno = 0L;
    p = text;
    while(*p && *p != '\r')
      p++;
    if(*p) {
      if(*p == '\r') {
        p++;
        if(*p != '\r') {
          pp = p;
          while(*pp == ' ')
            pp++;
          while(*pp && *pp != ' ')
            pp++;
          if(*pp) {
            *pp = 0;
            pp++;
          }
          idx->msgidcrc = crc32str(p);
          p = pp;
          idx->msgidserialno = strtol(pp,&p,16);
          p = pp;
        }
      }
      while(*p && *p != '\r') p++;
      if(*p) {
        if(*p == '\r') {
          p++;
          if(*p != '\r') {
            pp = p;
            while(*pp == ' ') pp++;
            while(*pp && *pp != ' ') pp++;
            if(*pp) {
              *pp = 0;
              pp++;
            }
            idx->replycrc = crc32str(p);
            p = pp;
            idx->replyserialno = strtol(pp,&p,16);
          }
        }
      }
    }
  }
}


void _fastcall calc_part_idx (XMSG *msg,INDEXES *idx) {

  if(!msg || !idx)
    return;

  idx->to   = csum16str(msg->to);
  idx->from = csum16str(msg->from);
  idx->subj = csum16str(msg->subj);
}
