#include "mailer.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <share.h>
#include <fcntl.h>
#include <io.h>
#include "bbs.h"
#include "xmisc.h"

ARC_TYPE *arcsighead = NULL;



ARC_TYPE * _fastcall find_type (char *filespec) {

  int         file;         /* File handle */
  ARC_TYPE    *info;
  int         l;            /* Length of the signature. */
  char        buffer[80];   /* Read buffer for the signatures. */

    file = sopen(filespec,O_BINARY | O_RDONLY,SH_DENYNO);    /* Open the file for binary read. */
    if (file == -1) {               /* If can't open it, return with error. */
        return NULL;
    }
    info = arcsighead;                 /* start of signatures */
    while (info) {
        l = strlen(info->signature);   /* Get the signature length. */
        if(l > 79) l = 79;
        if(info->file_offset >= 0L)
          lseek(file,info->file_offset,SEEK_SET);
        else
          lseek(file,info->file_offset,SEEK_END);
        read(file,buffer,l);
        buffer[l] = 0;
        if(!strcmp(info->signature,buffer))
           break;
        info = info->next;
    }
    close(file);                        /* Either way, we're done for now */
    return info;                        /* return signature, if any */
}


int _fastcall load_archivers (void) {

  int            handle,numlines = 21,x;
  char           s[257],*p;
  ARC_TYPE       *info = NULL,*last = NULL;

  p = searchpath("ARCHIVER.BB2",s,256);
  if(!p)
    return -1;
  handle = sopen(p,O_RDONLY | O_BINARY,SH_DENYNO);
  if(handle == -1)
    return -1;
  if(!fgetsx(s,256,handle)) {
    close(handle);
    return -1;
  }
  p = strchr(s,';');
  if(p)
    *p = 0;
  stripcr(s);
  lstrip(s);
  rstrip(s);
  if(*s)
    numlines = atoi(s);
  while(!eof(handle)) {
    if(!fgetsx(s,256,handle))
      break;
    p = strchr(s,';');
    if(p)
      *p = 0;
    stripcr(s);
    lstrip(s);
    rstrip(s);
    if(*s) {
      info = malloc(sizeof(ARC_TYPE));
      if(!info) break;
      memset(info,0,sizeof(ARC_TYPE));
      info->id = strdup(s);
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      stripcr(s);
      lstrip(s);
      rstrip(s);
      info->ext = strdup(s);
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      info->file_offset = atol(s);
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      stripcr(s);
      lstrip(s);
      rstrip(s);
      info->list = strdup(literal(s));
      if(!info->list) break;
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      stripcr(s);
      lstrip(s);
      rstrip(s);
      info->extract = strdup(literal(s));
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      stripcr(s);
      lstrip(s);
      rstrip(s);
      if(*s)
        info->exwdirs = strdup(literal(s));
      else
        info->exwdirs = NULL;
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      stripcr(s);
      lstrip(s);
      rstrip(s);
      if(*s) info->test = strdup(literal(s));
      else info->test = NULL;
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      stripcr(s);
      lstrip(s);
      rstrip(s);
      info->create = strdup(literal(s));
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      stripcr(s);
      lstrip(s);
      rstrip(s);
      info->createwdirs = strdup(literal(s));
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      stripcr(s);
      lstrip(s);
      rstrip(s);
      info->createrecurse = strdup(literal(s));
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      stripcr(s);
      lstrip(s);
      rstrip(s);
      info->move = strdup(literal(s));
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      stripcr(s);
      lstrip(s);
      rstrip(s);
      info->movewdirs = strdup(literal(s));
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      stripcr(s);
      lstrip(s);
      rstrip(s);
      info->delete = strdup(literal(s));
      if(!fgetsx(s,256,handle)) break;
      stripcr(s);
      info->signature = strdup(literal(s));
      if(!info->signature) break;
      if(!fgetsx(s,256,handle)) break;
      stripcr(s);
      info->startlist = strdup(s);
      if(!fgetsx(s,256,handle)) break;
      stripcr(s);
      info->endlist = strdup(s);
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      info->osizepos = atoi(s);
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      info->nsizepos = atoi(s);
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      info->fdpos = atoi(s);
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      info->fdflds = atoi(s);
      if(!fgetsx(s,256,handle)) break;
      p = strchr(s,';');
      if(p) *p = 0;
      info->fnpos = atoi(s);

      for(x = 21;x < numlines;x++) {
        if(!fgetsx(s,256,handle))
          break;
      }

      info->next = NULL;
      if(!arcsighead) {
        arcsighead = last = info;
      }
      else {
        last->next = info;
        last = info;
      }
    }
    info = NULL;
  }
  close(handle);
  if(info) {
    if(info->id)        free(info->id);
    if(info->ext)       free(info->ext);
    if(info->list)      free(info->list);
    if(info->extract)   free(info->extract);
    if(info->create)    free(info->create);
    if(info->move)      free(info->move);
    if(info->delete)    free(info->delete);
    if(info->signature) free(info->signature);
    if(info->startlist) free(info->startlist);
    if(info->endlist)   free(info->endlist);
    if(info->test)      free(info->test);
    if(info->exwdirs)   free(info->exwdirs);
    if(info->createwdirs)
                        free(info->createwdirs);
    if(info->createrecurse)
                        free(info->createrecurse);
    if(info->movewdirs) free(info->movewdirs);
  }
  if(!arcsighead) return -1;
  return 0;
}
