/////////////////////////////////////////////////////////////////////////////
//      TW2.H -- Tradewars 2 C header file.                                //
//                                                                         //
//      Selected portions of the TW2.H file.                               //
//                                                                         //
//      9/92  More explicit on variable types... ie.  Made sure that       //
//            the 32-bit compiler still uses a word sized integer in most  //
//            cases.                                                       //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

typedef unsigned char Uchar;
typedef unsigned short Uint;
typedef unsigned long Ulong;

// 'killed by' definitions..
#define CABAL   -1
#define DELETED -2
#define UNKNOWN -3
#define MINE    -4
#define ACTIVE  -5
#define PIRATES -6

/* struct _PLYROPTS

    -- boolean switches in player records -- used in struct _PLAYER

*/
    struct _PLYROPTS
    {
        Uint        Kloak:    1;             // cloaking device
        Uint        Graphics: 2;             // graphics (None, Color,
                                             // C/G w/o msc, C/G w/ music)
        Uint        RTOnNow:  1;             // REAL TIME: using TW now
        Uint        Banished: 1;             // Restricted from plane 0
        Uint        MailWaiting: 1;          // has mail waiting
    };

// union _WASCABAL_ used in _TWMAIN (formerly..  prior to ver 11)

union _WASCABAL_
    {
        char FreeForUse[23];
        struct _OLDCABAL
            {
                Uint        regen;           // cabal regeneration
                Uint        hq;              // cabal HQ location
                Uint        Secndry;         // secondary force location
                Uint        loc1;            // location around base #1
                Uint        loc2;            // location around base #2
                Uint        loc3;            // location around base #3
                Uint        loc4;            // location around base #4
                Uint        loc5;            // location around base #5
                Uint        loc6;            // location around base #6
                Uint        type2;           // number of cabal group 2 ftrs
                Uint        type3;           // number of cabal group 3 ftrs
                char        strength;        // cabal strength level 1 - 10
            } OldCabal;
    };

// union _WASOPTIONS_  formerly used in _TWMAIN - NOT USED!

union _WASOPTIONS_
    {
        int Unused;
        struct _OLDOPTIONS
            {
                Uint        aliases:  1;     // aliases on/off
                Uint        network:  1;     // network on/off
                Uint        news:     1;     // galactic news on/off
                Uint        debug:    1;     // debug on/off
                Uint        bbs_type: 4;     // bbs interface type
                Uint        GMon:     1;     // using GMon??
                Uint        externm:  1;     // external maintenance
                Uint        local_password: 1; // ask for local password?
                Uint        sales:    1;     // sales allowed??
                Uint        surr:     1;     // surrender allowed?
                Uint        show_dead: 1;    // show dead in rankings?
                Uint        MoreThan1K: 1;   // More than 1K sectors?
                Uint        Restricted: 1;   // restricted access for studs
            } Option;
    };

/* struct _TWMAIN

    -- file structure of main TW data file

*/
struct _TWMAIN
    {
        char        EditorPassword[13];      // password used to enter TWEDT
        Uint        StartingYear;            // starting year of game
        Uint        TurnsPerDay;             // turns per day allowed
        Uint        StartingFighters;        // starting fghter amount
        Uint        StartingCredits;         // starting credit amount
        Uint        StartingHolds;           // starting hold amount
        Uint        DaysInactive;            // max days of inactivity
        Uint        LastMaintenance;         // last day of maintenance
        Uint        NewsDays;                // days to save newspaper
        Uint        NewsDeleted;             // last day paper deleted
        float       BankInterest;            // todays bank interest
        Uint        MaxHolds;                // maximum holds allowed in TW
        Uint        MaxOre;                  // max planet prod of ore
        Uint        MaxOrg;                  // max planet prod of org
        Uint        MaxEqp;                  // max planet prod of eqp
        Uint        FighterPrice;            // todays fighter price
        union       _WASOPTIONS_ Old;        //
        Uint        CabalBounty;             // todays cabal bounty
        union       _WASCABAL_ Was;          //
        Uint        AutoLogOff;              // time in minutes before tmout
        Uint        MaxTime;                 // max time in minutes no montr
        char        BBSInfoFile[65];         // file to get BBS info from
        char        RankFileName[65];        // file for player rankings
        char        BBSSysopName[32];        // BBS SysOp name       (n-a-u)
        char        BBSName[41];             // BBS name (not always used)
        char        PortNumber;              // port num (not always used)
        Uint        ModemLockSpeed;          // speed of locked port (n-a-u)
        short       BBSMode;                 // running in bbs mode? y/n (n-u)
        char        ReservedPortionA[67];    // Reserved for use by TW2
        short       TW2Version;              // version number of tw
        char        MaxNodes;                // number of nodes (for chat)
        short       PlanetRecords;           // records in planet file
        short       PlayerRecords;           // records in user file
        short       TeamRecords;             // records in team file
        char        Language[4];             // language file extension
        Uchar       BBSType;                 // BBS type
        Ulong       TWOptions;               // home of options
        long        BanishValue;             // if restrict studs, this Value
        char        TWDirectory[65];         // directory TW data files are in
        short       MaxPlayers;              // maximum player total
        short       InputBuffer;             // input comm buffer
        short       OutputBuffer;            // output comm buffer
        char        NetDirectory[65];        // area for TW2NET.DAT/TW2NET.INC
        char        MsgDirectory[65];        // TW msg base directory
        Uchar       NetNode;                 // TW network node number
        short       Net;                     // Regular network #
        short       Node;                    // Regular node #
        short       NodesInNet;              // Nodes in the network
        char        PackerName[13];          // Network packer filename
        char        PackerOptions[10];       // Packer command options
        char        ChatFileDirectory[65];   // Drive/Directory for chat file
        char        ReservedPortionB[30];    // Reserved for use by TW2
        char        Unused[300];             // not currently in use..
    };

/*  struct _PLAYER

    -- structure for each record of TWPLAYER.DAT

*/
struct _PLAYER
    {
        char        RealName[31];            // players real (BBS) name
        char        Alias[31];               // players alias name (if any)
        char        Password[9];             // local password
        struct      _PLYROPTS Options;       // use: Player.Options.etc
        Uint        LastOn;                  // last day on
        short       DestroyedBy;             // player killed by
        Uint        TurnsLeft;               // turns left on last day
        Uint        SectorIn;                // current sector in
        Uint        LastSectorIn;            // last sector in
        Ulong       BankCredits;             // banked credits
        Ulong       Credits;                 // trading credits
        Uint        Fighters;                // fighters w/ ship
        Uint        Mines;                   // mines w/ ship
        Uint        Kloak;                   // cloak days left (if any)
        Uint        Probes;                  // probes w/ ship
        Uint        Holds;                   // holds w/ ship
        Uint        Ore;                     // ore in holds
        Uint        Org;                     // organics in holds
        Uint        Eqp;                     // equipment in holds
        Uint        TeamIn;                  // team in (if any)
        Uint        DayQuitTeam;             // day player quit team
        Uint        TimeUsed;                // time used today
        short       RTAttackBy;              // REAL TIME: attacked by
        Uint        UnusedInt;               // pointer to next lower player
        long        UnusedLong;              // value of player
        Uint        SuperSearch;             // super sector finder onboard
        Uint        RTMessage;               // REAL TIME: radio msg
        Uint        LastMsgRead;             // Last message number read
        char        JustPlainUnused[36];     // not currently in use..
    };

/*  struct _SECTOR

    -- structure for each record of TWSECTOR.DAT

*/
struct _SECTOR
    {
        Uint        DefenseForce;            // sector defense force ftr #
        short       DFOwner;                 // owner of those fighters
        Uint        Port;                    // port in sector (if any)
        Uint        Planet;                  // planet in sector (if any)
        Uint        Mine;                    // mine in sector (if any)
        char        InUnion;                 // is sector in union??
        Uint        DefenseOptions;          // Defense Force options
        Uint        OptionWork;              // Work Integer For above
        Uint        MineOptions;             // Mine Programming Options
        Uint        MOWork;                  // Mine Option Work
        char        Unused[31];              // not currently in use..
    };

/*  struct _PORT

    -- structure for each record of TWPORT.DAT

*/
struct _PORT
    {
        char        Name[30];                // name of port
        char        Class;                   // class of port 0, 1, 2, 3
        Uint        RecalcDay;               // last day materials recalc'd
        Uint        RecalcMin;               // last min materials recalc'd
        short       OreUnits;                // units of ore
        short       OrgUnits;                // units of organics
        short       EqpUnits;                // units of equipment
        Uint        OreProd;                 // productivity of ore per day
        Uint        OrgProd;                 // productivity of org per day
        Uint        EqpProd;                 // productivity of eqp per day
        short       OreCost;                 // cost of ore %/thsnd units
        short       OrgCost;                 // cost of org %/thsnd units
        short       EqpCost;                 // cost of eqp %/thsnd units
        Uint        OreFract;                // 1/10000's units of ore
        Uint        OrgFract;                // 1/10000's units of organics
        Uint        EqpFract;                // 1/10000's units of eqp
        char        Unused[20];              // not currently in use..
    };

/*  struct _PLANET

    -- structure for each record of the TWPLANET.DAT file

*/
struct _PLANET
    {
        char        Name[30];                // name of planet
        Uint        Owner;                   // owner of planet
        Uint        RecalcDay;               // last day materials recalc'd
        Uint        RecalcMin;               // last min materials recalc'd
        Uint        OreUnits;                // amount of ore
        Uint        OrgUnits;                // amount of organics
        Uint        EqpUnits;                // amount of equipment
        Uint        OreProd;                 // productivity of ore
        Uint        OrgProd;                 // productivity of organics
        Uint        EqpProd;                 // productivity of equipment
        Uint        OreFract;                // 1/10000's units of ore
        Uint        OrgFract;                // 1/10000's units of org
        Uint        EqpFract;                // 1/10000's units of eqp
        char        Factory;                 // factory  yes/no
        Uint        Workers;                 // number of workers
        Uint        Pay;                     // pay for each worker per day
        long        Cash;                    // factory cash available
        Uint        FactoryOre;              // factory ore supply
        Uint        FactoryOrg;              // factory organics supply
        Uint        FactoryEqp;              // factory equipment supply
        Uint        FactoryFighters;         // fighter supply
        Uint        DefenseForce;            // Planetary Defense force
        short       DefenseOwner;            // Defense force owner
        Uint        DefenseOptions;          // DF Options
        Uint        OptionWork;              // Option work area
        char        Unused[22];              // not currently in use..
    };

struct twcabal    // used in struct _CABAL_
    {
        Uint        Location;                // location of this group
        Uint        Goal;                    // goal of this cabal group
        Uint        Fighters;                // fighters in this group
    };

/*  struct _CABAL_

    -- file structure for each record of TWCABAL.DAT

*/
struct _CABAL_
    {
        Uint        Regeneration;            // cabal regeneration
        Uint        Hq;                      // cabal HQ location
        Uint        Secondary;               // secondary force location
        Uint        Location1;               // location around base #1
        Uint        Location2;               // location around base #2
        Uint        Location3;               // location around base #3
        Uint        Location4;               // location around base #4
        Uint        Location5;               // location around base #5
        Uint        Location6;               // location around base #6
        Uint        GroupType2;              // number of cabal group 2 ftrs
        Uint        GroupType3;              // number of cabal group 3 ftrs
        char        Strength;                // cabal strength level 1 - 10
        struct      twcabal Group[50];       // Array of all 50 group locs
    };

/*  struct _PLYRMSG

    -- file structure for each record of TWPMESS.DAT

*/
struct _PLYRMSG
    {
        Uint        To;                      // player msg is to and total #
        Uint        Active;                  // is msg active?
        short       From;                    // player who killed above ftrs
        Uint        Destroyed;               // fighters destroyed by above
    };

/*  struct _TEAM

    -- file structure for each record of TWTEAM.DAT

*/
struct _TEAM
    {
        char        Name[30];                // name of team
        char        Password[9];             // password to join team
        Uint        Players;                 // number of players on team
        Uint        Captain;                 // active/team captain
    };

// General TW2 options  used in _TWMAIN.TWOptions

#define ALIASES         0x00000001           // Aliases
#define NETWORK         0x00000002           // Networking
#define NEWS            0x00000004           // News/MsgstoSysop
#define DEBUG           0x00000008           // Debug mode
#define GMON            0x00000010           // GMon
#define EXTERNM         0x00000020           // External Maintenance
#define LOCALPW         0x00000040           // Password entry
#define SALES           0x00000080           // Sales of products
#define SURRENDER       0x00000100           // Surrendering?
#define SHOWDEAD        0x00000200           // Show dead in rankings?
#define RESERVED1       0x00000400
#define RESTRICTED      0x00000800           // restrict good players from plane 0
#define ALLOWKLOAK      0x00001000           // Allow kloaking?
#define KEEPSAVINGS     0x00002000           // keep savings when killed?
#define RESERVED2       0x00004000
#define ISNETWORKED     0x00008000           // in TW network mode?
#define ISNETHOST       0x00010000           // TW network host?
#define NOUNIONATTACKS  0x00020000           // no attacks allowed in Union
#define MUZAKOK         0x00040000           // Local muzak okay??
#define GGGRAPHICSOK    0x00080000           // Local Graphics Okay?
#define COMMITDATA      0x00100000           // commit data to disk?

// defense force options - used in Sector & Planet Defense force options
#define TEAMDF      0x0001                   // team defense force
#define ATTACKALL   0x0002                   // Defense force attacks anyone
#define ATTACKNONE  0x0004                   // attacks no one
#define ATTACKTEAM  0x0008                   // attack certain team
#define ATTACKPLYR  0x0010                   // attack certain player
