///////////////////////////////////////////////////////////////////////////
//                                                                       //
// GIO-2.C  Gern's IO example 2                                          //
//                                                                       //
// Link with GIO.LIB                                                     //
///////////////////////////////////////////////////////////////////////////

#define INCL_WIN
#define INCL_GPI
#define INCL_VIO
#define INCL_AVIO
#define INCL_DOS
#define INCL_DOSDEVIOCTL
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include "gio.h"

MRESULT EXPENTRY ClientWndProc(HWND, ULONG, MPARAM, MPARAM);
VOID CommIn(PVOID);

HAB   Hab;
HMTX  hmtxCommIn;
TID   TidCommIn;
HWND  HwndClient;

BOOL  KeepLooping = TRUE;

#define COMTHREAD 1

int main(void)
{
    static CHAR  SzClientClass[] = "GIO2";
    static ULONG FlFrameFlags    = FCF_TITLEBAR      | FCF_SYSMENU |
                                   FCF_SIZEBORDER    | FCF_MINMAX  |
                                   FCF_SHELLPOSITION | FCF_TASKLIST;

    HMQ  Hmq;
    HWND HwndFrame;
    QMSG Qmsg;
    PUSHORT Unused;

    Hab = WinInitialize(0);
    Hmq = WinCreateMsgQueue(Hab, 0);

    DosCreateMutexSem(NULL, &hmtxCommIn, 0, TRUE);

    TidCommIn = _beginthread(CommIn, NULL, 3072, &Unused);

    // Open Com1 at 19200,N,8,1 with buffers 128 bytes in size.
    if (ComOpen(NULL, 1, 19200, 'N', 8, 1, 128, 128, 0, FALSE))
    {
        DosBeep(1000, 250);         // ComOpen Failed.. Beep and exit
        DosExit(EXIT_PROCESS, 1);
    }

    WinRegisterClass(   Hab,            // Anchor Block Handle
                        SzClientClass,  // Name of Class Being Registered
                        ClientWndProc,  // Window Procedure For Class
                        CS_SIZEREDRAW,  // Class Style
                        0);             // Extra Bytes To Reserve

    HwndFrame = WinCreateStdWindow(
                        HWND_DESKTOP,   // Parent Window Handle
                        WS_VISIBLE,     // Style of Frame Window
                        &FlFrameFlags,  // Pointer To Control Data
                        SzClientClass,  // Client Window Class Name
                        NULL,           // Title Bar Text
                        0L,             // Style of Client Window
                        0,              // Module Handle For Resources
                        0,              // ID of Resources
                (PHWND) &HwndClient);   // Pointer To Client Window Handle

    WinSendMsg(HwndFrame,
               WM_SETICON,
               (MPARAM) WinQuerySysPointer(HWND_DESKTOP, SPTR_APPICON, FALSE),
               NULL);

    DosReleaseMutexSem(hmtxCommIn);

    while (WinGetMsg(Hab, &Qmsg, NULL, 0, 0))
        WinDispatchMsg(Hab, &Qmsg);

    WinDestroyWindow(HwndFrame);

    WinDestroyMsgQueue(Hmq);

    WinTerminate(Hab);

    DosSleep(50L);

    ComClose(FALSE);

    DosSleep(200L);

    DosCloseMutexSem(hmtxCommIn);

    return(0);
}

static HVPS  Hvps;

MRESULT EXPENTRY ClientWndProc(HWND Hwnd, ULONG Msg, MPARAM Mp1, MPARAM Mp2)
{
    HDC          Hdc;
    static HPS   Hps;
    static SHORT Rows, Cols;
    static LONG  WinRows, WinCols;
    RECTL        Rect;

    switch (Msg)
    {
        case WM_CREATE:
            Hdc = WinOpenWindowDC(Hwnd);

            VioCreatePS(&Hvps, 25, 80, FORMAT_CGA, 1, 0);
            VioAssociate(Hdc, Hvps);

            VioWrtTTY("\x1B[2J", 4, Hvps);

            VioGetDeviceCellSize(&Rows, &Cols, Hvps);

            if (! WinSetWindowPos(Hwnd, 0, 0, 0, 300, 200, SWP_ACTIVATE | SWP_SIZE))
                DosBeep(1200, 200);

            return 0;

        case WM_CHAR:
            if (CHARMSG(&Msg)->fs & KC_CHAR)
            {
                ComTXChar((BYTE) CHARMSG(&Msg)->chr);
            }
            else if (CHARMSG(&Msg)->fs & KC_VIRTUALKEY)
            {
                switch (CHARMSG(&Msg)->vkey)
                {
                    case VK_ESC:
                        ComTXChar(27);
                        break;
                    case VK_ALT:
                        switch (CHARMSG(&Msg)->chr)
                        {
                            case 'C':
                                VioWrtTTY("\x1B[2J", 4, Hvps);
                                break;
                        }
                }
            }

            return 0;

        case WM_SIZE:
            return (WinDefAVioWindowProc(Hwnd, Msg, (ULONG) Mp1, (ULONG) Mp2));

        case WM_PAINT:
            Hps = WinBeginPaint(Hwnd, NULL, NULL);

            WinQueryWindowRect(Hwnd, &Rect);

            WinRows = Rect.yTop;
            WinCols = Rect.xRight;

            WinFillRect(Hps, &Rect, CLR_BLACK);

            VioShowBuf(0, 2 * 25 * 80, Hvps);

            WinEndPaint(Hps);

            return 0;

        case WM_DESTROY:
            KeepLooping = FALSE;

            VioAssociate(NULL, Hvps);

            VioDestroyPS(Hvps);

            return 0;
    }

    return (WinDefWindowProc(Hwnd, Msg, Mp1, Mp2));
}

VOID CommIn(PVOID Unused)
{
    PVOID   Temp;
    BYTE    TrueChar;
    SHORT   InChar;

    Temp = Unused;

    DosRequestMutexSem(hmtxCommIn, SEM_INDEFINITE_WAIT);

    do
    {
        if (ComRXCharWaiting())
        {
            ComRXChar(&InChar);

            if (InChar == 12)   // FormFeed / Clear Screen
                VioWrtTTY("\x1B[2J", 4, Hvps);
            else
            {
                TrueChar = (BYTE) InChar;
                VioWrtTTY(&TrueChar, 1, Hvps);
            }
        }
        else
            DosSleep(1L);

    } while (KeepLooping);

    DosReleaseMutexSem(hmtxCommIn);

    _endthread();
}
