///////////////////////////////////////////////////////////////////////////
//                                                                       //
// GIO-1.C  Text based GIO example                                       //
//                                                                       //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#define INCL_BASE
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include "gio.h"

SHORT CommIn(VOID);
SHORT CommOut(VOID);
VOID ErrExit(CHAR *);

// some of my bad C programming habits..
#define AND  &&
#define OR   ||
#define NOT  !

#define EXITKEY 0x2D
#define CLRSCRN 0x2E

CHAR    TempString[80];

void main(SHORT ArgCount, CHAR **ArgVars)
{
    BOOL    KeepLooping = TRUE;
    CHAR    ComPort[6];
    SHORT   PortNumber;
    KBDINFO KBStatus;

    if (ArgCount < 2)
        ErrExit("\nUsage:  GIO-1 comport#\n");

    strcpy(TempString, "Com... A test for Gern's IO routines...\n\r");
    VioWrtTTY(TempString, strlen(TempString), 0);

    // Set up keyboard

    KBStatus.cb = sizeof(KBStatus);
    KbdGetStatus(&KBStatus, 0);

    KBStatus.fsMask &= 0xFFF0;
    KBStatus.fsMask |= KEYBOARD_ECHO_OFF | KEYBOARD_BINARY_MODE;
    KbdSetStatus(&KBStatus, 0);

    // set up com port.. just for the heck of it.. GIO actually does this

    sprintf(ComPort, "COM%c", ArgVars[1][0]);

    // Open Com Port "COMx" just like a file..

    PortNumber = atoi(ArgVars[1]);

    if (ComOpen(NULL, PortNumber, 19200, 'N', 8, 1, 128, 128, 0))
        ErrExit("\nCan't Open Com1!\n");

    do
    {
        CommIn();

        KeepLooping = (BOOL) CommOut();

    } while (KeepLooping);

    ComClose();

    DosSleep(200L);

    strcpy(TempString, "\r\nTerminating...\r\n\n");
    VioWrtTTY(TempString, strlen(TempString), 0);

    DosExit(EXIT_PROCESS, 0);
}

SHORT CommOut(VOID)
{
    KBDKEYINFO KBInfo;

    KbdCharIn(&KBInfo, IO_NOWAIT, 0);

    if (NOT KBInfo.fbStatus)
        return(1);

    if ((KBInfo.chChar == 0) OR (KBInfo.chChar == 0xE0))
    {
        switch (KBInfo.chScan)
        {
            case CLRSCRN:
                VioWrtTTY("\x1B[2J", 4, 0);
                break;
            case EXITKEY:
                return (0);
        }
    }

    ComTXChar(KBInfo.chChar);

    return (1);
}

SHORT CommIn(VOID)
{
    BYTE     TrueChar;
    SHORT    InChar;
    USHORT   WaitFlag;

    if (ComRXCharWaiting())
    {
        ComRXChar(&InChar);

        if (InChar == 12)   // FormFeed / Clear Screen
            VioWrtTTY("\x1B[2J", 4, 0);
        else
        {
            TrueChar = (BYTE) InChar;
            VioWrtTTY(&TrueChar, 1, 0);
        }
    }
    else
        DosSleep(5L);

    return(0);
}

VOID ErrExit(CHAR *ErrMsg)
{
    VioWrtTTY(ErrMsg, strlen(ErrMsg), 0);

    DosExit(EXIT_PROCESS, 1);              // Error Level of 1
}
