/*example extern-file of OffTag 1.1
  Parameters :
    Com-Handle         File-Handle of an open Com-Port (This is a number)
    NodeNo             for which Node this Script is launched
    filename           Fully qualified and in Quotes (e.g.  "c:\x\HEYYOU.ZIP")

*/
parse upper arg comhandle nodeno '"' filename '.' ext '"'

nodeno=strip(nodeno)
comhandle=strip(comhandle)

/*SIGNAL ON SYNTAX NAME usergone */ /* if remote & user hangsup, goto usergone. */

CALL init                      /* register extensions with REXX */

fnamepos=0
startsig=""
stopsig=""
unpack=""

call readpaths

ziplist="@"zippath" -l"
zipstartsig=" ------"
zipstopsig=" ------"
zipfname=28
unzip="@"zippath" -x -j -o "

arjlist="@"arjpath" l"
unarj="@"arjpath" e "
arjfname=1
arjstartsig="------------"
arjstopsig= "------------"

lzhlist="@"lhpath" l /o"
unlzh="@"lhpath" x /o "
lzhfname=22
lzhstartsig="  -------- "
lzhstopsig= "  -------- "

tempdir=temppath

/***********************/

screenlines=23
listlines=screenlines-2

/***********************/

savedir=directory()
nowdir=directory(tempdir)
if translate(nowdir)<>translate(tempdir) then do
  say "Wrong Temp-Directory"
  exit
end

tempfile="viewit"nodeno".tmp"

rc = RxAnsiInit()              /* Set up ANSI variables */

if (Comhandle <>'') & (Comhandle<>0) then do        /* If remote user */
  rc = RxMode(MIXED,Comhandle) /* set mode to mixed */
  local=0
end
else local=1

CRLF='0d'x'0a'x


ok=1
rc=Statusline("Gathering archive data. Please Wait...")
select
  when ext="ARJ" then do
      arjlist filename ">"tempfile
      fnamepos=arjfname
      startsig=arjstartsig
      stopsig=arjstopsig
      unpack=unarj
    end
  when ext="ZIP" then do
      ziplist filename ">"tempfile
      fnamepos=zipfname
      startsig=zipstartsig
      stopsig=zipstopsig
      unpack=unzip
    end
  when ext="LZH" then do
      lzhlist filename ">"tempfile
      fnamepos=lzhfname
      startsig=lzhstartsig
      stopsig=lzhstopsig
      unpack=unlzh
    end
  otherwise do
    rc=DumpFile(filename"."ext)
    ok=0
  end
end

if ok=1 then do
  scrline=0
  if startsig<>"" then
    show=0
  else
    show=1
  key=""
  do while Lines(tempfile)>0 & Key<>ESCAPE & pos(translate(key),Xrange('A','Z'))=0
    line=substr(linein(tempfile),1,77)
    if stopsig<>"" & substr(line,1,length(stopsig))=stopsig then show=0
    if show then do
      rc=RxPutChars(RED""d2c(c2d('A')+scrline)" "CYAN""line""CRLF)
      scrline=scrline+1
      fname.scrline=word(substr(line,fnamepos,77),1)
    end
    if startsig<>"" & substr(line,1,length(startsig))=startsig then show=1
    if scrline>=listlines then do
      rc=BottomLine("Press A-Z to View File or Esc for Exit. ENTER continues.")
      do until key=ENTER |  key=ESCAPE | pos(translate(key),Xrange('A','Z'))>0
        key=RxGetChar()
        if key=ENTER then do
          rc=StatusLine("Listing archive "filename)
          scrline=0
        end
      end
    end
  end
  rc=lineout(tempfile)
  if scrline<>0 & key<>ESCAPE & pos(translate(key),Xrange('A','Z'))=0 then do
    do until key=ENTER |  key=ESCAPE | pos(translate(key),Xrange('A','Z'))>0
      rc=BottomLine("Press A-Z to View File. ENTER or ESC returns.")
      key=RxGetChar()
    end
  end

  keypos=pos(translate(key),xrange('A','Z')) /*check for View-File command*/

  if keypos>0 & keypos<=scrline then do
    rc=StatusLine("Unpacking Filename : "fname.keypos)
    name=filespec("Name",fname.keypos)
    "@if exist "name" del "name
    unpack" "filename" "fname.keypos
    call dumpfile name
    "@if exist "name" del "name
  end
  "@if exist "tempfile" del "tempfile
  rc=directory(savedir)
end
/*else do
  rc=BottomLine("Press any key to return to OffTag")
  key=RxGetChar()
end*/
rc=BottomLine("Returning to OffTag, stand by...")
exit

/**************************/
dumpfile:
parse arg fname

buffer=""
maxbufflen=100

if fname<>"" then do
  rc=StatusLine("Displaying File "fname)
  line=0
  eof=0
  reply=""
  do while reply<>"Q" & eof=0
    if dumpline(fname)=0 then eof=1
    line=line+1
    if eof then do
      rc=BottomLine("End of File: Press any key to Quit")
      key=RxGetChar()
    end
    else
      if line>=listlines then do
        rc=BottomLine("Press Q to quit, any other Key continues.")
        reply=Translate(RxGetChar())
        line=0
        if reply<>"Q" then
          rc=StatusLine("Displaying File "fname)
      end
  end
  rc=lineout(fname)
end
else say "No Parameter passed"
return 0

/*************/
dumpline:
parse arg name

if (length(buffer)>0) | (chars(name)>0) then do
  buffer=buffer""Charin(name,,maxbufflen-length(buffer))
  nextcr=pos('0D'x,buffer)
  if (nextcr=0) | (nextcr>80) then
    nextcr=80
  else
    if substr(buffer,nextcr+1,1)='0A'x then
      buffer=delstr(buffer,nextcr+1,1)
  rc=RxPutChars(translate(substr(buffer,1,nextcr-1),,Xrange('00'x,'1F'x),'.')""CRLF)
  buffer=delstr(buffer,1,nextcr)
  if (length(buffer)>0) | (chars(name)>0) then
    return 1
  else
    return 0
end
else return 0

/**************************/
statusline:
  parse arg title
  rc=RxGoto(1,1)
  if length(title)>76 then title=left(title,76)"..."
  leftfillup=40-trunc(length(title)/2)
  rc=RxPutChars(INTENSE""CYAN""ON_BLUE""CLS)
  rc=RxPutChars(YELLOW""ON_Red""left("",leftfillup)""title""left("",79-leftfillup-length(title)))
  rc=RxPutChars(CRLF""CYAN""ON_BLUE)
return 0

/**************************/
bottomline:
  parse arg title
  rc=RxGoto(screenlines,1)
  if length(title)>76 then title=left(title,76)"..."
  leftfillup=40-trunc(length(title)/2)
  rc=RxPutChars(YELLOW""ON_RED""left("",leftfillup)""title""left("",79-leftfillup-length(title)))
  rc=RxGoto(screenlines,1)
return 0

/**************************/
readpaths:
  pathfile="FILEPATH.CFG"
  zippath="unzip"
  arjpath="unarj"
  lhpath="lh"
  temppath="c:\spool"
  bbspath="c:\max"
  offtagpath="c:\max\tagger"
  do while lines(pathfile)
    pathfileline=linein(pathfile)
    pathfilekeyword=translate(word(pathfileline,1))
    pathfileinfo=word(pathfileline,2)
    select
      when pathfilekeyword="UNPACK-ZIP" then do
          zippath=pathfileinfo
        end
      when pathfilekeyword="UNPACK-ARJ" then do
          arjpath=pathfileinfo
        end
      when pathfilekeyword="UNPACK-LH" then do
          lhpath=pathfileinfo
        end
      when pathfilekeyword="TEMPDIR" then do
          temppath=pathfileinfo
        end
      when pathfilekeyword="BBSDIR" then do
          bbspath=pathfileinfo
        end
      when pathfilekeyword="OFFTAGDIR" then do
          offtagpath=pathfileinfo
        end
      otherwise
    end
  end
  rc=lineout(pathfile)
  return 0


/* --------------------------------------------------------------------- */
/* Register all the functions to REXX                                    */
/* --------------------------------------------------------------------- */
init:
CALL RxFuncAdd 'RXANSIINIT','RXANSI','RXANSIINIT'
CALL RxFuncAdd 'RXGOTO',    'RXANSI','RXGOTO'
CALL RxFuncAdd 'RXMODE',    'RXANSI','RXMODE'
CALL RxFuncAdd 'RXLINE',    'RXANSI','RXLINE'
CALL RxFuncAdd 'RXLINETYPE','RXANSI','RXLINETYPE'
CALL RxFuncAdd 'RXBOX',     'RXANSI','RXBOX'
CALL RxFuncAdd 'RXGETCHAR', 'RXANSI','RXGETCHAR'
CALL RxFuncAdd 'RXGETCHARS','RXANSI','RXGETCHARS'
CALL RxFuncAdd 'RXPUTCHARS','RXANSI','RXPUTCHARS'
RETURN

/* --------------------------------------------------------------------- */
/* Remote user has hung up - tell host and quit                          */
/* --------------------------------------------------------------------- */
usergone:
  IF lastkey = 'USER GONE' THEN
     say 'User gone'
  ELSE
     SAY 'Bug in your Rexx procedure'
  rc=directory(savedir)
  Exit

