/*                               SCAN-CD                             */
/*       scans CDs for files.bbs'es copies 'em and creates a         */
/*                   Maximus-Ready Filearea.ctl file                 */
/*                       Author Michael Mrosowski                    */
/*    (fidonet: 2:240/5022.1  internet: lagaffe@offline.sh.sub.de)   */
/* This one is free, change it, delete it, use it, sellit as you want*/

/* I don't take any responsability for any trouble or damage the use */
/*                        of this script may cause                   */

call RxFuncAdd "SysFileTree", "RexxUtil", "SysFileTree"

/*****************Customizeable Area*************************************/
AccessLevel= "Limited"    /*Maximus AccessLevel/Lock*/
FilesBbsName="FILES.BBS"  /*Name of Dir-Files to search for*/
IncludeFileId="N"         /*"Y" includes file_id.diz in *.bbs if present*/
DescStartWord=2           /*Description starts at word 2 (here)         */
BbsDir="C:\MAX\CD"       /*Target Directory for .ctl and the*/
                          /*copied .bbs files*/
DizName="FILE_ID.DIZ"
DoUnzip="@unzip -o "
DoUnarj="@unarj x "
/************************************************************************/

IncludeFileId=Substr(Translate(IncludeFileId),1,1)

say "This Script will scan a CD for directories with FILES.BBS inside."
say "It will create a Maximus-Ready *.ctl file (include that) and copies"
say "the files.bbs to your a local directory on your harddisk. It will"
say "also include FILE_ID.DIZ descriptions of *.zip and *.arj archives in"
say "the FILES.BBS if desired."
say
say "Current settings:"
say "-----------------"
say "FilesBBS name : "FilesBBSName
say "Include FileId: "IncludeFileId
say "Unzip command : "DoUnzip
say "UnArj command : "DoUnArj
say "Description starts at word no. "DescStartWord
say "Directory where to put the copied files.bbs : "BBSDir
say "AccessLevel for your users to this CD       : "AccessLevel
say
say "Please CHECK the Settings above and correct them if necessary with"
say "a Text-Editor in SCANCD.CMD. The Directory for the FILES.BBS must"
say "already be present (preferrably empty)."
say "Abort at any time with Ctrl+Break (and ENTER if neccessary)."
say "Ehmm.... put now your CD in the drive ;-) and: USE AT YOUR OWN RISK!"
say
say "Your CD drive (e.g. 'F:'): "
pull cddrive

currdir=directory(bbsdir)

say "Area-Name prefix (max. 4 chars long) :"
pull prebbs

areactl=bbsdir"\"prebbs"AREA.CTL"

/*trace all*/
say "Here we go. Gathering Directory Data. Please wait some seconds..."
rc=SysFileTree(cddrive"\"filesbbsname,found,"FSO")
if found.0>0 then do
  do i=1 to found.0                 /*Loop for every Files.bbs found*/
    newbbsname=prebbs""i".bbs"      /*write area-infos to *.ctl*/
    dirname=filespec("path",found.i)
    dirname=filespec("name",substr(dirname,1,length(dirname)-1))
    downloaddir=filespec("drive",found.i)filespec("path",found.i)
    rc=lineout(areactl,"Area "prebbs""dirname)
    rc=lineout(areactl,"  FileInfo   "filespec("path",found.i))
    rc=lineout(areactl,"  FileAccess "accesslevel)
    rc=lineout(areactl,"  FileList   "bbsdir"\"newbbsname)
    rc=lineout(areactl,"  Download   "downloaddir)
    rc=lineout(areactl,"End Area")
    rc=lineout(areactl," ")
    say "Processing "found.i
    filefound=0
    do while lines(found.i)>0    /*scan found files.bbs line per line*/
      fbbs=linein(found.i)
      fpath=filespec("drive",found.i)filespec("path",found.i)
      filename=translate(strip(word(fbbs,1)))
      fdesc=subword(fbbs,descstartword,300)
      if pos(".",filename)<>0 then do
        filefound=1
        rc=charout(,filename" ")
        parse value filename with fname "." fext
        diz=0
        if IncludeFileId="Y" then do /* include File_ID.Diz ?? */
          select
            when fext="ZIP" then do
                DoUnzip""fpath""fname" "dizname" >nul"
                rc=SysFileTree(dizname,dizfind,"FO")
                if dizfind.0>0 then
                  diz=1
              end
            when fext="ARJ" then do
                DoUnarj""fpath""fname" "dizname" >nul"
                rc=SysFileTree(dizname,dizfind,"FO")
                if dizfind.0>0 then
                  diz=1
              end
            otherwise
          end
        end
        if diz=1 then do
          do while lines(dizname)>0 /*copy diz-file when found*/
            rc=lineout(newbbsname,left(filename,15)""linein(dizname))
            filename=""
          end
          rc=lineout(dizname)
          "@del "dizname
        end
        else rc=lineout(newbbsname,left(filename,15)""fdesc)
      end
      else do /*not a filename, extended description ?*/
        if filefound=1 then do
          fbbs=strip(fbbs)
          if fbbs<>"" then do
            if substr(fbbs,1,1)="|" then
              fbbs=delstr(fbbs,1,1)
            rc=lineout(newbbsname,left("",15)""fbbs)
          end
          else filefound=0
        end
      end
    end
    rc=lineout(found.i)
    rc=lineout(newbbsname)
  end
  rc=lineout(areactl)
  say "SCANCD finished Ok"
end
else say "No FILES.BBS Files found in Target Directory"
currdir=directory(currdir)
