/* OffTag tagger.cfg Configuration Program                            */

/*Constants*/

/*Color Values*/
BLACK  =0
RED    =1
GREEN  =2
BROWN  =3
BLUE   =4
MAGENTA=5
CYAN   =6
LIGHTGRAY   =7
DARKGRAY    =8
LIGHTRED    =9
LIGHTGREEN  =10
YELLOW      =11
LIGHTBLUE   =12
LIGHTMAGENTA=13
LIGHTCYAN   =14
WHITE       =15

collist="BLACK RED GREEN BROWN BLUE MAGENTA CYAN LIGHTGRAY DARKGRAY "
collist=collist"LIGHTRED LIGHTGREEN YELLOW LIGHTBLUE LIGHTMAGENTA LIGHTCYAN "
collist=collist"WHITE "

syscols="BLACK BLUE GREEN CYAN RED MAGENTA BROWN LIGHTGRAY DARKGRAY "
syscols=syscols" LIGHTBLUE LIGHTGREEN LIGHTCYAN LIGHTRED LIGHMAGENTA YELLOW WHITE "

/*ANSI Codes*/
CLREOL=D2C(27)"[K"
CLRSCR=D2C(27)"[2J"
CRLF=D2C(13)D2C(10)

/*Keyboard Codes*/
UP_KEY   =D2C(0)D2C(72)
DOWN_KEY =D2C(0)D2C(80)
LEFT_KEY =D2C(0)D2C(75)
RIGHT_KEY=D2C(0)D2C(77)
HOME_KEY =D2C(0)D2C(71)
END_KEY  =D2C(0)D2C(79)
PGUP_KEY =D2C(0)D2C(73)
PGDN_KEY =D2C(0)D2C(81)
INS_KEY  =D2C(0)D2C(82)
DEL_KEY  =D2C(0)D2C(83)
F1_KEY   =D2C(0)D2C(59)
F2_KEY   =D2C(0)D2C(60)
F3_KEY   =D2C(0)D2C(61)
F4_KEY   =D2C(0)D2C(62)
F5_KEY   =D2C(0)D2C(63)
F6_KEY   =D2C(0)D2C(64)
F7_KEY   =D2C(0)D2C(65)
F8_KEY   =D2C(0)D2C(66)
F9_KEY   =D2C(0)D2C(67)
F10_KEY  =D2C(0)D2C(68)
ALTX_KEY =D2C(0)D2C(45)
STAB_KEY =D2C(0)D2C(15)
CR=D2C(13)
ESC=D2C(27)
TAB=D2C(9)
BS=D2C(8)

/*Global Variables*/
lastkey=""
winx1=0
winy1=0
winx2=79
winy2=24
EditHigh=21
Foreground=LIGHTGRAY
Background=BLACK
datafile="confinfo.dat"
taggercfg="tagger.cfg"
taggercfgnew="tagger.cf$"
sections="PARAMETERS FILEPATHS COLORS MISCELLANEOUS SPEEDADAPT PROTOCOLS FILEMANAGER EXTERNAL"
/*Exposure list for global variables/constants*/

globals="lastkey winx1 winy1 winx2 winy2 Foreground Background "
globals=globals"datafile CInfo. EditHigh Sections "

globals=globals"CLREOL CLRSCR CRLF "collist" syscols collist taggercfg taggercfgnew "

globals=globals"UP_KEY DOWN_KEY LEFT_KEY RIGHT_KEY HOME_KEY END_KEY "
globals=globals"PGUP_KEY PGDN_KEY INS_KEY DEL_KEY F1_KEY F2_KEY F3_KEY "
globals=globals"F4_KEY F5_KEY F6_KEY F7_KEY F8_KEY F9_KEY F10_KEY "
globals=globals"ALTX_KEY STAB_KEY CR ESC TAB BS "



call RxFuncAdd "SysFileTree", "RexxUtil", "SysFileTree"
call RxFuncAdd "SysCurPos", "RexxUtil", "SysCurPos"
call RxFuncAdd "SysGetKey", "RexxUtil", "SysGetKey"


sections="PARAMETERS FILEPATHS COLORS MISCELLANEOUS SPEEDADAPT PROTOCOLS FILEMANAGER EXTERNAL"
men.values=sections
men.0=4
men.1="Parameters"
men.Info.1="permanently used run-time parameters"
men.2="Filepaths"
men.Info.2="locations and names of used files"
men.3="Colors"
men.Info.3="colors of Tagger-display"
men.4="Miscellaneous"
men.Info.4="limits,formats,etc."
men.5="SpeedAdapt"
men.Info.5="how the Tagger-display adapts to BPS-rates"
men.6="Protocols"
men.Info.6="download-protocol menu and actions"
men.7="Filemanager"
men.Info.7="settings for the Filemanager-mode"
men.8="External"
men.Info.8="external per-file programs/scripts, archive-viewer, vircheck, touch, etc."

rc=InitCInfo()
rc=ReadConfig()

do until lastkey<>ESC
  lastkey=""
  do until lastkey=ESC
    rc=Charout(,SetColor(Black,LightGray)CLRSCR""SetColor(Red,LightGray))
    say "  Ŀ          Ŀ            ķ    ķ    Ŀ "
    say "                                                    "
    say "        Ŀ Ŀ       Ŀ Ŀ            Ŀ Ŀ Ŀ    Ŀ"
    say "                    Ĵ  Ŀ                              "
    say "                       o               "

    rc=Charout(,At(1,22)SetColor(Blue,LightGray)"look here for specific info Ŀ")
    rc=Charout(,At(40,23)"")
    rc=Charout(,At(70,23)SetColor(DarkGray,LightGray)"(pure REXX)")
    Sec=VerMenu("Select the section to configure:",1,White,Blue)
    if lastkey<>ESC then do
      rc=EditSection(Sec)
      lastkey=""
    end  
  end  
  rc=Charout(,SetColor(Black,LightGray)CLRSCR)
  SaveIt=Decision("Save Configuration ?","Save  Forget", "Save", White, Blue )
end
if SaveIt="Save" then do
  rc=WriteConfig()
  say SetColor(White,Black)CLRSCR""At(1,3)"Configuration saved in Tagger.CFG"
end
else  
  say SetColor(White,Black)CLRSCR""At(1,3)"Configuration NOT saved."

Exit
/*********************************************************************/

/*Init the Field-Info Structure*/

InitCInfo:
  do while lines(datafile)
    line=linein(datafile)
/*    trace intermediate*/
    parse upper value line with Sec "|"
    if Sec<>";" & Sec<>"" then do
      if(Symbol("Cinfo.Sec.Num")="LIT") then do
        Cinfo.Sec.Num=0
        CInfo.Sec.Idx=""
      end  
      Cinfo.Sec.Num=Cinfo.Sec.Num+1
      count=Cinfo.Sec.Num  
      parse value line with name "|" CInfo.Sec.Token.count "|" CInfo.Sec.Type.count "|" CInfo.Sec.Default.count "|" CInfo.Sec.Info.count "|" CInfo.Sec.Help.count

      CInfo.Sec.Idx=CInfo.Sec.Idx""CInfo.Sec.Token.count" "

      CInfo.Sec.Value.count=CInfo.Sec.Default.count
      CInfo.Sec.Active.count=0
/*      say CInfo.Sec.Info.count*/
    end
  end
  rc=lineout(datafile)  
  return count<>0

WriteConfig: Procedure Expose (globals)
  "@if exist "taggercfgnew" del "taggercfgnew
  sec=""
  do while lines(taggercfg)
    orgline=linein(taggercfg)
    line=Strip(orgline)
    if substr(line,1,1)<>";" & line<>"" then do
      Keyword=Translate(word(line,1))
      if sec="" then do   /*no active Section -> Section starting ?*/
        If WordPos(Keyword,sections)>0 then do
          sec=Keyword
          rc=lineout(taggercfgnew,orgline)
        end  
      end
      else do  /*active Section -> Section Ending ?*/
        if Keyword="END" then do
          If Symbol("Cinfo.Sec.Num")<>"LIT" then
            do c=1 to CInfo.Sec.Num /*Write new Keywords before End*/
              if CInfo.Sec.Active.c=1 then 
                rc=lineout(taggercfgnew,"  "Left(Cinfo.Sec.Token.c,18)" "CInfo.Sec.Value.c)
            end
          rc=lineout(taggercfgnew,orgline)
          sec=""
        end  
        else do
          c=WordPos(Keyword,CInfo.Sec.Idx)  /*known Keyword ?*/         
          If c>0 then do
            if CInfo.Sec.Active.c=1 then do
              CInfo.Sec.Active.c=0 /*Set inactive and write Keyw+Value*/
              rc=lineout(taggercfgnew,"  "Left(word(line,1),18)" "CInfo.Sec.Value.c)
            end  
          end
          else rc=lineout(taggercfgnew,orgline) /*write unknown keyword back ??*/
        end  
      end
    end
    else 
      rc=lineout(taggercfgnew,orgline)
  end  
  rc=lineout(taggercfgnew)
  rc=lineout(taggercfg)
  "@del "taggercfg
  "@ren "taggercfgnew" "taggercfg
  return 0
  
ReadConfig: Procedure Expose (globals)
  sec=""
  do while lines(taggercfg)
    line=Strip(linein(taggercfg))
    if substr(line,1,1)<>";" & line<>"" then do
      Keyword=Translate(word(line,1))
      if sec="" then do   /*no active Section -> Section starting ?*/
        If WordPos(Keyword,sections)>0 then
          sec=Keyword
      end
      else do  /*active Section -> Section Ending ?*/
        if Keyword="END" then 
          sec=""
        c=WordPos(Keyword,CInfo.Sec.Idx)  /*known Keyword ?*/
        If c>0 then do
          CInfo.Sec.Active.c=1 /*Set active and read value*/
          If length(Word(line,2))>0 then do
            CInfo.Sec.Value.c=SubStr(line,WordIndex(line,2),length(line)-WordIndex(line,2)+1)

            if Sec="COLORS" then do  /*still Number ? -> convert*/
              if Datatype(CInfo.Sec.Value.c,"N") then do
                myfore=CInfo.Sec.Value.c // 16
                myback=(CInfo.Sec.Value.c-myfore) %  16
                CInfo.Sec.Value.c=word(syscols,myfore+1)" ON "word(syscols,myback+1)
              end
            end

          end
          else
            CInfo.Sec.Value.c=""  
        end
      end
    end
  end  
  rc=lineout(taggercfg)
  return 0
  
/*********************************************************************/

EditSection: Procedure Expose (globals)
  parse arg sec

  rebuild=1
  top=0
  line=1
  lastkey=""
  win=SaveWinCoords()
  rc=Frame(" "Sec" Section ",1,1,80,23,LightCyan,Blue)
  do until lastkey=ESC
    if rebuild=1 then do
      rc=ShowSection(sec,top)
      rebuild=0
    end
    rebuild=EditField(sec,top+line,line)
    c=top+line
    select
      when length(lastkey)=1 & lastkey=" " then do
        if CInfo.Sec.Active.c=1 then
          CInfo.Sec.Active.c=0
        else
          CInfo.Sec.Active.c=1
        rc=ShowField(Sec,c,line)
      end  
      when lastkey=DOWN_KEY then
        if top+line<CInfo.Sec.Num then do       
          line=line+1
          if line>EditHigh then do
            line=1
            top=top+EditHigh
            rebuild=1
          end
        end  
      when lastkey=UP_KEY then
        if top+line>1 then do       
          line=line-1
          if line<=0 then do
            line=EditHigh
            top=top-EditHigh
            rebuild=1
          end
        end  
      when lastkey=PGUP_KEY then
        if top>0 then do
          top=top-EditHigh
          rebuild=1
        end
        else line=1
      when lastkey=PGDN_KEY then
        if top+EditHigh<=CInfo.Sec.Num then do
          top=top+EditHigh
          if top+line>CInfo.Sec.Num then
            line=CInfo.Sec.Num-Top
          rebuild=1
        end          
        else line=CInfo.Sec.Num-Top
            
      Otherwise  
    end  
  end
  rc=RestoreWinCoords(win)
  return 0

ShowSection: Procedure Expose (globals)
  parse arg sec,top
  
  do i=1 to EditHigh
    if top+i<=CInfo.Sec.Num then
      rc=ShowField(sec,top+i,i)
    else do
      rc=CharOut(,at(1,i)SetColor(LightCyan,Blue))
      rc=SpaceEol()
    end  
  end
  return 0

/*Show Fieldtext and Value*/
ShowField: Procedure Expose (globals)
  parse arg sec,c,line
  
  if CInfo.Sec.Active.c=1 then do
    rc=CharOut(,At(1,line)SetColor(LightCyan,Blue)" "Left(CInfo.Sec.Info.c,21)"  ")
    rc=SpaceEol()
    rc=ShowFieldValue(CInfo.Sec.Type.c,CInfo.Sec.Value.c,1,line)
  end
  else do  
    rc=CharOut(,At(1,line)SetColor(DarkGray,Blue)"("Left(CInfo.Sec.Info.c,21)") ")
    rc=SpaceEol()
    rc=ShowFieldValue(CInfo.Sec.Type.c,CInfo.Sec.Default.c,0,line)
  end  
  return 0

/*Display Fieldvalue, depending on Type*/  
ShowFieldValue: Procedure Expose (globals)
  parse arg type,val,active,line
  
  rc=Charout(,at(25,line))
  Select
    when type="C" then do/*Color*/
      rc=CharOut(,SetColorFromString(val)"XXXXXXX")
    end
    when type="F" then do/*Flag*/
      rc=CharOut(,SetColor(White,Blue))
      if Active=1 then
        rc=CharOut(,"ON ")
      else
        rc=CharOut(,"OFF")
    end
    when Substr(type,1,1)="S" then do /*String+Length*/
      len=substr(type,2,length(type)-1)
      rc=CharOut(,SetColor(Black,Cyan)Left(val,len))
    end
    when Substr(type,1,1)="N" then do /*String+Length*/
      len=substr(type,2,length(type)-1)
      rc=CharOut(,SetColor(Black,Cyan)Right(val,len))
    end
    Otherwise
  end
  return 0

/*Edits a given field, Returns 1 if Screen has to be rebuilt*/
EditField: Procedure Expose (globals)
  parse arg sec,c,line
  
  rc=helpline("Select Field:   Pg Pg  Set Value with < | ON/OFF = SPACE  Abort = ESC")
  rebuild=0
  rc=InfoLine(CInfo.Sec.Help.c)
  Select
    when CInfo.Sec.Type.c="C" then do
      rc=CharOut(,at(25,line)) /*Position Cursor*/
      key=GetKey()
      if key=CR then do
        win=SaveWinCoords()
        CInfo.Sec.Value.c=EditColor(CInfo.Sec.Value.c)
        rc=RestoreWinCoords(win)

/*        rc=CharOut(,SetColor(White,Black))
        trace intermediate*/
        
        CInfo.Sec.Active.c=1       
        rc=ShowField(sec,c,line)
        lastkey=""
      end  
    end
    when CInfo.Sec.Type.c="F" then do
      rc=CharOut(,at(25,line)) /*Position Cursor*/
      key=GetKey()
      if key=CR then do
        if CInfo.Sec.Active.c=1 then
          CInfo.Sec.Active.c=0
        else
          CInfo.Sec.Active.c=1
        rc=ShowField(sec,c,line)
        lastkey=""
      end  
    end
    when Substr(CInfo.Sec.Type.c,1,1)="S" | Substr(CInfo.Sec.Type.c,1,1)="N"  then do
      rc=CharOut(,at(25,line)) /*Position Cursor*/
      key=GetKey()
      if key=CR then do
        len=substr(CInfo.Sec.Type.c,2,length(CInfo.Sec.Type.c)-1)
        If Substr(CInfo.Sec.Type.c,1,1)="N" then
          CInfo.Sec.Value.c=InputNumber(CInfo.Sec.Value.c,25,line,len,White,Red)
        else
          CInfo.Sec.Value.c=Input(CInfo.Sec.Value.c,25,line,len,White,Red)
        CInfo.Sec.Active.c=1       
        rc=ShowField(sec,c,line)
        lastkey=""
      end  
    end  
    Otherwise
  end
  return rebuild    


EditColor: Procedure Expose (globals)
  parse upper arg fore "ON" back
  
  rc=Helpline("Select Color with "D2C(17)" "D2C(16)" "D2C(24)" "D2C(25)"  Save with < | Abort with ESC")
  rc=frame("Set Color",39,6,60,15,Black,LightGray)
  do yp=0 to 7
    line=at(3,yp+1)
    do xp=0 to 15
      line=line""SetColor(xp,yp)"X"
    end
    rc=CharOut(,line)
  end
  
  xp=WordPos(fore,collist)-1
  if xp<0 then xp=0
  yp=WordPos(back,collist)-1
  if yp<0 then yp=0
  key=""
  do until key=CR | key=ESC
    cx=xp+2
    cy=yp+1
    rc=Charout(,SetColor(Black,Cyan)at(cx,cy)">"at(cx+2,cy)"<")
    key=GetKey()
    if xp-1>=0 then
      rc=CharOut(,at(cx,cy)SetColor(xp-1,yp)"X")
    else
      rc=CharOut(,at(cx,cy)SetColor(Black,LightGray)" ")
      
    if xp+1<=15 then
      rc=CharOut(,at(cx+2,cy)SetColor(xp+1,yp)"X")
    else
      rc=CharOut(,at(cx+2,cy)SetColor(Black,LightGray)" ")
    
    select
      when key=UP_KEY then
        if yp>0 then yp=yp-1
      when key=DOWN_KEY then
        if yp<7 then yp=yp+1
      when key=LEFT_KEY then
        if xp>0 then xp=xp-1
      when key=RIGHT_KEY then
        if xp<15 then xp=xp+1
      otherwise
    end  
  end
  rc=frame("",39,6,60,15,Blue,Blue)
  if key=CR then
    return Word(Collist,xp+1)" ON "Word(Collist,yp+1)
  else
    return fore" ON "back  
  
SetColorFromString: Procedure Expose (globals)
/*  parse upper arg fore "ON" back*/
  parse arg color
  
  fore=Translate(word(color,1))
  back=Translate(word(color,3))
  return SetColor(WordPos(fore,collist)-1,WordPos(back,collist)-1)


/***************************************************************************/
/* Console I/O handling: */

/*Update the 2nd lowest Line*/
Infoline: Procedure Expose (globals)
  parse arg str
  
  win=SaveWinCoords()
  fore=Foreground
  back=Background
  rc=Window(1,24,80,24)
  rc=Charout(,at(1,1)SetColor(White,Black)ClrEol)
  rc=Charout(,at(Centerx(str),1)str)
  rc=RestoreWinCoords(win)
  rc=Charout(,SetColor(fore,back))
  return 0

/*Updates the lowest Line*/
Helpline: Procedure Expose (globals)
  parse arg str
  
  win=SaveWinCoords()
  y2=winy2
  fore=Foreground
  back=Background
  rc=Window(1,25,80,25)
  rc=Charout(,at(1,1)SetColor(Black,Cyan)ClrEol)
  rc=Charout(,at(Centerx(str),1)str)
  rc=RestoreWinCoords(win)
  rc=Charout(,SetColor(fore,back))
  return 0

SaveWinCoords:
  return winx1+1" "winy1+1" "winx2+1" "winy2+1
  
RestoreWinCoords:
  rc=Window(Word(arg(1),1),Word(arg(1),2),Word(arg(1),3),Word(arg(1),4))
  return 0

VerMenu: Procedure Expose (globals) men.
  parse arg title,cItem,Fore,Back 

  win=SaveWinCoords()
  line=WordPos(cItem,men.values)
  if line=0 then line=1
  rc=Helpline("Choose with "D2C(24)" "D2C(25)"  Select with < | Abort with ESC")
  width=length(title)
  do i=1 to Men.0
    if length(Men.i)>width then
      width=length(Men.i)
  end    
  width=width+5
  rc=Frame(title,CenterX(left("",width)),11-(Men.0 % 2),CenterX(Left("",width))+width-1,11-(Men.0 %2)+Men.0+3,Fore,Back)
  do i=1 to Men.0
    rc=Charout(,At(CenterX(Men.i),i+1)Men.i)
  end  
  lastkey="" 
  do until lastkey=CR | lastkey=ESC
    rc=InfoLine(men.Info.line)
    rc=Charout(,At(2,line+1)SetColor(Black,Cyan)Left("",width-5)At(CenterX(Men.line),line+1)Men.line)
    key=GetKey()
    rc=Charout(,At(2,line+1)SetColor(Fore,Back)Left("",width-5)At(CenterX(Men.line),line+1)Men.line) 
    select
      when key=DOWN_KEY then
        if line<men.0 then
          line=line+1
        else
          line=1
      when key=UP_KEY then
        if line>1 then
          line=line-1
        else
           line=men.0
      Otherwise
    end           
  end  
  rc=RestoreWinCoords(win)
  if lastkey=CR then
    return Word(men.Values,line)
  else
    return cItem

/* Displays a Framed window with a horizontal Menu*/
Decision: Procedure Expose (globals)
  parse arg title,Items,cItem,Fore,Back 

  win=SaveWinCoords()
  rc=Helpline("Choose with "D2C(17)" "D2C(16)"  Select with < | Abort with ESC")
  width=length(Title)
  if length(Items)>width then
    width=length(Items)
  width=width+6
  width=Left("",width)
  rc=Frame(title,CenterX(width),10,CenterX(width)+length(width)-1,14,Fore,Back)
  lastkey=""
  do until lastkey=CR | lastkey=ESC
   cItem=HorMenu(Items,cItem,CenterX(Items),2)
  end  
  rc=RestoreWinCoords(win)
  return cItem

/*gibt die Anzahl der Spaces zurueck, die das Bild bis zum rechten Fenster auffuellen*/
SpaceEol: Procedure Expose(globals)

  parse value SysCurPos() with ypos xpos
  rc=CharOut(,Left("",winx2-xpos+1," "))
  return 0

/*returns the xpos for the string to be placed centered in the window*/
CenterX: Procedure Expose (globals)
  parse arg str
  
  len=length(str)
  r=(winx2-winx1+1) % 2 - (len % 2) + 1
  if r<1 then
    return 1
  else
    return r   

/*Horizontal Menu, returns the selected string or ""*/
HorMenu: Procedure Expose (globals)
  parse arg Items,cItem,x1,y1
  
  if cItem="" then 
    choice=1
  else
    choice=WordPos(cItem" ",Items)
  oldfore=Foreground
  oldback=Background 
  rc=Helpline("Move: HOME END "D2C(17)" "D2C(16)"  Ok =  <   | Abort = ESC")
  do until key=CR | key=ESC | key=UP_KEY | key=DOWN_KEY | key=TAB | key=STAB_KEY
    rc=CharOut(,SetColor(oldfore,oldback)at(x1,y1)" "Items" ")
    rc=CharOut(,SetColor(BLACK,CYAN)at(x1+WordIndex(Items,Choice)-1,y1)" "Word(Items,Choice)" ")
    key=GetKey()
    Select
      when Key=LEFT_KEY then
        if choice>1 then
          choice=choice-1
        else
          choice=words(Items)
      when Key=RIGHT_KEY then
        if choice<words(Items) then
          choice=choice+1
        else
          choice=1
      Otherwise
    end   
  end
  rc=CharOut(,SetColor(oldfore,oldback))
  if Key=ESC then
    return ""
  else
    return Word(Items,choice)
end

/*Gets a Keycode (also extended), lastkey is global*/
GetKey: Procedure Expose (globals)
  lastkey=SysGetKey("NOECHO")
  if lastkey=X2C("E0") then
    lastkey=D2C(0)
  if lastkey=D2C(0) then
    lastkey=lastkey""SysGetKey("NOECHO")
  return lastkey

/*Input a string*/
Input: procedure Expose (globals)
  parse arg fval,x1,y1,len,fore,back
  return InputAll(fval,x1,y1,len,fore,back,"N")

/*Input a number*/
InputNumber: procedure Expose (globals)
  parse arg fval,x1,y1,len,fore,back
  return InputAll(fval,x1,y1,len,fore,back,"J")

InputAll: procedure Expose (globals)
  parse arg fval,x1,y1,len,fore,back,numbers
  orgfval=fval
  epos=length(fval)
  rc=CharOut(,SetColor(fore,back))
  key=""
  do until key=CR | key=ESC | key=TAB | key=STAB_KEY | key=UP_KEY | key=DOWN_KEY
    rc=Charout(,At(x1,y1)Left(fval,len," ")At(x1+epos,y1))
    key=GetKey()
    Select
      when length(key)=1 & C2D(Key)>=32 & C2D(Key)<=255 then
        if numbers="N" | (key>='0' & key<='9') then
          if length(fval)<len & epos<len then do
            fval=Insert(key,fval,epos)
            epos=epos+1
          end
      when Key=BS then
        if epos>0 then do
          epos=epos-1
          fval=DelStr(fval,epos+1,1)
        end  
      when Key=DEL_KEY then
        fval=DelStr(fval,epos+1,1)
      when Key=LEFT_KEY then
        if epos>0 then epos=epos-1        
      when Key=RIGHT_KEY then
        if (numbers="N" & epos<len) | epos<length(fval) then epos=epos+1
      when Key=END_KEY then
        epos=length(fval)
      when Key=HOME_KEY then
        epos=0    
      Otherwise
    end    
  end
  trace off
  if key<>ESC then
    return fval
  else
    return orgfval

/*Set window coordinates for relative at()-command*/
Window: Procedure Expose (Globals)
  parse arg x1,y1,x2,y2
  winx1=x1-1
  winy1=y1-1
  winx2=x2-1
  winy2=y2-1
  return 0
    
/*draw frame, fill it with the color and set the window-coords*/
Frame: procedure Expose (globals)
  parse arg title,x1,y1,x2,y2,fore,back 
  rc=window(1,1,80,25)
  rc=CharOut(,at(x1,y1)SetColor(fore,back)""left("",x2-x1-1,"")"");
  i=y1+1
  do while i<y2
    rc=CharOut(,at(x1,i)""left("",x2-x1-1," ")"")
    i=i+1
  end
  rc=CharOut(,at(x1,y2)""left("",x2-x1-1,"")"");
  rc=Window(x1+1,y1+1,x2-1,y2-1)
  rc=CharOut(,at(Centerx(title),0)title""at(1,1))
return 0

/*returns an ansi-string which sets a color*/
SetColor: procedure Expose (globals)
  parse arg Fore,Back
  Foreground=Fore
  Background=Back
  if Back<0 then Back=0
  if Fore<0 then Fore=0
  if Fore>7 then 
    return D2C(27)"[1;"Fore+22";"Back+40"m"
  else 
    return D2C(27)"[0;"Fore+30";"Back+40"m"

/*returns an ansi-string which positions the cursor*/
At: procedure Expose (globals)
  parse arg xpos,ypos
  return D2C(27)"["ypos+winy1";"xpos+winx1"H"

