/* 

  This one generates a file announcement out of your tagged files, 
  (preferrably) use this in a seperate cfg-file locally. 
  filedesc.hdr should hold the header of your announcement and
  filedesc.ftr should be the footer.
  Adjust the variable "destfile" to the path where you want the
  announcement to be created.

  Include this cmd-file in your "local" cfg-file for the tagger in the
  Protocols Section like that:
  
  NoQuit P Generate_file-announcement FILEDESC.CMD

*/
call RxFuncAdd "SysFileTree", "RexxUtil", "SysFileTree"
call RxFuncAdd "SysFileSearch", "RexxUtil", "SysFileSearch"
arg com node filelist

destfile="d:\timed\tagger"
dlcounterid="[" /*identifies dlcounter*/

namewid=13
sizewid=6
datewid=10
linewid=75
leftwid=namewid+sizewid+datewid
descwid=linewid-leftwid

copy "filedesc.hdr" destfile
filenum=0
line=linein(filelist)
do while line<>""
  fname=word(line,1)
  name=left(filespec("name",fname),namewid)
  size=format(word(line,2) / 1024,sizewid-1,0)"k"
  date=" "left(word(line,3),datewid-1)
  linedesc=delword(line,1,3)
  if substr(linedesc,1,1)="[" then  /*remove Dl-Counter (one word)*/
    linedesc=delword(linedesc,1,1)
  first=1
  do while first=1 | word(linedesc,1)<>"" /*do once for each wrapped line*/
    if first then do
      first=0
      leftspace=name""size""date""
    end
    else leftspace=left("",leftwid)
    i=0
    do while length(subword(linedesc,1,i+1))<descwid & word(linedesc,i+1)<>""
      i=i+1 /*count max words to fill one line*/
    end 
    if i=0 then do /*cut word if too long*/
      thisline=substr(linedesc,1,descwid)
      linedesc=substr(linedesc,descwid+1,length(linedesc)-descwid)
    end 
    else do 
      thisline=subword(linedesc,1,i)
      linedesc=delword(linedesc,1,i)
    end
    rc=lineout(destfile,leftspace""thisline)
  end
  line=linein(filelist)
end
rc=lineout(filelist)
rc=lineout(destfile)
type "filedesc.ftr >> "destfile
exit
