#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "msgapi.h"

#define BUFSIZE 8192

#define msgtype(x) (*(x)=='$' ? MSGTYPE_SQUISH : MSGTYPE_SDM)
#define msgname(x) (*(x)=='$' ? (x)+1 : (x))

void segviol() {
  abort();
}

int dosftime(char *buf, int size, char *format, struct _stamp time) {
struct tm mytime;

mytime.tm_mday=time.date.da;
mytime.tm_mon =time.date.mo;
mytime.tm_year=time.date.yr+80;
mytime.tm_hour=time.time.hh;
mytime.tm_min =time.time.mm;
mytime.tm_sec =time.time.ss;

return strftime(buf,size,format,&mytime);
}

char *fido(NETADDR *n) {
static char buf[25];

  sprintf(buf,"%d:%d/%d.%d",n->zone,n->net,n->node,n->point);
return buf;
}

int main(int argc,char *argv[]) {
XMSG msg;
HAREA in_area;
HMSG in_msg;
struct _minf mi;
char *ctrl,*buffer,*name,*p,*q;
dword offset, msgn;
long got;
int ctrllen,type;

  if (argc<2) {
    fprintf(stderr,"Areaname expected\n");
    exit(1);
  }

  type=msgtype(argv[1]);

  name=strdup(msgname(argv[1]));

  printf("Reading %s Area %s\n",
	 type==MSGTYPE_SQUISH ? "Squish" : "*.Msg",name);

  signal(SIGSEGV,segviol);

  memset(&mi, '\0', sizeof mi);
  mi.req_version=1;
  mi.def_zone=2;

  mi.palloc   = mi.farpalloc   = malloc;
  mi.repalloc = mi.farrepalloc = realloc;
  mi.pfree    = mi.farpfree    = free;

  MsgOpenApi(&mi);

  if ((in_area=MsgOpenArea(name, MSGAREA_NORMAL, type))==NULL) {
    printf("Error opening area `%s' (type %s) for read!\n",
	   name,type==MSGTYPE_SQUISH ? "Squish" : "*.Msg");
    exit(1);
  }
/*
  MsgLock(in_area);
*/
  if ((buffer=malloc(BUFSIZE))==NULL)
  {
    printf("Error!  Ran out of memory...\n");
    exit(1);
  }

  for (msgn=1L; msgn <= MsgHighMsg(in_area); msgn++) {
    if ((in_msg=MsgOpenMsg(in_area,MOPEN_READ,msgn))==NULL)
      continue;

    ctrllen=(int)MsgGetCtrlLen(in_msg);

    if ((ctrl=malloc(ctrllen))==NULL)
      ctrllen=0;

    MsgReadMsg(in_msg, &msg, 0L, 0L, NULL, ctrllen, ctrl);
    ConvertControlInfo(ctrl,&msg.orig,&msg.dest);

    dosftime(buffer,20,"%d %m %y, %H:%M:%S",msg.date_written);
    printf("From: %s, %s (%s)\n",msg.from,fido(&msg.orig),buffer);
    dosftime(buffer,20,"%d %m %y, %H:%M:%S",msg.date_arrived);
    printf("To:   %s, %s (%s)\n",msg.to,fido(&msg.dest),buffer);
    printf("Subj: %s\n",msg.subj);

    printf("Ctrlsize %d, Textsize %d\n--- Message start\n",
	   ctrllen,MsgGetTextLen(in_msg));

    if (((p=ctrl)!=NULL) && *ctrl) {
      while (*p) {
	switch (*p) {
	  case '\001':
	    putchar('@');
 	    break;
	  default:
	    putchar(*p);
 	    break;
	}
	++p;
	if ((*p && (*p=='\001')) ||
	    (*p=='\0'))
	  putchar('\n');
      }
    }

    for (offset=0L;
	 offset < MsgGetTextLen(in_msg);
	 ) {
      got=MsgReadMsg(in_msg, NULL, offset, BUFSIZE, buffer, 0L, NULL);

      if (got <= 0)
        break;

      buffer[got]='\0';

      for (p=buffer; *p, (q=strpbrk(p,"\r\n"))!=NULL; p=q+1) {
	if (q) *q='\0';
        puts(p);
      }
      offset += got;
    }

    if (ctrl)
      free(ctrl);

    printf("--- Message end\n");
    MsgCloseMsg(in_msg);
  }

  free(buffer);
  MsgCloseArea(in_area);
/*
  MsgUnlock(in_area);
*/
  MsgCloseApi();

  free(name);
  return 0;
}
