/* $Id: MSGAPI.H 1.4 1994/04/01 12:15:26 sjd Exp sjd $ */

#ifndef __SQAPI_H_DEFINED
#define __SQAPI_H_DEFINED
#define __MSGAPI_H_DEFINED

#include <stdio.h>
#include <stdlib.h>
#include "stamp.h"
#include "typedefs.h"
#include "compiler.h"

#define MSGAPI
#define MSGAPI_VERSION 1

struct _msgapi;
struct _msgh;
struct _netaddr;
struct _xmsg;

#if !defined(MSGAPI_NO_OLD_TYPES)
  typedef struct _msgapi MSG;
  typedef struct _msgh MSGH;
#endif

/* Handle special code for OS/2 DLLs */

#define OS2LOADDS
#define OS2FAR

/* Definitions for MsgAPI 0.4+ */

typedef struct _msgapi *HAREA;
typedef struct _msgh *HMSG;

typedef struct _xmsg XMSG;
typedef struct _xmsg *PXMSG;

typedef struct _netaddr NETADDR;
typedef NETADDR *PNETADDR;

typedef dword UMSGID;

/* MsgOpenArea(name, MODE, type); */

#define MSGAREA_NORMAL  0x00
#define MSGAREA_CREATE  0x01
#define MSGAREA_CRIFNEC 0x02

/* MsgOpenArea(name, mode, TYPE); */

#define MSGTYPE_SDM     0x01
#define MSGTYPE_SQUISH  0x02
#define MSGTYPE_ECHO    0x80

/* MsgOpenMsg(mh, mode, N); */

#define MSGNUM_CUR      (dword)-1L
#define MSGNUM_PREV     (dword)-2L
#define MSGNUM_NEXT     (dword)-3L

#define MSGNUM_current  MSGNUM_CUR
#define MSGNUM_previous MSGNUM_PREV
#define MSGNUM_next     MSGNUM_NEXT

/* MsgOpenMsg(mh, MODE, n); */

#define MOPEN_CREATE    0
#define MOPEN_READ      1
#define MOPEN_WRITE     2
#define MOPEN_RW        3

/* MsgUidToMsgn(mh, umsgid, TYPE) */

#define UID_EXACT     0x00
#define UID_NEXT      0x01
#define UID_PREV      0x02

/* Values for 'msgapierr' */

#define MERR_NONE   0     /* No error                                       */
#define MERR_BADH   1     /* Invalid handle passed to function              */
#define MERR_BADF   2     /* Invalid or corrupted file                      */
#define MERR_NOMEM  3     /* Not enough memory for specified operation      */
#define MERR_NODS   4     /* Maybe not enough disk space for operation      */
#define MERR_NOENT  5     /* File/message does not exist                    */
#define MERR_BADA   6     /* Bad argument passed to msgapi function         */
#define MERR_EOPEN  7     /* Couldn't close - messages still open           */
#define MERR_NOLOCK 8     /* Base needs to be locked to perform operation   */
#define MERR_SHARE  9     /* Resource in use by other process               */
#define MERR_EACCES 10    /* Access denied (can't write to read-only, etc)  */
#define MERR_BADMSG 11    /* Bad message frame (Squish)                     */
#define MERR_TOOBIG 12    /* Too much text/ctrlinfo to fit in frame (Squish)*/


/* Bitmasks for XMSG.attr */

#define MSGPRIVATE 0x0001
#define MSGCRASH   0x0002
#define MSGREAD    0x0004
#define MSGSENT    0x0008
#define MSGFILE    0x0010
#define MSGFWD     0x0020
#define MSGORPHAN  0x0040
#define MSGKILL    0x0080
#define MSGLOCAL   0x0100
#define MSGHOLD    0x0200
#define MSGXX2     0x0400
#define MSGFRQ     0x0800
#define MSGRRQ     0x1000
#define MSGCPT     0x2000
#define MSGARQ     0x4000
#define MSGURQ     0x8000

#define MSGSCANNED 0x00010000L  /* Message has been exported to the network */
#define MSGUID     0x00020000L  /* xmsg.uid field contains umsgid of msg */


/* Field sizes in XMSG */

#define XMSG_FROM_SIZE  36
#define XMSG_TO_SIZE    36
#define XMSG_SUBJ_SIZE  72


/* Number of reply fields in XMSG.replies */

#define MAX_REPLY 9

#ifndef cpp_begin
  #ifdef __cplusplus
    #define cpp_begin()   extern "C" {
    #define cpp_end()     }
  #else
    #define cpp_begin()
    #define cpp_end()
  #endif
#endif

/* Initialization structure */

#pragma pack(1)
cpp_begin()
  struct _minf {
    /* Version 0 information */

    word req_version;
    word def_zone;
    word haveshare;

    /* Version 1 information */

    void * (*palloc)(size_t size);
    void   (*pfree)(void *ptr);
    void * (*repalloc)(void *ptr, size_t size);

    void * (*farpalloc)(size_t size);
    void   (*farpfree)(void *ptr);
    void * (*farrepalloc)(void *ptr, size_t size);
  };
cpp_end()

/* The network address structure.  The z/n/n/p fields are always             *
 * maintained in parallel to the 'ascii' field, which is simply an ASCII     *
 * representation of the address.  In addition, the 'ascii' field can        *
 * be used for other purposes (such as internet addresses), so the           *
 * contents of this field are implementation-defined, but for most cases,    *
 * should be in the format "1:123/456.7" for Fido addresses.                 */

struct _netaddr
{
  word zone;
  word net;
  word node;
  word point;
};


/* The eXtended message structure.  Translation between this structure, and *
 * the structure used by the individual message base formats, is done       *
 * on-the-fly by the API routines.                                          */

struct _xmsg
{
  dword attr;

  byte from[XMSG_FROM_SIZE];
  byte to[XMSG_TO_SIZE];
  byte subj[XMSG_SUBJ_SIZE];

  NETADDR orig;        /* Origination and destination addresses             */
  NETADDR dest;

  struct _stamp date_written;   /* When user wrote the msg (UTC)            */
  struct _stamp date_arrived;   /* When msg arrived on-line (UTC)           */
  sword utc_ofs;                /* Offset from UTC of message writer, in    *
                                 * minutes.                                 */

  UMSGID replyto;               /* This is a reply to message #x            */
  UMSGID replies[MAX_REPLY];    /* Replies to this message                  */
  dword umsgid;                 /* UMSGID of this message, if (attr&MSGUID) */
                                /* This field is only stored on disk -- it  *
                                 * is not read into memory.                 */

  byte __ftsc_date[20];/* Obsolete date information.  If it weren't for the *
                        * fact that FTSC standards say that one cannot      *
                        * modify an in-transit message, I'd be VERY         *
                        * tempted to axe this field entirely, and recreate  *
                        * an FTSC-compatible date field using               *
                        * the information in 'date_written' upon            *
                        * export.  Nobody should use this field, except     *
                        * possibly for tossers and scanners.  All others    *
                        * should use one of the two binary datestamps,      *
                        * above.                                            */
};


/* This is a 'message area handle', as returned by MsgOpenArea(), and       *
 * required by calls to all other message functions.  This structure        *
 * must always be accessed through the API functions, and never             *
 * modified directly.                                                       */

cpp_begin()
struct _msgapi
{
  #define MSGAPI_ID   0x0201414dL

  dword id;                       /* Must always equal MSGAPI_ID */

  word len;                       /* LENGTH OF THIS STRUCTURE! */
  word type;                      /* Type of this base - MSGTYPE_SDM, etc */

  dword num_msg;                  /* Number of msgs in this area */
  dword cur_msg;                  /* Current message number */
  dword high_msg;                 /* Highest message number in this area */
  dword high_water;               /* Message number of high water marker */

  word sz_xmsg;                   /* Size of _xmsg structure */

  byte locked;                    /* Base is locked from use by other tasks */
  byte isecho;                    /* Is this an EchoMail area?              */

  /* Function pointers for manipulating messages within this area.          */
  struct _apifuncs {
    sword  (* MAPIENTRY CloseArea)(HAREA mh);
    HMSG   (* MAPIENTRY OpenMsg)  (HAREA mh,word mode,dword n);
    sword  (* MAPIENTRY CloseMsg) (HMSG msgh);
    dword  (* MAPIENTRY ReadMsg)  (HMSG msgh, PXMSG msg, dword ofs,
                                 dword bytes, byte *text, dword cbyt,
                                 byte *ctxt);
    sword  (* MAPIENTRY WriteMsg) (HMSG msgh, word append, PXMSG msg,
                                 byte *text, dword textlen,
                                 dword totlen, dword clen, byte *ctxt);
    sword  (* MAPIENTRY KillMsg)  (HAREA mh, dword msgnum);
    sword  (* MAPIENTRY Lock)     (HAREA mh);
    sword  (* MAPIENTRY Unlock)   (HAREA mh);
    sword  (* MAPIENTRY SetCurPos)(HMSG msgh, dword pos);
    dword  (* MAPIENTRY GetCurPos)(HMSG msgh);
    UMSGID  (* MAPIENTRY MsgnToUid)(HAREA mh, dword msgnum);
    dword  (* MAPIENTRY UidToMsgn)(HAREA mh, UMSGID umsgid, word type);
    dword  (* MAPIENTRY GetHighWater)(HAREA mh);
    sword  (* MAPIENTRY SetHighWater)(HAREA mh, dword hwm);
    dword  (* MAPIENTRY GetTextLen)(HMSG msgh);
    dword  (* MAPIENTRY GetCtrlLen)(HMSG msgh);
    UMSGID (* MAPIENTRY GetNextUid)(HAREA harea);
  } *api;

  /* Pointer to application-specific data.  API_SQ.C and API_SDM.C use      *
   * this for different things, so again, no applications should muck       *
   * with anything in here.                                                 */

  void *apidata;
};
cpp_end()


/* This is a 'dummy' message handle.  The other message handlers (contained *
 * in API_SQ.C and API_SDM.C) will define their own structures, with some   *
 * application-specified variables instead of other[].  Applications should *
 * not mess with anything inside the _msgh (or MSGH) structure.             */

#define MSGH_ID  0x0302484dL

#if !defined(MSGAPI_HANDLERS) && !defined(NO_MSGH_DEF)
struct _msgh
{
  HAREA ha;
  dword id;

  dword bytes_written;
  dword cur_pos;
};
#endif

/* #include "api_brow.h" */

/* This variable is modified whenever an error occurs with the Msg...()     *
 * functions.  If msgapierr==0, then no error occurred.                     */

extern word msgapierr;

extern struct _minf mi;

/* Now, a set of macros, which call the specified API function.  These      *
 * will map calls for 'MsgOpenMsg()' into 'SquishOpenMsg()',                *
 * 'SdmOpenMsg()', or '<insert fave message type here>'.  Applications      *
 * should always call these macros, instead of trying to call the           *
 * manipulation functions directly.                                         */

#define MsgCloseArea(mh)       (*(mh)->api->CloseArea) (mh)
#define MsgOpenMsg(mh,mode,n)  (*(mh)->api->OpenMsg)          (mh,mode,n)
#define MsgCloseMsg(msgh)      ((*(((HMSG)msgh)->ha->api->CloseMsg))(msgh))
#define MsgReadMsg(msgh,msg,ofs,b,t,cl,ct) \
        (*(((HMSG)msgh)->ha->api->ReadMsg))(msgh,msg,ofs,b,t,cl,ct)
#define MsgWriteMsg(gh,a,m,t,tl,ttl,cl,ct) \
        (*(((HMSG)gh)->ha->api->WriteMsg))(gh,a,m,t,tl,ttl,cl,ct)
#define MsgKillMsg(mh,msgnum)     (*(mh)->api->KillMsg)(mh,msgnum)
#define MsgLock(mh)               (*(mh)->api->Lock)(mh)
#define MsgUnlock(mh)             (*(mh)->api->Unlock)(mh)
#define MsgGetCurPos(msgh)        (*(((HMSG)msgh)->ha->api->GetCurPos))(msgh)
#define MsgSetCurPos(msgh,pos) \
        (*(((HMSG)msgh)->ha->api->SetCurPos))(msgh,pos)
#define MsgMsgnToUid(mh,msgn)     (*(mh)->api->MsgnToUid)(mh,msgn)
#define MsgUidToMsgn(mh,umsgid,t) (*(mh)->api->UidToMsgn)(mh,umsgid,t)
#define MsgGetHighWater(mh)       (*(mh)->api->GetHighWater)(mh)
#define MsgSetHighWater(mh,n)     (*(mh)->api->SetHighWater)(mh,n)
#define MsgGetTextLen(msgh)       (*(((HMSG)msgh)->ha->api->GetTextLen))(msgh)
#define MsgGetCtrlLen(msgh)       (*(((HMSG)msgh)->ha->api->GetCtrlLen))(msgh)
#define MsgGetNextUid(ha)         (*(ha)->api->GetNextUid)(ha)

/* These don't actually call any functions, but are macros used to access    *
 * private data inside the _msgh structure.                                  */

#define MsgCurMsg(mh)         ((mh)->cur_msg)
#define MsgNumMsg(mh)         ((mh)->num_msg)
#define MsgHighMsg(mh)        ((mh)->high_msg)

#define MsgGetCurMsg(mh)      ((mh)->cur_msg)
#define MsgGetNumMsg(mh)      ((mh)->num_msg)
#define MsgGetHighMsg(mh)     ((mh)->high_msg)

#define MsgStripDebris(str)          StripNasties(str)
#define MsgCreateCtrlBuf(t, n, l)    CopyToControlBuf(t, n, l)
#define MsgGetCtrlToken(where, what) GetCtrlToken(where, what)
#define MsgCvt4D(c, o, d)            ConvertControlInfo(c, o, d)
#define MsgCvtCtrlToKludge(ctrl)     CvtCtrlToKludge(ctrl)
#define MsgRemoveToken(c, w)         RemoveFromCtrl(c, w)
#define MsgGetNumKludges(txt)        NumKludges(txt)
#define MsgWrite4D(msg, wf, ctrl)    WriteZPInfo(msg, wf, ctrl)
#define MsgInvalidHmsg(mh)           InvalidMsgh(mh)
#define MsgInvalidHarea(mh)          InvalidMh(mh)


cpp_begin()
  sword MAPIENTRY MsgOpenApi(struct _minf *minf);
  sword MAPIENTRY MsgCloseApi(void);

  HAREA MAPIENTRY MsgOpenArea(byte *name, word mode, word type);
  sword MAPIENTRY MsgValidate(word type, byte *name);
  sword MAPIENTRY MsgBrowseArea(char *b);

  void MAPIENTRY MsgFreeCtrlBuf(char *cbuf);
  void MAPIENTRY MsgFreeCtrlToken(char *cbuf);

  byte *StripNasties(byte *str);
  byte *CopyToControlBuf(byte *txt, byte * *newtext, unsigned *length);
  byte *GetCtrlToken(byte *where, byte *what);
  void  ConvertControlInfo(byte *ctrl, PNETADDR orig, PNETADDR dest);
  byte *CvtCtrlToKludge(byte *ctrl);
  void  RemoveFromCtrl(byte *ctrl,byte *what);
  word  NumKludges(char *txt);
  int   WriteZPInfo(PXMSG msg, void (*wfunc)(byte *str), byte *kludges);

  void  SquishSetMaxMsg(HAREA sq, dword max_msgs, dword skip_msgs, dword age);
  dword SquishHash(byte *f);

  HAREA MSGAPI SdmOpenArea(byte *name, word mode, word type);
  sword MSGAPI SdmValidate(byte *name);

  HAREA MSGAPI SquishOpenArea(byte *name, word mode, word type);
  sword MSGAPI SquishValidate(byte *name);

  sword InvalidMsgh(HMSG msgh);
  sword InvalidMh(HAREA mh);

  void ParseNNN(char *netnode, NETADDR *pn, word all);

  int farread(int handle, byte *buf, unsigned len);
  int farwrite(int handle, byte *buf, unsigned len);

  byte *Address(NETADDR *a);

  #ifndef MSGAPI_INIT
    extern void * (*palloc)(size_t size);
    extern void (*pfree)(void *ptr);
    extern void * (*repalloc)(void *ptr, size_t size);

    extern void * (*farpalloc)(size_t size);
    extern void (*farpfree)(void *ptr);
    extern void * (*farrepalloc)(void *ptr, size_t size);
  #endif

cpp_end()

#endif
