/***********************************************************************/
/*                                                                     */
/* Rexxsend.Cmd v1.11 - John Cuccia   02/06/94                         */
/*                                                                     */
/*  Usage:                                                             */
/*                                                                     */
/*    RexxSend /ftextfile /lsendlist /amsgarea /bbasetype /tmailtype   */
/*             /ssendfile                                              */
/*                                                                     */
/*  TEXTFILE is a file containing the text of the message to be sent.  */
/*                                                                     */
/*  SENDLIST is the list of nodes to which the message will be sent.   */
/*                                                                     */
/*  MSGAREA is the area in which the message(s) will be posted.  Use   */
/*    the root filename (omit the .SQD extension) for squish areas or  */
/*    the directory name for *.MSG areas.                              */
/*                                                                     */
/*  BASETYPE is either "S" for Squish-style areas or "F" for           */
/*    Fido-style *.MSG areas.                                          */
/*                                                                     */
/*  MAILTYPE is either "N" for Netmail or "E" for Echomail.            */
/*                                                                     */
/*  SENDFILE is the fully qualified filename of a file to be attached  */
/*                                                                     */
/*  SENDFILE is optional, all other arguments are required             */
/*                                                                     */
/*  You must precede all command line options with either a forward    */
/*  slash (/) or a dash (-).                                           */
/*                                                                     */
/***********************************************************************/

'@echo off'

ver='1.1'

i=1
parse upper arg arg.i rest

do while rest <> ''
  i=i+1
  parse upper var rest arg.i rest
end

argcount=i
sendflag=0

if argcount < 5 then
  do
    error=1
    signal parmerror
  end

do i=1 to argcount
  if left(arg.i,1)<>'/' & left(arg.i,1)<>'-' then
    do
      error=3
      signal parmerror
    end
end

do i=1 to argcount
  if substr(arg.i,2,1) ='F' then
    textfile=substr(arg.i,3)
  if substr(arg.i,2,1)= 'L' then
    sendlist=substr(arg.i,3)
  if substr(arg.i,2,1)= 'A' then
    msgarea=substr(arg.i,3)
  if substr(arg.i,2,1)= 'B' then
    basetype=substr(arg.i,3)
  if substr(arg.i,2,1)= 'T' then
    mailtype=substr(arg.i,3)
  if substr(arg.i,2,1)= 'S' then
    do
      sendfile=substr(arg.i,3)
      sendflag=1
    end
end

if basetype <> 'F' & basetype <> 'S' then
  do
    error=4
    signal parmerror
  end

if mailtype <> 'N' & mailtype <> 'E' then
  do
    error=5
    signal parmerror
  end

if stream(textfile,'c','query exists') = '' then
  call nofile(textfile)

if stream(sendlist,'c','query exists') = '' then
  call nofile(sendlist)

if sendflag = 1 then
  do
    if stream(sendfile,'c','query exists') = '' then
      call nofile(sendfile)
  end

if rxfuncquery(sysfiletree) <> 0 then
  call rxfuncadd 'sysfiletree','rexxutil','sysfiletree'


if basetype=='S' then
  msgtype='SQUISH'
else
  msgtype='SDM'

if mailtype=='N' then
  areatype='NET'
else
  areatype='ECHO'

if msgtype == 'SDM' then
  do
    rc=sysfiletree(msgarea,stemres,'D',,)
    if stemres.0 \= 1 then
      signal noareafound
    else
      nop
  end
else
  do
    if stream(msgarea'.SQD','c','query exists') = '' then
     call nofile(msgarea'.SQD')
    else
      nop
  end


cr = '0d'x
tagtext = cr'--- RexxSend v'ver||cr
origin = ' * Origin: Cajunet (1:3803/1)'cr

filesize=stream(textfile,'c','query size')
msgtext=charin(textfile,1,filesize)
text=msgtext||tagtext

if areatype == 'ECHO' then
  text=text||origin

parse value date(S) with today
yyyy=left(today,4)
mo=substr(today,5,2)
dd=right(today,2)
yy=right(yyyy,2)

parse value time() with hh':'mm':'ss

call rxfuncadd 'rxydbautilinit','ydbautil','rxydbautilinit'
call rxydbautilinit

address CMD 'rxsubcom register MSGAPI rxmsgapi RXMSGAPI'
address CMD 'rxsubcom load MSGAPI RXMSGAPI'

send1= rxexeci(sendlist,,payors.,'s')
parse var send1 paylread paybread

controla = '01'x
/*control = controla || 'PID RXMSGAPI'*/
control = ''
if areatype == 'NET' then
  xmsg.attr = 385
else
  xmsg.attr = 256
xmsg.from = 'John Cuccia'
if sendflag = 1 then
  do
    if areatype == 'NET' then
      do
        xmsg.subj = sendfile
        xmsg.attr=xmsg.attr+16
      end
    else
      xmsg.subj = '.....'
  end
else
  xmsg.subj = '.....'
xmsg.orig = '1:3803/1.0'
xmsg.utc_ofs = 360
xmsg.replyto = 0
xmsg.replies.1 = 0
xmsg.replies.2 = 0
xmsg.replies.3 = 0
xmsg.replies.4 = 0
xmsg.replies.5 = 0
xmsg.replies.6 = 0
xmsg.replies.7 = 0
xmsg.replies.8 = 0
xmsg.replies.9 = 0
xmsg.replies.10 = 0
xmsg.ftsc_date = dd||' '||left(date('M'),3)||' '||yy||'  'hh':'mm':'ss

address MSGAPI
'OPEN_API 1 0'
'OPEN_AREA MSG' msgarea 'MSGAREA_NORMAL' msgtype
'LOCK MSG'

say ''

do count=1 to paylread

  parse var payors.count addr name

  if payors.count == '' then leave

  XMSG.to=name

  if substr(right(addr,2),1,1) <>'.' then
    XMSG.dest=addr||'.0'
  else
    XMSG.dest=addr

  'OPEN_MSG MSGH MSG MOPEN_CREATE 0'

  XMSG.date_written=yyyy'/'mo'/'dd||':'||time('N')
  XMSG.date_arrived=XMSG.date_written

  'WRITE_MSG MSGH 0 XMSG. TEXT' length(text) length(text) length(control) 'CONTROL'
  'CLOSE_MSG MSGH'
  say '       Creating message for' XMSG.to

end

'UNLOCK MSG'
'CLOSE_AREA MSG'
'CLOSE_API'

signal cleanup

nofile:
  parse arg filename
  say 'File 'filename' not found'
  signal cleanup

noareafound:
  say 'directory 'msgarea' not found'
  signal cleanup

parmerror:
  say 'RexxSend v'ver 'usage:'
  say ''
  say '   RexxSend /ftextfile /lsendlist /amsgarea /bbasetype /tmailtype /ssendfile'
  say ''
  say 'TEXTFILE is a file containing the text of the message to be sent.'
  say ''
  say 'SENDLIST is the list of nodes to which the message will be sent.'
  say ''
  say 'MSGAREA is the area in which the message(s) will be posted.  Use'
  say '  the root filename (omit the .SQD extension) for squish areas or'
  say '  the directory name for *.MSG areas.'
  say ''
  say 'BASETYPE is either "S" for Squish-style areas or "F" for *.MSG areas.'
  say ''
  say 'MAILTYPE is either "N" for Netmail or "E" for Echomail.'
  say ''
  say 'SENDFILE is the fully qualified name of a file to be attached.'
  say ''
  say '    SENDFILE is optional, all other arguments are required'
  say ''
  say '    You must precede all command line options with either a forward'
  say '    slash (/) or a dash (-).'

cleanup:
  if rxfuncquery(rxexeci) = 0 then
    call rxydbautilterm
  address CMD 'rxsubcom drop MSGAPI'
  exit

