///////////////////////////////////////////////////////////////////////////
//                                                                       //
// GIO.H  --  Gern's 32-bit I/O routines for OS/2 2.x                    //
//                                                                       //
//                                                                       //
//                                                                       //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

// ERROR_USER_DEFINED_BASE  is  0xFF00  -or-  65280

#define COMERR_PORT_NOT_OPEN                ERROR_USER_DEFINED_BASE + 1
#define COMERR_INVALID_BUFFER_SIZES         ERROR_USER_DEFINED_BASE + 2
#define COMERR_INPUT_BUFFER_ALLOCATION      ERROR_USER_DEFINED_BASE + 3
#define COMERR_OUTPUT_BUFFER_ALLOCATION     ERROR_USER_DEFINED_BASE + 4
#define COMERR_STARTING_INPUT_THREAD        ERROR_USER_DEFINED_BASE + 5
#define COMERR_STARTING_OUTPUT_THREAD       ERROR_USER_DEFINED_BASE + 6
#define COMERR_OPENING_PORT                 ERROR_USER_DEFINED_BASE + 7
#define COMERR_SETTING_BPS_RATE             ERROR_USER_DEFINED_BASE + 8
#define COMERR_SETTING_LINE_CONTROL         ERROR_USER_DEFINED_BASE + 9
#define COMERR_CARRIER_DROPPED              ERROR_USER_DEFINED_BASE + 10
#define COMERR_NO_CHAR_WAITING              ERROR_USER_DEFINED_BASE + 11
#define COMERR_TIMED_CHAR_NOT_RECEIVED      ERROR_USER_DEFINED_BASE + 12
#define COMERR_BUFFER_ALLOCATION            ERROR_USER_DEFINED_BASE + 13

///////////////////////////////////////////////////////////////////////////
// To set parent and/or owner of the GIO Infobox dialog, you call
// ComSetInfoboxHwnd with either of these two parameters, and a valid
// HWND
// Example:
// ReturnCode = ComSetInfoboxHwnd(COM_SETINFOBOXPARENT, Hwnd);
//
// This sets the dialog box -parent- window to 'Hwnd'.
//
#define COM_SETINFOBOXPARENT 1
#define COM_SETINFOBOXOWNER  2

// ComOpen 'OpenFlags'
#define LEAVEPORTOPEN       0x00000001
#define OPENPORTSHARED      0x00000002
#define OPENWRITETHROUGH    0x00000004

#ifndef BSEDEV_INCLUDED

typedef struct _DCBINFO
{
    USHORT usWriteTimeout;
    USHORT usReadTimeout;
    BYTE   fbCtlHndShake;
    BYTE   fbFlowReplace;
    BYTE   fbTimeout;
    BYTE   bErrorReplacementChar;
    BYTE   bBreakReplacementChar;
    BYTE   bXONChar;
    BYTE   bXOFFChar;
} DCBINFO, *PDCBINFO;

#endif

///////////////////////////////////////////////////////////////////////////
// See GIO.DOC for exact parameters for functions
//
APIRET EXPENTRY ComOpen(PSZ    PortName,   SHORT  PortNumber,
                        ULONG  BPSRate,    BYTE   Parity,
                        SHORT  DataBits,   SHORT  StopBits,
                        USHORT InBufSize,  USHORT OutBufSize,
                        HFILE  ValidHandle,ULONG  OpenFlags);

APIRET EXPENTRY ComClose(BOOL LeavePortOpen);

APIRET EXPENTRY ComSetBPSRate(ULONG BPSRate);

APIRET EXPENTRY ComGetDCBInfo(PDCBINFO DCBInfo);

APIRET EXPENTRY ComSetDCBInfo(PDCBINFO DCBInfo);

APIRET EXPENTRY ComSetLineControl(BYTE Parity, SHORT DataBits, SHORT StopBits);

APIRET EXPENTRY ComSetFlowControl(VOID);

APIRET EXPENTRY ComSetDTR(SHORT DTROn);

BOOL   EXPENTRY ComReportDCD(VOID);

BOOL   EXPENTRY ComReportCTS(VOID);

APIRET EXPENTRY ComXONEnable(VOID);

APIRET EXPENTRY ComXONDisable(VOID);

APIRET EXPENTRY ComPurgeTXBuffer(VOID);

APIRET EXPENTRY ComTXCharImm(BYTE Char);

ULONG  EXPENTRY ComTXChar(BYTE Char);

APIRET EXPENTRY ComTXString(PSZ String, BOOL CheckCD);

APIRET EXPENTRY ComTXBuffer(PBYTE Buffer, ULONG Size, BOOL CheckCD);

APIRET EXPENTRY ComTXEmpty(VOID);

APIRET EXPENTRY ComTXFull(VOID);

APIRET EXPENTRY ComTXFree(PUSHORT BytesFree);

VOID   EXPENTRY ComWaitTillTXEmpty(ULONG Delay);

APIRET EXPENTRY ComPurgeRXBuffer(VOID);

APIRET EXPENTRY ComRXChar(PSHORT Char);

APIRET EXPENTRY ComRXPeek(PSHORT Char);

APIRET EXPENTRY ComRXCharWaiting(VOID);

APIRET EXPENTRY ComRXCharTimed(PSHORT Char, ULONG Delay);

VOID   EXPENTRY ComSetDebug(BOOL Mode);

APIRET EXPENTRY ComPause(VOID);

APIRET EXPENTRY ComResume(VOID);

APIRET EXPENTRY ComQueryHandle(PHFILE Handle);

APIRET EXPENTRY ComSetInfoboxHwnd(ULONG Type, HWND Hwnd);

VOID   EXPENTRY ComSetDebugIdentity(PSZ Identity);

ULONG  EXPENTRY TimeHSecSet(ULONG Delay);

BOOL   EXPENTRY TimeHSecIsUp(ULONG DelayTime);

