/* init.c
**
** Released into the PUBLIC DOMAIN 10 jul 1994 by John Dennis
**
** Handles sub-system initaliseation for msgedsq..
**
*/

#define INCL_MAIN

#include "msged.h"
#include "msg.h"
#include "fido.h"
#include "main.h"

struct _sv   *string_vars;
struct _swv  *switch_vars;

msghandle msgdo[2] =
{
    {
        FidoMsgReadHeader, FidoMsgReadText,  FidoMsgWriteHeader,
        FidoMsgWriteText,  FidoMsgDelete,    FidoAreaSetLast,
        FidoMsgAreaOpen,   FidoMsgAreaClose, FidoMsgClose,
        FidoUidToMsgn,     FidoMsgnToUid
    },
    {
        SquishMsgReadHeader, SquishMsgReadText,  SquishMsgWriteHeader,
        SquishMsgWriteText,  SquishMsgDelete,    SquishAreaSetLast,
        SquishMsgAreaOpen,   SquishMsgAreaClose, SquishMsgClose,
        SquishUidToMsgn,     SquishMsgnToUid
    }
};

D_LIST   *node_lists    = NULL;   /* the nodelists recognized by the system */
AREA     *arealist      = NULL;   /* list of areas */
ALIAS    *aliaslist     = NULL;   /* list of aliases */
ADDRESS  *domain_list   = NULL;   /* list of domain-gates */
ADDRESS  *alias         = NULL;   /* list of akas */
msg      *message       = NULL;   /* current message */
char    **templates     = NULL;   /* templates in system */
USER      user_list[MAXUSERS];          /* list of users */
ADDRESS   uucp_gate;              /* the uucp gate */

unsigned int  *macros[41];        /* function key macros + 1 for autostart */
int    maxx;              /* maximum screen columns */
int    maxy;              /* maximum screen rows */
int    rot13;
int    stripSoft;

int InitVars(void)
{
    /*
    ** Allocate some memory & initialize it.
    */

    string_vars = malloc(sizeof(struct _sv));
    switch_vars = malloc(sizeof(struct _swv));

    if (!string_vars || !switch_vars)
    {
        release(string_vars);
        release(switch_vars);
        return FAIL;
    }

    memset(string_vars, 0, sizeof(struct _sv));
    memset(switch_vars, 0, sizeof(struct _swv));
    memset(user_list,   0, sizeof(user_list));
    memset(macros,      0, sizeof(macros));

    /*
    **
    ** Initialize all the variables to default values.
    **
    */

    SW->rm            = 80;
    SW->qm            = 80;
    SW->tabsize       = 4;
    SW->use_lastr     = NO;
    SW->qquote        = NO;
    SW->msgids        = YES;
    SW->opusdate      = NO;
    SW->shownotes     = NO;
    SW->seenbys       = YES;
    SW->confirmations = YES;
    SW->datearrived   = NO;
    SW->redraw        = YES;
    SW->showaddr      = YES;
    SW->rawcc         = YES;
    SW->savecc        = NO;
    SW->hardquote     = YES;
    SW->chopquote     = YES;
    SW->showcr        = NO;
    SW->showeol       = NO;
    SW->showrealmsgn  = NO;
    SW->usemouse      = YES;
    SW->tabexpand     = YES;
    SW->usepid        = NO;
    SW->soteot        = YES;
    SW->rquote        = MT_QUO;
    SW->rotharea      = MT_QUO|MT_ARC;
    SW->rfollow       = MT_QUO|MT_FOL;
    SW->rextra        = MT_QUO|MT_FOL|MT_ARC;
    SW->tearline      = YES;
    SW->showsystem    = YES;
    ST->comspec       = getenv("COMSPEC");
    ST->outfile       = strdup("msged.txt");
    ST->quotestr      = strdup(" > ");
    ST->confmail      = strdup("confmail.out");
    ST->lastread      = strdup("lastread");
    ST->cfgfile       = strdup("msged.cfg");
    ST->uucpgate      = strdup("UUCP");
    ST->editorName    = NULL;
    ST->nodebase      = NULL;
    ST->sysop         = NULL;

    uucp_gate.notfound = 1;

    return OK;
}

void DeinitMem(void)
{
    release(switch_vars);
    release(string_vars);
}

/* end */
