#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include "mrl.h"

struct msgrec
{
 unsigned int n;
 char *msgid;
 char *reply;
 unsigned int lprev;
 unsigned int lnext;
 struct msgrec *next;
};

struct msgrec *fmsg=NULL; /* pointer to first message */
struct msgrec *last=NULL; /* pointer to  last message */

/* lok. fce - hledani*/
struct msgrec *FindbyMSGID(const char *msgid);
struct msgrec *Findbyn(unsigned int n);

/* build msg list */
int AddToList(unsigned int n, const char *mid, const char *rid);
int BuildMsgList(const char *dir);

/* Linkovani */
void LinkList(void); /* Zlinkuje list v pameti */
int UpdateMsgList(const char *dir);

/* Kod zacina zde ! */
int AddToList(unsigned int n, const char *mid, const char *rid)
{
 struct msgrec *b;
 char *s;
 if(!(b=malloc(sizeof(struct msgrec)))) return -1;
					
 /* init */
 b->n=n;
 b->msgid=NULL;
 b->reply=NULL;
 b->next=NULL;
 b->lprev=0;
 b->lnext=0;
 
 if(strlen(mid))
  {
   if(!(s=malloc(strlen(mid)+1))){ 
				   free(b);
				   return -1;
				};
   strcpy(s,mid);
   b->msgid=s;
  }

 if(strlen(rid))
  {
   if(!(s=malloc(strlen(rid)+1))){
					free(b->msgid);
					free(b);
					return -1;
				  };
   strcpy(s,rid);
   b->reply=s;
  }

  /* link b to list */
  if(last) last->next=b;
  else fmsg=b;
  last=b;
  return 0;
}

int BuildMsgList(const char *dir)
{
 unsigned i;
 char *tmp=malloc(280);
 char *etmp=malloc(380);
 char *mtmp=malloc(280);
 char *rtmp=malloc(280);
 if((!tmp)||(!mtmp)||(!rtmp)||(!etmp))
  { WriteLog(logname," Malloc error in BuildMsgList",'!');return -1;}
 for(i=mmin;i<=mmax;i++)
 {
/*printf("\n");*/
  CreName(tmp,dir,i);
/*printf("Trying: %s..",tmp);*/
  if(GetMID(tmp,mtmp,rtmp)) continue;
/*printf("OK");*/
/*printf("\n%d %s==%s",i,mtmp,rtmp);*/
  if(AddToList(i,mtmp,rtmp))
    { WriteLog(logname," Malloc error in AddToList",'!');return -1;}

  if(SetLinks(tmp,0,0)) { sprintf(etmp," %s - Link reset error",tmp);
                          WriteLog(logname,etmp,'!');
	                  perror(etmp); };
 }
 /* ted jeste pridame jeden prazdny zaznam na konec */
 AddToList(65535,"","");
 free(tmp);
 free(mtmp);
 free(rtmp);
 free(etmp);
 return 0;
}

int UpdateMsgList(const char *dir)
/* zmeni jen ty .MSG co se zlinkovaly */
{
 char *tmp=malloc(260);
 char *etmp=malloc(360);
 struct msgrec *i=fmsg;
 if(!tmp) return -1;
 while(i->next)
 {
  if((i->lprev)||(i->lnext))
    {
     CreName(tmp,dir,i->n);
     if(SetLinks(tmp,i->lprev,i->lnext))
      { sprintf(etmp,"Cannot update links in %s",tmp);
        WriteLog(logname,etmp,'!');
	perror(etmp);
      }
/*    else
      printf("%s updated.\n",tmp); */
    }
  i=i->next;
 }   
 free(tmp);
 free(etmp);
 return 0;
}

struct msgrec *Findbyn(unsigned int n)
{
  struct msgrec *i=fmsg;
  while((i->n<=n)&&(i->next))
    if(n==i->n) return i;
    else
     i=i->next;
  WriteLog(logname," NULL returned by Findbyn",'!');
  return NULL;
}

struct msgrec *FindbyMSGID(const char *msgid)
{
  struct msgrec *i=fmsg;
  while(i->next)
  {
    if (i->msgid)
      if(!strcmp(msgid,i->msgid))
        return i;
    i=i->next;
  }
  return NULL;
}


void LinkList(void) /* Zlinkuje list v pameti */
{
 char *tmp=malloc(255);
 struct msgrec *i,*j;
 if(!tmp) WriteLog(logname,"Out of memory in LinkList, Linking aborted",'!');
 for(i=fmsg;i->next;i=i->next) 
 {
 if(!(i->reply)) continue; /* neni to odpoved na neco */
 if((j=FindbyMSGID(i->reply)))
   {
   i->lprev=j->n;
   /* nasli jsme odpoved, prilinkujeme ji na konec */
   for(;(j->lnext)&&(j->next);j=Findbyn(j->lnext)); /* najdi konec threadu */
   j->lnext=i->n;
   sprintf(tmp,"msg %hu linked to msg %hu",j->n,i->n);
   WriteLog(logname,tmp,'*');
   }
 }
 free(tmp);
}

int Link(const char *dir)
{
 if(BuildMsgList(dir)) return -1;
 LinkList();
 if(UpdateMsgList(dir)) return -1;
 return 0;
}
