/* REXX script to read and report on MAXFMPM.INI */
'@echo off'

Call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'
Call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

Call SysFileTree 'MAXFMPM.INI', 'files', 'FO'

If files.0 \= 1 Then Do
    Say
    Say 'MAXFMPM.INI not found, or more than one found.'
    Exit
End

rc = SysIni(files.1, 'MaxFilePM', 'Installed')
Say 'Installed = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'BBSType');
Say 'BBSType = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'RegKey');
Say 'RegKey = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'RegName');
Say 'RegName = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'AutoSave');
Say 'AutoSave = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'ButtonBar');
Say 'ButtonBar = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'AutoFBP');
Say 'AutoFBP = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'AutoAdopt');
Say 'AutoAdopt = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'DLCounter');
Say 'DLCounter = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'DisplayDate');
Say 'DisplayDate = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'DisplaySize');
Say 'DisplaySize = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'NumAdopt');
Say 'NumAdopt = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'HeaderSize');
Say 'HeaderSize = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'ExtDescMarker');
Say 'ExtDescMarker = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'AreaDat');
Say 'AreaDat = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'TempDir');
Say 'TempDir = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'MaxDir');
Say 'MaxDir = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'FBPCmd');
Say 'FBPCmd = 'rc

rc = SysIni(files.1, 'MaxFilePM', 'REXXCfg');
Say 'REXXCfg = 'rc
