/* REXX Install for MaxFile/PM */
'@echo off'
Say "MaxFile/PM Installation Aid."
Say 'Copyright 1994 Craig Morrison, All Rights Reserved.'

Parse Upper Arg iDir .
If iDir = ' ' Then Do
    Say
    Say 'What directory do want to install MaxFile/PM in?'
    Pull iDir .
    If iDir = ' ' Then Exit
End

Call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'

iDir = Strip(iDir, 'T', '\')
cDir = Translate(Directory())
If iDir = cDir Then Do
    Say
    Say "Can't install to the current directory!"
    Say 'Please try again.'
    Exit
End

Say
Say 'MaxFile/PM will be installed in 'iDir', continue (Y or N)?'
Pull YesNo .

If YesNo \= 'Y' Then Do
    Say
    Say 'Installation aborted.'
    Exit
End

nDir = Directory(iDir)
nDir = Translate(Directory())
If nDir \= iDir Then 'MD 'iDir
nDir = Directory(iDir)
nDir = Translate(Directory())
if nDir \= iDir Then Do
    Say
    Say 'Error creating install directory 'iDir'!'
    Say 'Installation aborted.'
    Exit
End

nDir = Directory(cDir)

Say
Say 'Copying program files to 'iDir'.'
Say
Say 'Copying 'cDir'\maxfmpm.exe to 'iDir
Command = 'COPY 'cDir'\maxfmpm.exe 'iDir' > nul'
Command
If rc = 0 Then Do
    Command = 'COPY 'cDir'\maxfmpm.txt 'iDir' > nul'
    Command
End
If rc = 0 Then Do
    Say 'Copying 'cDir'\register.frm to 'iDir
    Command = 'COPY 'cDir'\register.frm 'iDir' > nul'
    Command
End
If rc = 0 Then Do
    Say 'Copying 'cDir'\announce.cmd to 'iDir
    Command = 'COPY 'cDir'\announce.cmd 'iDir' > nul'
    Command
End
If rc = 0 Then Do
    Say 'Copying 'cDir'\tann.cmd to 'iDir
    Command = 'COPY 'cDir'\tann.cmd 'iDir' > nul'
    Command
End
If rc = 0 Then Do
    Say 'Copying 'cDir'\showini.cmd to 'iDir
    Command = 'COPY 'cDir'\showini.cmd 'iDir' > nul'
    Command
End
If rc = 0 Then Do
    Say 'Copying 'cDir'\fixini.cmd to 'iDir
    Command = 'COPY 'cDir'\fixini.cmd 'iDir' > nul'
    Command
End
If rc = 0 Then Do
    Say 'Copying 'cDir'\testrexx.cmd to 'iDir
    Command = 'COPY 'cDir'\testrexx.cmd 'iDir' > nul'
    Command
End
If rc = 0 Then Do
    Say 'Copying 'cDir'\listarea.cmd to 'iDir
    Command = 'COPY 'cDir'\listarea.cmd 'iDir' > nul'
    Command
End
If rc = 0 Then Do
    Say 'Copying 'cDir'\fmtdesc.cmd to 'iDir
    Command = 'COPY 'cDir'\fmtdesc.cmd 'iDir' > nul'
    Command
End
If rc = 0 Then Do
    Say 'Copying 'cDir'\insobj.cmd to 'iDir
    Command = 'COPY 'cDir'\insobj.cmd 'iDir' > nul'
    Command
End
If rc = 0 Then Do
    Say 'Copying 'cDir'\scalar.cmd to 'iDir
    Command = 'COPY 'cDir'\scalar.cmd 'iDir' > nul'
    Command
End
If rc = 0 Then Do
    Say 'Copying 'cDir'\readme.txt to 'iDir
    Command = 'COPY 'cDir'\readme.txt 'iDir' > nul'
    Command
End
If rc = 0 Then Do
    Say 'Copying 'cDir'\probwks.txt to 'iDir
    Command = 'COPY 'cDir'\probwks.txt 'iDir' > nul'
    Command
End
If rc = 0 Then Do
    Say 'Copying 'cDir'\execdos.exe to 'iDir
    Command = 'COPY 'cDir'\execdos.exe 'iDir' > nul'
    Command
End
If rc = 0 Then Do
    Say 'Copying 'cDir'\license.txt to 'iDir
    Command = 'COPY 'cDir'\license.txt 'iDir' > nul'
    Command
End
If rc = 0 Then Do
    Say 'Copying 'cDir'\maxfmpm.inf to 'iDir
    Command = 'COPY 'cDir'\maxfmpm.inf 'iDir' > nul'
    Command
End

If rc \= 0 Then Do
    Say
    Say 'Error #'rc' occured while copying files.'
    Say 'MaxFile/PM was not installed correctly.'
    Say 'Installation aborted.'
    Exit
End

Say
Say 'Do you want this installation aid to create the WorkPlace Shell'
Say 'objects on your desktop for MaxFile/PM (Y or N)?'
Pull YesNo .
If YesNo = 'Y' Then Do
    nDir = Directory(iDir)
    call insobj
    nDir = Directory(cDir)
End

If Stream(iDir'\MAXFMPM.INI', 'c', 'query exists') \= '' Then Do
    Say
    Say 'MAXFMPM.INI detected, do you want to use this file for this'
    Say 'installation of MaxFile/PM (Y or N)?'
    Pull YesNo .
    If YesNo = 'Y' Then Do
        rc = SysIni(iDir'\MAXFMPM.INI', 'MaxFilePM', 'Installed', '1')
        rc = SysIni(iDir'\MAXFMPM.INI', 'MaxFilePM', 'Installed')
        If rc \= '1' Then Do
            Say
            Say 'Error setting installed flag in 'iDir'\MAXFMPM.INI!'
        End
    End
End

Say
Say "Installation complete!"
Say
Say 'About to start View to show the MaxFile/PM Online Reference.'
Say 'Press ENTER to continue...'
Pull .

'view 'iDir'\maxfmpm OverView'
