/* ANNOUNCE.CMD - REXX program to generate a File Announcement
with MPBeta for new files. Version 1.1

ver 1.1:  Found an error and in the process of cleaning it up, sped up the
program's execution! Moved the file_desc stuff inside the loop.

  - 10 July, 1994 by Elliott Goodman, 1:102/1319 -
*/

/* check whether RxFuncs are loaded. If not, load them. */       
                                                                 
if RxFuncQuery('SysLoadFuncs') then                              
do                                                               
        call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
        call SysLoadFuncs                                        
end                                                              

/* Just to let the user know what's going on.... */

say 'Searching thru file areas for new files to announce.'
say 'Please wait....';
say ' ';


/* create a tracking file */
report = 'd:\lora\file\mpbeta\announce.txt'

/* delete old tracking file, if present */
call SysFileDelete(report)

m_txt = 'Report of ANNOUNCE.CMD activity'
call lineout report, m_txt
m_txt = ''
call lineout report, m_txt

/* get today's date, create an index from it */
day_index = SPECIFIED_DATE_IN_DAYS( DATE('U') )                        

/* set some defaults */

nfile.0 = 0
files.0 = 0				/* will increment */
file_index = 0

/* set up the array elements of FILES which will be used by
MPM_AnnounceFiles() at the end of all this processing.
See TANN.CMD included with MPBeta for details.   */

files.msgpath = 'D:\LORA\MSG\USERS'
files.msgtype = 'SQUISH'
files.msgflag = 'CRASH'
files.to = 'ALL'
files.toaddr = '1:102/1316.0'
files.header = 'New files online at Miles Enterprises BBS'
files.from = 'Elliott Goodman'
files.fromaddr = '1:102/1319.0'
files.footer = '- Elliott'

/* your origin info */
files.origin = 'Miles Enterprises * 805-264-0200 *'

/* my first 44 areas are on the CD so I start with 44 (and increment it
immediately.) This saves time since the CD is slow. */
mpmarea = 44	

do forever				/* we'll bail out after the last area */
   mpmarea = MPM_QueryArea(mpmarea)	/* look at next area */
   if mpmarea = 'ERROR' then do
      leave				/* this will bail us out */
      end /* if error (past last file area) */

/* get drive/subdir of next file area */
   area_path = MPM_QueryAreaInfo(mpmarea, '1')

/* notify user of our progress */
   say area_path ;

/* use SysFileTree here to check for new files */
   call SysFileTree area_path, stuff, 'F'

/* reset before each file area */
   found_new = 0
   nfile.0 = 0

/* assume at least one file in the file area */
   do i = 1 to stuff.0		/* cycle thru files in one area */

/* get info on each file in the area */
   parse var stuff.i,
         file_date,
         file_time,
         file_size,
         file_attr,
         file_name

/* remove trailing space */
   file_name = strip( file_name )

/* remove drive/subdir info from filename */
   parse var file_name (area_path) file_name

/* convert to caps, just in case */
   file_name = translate( file_name )

/* get extention. We don't want to announce FILES.BBS or FILES.BAK! */
   parse var file_name junk '.' extn

   if extn = 'BAK' then do
      iterate
      end

   if extn = 'BBS' then do
      iterate
      end

/* test if next file is dated today, hence NEW */
   file_test = SPECIFIED_DATE_IN_DAYS( file_date )
   if file_test = day_index then do

/* here's where the ver. 1.1 code makes it's major changes. Store the
files that are new and do them all at once for each area */
      found_new = 1
      nfile.0 = nfile.0 + 1
      t_index = nfile.0
      nfile.t_index = file_name
      end /* if file_test = day_index */

   end /* do i = 1 to stuff.0 */

/* now, if we found one or more new files in this area... */
   if found_new = 1 then do

/* we have to open the files.bbs file so we can get the
description */
      retval = MPM_OpenArea(mpmarea)

/* this just gives the system time to open the file */
      Call SysSleep 3

/* ....cycle thru the new files for this area */
      do k = 1 to nfile.0

/* continue storing elements in FILES */
         file_index = file_index + 1
         files.0 = files.0 + 1
         files.file_index.path = area_path
         files.file_index.file = nfile.k

         file_desc = MPM_QueryFileInfo(mpmarea, nfile.k, '3')
         files.file_index.desc = file_desc
         end /* do k to nfile.0 */

/* close the files.bbs file to avoid problems */
      retval = MPM_CloseArea(mpmarea)
      end /* if  found = 1 */

   end /* do forever */

/* if no new files: exit */
if files.0 = 0 then do
   m_txt = 'No new files found'
   call lineout report, m_txt
   exit
   end

/* there are new files. Save the info so we can play
with the descriptions when we wake up <g> */

m_txt = 'List of New Files'
call lineout report, m_txt
m_txt = ' '
call lineout report, m_txt

do j = 1 to files.0
   m_txt = 'File Path = ' files.j.path
   call lineout report, m_txt
   m_txt = 'File Name = ' files.j.file
   call lineout report, m_txt
   m_txt = 'File Description = ' files.j.desc
   call lineout report, m_txt
   m_txt = ' '
   call lineout report, m_txt
   end  

/* actually make the announcement */
retval = MPM_AnnounceFiles('files')

m_txt = files.0 'new files announced!'
call lineout report, m_txt

/* and we're done */
exit

/*------------------------------------------------*/                 
/* Convert calendar date to consistent date index                  */
/*------------------------------------------------*/                 
SPECIFIED_DATE_IN_DAYS:                                              
   Procedure                                                         
                                                                     
parse arg,                                                           
   mm '/',                                                           
   dd '/',                                                           
   yy                                                                
                                                                     
days_by_month = '31 28 31 30 31 30 31 31 30 31 30 31'                
current_number_of_days = (yy * 365) + dd                             
do m = 1 while m < mm                                                
   current_number_of_days = current_number_of_days +,                
      WORD( days_by_month, m )                                       
end                                                                  
return current_number_of_days                                        

