
/* Simple client-end example of a MaxSnoop app.
 *
 * EMX 0.8h
 */

#define ESCAPE 27
#define INCL_NOPM
#define INCL_DOS
#define INCL_VIO
#define INCL_DOSERRORS
#define INCL_DOSPROCESS
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/winmgr.h>
#include <sys/kbdscan.h>
#include <sys/video.h>
#include <ctype.h>


char BangColour = 127;
char PlusColour = 127;
char ColonColour = 127;
char PoundColour = 127;
char EqualsColour = 127;
char StarColour = 127;
char ** buffer;
wm_handle main_window;
int scr_size[2];
int top = -1;
int offset = 0;
int size = 100;
char normal_key_code = 0;
char extended_code = 0;
char Help_Open = 0;
wm_handle Help;




static char * Colours[9] = {
  "BLACK",
  "BLUE",
  "GREEN",
  "CYAN",
  "RED",
  "MAGENTA",
  "YELLOW",
  "BROWN",
  "WHITE"
};




int GetColour(char *);
void Colour_Line(char, char);
static HPIPE OpenPipe(char *name);
static USHORT PRead(HPIPE hp, VOID *pv, ULONG cb, USHORT *pbr);
void displaylist(void);
void handle_key_event(char * not_done, HPIPE hp);
void ARGS();
void HELP();
int rc;

void main(int argc, char **argv)
{
  int l;
  USHORT bytes;
  char msg[258];
  HPIPE hp = 0;
  VIOMODEINFO ModeData;
  int i;
  char not_done = 1;
  char * lines = "23";
  char * pipename = "";
  ULONG rc;

  if (argc < 2)
    {
      ARGS();
      exit(-1);
    }
  for (i=1; i < argc; ++i)
    {
      if (argv[i][0] != '-')
	{
	  printf("I don't understand the commandline arg %s\n",argv[i]);
	  ARGS();
	}
      else if (argv[i][1] == '-')
	{
	  printf("I don't understand the commandline arg %s\n",argv[i]);
	  ARGS();
	}
      else
	switch (argv[i][1]){
	case 'p':
	  pipename = &argv[i][2];
	  break;
	case '+':
	  PlusColour = GetColour(&argv[i][2]);
	  break;
	case '#':
	  PoundColour = GetColour(&argv[i][2]);
	  break;
	case '!':
	  BangColour = GetColour(&argv[i][2]);
	  break;
	case ':':
	  ColonColour = GetColour(&argv[i][2]);
	  break;
	case '=':
	  EqualsColour = GetColour(&argv[i][2]);
	  break;
	case '*':
	  EqualsColour = GetColour(&argv[i][2]);
	  break;
	case 's':
	  size = atoi(&argv[i][2]);
	  if (size < 100){
	    size = 100;
	    printf("you must use at least 100 lines of scroll back buffer\n");
	    printf("I will set the default to 100 for you.\n");
	    sleep(2);
	  }
	  break;
	case 'l':
	  lines = &argv[i][2];
	  break;
	default:
	  ARGS();
	}
    }

  if (!strlen(pipename)){
    ARGS();
    exit(-1);
  }

  size = 1000;

  buffer =  malloc(size*sizeof(char *));

  rc = VioGetMode(&ModeData, 0);
  scr_size[0] = ModeData.col;
  scr_size[1] = ModeData.row;

  ModeData.row = atoi(lines);
  ModeData.cb = sizeof(ModeData);
  ModeData.color = 4;
  ModeData.fbType = 1;
  ModeData.hres = 640;
  ModeData.vres = 16*ModeData.row;
  rc = VioSetMode(&ModeData, 0);

  rc = VioGetMode(&ModeData, 0);
  /* scr_size[0] = ModeData.col;*/
  ModeData.row = atoi(lines);
  rc = VioSetMode(&ModeData, 0);
  scr_size[0] = 80;
  scr_size[1] = ModeData.row;
  VioScrollDn(0, 0, scr_size[1], scr_size[2], scr_size[1], " ", 0);

  for (i = 0; i < size; ++i) buffer[i] = NULL;

  rc = wm_init(2);
  main_window = wm_create(0,0,scr_size[0],scr_size[1],0,
			  F_WHITE|B_BLACK|INTENSITY,F_WHITE|B_BLACK|INTENSITY);
  wm_open(main_window);
  wm_wrap(main_window, 0);
  while(not_done){
    hp = OpenPipe(pipename);
    while (hp)
      {
	if (!(rc = PRead(hp, msg, sizeof(msg)-2, &bytes))){
	  msg[bytes] = 0;
	  l = 0;
	  while ((31 < msg[l]) && (l < strlen(msg))) ++l;
	  msg[l] = 0;
	  msg[++l] = 0; 
	  ++top;
	  if (top == size) top = 0;
	  msg[scr_size[0]] = 0;
	  buffer[top] = realloc(buffer[top], strlen(msg) + 1);
	  strcpy(buffer[top], msg);

	  if (offset == 0){
	    wm_scroll(main_window, 1);
	    if (buffer[top] != NULL){
	      wm_puts_at(main_window, 0, scr_size[1]-1, buffer[top]);
	      Colour_Line(scr_size[1]-1, buffer[top][0]);}}
	  else{
	    offset = 0;
	    displaylist();}
	}
	else if ((rc != ERROR_MORE_DATA) &&
		 (rc != ERROR_NO_DATA)){
	  rc = DosClose(hp);
	  hp = 0;}
	if ((normal_key_code = _read_kbd(0,0,0)) >= 0){
	  if (!normal_key_code)
	    extended_code = _read_kbd(0,0,0);
	  handle_key_event(&not_done, hp);
	}
	else
	  _sleep2(25);
      }
  }
}




int GetColour(char *p)
{
  int i;

  for (i = B_BLACK; i < B_WHITE; i += B_BLUE)
    if (strnicmp(Colours[i/B_BLUE], p, strlen(Colours[i/B_BLUE])) == 0)
      return i;
  return(F_WHITE);
}





void Colour_Line(char loc, char character)
{
  switch (character){
    
  case '!':
    if (BangColour != 127)
      wm_puta_at(main_window,0,loc,F_WHITE|BangColour|INTENSITY,scr_size[0]);
    break;
  case ':':
    if (ColonColour != 127)
      wm_puta_at(main_window,0,loc,F_WHITE|ColonColour|INTENSITY,scr_size[0]);
    break;
  case '#':
    if (PoundColour != 127)
      wm_puta_at(main_window,0,loc,F_WHITE|PoundColour|INTENSITY,scr_size[0]);
    break;
  case '+':
    if (PlusColour != 127)
      wm_puta_at(main_window,0,loc,F_WHITE|PlusColour|INTENSITY,scr_size[0]);
    break;
  case '=':
    if (EqualsColour != 127)
      wm_puta_at(main_window,0,loc,F_WHITE|EqualsColour|INTENSITY,scr_size[0]);
    break;
  case '*':
    if (StarColour != 127)
      wm_puta_at(main_window,0,loc,F_WHITE|StarColour|INTENSITY,scr_size[0]);
    break;
  }
}






void ARGS()
{
  printf("\n             Text Snoop\n\n");
  printf("From the maker of MaxFile/2.  Code is adapted from work done by\n");
  printf("Peter Fitzsimmons.\n\n");
  printf("This program takes one of many arguments arguments\n");
  printf("-p<pipename> where <pipename> is the name of the snoop pipe\n");
  printf("-s<num>      where <num> is the number of log lines to retain\n");
  printf("-l<num>      where <num> is the number of screen lines\n");
  printf("-!<colour>   where <colour> is the colour for lines begining with !\n");
  printf("-=<colour>   where <colour> is the colour for lines begining with =\n");
  printf("-+<colour>   where <colour> is the colour for lines begining with +\n");
  printf("-#<colour>   where <colour> is the colour for lines begining with #\n");
  printf("-*<colour>   where <colour> is the colour for lines begining with *\n");
  printf("-:<colour>   where <colour> is the colour for lines begining with :\n");

  printf("\n <colour> can be any of the following: BLUE, GREEN, CYAN, RED, MAGENTA\n");
  printf("                                       YELLOW, BROWN, or WHITE\n");

  printf("\n\nyou must at least specify a pipe to read\n\n");
  exit(-1);
}



void displaylist(void)
{
  int place;
  int i;
  int TOP = top;

  wm_clear(main_window);
  for (i = 0; i < scr_size[1]; ++i)
    {
      place = TOP + offset - i;
      if (place < 0) place = place + size;
      if (buffer[place]  != NULL){
	wm_puts_at(main_window, 0, scr_size[1]-1-i, buffer[place]);
	Colour_Line(scr_size[1]-i-1, buffer[place][0]);
      }
    }
}



void handle_key_event(char * not_done, HPIPE hp)
{
  int place;

  if (normal_key_code){
    switch (normal_key_code){
    case 'x': case 'X':
      * not_done = 0;
      DosClose(hp);
      wm_close_all();
      exit(0);
      break;
    case ESCAPE:
      if (Help_Open){
	wm_close(Help);
	wm_delete(Help);
	Help_Open = 0;}
      break;
    }
  }
  else if (extended_code){
    switch (extended_code){
    case K_PAGEUP:
      if (offset != scr_size[1] - size){
	offset = offset - scr_size[1] + 1;
	if (-offset > size-scr_size[1]) offset = -size + scr_size[1];
	displaylist();
      }
      break;
    case K_HOME:
      if (offset != scr_size[1] - size){
	offset =  scr_size[1] - size;
	displaylist();
      }
    case K_UP:
      if (offset != scr_size[1] - size){
	--offset;
	place = top + offset - scr_size[1] + 1;
	if (place < 0) place = place + size;
	wm_ins_line(main_window, 0, 1);
	if (buffer[place]  != NULL){
	  wm_puts_at(main_window, 0, 0, buffer[place]);
	  Colour_Line(0, buffer[place][0]);
	}
      }
      break;
    case K_PAGEDOWN:
      if (offset){
	offset = offset + scr_size[1] - 1;
	if (offset > 0) offset = 0;
	displaylist();}
      break;
    case K_END:
      if (offset){
	offset = 0;
	displaylist();}
      break;
    case K_DOWN:
      if (offset){
	++offset;
	place = top + offset;
	if (place < 0) place = place + size;
	wm_scroll(main_window, 1);
	if (buffer[place]  != NULL){
	  wm_puts_at(main_window, 0, scr_size[1]-1, buffer[place]);
	  Colour_Line(scr_size[1]-1, buffer[place][0]);
	}
      }
      break;
    case K_F1:
      HELP();
      break;
    }
  }
  extended_code = 0;
  normal_key_code = 0;
}


/* if the pipe doesn't exist, this function polls for it.  I don't
 * like polling,  but we have no choice,  since the Snooper is
 * usually always running,  but the Snoopee is not.
 */
static HPIPE OpenPipe(char *name)
{
  char msg[100];
  char *pname;
  USHORT rc;
  ULONG us;
  HPIPE hf;
  int shown = FALSE;
  int more = 1;
  char junk;
  
  pname = name;
  if(!pname)
    pname = "\\pipe\\maxsnoop";
  
  for(;;){
    rc = DosOpen((PCSZ) pname, &hf, &us, 0L, FILE_NORMAL,
                 FILE_OPEN,
                 OPEN_ACCESS_READONLY  | OPEN_SHARE_DENYREADWRITE | OPEN_FLAGS_NOINHERIT,
                 0L);
    if(!rc)
      break;
    if ((normal_key_code = _read_kbd(0,0,0)) >= 0){
      if (!normal_key_code)
	extended_code = _read_kbd(0,0,0);
      handle_key_event(&junk, hf);
    }

    if(rc == ERROR_PIPE_BUSY){
      if (more){
	more = !more;
	strcpy(msg, "Pipe is busy, waiting to connect...");
	++top;
	if (top == size) top = 0;
	msg[scr_size[0]] = 0;
	buffer[top] = realloc(buffer[top], strlen(msg) + 1);
	strcpy(buffer[top], msg);
	if (offset == 0){
	  wm_scroll(main_window, 1);
	  wm_puts_at(main_window, 0, scr_size[1]-1, buffer[top]);}
	else{
	  offset = 0;
	  displaylist();}
      }
      rc = DosWaitNPipe(pname, 10L);
      if(rc && rc != ERROR_SEM_TIMEOUT)
	break;
    }
    else{
      if(!shown){
	
	strcpy(msg, "Pipe doesn't exist; polling continues...");
	++top;
	if (top == size) top = 0;

	msg[scr_size[0]] = 0;

	buffer[top] = realloc(buffer[top], strlen(msg) + 1);
	strcpy(buffer[top], msg);
	shown = 1;

	if (offset == 0){
	  wm_scroll(main_window, 1);
	  wm_puts_at(main_window, 0, scr_size[1]-1, buffer[top]);
	}
	else{
	  offset = 0;
	  displaylist();}
      }
      _sleep2(25);
    }
  }
  
  if(rc){
    
    printf("dosopen error %d\n", rc);
    return 0;
  }
  DosSetNPHState(hf,  NP_READMODE_MESSAGE | NP_NOWAIT);
  return hf;
}

static USHORT PRead(HPIPE hp, VOID *pv, ULONG cb, USHORT *pbr)
{
  USHORT rc;
  ULONG br=0;
  ULONG state;
  AVAILDATA ad;
  
  rc = DosRead(hp, pv, cb, &br);
  if(!rc && br == 0){
    DosSleep(1L);   /* yield to LanMan on zero byte read,  
		       so it can detect any pipe error.*/
    rc = DosPeekNPipe(hp, "", 0, &br, &ad, &state);
    if(!rc && state != 3)
      rc = ERROR_BROKEN_PIPE;}
  *pbr = br;
  return rc;
}


void HELP()
{
  if (!Help_Open){
    Help_Open = 1;
    Help = wm_create(18,scr_size[1]/2-2,62, scr_size[1]/2+1, 2,
		     F_RED|B_BLACK|INTENSITY,F_YELLOW|B_BLACK|INTENSITY);
    wm_border(Help, 2, B_BLACK|F_RED|INTENSITY,"press <esc> to close"
	      ,1, B_BLACK|F_BLUE|INTENSITY);
    wm_open(Help);
    wm_top(Help);
    wm_puts_at(Help, 2,0,"Page UP, Down:  Scroll up, down one page");
    wm_puts_at(Help, 2,1,"Home, End:      Go to top, bottem");
    wm_puts_at(Help, 2,2,"Arrow UP, Down: Scroll up, down one line");
    wm_puts_at(Help, 2,3,"x, X:           Quit");
  }
}


