// (c) 1995 Wouter Cloetens 2:292/608.18@fidonet 81:432/109@OS2Net
//                          wouter.cloetens@ping.be

#define INCL_DOSDATETIME
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#ifdef __WATCOMC__
#include <errno.h>
#undef ENAMETOOLONG
#undef ENOTEMPTY
#endif
#include <types.h>
#include <sys/socket.h>
#include "typedefs.h"
#include "msgapi.h"
#include "prog.h"
#include "ipost.h"
#include "nntp.h"
#include "nntpcl.h"
#include "socket.h"

#define ALLOCSIZE 4000

void beginmsg(char *szFromAddr, char *szAreaName, bool fEcho);
void endmsg();
void writemsg(bool fEcho, dword lMsgAttr, struct _stamp *date,
	char *szFromAddr, char *szToAddr, char *szFrom, char *szTo,
	char *szSubject, char *szCtrl, char *buf);

static int doArticle (int socket, int artnum);
void initloop();
void processheader();
void addkludge(char *kl, char *value);
void getdt();
void getname(char *s, size_t slen, char *lin);

/* extern char killEnabled;	kill processing enabled for this group */
char szSubject[XMSG_SUBJ_SIZE];
char szFrom[XMSG_FROM_SIZE];
char szTo[XMSG_TO_SIZE];
char *szAreaName;
char origin[84];
char *buf, *cbuf;
size_t buflen, linelen, bufalloc, cbufalloc;
char linebuf[512];
struct _stamp date;

/**********************************
 * Get articles from the newsgroup.
 * Return TRUE if successful.
 **********************************/
int doGroup (int socket, NewsrcGroup *np, int groupCnt)
{
 int lo, hi;
 int first, i, n;
 int percent, lastPercent;

 char *szSqAreaName = getentry(np->name);
 if(!szSqAreaName)
 {
	fprintf(stderr, "No Squish msgbase defined for group %s\n", np->name);
	return 0;
 }

// select group name from news server
 if (!nntpGroup(socket, np->name, &lo, &hi))
	return 0;

//----Open Squish msgbase------------------------------------------------------
 beginmsg(szFromAddr, szSqAreaName, 1);

/* killEnabled = killGroup(np->name); */

// Fix up the read article number list
 np->readList = fixReadList(np->readList, lo, hi);

 first = firstUnread(np->readList);
 n = hi - first + 1;
 if (n < 0) n = 0;
 printf("%s: %4d unread article%c in %s\n", progname, n,
	(n == 1) ? ' ' : 's', np->name);
 lastPercent = 0;

// Look through unread articles
 for (i = first; i <= hi; ++i)
 {
	percent = ((i - first + 1) * 100) / n;
	if (percent != lastPercent)
	{
	    printf("%d%%\r", percent);
	    fflush(stdout);
	    lastPercent = percent;
	}

	if (!isRead(i, np->readList))
	{
	    /* Mark as read */
	    np->readList = markRead(i, np->readList);

	    /* Process the article */
	    doArticle(socket, i);
	}
    }
    //----Close Squish msgbase-----------------------------------------------------
    endmsg();

    return 1;
}


/******************************************
 * Get the article, process it and post it
 * Return TRUE if successful.
 ******************************************/
int doArticle (int socket, int artnum)
{
    long artSize;
    unsigned toRead, wasRead;
    char *bufp;
    char gotXref;
/*  char killed; */

//---Squish message init--------------
    union stamp_combo combo;
    struct tm *tmdate;
    time_t time_now;

    time(&time_now);
    tmdate = localtime(&time_now);
    date = (TmDate_to_DosDate(tmdate, &combo))->msg_st;

    szSubject[0] = 0;
    strcpy(szFrom, "Unknown");
    strcpy(szTo, szDefTo);
    sprintf(origin, "---\r * Origin: %s (Usenet %s)",
	DefOrg ? DefOrg : "usenet - ftn gateway using iPost/2", szFromAddr);

//---reset message and kludge buffers-
    buf = (char *)realloc(buf, 0);
    cbuf = (char *)realloc(cbuf, 0);
    bufalloc = cbufalloc = 0;
    buflen = 0;

//---Request article------------------
	SockPrintf(socket, "ARTICLE %d\r\n", artnum);
	if (SockGets(socket, linebuf, sizeof(linebuf)) < 0)
	    return 0;

	if (linebuf[0] == CHAR_FATAL)	/* Fatal error */
	{
	    fprintf(stderr, "%s\n", linebuf);
	    exit(EXIT_FAILURE);
	}

	if (linebuf[0] != CHAR_OK)
	    return 0;

	gotXref = 0;

	//---Get lines of article head----------------------------------------
	while (SockGets(socket, linebuf, sizeof(linebuf)) == 0)
	{
		bufp = linebuf;

		//--- "\r\n.\r\n" is EOT, ".." translates to "." ------------
		if (linebuf[0] == '.')
		{
			++bufp;
			if (linebuf[1] == '\0')
				break;
		}

		if (*bufp == '\0')
			break;

        	processheader(bufp);

		if (doXref && !gotXref && strnicmp(bufp, "Xref: ", 6) == 0)
		{
			processXref(bufp+6);
			gotXref = 1;
		}
	}
	strcat(buf, "\r");
	buflen = strlen(buf);

	//---Retrieve article body--------------------------------------------
	while (SockGets(socket, linebuf, sizeof(linebuf)) == 0)
	{
		bufp = linebuf;

		//--- "\r\n.\r\n" is EOT, ".." translates to "." ------------
		if (linebuf[0] == '.')
		{
			++bufp;
			if (linebuf[1] == '\0')
				break;
		}

		//--- intercept tear & originline lookalikes ----------------
		if(!strncmp(bufp, "---", 3) && isspace(bufp[3]))
			bufp[1] = '+';
		if(!strncmp(bufp, " * Origin: ", 11))
			bufp[1] = '+';

		//--- append to buffer --------------------------------------
		if(buflen + (linelen = strlen(bufp) + 1) >= bufalloc)
		{
			bufalloc += ALLOCSIZE;
			buf = (char *)realloc(buf, bufalloc);
		}
		bufp[linelen - 1] = '\r';
		bufp[linelen] = 0;
		strcpy(buf + buflen, bufp);
		buflen += linelen;
	}

//---post article-------------------------------------------------------------
	if(buflen + (linelen = strlen(origin)) >= bufalloc)
	{
		bufalloc += ALLOCSIZE;
		buf = (char *)realloc(buf, bufalloc);
	}
	strcpy(buf + buflen, origin);
	buflen += linelen;
	buf[buflen] = 0;
	writemsg(1, MSGLOCAL, &date,
		szFromAddr, "", szFrom, szTo,
		szSubject, cbuf, buf);

    return 1;
}

/**************************************
 * Process line in RFC message header
 *************************************/
void processheader(char *lbuf)
{
 size_t linelen;
 unsigned int fKludge = 1;
 char *p, *kl, sep;

//---From------------------------------------------
//format: From: Person's Name <e-mail>
//    or: From: e-mail (Person's Name)
 if(!strncmp("From: ", lbuf, 6))
 {
	fKludge = 0;
	getname(szFrom, sizeof(szFrom), lbuf);
 }

//---X-To------------------------------------------
 if(!strncmp("X-To: ", lbuf, 6))
 {
	fKludge = 0;
	getname(szTo, sizeof(szTo), lbuf);
 }

//---Subject---------------------------------------
 if(!strncmp("Subject: ", lbuf, 9))
 {
	memset(&szSubject, 0, sizeof(szSubject));
	fKludge = 0;
	strncpy(szSubject, lbuf + 9, sizeof(szSubject) - 1);
 }

//---Organization -> Origin------------------------
 if(!strncmp("Organization: ", lbuf, 14))
 {
	char c;

	if(strlen(p = lbuf + 14) > orglen)
	{
		c = p[orglen];
		p[orglen] = 0;
	}
	else
		c = 0;
	sprintf(origin, "---\r * Origin: %s (Usenet %s)", p, szFromAddr);
	if(c)
		p[orglen] = c;
 }

//---Lines: kill-----------------------------------
 if(!strncmp("Lines: ", lbuf, 7))
	fKludge = 0;

//---Date------------------------------------------
 if(!strncmp("Date: ", lbuf, 6))
	getdt(lbuf);

//---Append to kludge buffer, split long lines-----
 if(fKludge)
 {
	kl = lbuf;
	if((p = strchr(lbuf, ' ')) == NULL)
		p = "";
	*p++ = 0;

	//---Determine separator character for split
	if(!strncmp(kl, "Path", 4))
		sep = '!';
	else if(!strncmp(kl, "Newsgroups", 10) || !strncmp(kl, "Followup-To", 11))
		sep = ',';
	else
		sep = ' ';

	while(linelen = strlen(p))
	{
		char *q = NULL, *qnext = NULL;
		if(linelen + strlen(kl) >= 74)
		{
			if(qnext = strchr(p + 74 - strlen(kl), sep))
				*qnext = 0;
			if((q = strrchr(p, sep)) == NULL)
				q = qnext;
			if(qnext)
				*qnext = sep;
		}
		if(q)
			*q = 0;
		addkludge(kl, p);
		if(q)
			p = q + 1;
		else
			p += linelen;
	}
 }
}

//---Add klugdeline to kludge buffer------------------------------
void addkludge(char *kl, char *value)
{
  int tlen;

  if(buflen + (tlen = strlen(kl) + strlen(value) + 6) >= cbufalloc)
  {
	cbufalloc += ALLOCSIZE;
	cbuf = (char *)realloc(cbuf, cbufalloc);
  }
  strcpy(cbuf + buflen, "\01RFC-");
  strcpy(cbuf + buflen + 5, kl);
  strcat(cbuf + buflen + 5, " ");
  strcat(cbuf + buflen + 5, value);
  buflen += tlen;
}

//---Parse date/timestamp from RFC-Date----------------------------
//format: Date:[ day-of-week,] dd Mon [yy]yy hh:mm:ss[ timezone]
void getdt(char *lbuf)
{
 static char months[12][4] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
			      "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
 int day, mon, yr, hr, min, sec;
 char *p;

 if(p = strchr(lbuf, ','))
	p += 2;
 else
	p = lbuf + 6;

 if((day = atoi(p)) <= 0 || day > 31)
	return;
 if(!(p = strchr(p, ' ')))
	return;
 p++;

 for(mon = 0; mon < 12 && strncmp(months[mon], p, 3); mon++);
 if(mon >= 12)
	return;
 p += 4;

 if((yr = atoi(p)) >= 1980)
	p += 5;
 else if(yr < 100 && yr >= 0)
 {
	p += 3;
	if((yr += 1900) < 1980)
		yr += 100;
 }
 else
	return;

 if((hr = atoi(p)) < 0 || hr >= 24)
	return;
 p += 3;

 if((min = atoi(p)) < 0 || hr > 60)
	return;
 p += 3;

 if((sec = atoi(p)) < 0 || hr > 60)
	return;

 date.date.da = day;
 date.date.mo = mon + 1;
 date.date.yr = yr - 1980;
 date.time.hh = hr;
 date.time.mm = min;
 date.time.ss = sec >> 1;
}

//---Parse From and X-To kludges--------------------
//---Append line to body text buffer----------------
//format: X-To/From: Person's Name <e-mail>
//    or: X-To/From: e-mail (Person's Name)
void getname(char *s, size_t slen, char *lin)
{
 char *p;

 // clear destination string
 memset(s, 0, slen);

 // get real name in destination string
 if(p = strchr(lin, '('))
	strncpy(s, p + 1, min(strchr(p, ')') - p - 1, slen - 1));
 else
 {
	if(!(p = strchr(lin + 6, '<')))
		p = lin + 1024;
	strncpy(s, lin + 6, min(p - lin - 6, slen - 1));
 }

 // trim trailing spaces
 if(*s) for(p = s + strlen(s) - 1; *p == ' '; p--)
	*p = 0;

 // append line to message body buffer
 if((buf ? strlen(buf) : 0) + strlen(lin) + 2 >= bufalloc)
 {
	bool newbuf = buf == NULL;
	bufalloc += ALLOCSIZE;
	buf = (char *)realloc(buf, bufalloc);
	if(newbuf) buf[0] = 0;
 }
 strcat(buf, lin);
 strcat(buf, "\r");
}
