/*
FidoConfig to FleetStreet's AREAS.INI converter V0.03
Copyright 1999 Oleg Deribas 2:461/13@fidonet

To compile with emx 0.9d:
gcc.exe -s -Zomf -Zcrtdll -Wall -o fc2fleet.exe -I../fidoconfig -I../smapi -L../fidoconfig -L../smapi fc2fleet.c -lsmapi -lfidoconfig -lwrap

*/

#define INCL_WINSHELLDATA
#include <os2.h>
#include <stdio.h>
#include "fidoconfig.h"

#define TYPE_ECHO    "\0"
#define TYPE_NETMAIL "\1"
#define TYPE_LOCAL   "\2"

#define FMT_MSG    "\1"
#define FMT_SQUISH "\2"
#define FMT_JAM    "\3"

s_fidoconfig *config;
char *UserName = NULL;

int writeArea(HINI hini, s_area *area, char *type)
{
	char tmp[255];
	ULONG PrfSize = 4;
//	BOOL rc;

	sprintf(tmp, "%u:%u/%u.%u",
		area->useAka->zone,
		area->useAka->net,
		area->useAka->node,
		area->useAka->point);

	PrfWriteProfileString(hini, area->areaName, "Address", tmp);
	if (UserName == NULL)
	{
		PrfWriteProfileString(hini, area->areaName, "Name", config->sysop);
	}
	else
	{
		PrfWriteProfileString(hini, area->areaName, "Name", UserName);
	}
	if ( area->description != NULL )
	{
		PrfWriteProfileString(hini, area->areaName, "Desc", area->description);
	}
	else
	{
		PrfWriteProfileString(hini, area->areaName, "Desc", area->areaName);
	}
	PrfWriteProfileString(hini, area->areaName, "Path", area->fileName);
	PrfWriteProfileData  (hini, area->areaName, "Type", type, 2);

	if (area->msgbType == MSGTYPE_SQUISH)
	{
		PrfWriteProfileData(hini, area->areaName, "Format", FMT_SQUISH, 2);
	}
	else
	{
		PrfWriteProfileData(hini, area->areaName, "Format", FMT_MSG, 2);
	}
	
	if ( !PrfQueryProfileData(hini, area->areaName, "Options", (PVOID) tmp, &PrfSize) )
	{
		memset(tmp, 0, 4);
	}
	tmp[0] |= 8;
	PrfWriteProfileData(hini, area->areaName, "Options", tmp, 4);

	return 0;
}


int main (int argc, char *argv[]) 
{
	HAB hab;
	HINI hini;
	int i;
	s_area *area;

	printf("FidoConfig to FleetStreet's AREAS.INI converter V0.03\n");
	printf("Copyright 1999 Oleg Deribas 2:461/13@fidonet\n\n");

	config = readConfig();
	if (config!= NULL) 
	{
		if ( argc >1 )
		{
			if (argv[1][1] == '?')
			{
				printf("Usage: fc2fleet.exe [\"User Name\"]\n\n");
				exit(0);
			}
			else
			{
				UserName = (char *) malloc(sizeof(argv[1]));
				strcpy(UserName,argv[1]);
			}
		}
		hab = WinInitialize(0);
		if ((hini = PrfOpenProfile(hab, "AREAS.INI")) == NULLHANDLE)
		{
			/* File was not opened or created */
			printf("Error opening AREAS.INI\n");
			return 1;
		}
		
		writeArea(hini, &(config->netMailArea), TYPE_NETMAIL);
		writeArea(hini, &(config->dupeArea), TYPE_LOCAL);
		writeArea(hini, &(config->badArea), TYPE_LOCAL);

		for (i=0; i<config->echoAreaCount; i++) 
		{
			area = &(config->echoAreas[i]);
			if (area->msgbType != MSGTYPE_PASSTHROUGH)
				writeArea(hini, area, TYPE_ECHO);
		}

		for (i=0; i<config->localAreaCount; i++)
		{
			area = &(config->localAreas[i]);
			writeArea(hini, area, TYPE_LOCAL);
		}

		PrfCloseProfile(hini);
		disposeConfig(config);
		return 0;
	}
	printf("Error opening Config-file\n");
	return 1;
}
