{$M 32768,0,655360}
program StatConv;
uses
  TParam, TFileIO,
  Bits,
  Types, ApiInt;

type
  PStatConvert    = ^TStatConvert;
  TStatConvert    = object
    NodeNumber    : Word;
    StatType      : ( Clean, PCB12, PCB14, MG );

    constructor Init;
    destructor Done;

    procedure ReadParams;
    procedure MakeFiles;
  end;

  BasArray        = array[1.. 4] of byte;
  Ascii2          = array[1.. 2] of char;
  Ascii4          = array[1.. 4] of char;
  Ascii5          = array[1.. 5] of char;
  Ascii6          = array[1.. 6] of char;
  Ascii8          = array[1.. 8] of char;
  Ascii12         = array[1..12] of char;
  Ascii13         = array[1..13] of char;
  Ascii15         = array[1..15] of char;
  Ascii18         = array[1..18] of char;
  Ascii24         = array[1..24] of char;
  Ascii25         = array[1..25] of char;
  Ascii27         = array[1..27] of char;
  Ascii30         = array[1..30] of char;
  String80        = string[80];
  FileNameType    = string[80];

var
  StatConvert      : PStatConvert;

constructor TStatConvert.Init;
begin
  dllInit( '', 0 );
end; { contructor Init }

destructor TStatConvert.Done;
begin
end; { destructor Done }

procedure TStatConvert.ReadParams;
begin
  if Par^.SwAct['T'] then
    if ( Par^.SwStr['T'] = 'PCB12' ) then StatType := PCB12
    else if ( Par^.SwStr['T'] = 'PCB14' ) then StatType := PCB14
    else if ( Par^.SwStr['T'] = 'MG' ) then StatType := MG
    else StatType := PCB14
  else StatType := PCB14;

  if Par^.SwAct['C'] then StatType := Clean;

  NodeNumber := S2I( Par^.Str[1] );
end; { procedure ReadParams }

procedure TStatConvert.MakeFiles;
var
  SysCfg           : SysCfgT;
  NodeCfg          : ModCfgT;
  NStat            : NodeStat;
  User             : LocUsers;
  BBSDir           : string;
  FileDir          : string;

  Procedure MKS(PReal : Real; Var BReal : BasArray);
  Var
    X              : Array[1..6] of byte absolute PReal;
  begin { MKS }
  { Flip the exponent byte and try to pretend that X[2] & X[3] never existed   }
      Move(X[4],BReal[1],3);
      BReal[4] := X[1];
  end;  { MKS }

  Procedure WritePCB12;
  type
    PCB12FileType   = record             { 128 Bytes for PCBOARD version 12.1  }
           Display  : Ascii2;            { Sysop's Display ON/OFF              }
           Printer  : Ascii2;            { Sysop's Printer ON/OFF              }
           PageBell : Ascii2;            { Sysop's Page Bell ON/OFF            }
           CallAlarm: Ascii2;            { Caller Alarm ON/OFF                 }
           SysopNext: Ascii2;            { Sysop "Next On" Flag                }
           BaudRate : Ascii4;            { "CONNECT" Baud Rate of Caller       }
           Name     : Ascii27;           { Full Name of Caller (plus 2 spaces) }
           FirstName: Ascii15;           { First Name of Caller                }
           Graphics : Ascii2;            { Graphics Mode of Caller             }
           Password : Ascii12;           { Password of Caller                  }
           RecordNum: Integer;           { User's Database Record Number (MKI$)}
           TimeLogOn: BasArray;          { Time User Logged On   (MKS$ seconds)}
           TimeAllow: BasArray;          { User's Allowed Time   (MKS$ seconds)}
           TimeDoor : BasArray;          { Time Exited to Door   (MKS$ seconds)}
           LogONStattattr : Ascii5;            { Time User Logged On          (HH:MM)}
           ConfExit : Ascii2;            { Area Exited to DOS   (not converted)}
           ConfFlags: Ascii18;           { Areas "Joined" Flags (not converted)}
           ConfTime : Ascii2;            { Area "Bonus" Time    (not converted)}
           ByteLmtDL: Ascii8;            { Daily Download Limit (not converted)}
           TimeCred : Integer;           { Upload Time Bonus Earned      (MKI$)}
           Language : Ascii4;            { Language Version Being Used         }
           ModemType: Ascii2;            { Error Correcting Modem YES/NO       }
           NodeChat : Char;              { Node Chat Status Flag               }
         end;

  var
    SS             : string;
    P12            : PCB12FileType;
    P12F           : file of PCB12FileType;
    BR             : BasArray;

  begin
    With P12 Do
    begin
      Display:='-1';
      Printer:=' 0';
      PageBell:=' 0';
      CallAlarm:=' 0';
      SysopNext:='N '; { 'N ', 'X ', '  '}
      if (NStat.ConnectSpeed.ModemSpeed=0) then
        BaudRate:='Loca'
      Else
      begin
        SS:=Fill(I2S(NStat.ConnectSpeed.ModemSpeed,0),5,#32);
        Move(SS[1],BaudRate,4);
      end;
      SS:=Fill(NStat.UserName,27,#32);
      Move(SS[1],Name,27);
      SS:=Fill(GetFirst(SS),15,#32);
      Move(SS[1],FirstName,15);
      if not (IBM In NStat.Graphics) then
        Graphics:='7E'
      Else if not (ANSI In NStat.Graphics) then
        Graphics:=' 0'
      Else
        Graphics:='-1';
      Password:='            ';
      if (UpStr(NStat.UserName) = SysCfg.SysOpName) then
        RecordNum:=1
      Else
        RecordNum:=2;
      MKS(NStat.Connected,BR);
      TimeLogOn:=BR;
      MKS(NStat.TimeAllowed * 60,BR);
      TimeAllow:=BR;
      MKS(TimeNow,BR);
      TimeDoor:=BR;
      SS:=TimeStr(NStat.Connected);
      Move(SS[1],LogONStattattr,5);
      ConfExit:='  ';
      ConfFlags:='                  ';
      ConfTime:='  ';
      ByteLmtDL:='0       ';
      TimeCred:=0;
      Language:='.   ';
      Language[2] := User.Language;
{      if NStat.ConnectSpeed.MNP then
        ModemType:='-1'
      Else}
        ModemType:=' 0';
      NodeChat:='U';
    end;

    Assign(P12F,'TEMP\' + I2S( NStat.NodeNo, 3 ) + '\PCBOARD.'+I2S(NStat.NodeNo,0));
    ReWrite(P12F);
    Write(P12F,P12);
    Close(P12F);

    Writeln('PCBoard version 12.0 - PCBOARD.SYS file written');
  end; { Procedure WritePCB12 }

  Procedure WritePCB14;
  type
    PCB14FileType   = record             { 128 Bytes for PCBOARD version 14.0  }
           Display  : Ascii2;            { Sysop's Display ON/OFF              }
           Printer  : Ascii2;            { Sysop's Printer ON/OFF              }
           PageBell : Ascii2;            { Sysop's Page Bell ON/OFF            }
           CallAlarm: Ascii2;            { Caller Alarm ON/OFF                 }
           SysopNext: Char;              { Sysop "Next On" Flag                }
           ModemType: Ascii2;            { Error Correcting Modem YES/NO       }
           Graphics : Char;              { Graphics Mode of Caller             }
           NodeChat : Char;              { Available for Node Chat YES/NO      }
           BaudOpen : Ascii5;            { Baud Rate to Open Modem at          }
           BaudRate : Ascii5;            { "CONNECT" Baud Rate of Caller       }
           RecordNum: Integer;           { User's Database Record Number (MKI$)}
           FirstName: Ascii15;           { First Name of Caller                }
           Password : Ascii12;           { Password of Caller                  }
           TimeLogOn: Integer;           { Time User Logged On   (MKI$ minutes)}
           TimeUsed : Integer;           { Time Used Today       (MKI$ minutes)}
           LogONStattattr : Ascii5;            { Time User Logged On       (HH:MM:SS)}
           TimeLimit: Integer;           { Daily Time Limit      (MKI$ minutes)}
           ByteLmtDL: Integer;           { Daily Download Limit  (MKI$ K-bytes)}
           ConfExit : Char;              { Conference (Area) User Exited From  }
           ConfFlags: Ascii5;            { Areas User Has "Joined" Today       }
           ConfScan : Ascii5;            { Areas User Has Scanned for New Mail }
           ConfTime : Integer;           { Area "Bonus" Time     (MKI$ minutes)}
           TimeCred : Integer;           { Upload Time Credit    (MKI$ minutes)}
           Language : Ascii4;            { Language Version Being Used         }
           Name     : Ascii25;           { Full Name of Caller   (First & Last)}
           TimeLeft : Integer;           { Session Time Remaining(MKI$ minutes)}
           NodeNum  : Char;              { BBS Node Number That Caller is Using}
           EventTime: Ascii5;            { Scheduled EVENT Time         (HH:MM)}
           EventFlag: Ascii2;            { Is EVENT Time Active?               }
           EventMove: Ascii2;            { Delay EVENT Until User Logs Off?    }
           MsgRecall: BasArray;          { "Memorized" Message Number    (MKS$)}
           ComPortID: Char;              { Com Port Number (0, 1, 2)           }
           Reserved : Ascii2;            { Reserved for Future Use             }
         end;

    PCB14UsersType  = record
           Name     : Ascii25;
           CityState: Ascii24;
           Password : Ascii12;
           WPhone   : Ascii13;
           HPhone   : Ascii13;
           LastDate : Ascii6;
           LastTime : Ascii5;
           Expert   : Char;
           Protocol : Char;
           RFU1     : Char;
           LastNew  : Ascii6;
           SecLevel : Byte;
           Times    : Integer;
           PageLen  : Byte;
           Uploads  : Integer;
           Downloads: Integer;
           DailyDown: Ascii8;
           ToDayDown: Ascii8;
           UserCom  : Ascii30;
           SysOpCom : Ascii30;
           TimeUsed : Integer;
           SubDate  : Ascii6;
           SubLevel : Byte;
           Area     : Byte;
           AreaReg  : Ascii5;
           AreaExp  : Ascii5;
           AreaScan : Ascii5;
           DownByte : Ascii8;
           UpByte   : Ascii8;
           DelFlag  : Char;
           LastRead : array[0..39] of BasArray;
           RFU2     : array[1..15] of Char;
         end;

  var
    SS             : string;
    P14            : PCB14FileType;
    P14F           : file of PCB14FileType;
    U14            : PCB14UsersType;
    U14F           : file of PCB14UsersType;
    BR             : BasArray;
    TT             : Text;
    LL             : Integer;

  begin
    { '-1'= On, ' 0'= Off }

    With P14 Do
    begin
      Display:='-1';
      Printer:=' 0';
      PageBell:=' 0';
      CallAlarm:=' 0';
      SysopNext:='N';
{      if NStat.ConnectSpeed.MNP then
        ModemType:='-1'
      Else}
        ModemType:=' 0';
      if not (IBM In NStat.Graphics) then
        Graphics:='7'
      Else if not (ANSI In NStat.Graphics) then
        Graphics:='N'
      Else
        Graphics:='Y';
      NodeChat:='U';
      SS:=Fill(I2S(NStat.BaudRate,0),5,#32);
      Move(SS[1],BaudOpen,5);
      if (NStat.ConnectSpeed.ModemSpeed=0) then
        BaudRate:='Local'
      Else
      begin
        SS:=Fill(I2S(NStat.ConnectSpeed.ModemSpeed,0),5,#32);
        Move(SS[1],BaudRate,5);
      end;
      if (UpStr(NStat.UserName) = SysCfg.SysOpName) then
        RecordNum:=1
      Else
        RecordNum:=2;
      SS:=NStat.UserName;
      SS:=Fill(GetFirst(SS),15,#32);
      Move(SS[1],FirstName,15);
      Password:='            ';
      TimeLogOn:=NStat.Connected div 60;
      TimeUsed:=-(NStat.TimeAllowed-NStat.TimeLeft);
      SS:=TimeStr(NStat.Connected);
      Move(SS[1],LogONStattattr,5);
      TimeLimit:=NStat.TimeAllowed;
      ByteLmtDL:=0;
      ConfExit:=' ';
      ConfFlags:='     ';
      ConfScan:='     ';
      ConfTime:=0;
      TimeCred:=0;
      Language:='.   ';
      Language[2] := User.Language;
      SS:=Fill(NStat.UserName,25,#32);
      Move(SS[1],Name,25);
      TimeLeft:=NStat.TimeLeft;
      SS:=Char(Byte(NStat.NodeNo));
      Move(SS[1],NodeNum,1);
      EventTime:='00:00';
      EventFlag:=' 0';
      EventMove:='-1';
      MKS(0,BR);
      MsgRecall:=BR;
      SS:=I2S(NStat.ComPort,1);
      Move(SS[1],ComPortID,1);
      Reserved:='  ';
    end;

    Assign(P14F,'TEMP\' + I2S( NStat.NodeNo, 3 ) + '\PCBOARD.SYS');
    ReWrite(P14F);
    Write(P14F,P14);
    Close(P14F);

    Writeln('PCBoard version 14.0 - PCBOARD.SYS file written');

    Assign(TT,'TEMP\' + I2S( NStat.NodeNo, 3 ) +'\PCBOARD.DAT');
    ReWrite(TT);

    Writeln(TT,'*** PCBoard Version 14.0 data pcbfile ***');
    Writeln(TT,'SysOp');
    Writeln(TT,'PASSWORD');
    Writeln(TT,'-1');
    Writeln(TT,'-1');

    For LL:=1 To 18 Do
      Writeln(TT,'100');

    GetDir( 0, SS );
    SS:= SS + '\TEMP\' + I2S( NStat.NodeNo, 3 ) + '\';

    For LL:=1 To 5 Do
      Writeln(TT,SS);

    Writeln(TT,SS+'USERS');
    Writeln(TT,SS+'CALLER');
    Writeln(TT,SS+'CNAMES');
    Writeln(TT,SS+'PWRD');
    Writeln(TT,SS+'FSEC');
    Writeln(TT,SS+'UPSEC');
    Writeln(TT,SS+'TCAN');
    Writeln(TT,SS+'WELCOME');
    Writeln(TT,SS+'NEWUSER');
    Writeln(TT,SS+'CLOSED');
    Writeln(TT,SS+'WARNING');
    Writeln(TT,SS+'EXPIRED');
    Writeln(TT,SS+'USERNET.DAT');
    Writeln(TT,SS+'CNFN');
    Writeln(TT,SS+'NEWASK');
    Writeln(TT,SS+'NEWREG');
    Writeln(TT,SS+'PCBPROT.DAT');
    Writeln(TT,SS+'DOWNLOAD.TXT');
    Writeln(TT,SS+'SCRIPT0');
    Writeln(TT,SS+'ANStattatWER0');
    Writeln(TT,SS+'PCBML.DAT');
    Writeln(TT,SS+'GTOPIC');

    Writeln(TT,'15');

    Writeln(TT,'COM'+I2S(NStat.ComPort,1)+':');
    Writeln(TT,I2S(NStat.BaudRate,0));
    Writeln(TT,'-1');
    Writeln(TT,'ATM0H0');
    Writeln(TT,'ATM0H1');

    For LL:=1 To 9 Do
      Writeln(TT,'0');

    Writeln(TT,'00:01');
    Writeln(TT,'23:59');
    Writeln(TT,'0');
    Writeln(TT,'0');
    Writeln(TT,'-1');
    Writeln(TT,'0');
    Writeln(TT,'0');
    Writeln(TT,'-1');
    Writeln(TT,'0');
    Writeln(TT,'0');
    Writeln(TT,'-1');
    Writeln(TT,'0');
    Writeln(TT,'0');
    Writeln(TT,'-1');
    Writeln(TT,'0');
    Writeln(TT,'-1');
    Writeln(TT,'-1');
    Writeln(TT,'-1');
    Writeln(TT,'-1');
    Writeln(TT,'0');
    Writeln(TT,'-1');
    Writeln(TT,'-1');
    Writeln(TT,'0');
    Writeln(TT,'5');
    Writeln(TT,'-1');
    Writeln(TT,I2S(NStat.NodeNo,0));
    Writeln(TT,'20');
    Writeln(TT,'99');
    Writeln(TT,'Bits & Bytes');
    Writeln(TT,'Leave a comment for the sysops (Enter)=no');
    Writeln(TT,'What is your PCBoard S/N');
    For LL:=1 To 10 Do
      Writeln(TT,'');
    Writeln(TT,'X');
    Writeln(TT,'9');
    Writeln(TT,'99');
    Writeln(TT,'37');
    Writeln(TT,'0');
    Writeln(TT,' 0');
    Writeln(TT,'16:30');
    Writeln(TT,'1');
    Writeln(TT,'0');
    Writeln(TT,'0');
    Writeln(TT,'8');
    Writeln(TT,'0');
    Writeln(TT,'1');
    Writeln(TT,'0');

    For LL:=1 To 30 Do
      Writeln(TT,'9');

    Close(TT);

    Writeln('PCBoard version 14.0 - PCBOARD.DAT file written');

    With U14 Do
    begin
      SS:=Fill(NStat.UserName,25,#32);
      Move(SS[1],Name,25);
      SS:=Fill(NStat.City,24,#32);
      Move(SS[1],CityState,24);
      WPhone   :='             ';
      HPhone   :='             ';
      LastDate :='810101';
      LastTime :='01:01';
      Expert   :='Y';
      Protocol :='Z';
      LastNew  :='810101';
      SecLevel :=9;
      Times    :=1;
      PageLen  :=23;
      UpLoads  :=0;
      Downloads:=0;
      DailyDown:='        ';
      TodayDown:='        ';
      UserCom  :='                              ';
      SysOpCom :='                              ';
      TimeUsed :=0;
      SubDate  :='810101';
      SubLevel :=9;
      Area     :=0;
      AreaReg  :=#0#0#0#0#0;
      AreaExp  :=#0#0#0#0#0;
      AreaScan :=#0#0#0#0#0;
      DownByte :='        ';
      UpByte   :='        ';
      DelFlag  :='N';
      MKS(0,BR);
      For LL:=0 To 39 Do
        LastRead[LL]:=BR;
    end;

    Assign(U14F,'TEMP\' + I2S( NStat.NodeNo, 3 ) +'\USERS');
    ReWrite(U14F);
    Write(U14F,U14);
    Write(U14F,U14);
    Close(U14F);

    Writeln('PCBoard version 14.0 - USERS file written');
  end; { Procedure WritePCB14 }

{}procedure WriteMG;
  var
    MGFile         : TFile;

  begin
    with MGFile do
    begin
      Assign( FileDir + '\USERINFO.TXT',
              fmWriteOnly or fmExclusive,
              1,
              faNormalAccess,
              ftMaxTimeout );
      ReWrite;
      WriteTextln( NStat.UserName );
      WriteTextln( I2S( NStat.BaudRate, 0 ));
      WriteTextln( '8');
      WriteTextln( I2S( NStat.TimeAllowed * 60 - TimeUsed( NStat.Connected, TimeNow ), 0 ));
      Close;
    end;
    Writeln('Milton Gameworks - USERINFO.TXT file written');
{}end; { Procedure WriteMG }

begin
  if not fioReadMainCfg( SysCfg ) or
     not fioReadNodeCfg( NodeCfg, NodeNumber ) or
     not fioGetNodeStatus( NStat, NodeNumber ) or
     not fioReadLocalUsr( User, NStat.UserPos ) then
  begin
    Writeln( 'Unable to collect information' );
    Exit;
  end;

  GetDir( 0, BBSDir );
  FileDir := BBSDir + '\TEMP\' + I2S( NodeNumber, 3 );

  case StatType of
    Clean:;
    PCB12: WritePCB12;
    PCB14: WritePCB14;
    MG: WriteMG;
  end;
end; { procedure MakeFiles }

begin
  Writeln;
  Writeln( 'StatConv v1.03 - Create files for door usage' );
  Writeln;

  if not ( Par^.Count = 1 ) then
  begin
    Writeln( 'Usage:' );
    Writeln( '   StatConv {-T[PCB12|PCB14|MG]|-C} [node#]' );
    Writeln;
    Writeln( '   -T           Type of door-info files to make (PCBoard v12, v14 or Milton Gameworks)' );
    Writeln( '                (Default: PCBoard v14)' );
    Writeln( '   -C           Clean up alle StatConv made files' );
    Writeln( '   node#        Number of node' );
    Exit;
  end;

  New( StatConvert, Init );
  StatConvert^.ReadParams;
  StatConvert^.MakeFiles;
  Dispose( StatConvert, Done );
end. { program StatConv }